/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion.callgraph;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfoCollection;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.callgraph.InvokeExtractor;
import com.android.tools.r8.ir.conversion.callgraph.NodeBase;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class IRProcessingCallGraphUseRegistry<N extends NodeBase<N>>
extends InvokeExtractor<N> {
    private final FieldAccessInfoCollection<?> fieldAccessInfoCollection;

    IRProcessingCallGraphUseRegistry(AppView<AppInfoWithLiveness> appView, N currentMethod, Function<ProgramMethod, N> nodeFactory, Map<DexMethod, ProgramMethodSet> possibleProgramTargetsCache, Predicate<ProgramMethod> targetTester) {
        super(appView, currentMethod, nodeFactory, possibleProgramTargetsCache, targetTester);
        this.fieldAccessInfoCollection = appView.appInfo().getFieldAccessInfoCollection();
    }

    private void addFieldReadEdge(ProgramMethod writer) {
        assert (!((DexEncodedMethod)writer.getDefinition()).isAbstract());
        if (!this.targetTester.test(writer)) {
            return;
        }
        ((NodeBase)this.nodeFactory.apply(writer)).addReaderConcurrently(this.currentMethod);
    }

    private void processFieldRead(DexField reference) {
        Object fieldAccessInfo;
        DexField rewrittenReference = this.appView.graphLens().lookupField(reference, this.getCodeLens());
        if (!rewrittenReference.getHolderType().isClassType()) {
            return;
        }
        ProgramField field = ((AppInfoWithLiveness)this.appView.appInfo()).resolveField(rewrittenReference).getSingleProgramField();
        if (field == null || ((AppInfoWithLiveness)this.appView.appInfo()).isPinned(field)) {
            return;
        }
        if (field.getAccessFlags().isStatic()) {
            this.addClassInitializerTarget(field.getHolder());
        }
        if ((fieldAccessInfo = this.fieldAccessInfoCollection.get((DexField)field.getReference())) != null && fieldAccessInfo.hasKnownWriteContexts() && fieldAccessInfo.getNumberOfWriteContexts() == 1) {
            fieldAccessInfo.forEachWriteContext(this::addFieldReadEdge);
        }
    }

    private void processFieldWrite(DexField reference) {
        DexField rewrittenReference = this.appView.graphLens().lookupField(reference, this.getCodeLens());
        if (!rewrittenReference.getHolderType().isClassType()) {
            return;
        }
        ProgramField field = ((AppInfoWithLiveness)this.appView.appInfo()).resolveField(rewrittenReference).getSingleProgramField();
        if (field == null || ((AppInfoWithLiveness)this.appView.appInfo()).isPinned(field)) {
            return;
        }
        if (field.getAccessFlags().isStatic()) {
            this.addClassInitializerTarget(field.getHolder());
        }
    }

    private void processInitClass(DexType type) {
        DexType rewrittenType = this.appView.graphLens().lookupType(type);
        if (rewrittenType.isIntType()) {
            assert (this.appView.hasUnboxedEnums());
            assert (this.appView.unboxedEnums().isUnboxedEnum(type));
            return;
        }
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(rewrittenType));
        if (clazz == null) {
            assert (false);
            return;
        }
        this.addClassInitializerTarget(clazz);
    }

    protected void addClassInitializerTarget(DexProgramClass clazz) {
        assert (clazz != null);
        if (clazz.hasClassInitializer()) {
            this.addCallEdge(clazz.getProgramClassInitializer(), false);
        }
    }

    protected void addClassInitializerTarget(DexType type) {
        assert (type.isClassType());
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(type));
        if (clazz != null) {
            this.addClassInitializerTarget(clazz);
        }
    }

    @Override
    protected void processSingleTarget(ProgramMethod singleTarget, ProgramMethod context) {
        super.processSingleTarget(singleTarget, context);
        if (singleTarget.getAccessFlags().isStatic()) {
            this.addClassInitializerTarget(singleTarget.getHolder());
        }
    }

    @Override
    public void registerInitClass(DexType clazz) {
        this.processInitClass(clazz);
    }

    @Override
    public void registerInstanceFieldRead(DexField field) {
        this.processFieldRead(field);
    }

    @Override
    public void registerInstanceFieldWrite(DexField field) {
        this.processFieldWrite(field);
    }

    @Override
    public void registerInstanceOf(DexType type) {
    }

    @Override
    public void registerNewInstance(DexType type) {
        if (type.isClassType()) {
            this.addClassInitializerTarget(type);
        }
    }

    @Override
    public void registerStaticFieldRead(DexField field) {
        this.processFieldRead(field);
    }

    @Override
    public void registerStaticFieldWrite(DexField field) {
        this.processFieldWrite(field);
    }

    @Override
    public void registerTypeReference(DexType type) {
    }

    @Override
    public void registerCallSite(DexCallSite callSite) {
        this.registerMethodHandle(callSite.bootstrapMethod, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
    }
}

