/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion.callgraph;

import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.callgraph.NodeBase;
import java.util.Set;
import java.util.TreeSet;

public class Node
extends NodeBase<Node>
implements Comparable<Node> {
    public static Node[] EMPTY_ARRAY = new Node[0];
    private int numberOfCallSites = 0;
    private final Set<Node> callees = new TreeSet<Node>();
    private final Set<Node> callers = new TreeSet<Node>();
    private final Set<Node> readers = new TreeSet<Node>();
    private final Set<Node> writers = new TreeSet<Node>();

    public Node(ProgramMethod method) {
        super(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReaderConcurrently(Node reader) {
        Set<Node> set = this.readers;
        synchronized (set) {
            this.readers.remove(reader);
        }
        set = reader.writers;
        synchronized (set) {
            reader.writers.remove(this);
        }
    }

    public void addCallerConcurrently(Node caller) {
        this.addCallerConcurrently(caller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallerConcurrently(Node caller, boolean likelySpuriousCallEdge) {
        if (caller != this && !likelySpuriousCallEdge) {
            boolean changedCallers;
            Set<Node> set = this.callers;
            synchronized (set) {
                changedCallers = this.callers.add(caller);
                ++this.numberOfCallSites;
            }
            if (changedCallers) {
                set = caller.callees;
                synchronized (set) {
                    caller.callees.add(this);
                }
                this.removeReaderConcurrently(caller);
            }
        } else {
            Set<Node> set = this.callers;
            synchronized (set) {
                ++this.numberOfCallSites;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReaderConcurrently(Node reader) {
        if (reader != this) {
            Set<Node> set = this.callers;
            synchronized (set) {
                boolean readersChanged;
                if (this.callers.contains(reader)) {
                    return;
                }
                Set<Node> set2 = this.readers;
                synchronized (set2) {
                    readersChanged = this.readers.add(reader);
                }
                if (readersChanged) {
                    set2 = reader.writers;
                    synchronized (set2) {
                        reader.writers.add(this);
                    }
                }
            }
        }
    }

    public void removeCaller(Node caller) {
        boolean callersChanged = this.callers.remove(caller);
        assert (callersChanged);
        boolean calleesChanged = caller.callees.remove(this);
        assert (calleesChanged);
        assert (!this.hasReader(caller));
    }

    public void removeReader(Node reader) {
        boolean readersChanged = this.readers.remove(reader);
        assert (readersChanged);
        boolean writersChanged = reader.writers.remove(this);
        assert (writersChanged);
        assert (!this.hasCaller(reader));
    }

    public void cleanCalleesAndWritersForRemoval() {
        boolean changed;
        assert (this.callers.isEmpty());
        assert (this.readers.isEmpty());
        for (Node callee : this.callees) {
            changed = callee.callers.remove(this);
            assert (changed);
        }
        for (Node writer : this.writers) {
            changed = writer.readers.remove(this);
            assert (changed);
        }
    }

    public void cleanCallersAndReadersForRemoval() {
        boolean changed;
        assert (this.callees.isEmpty());
        assert (this.writers.isEmpty());
        for (Node caller : this.callers) {
            changed = caller.callees.remove(this);
            assert (changed);
        }
        for (Node reader : this.readers) {
            changed = reader.writers.remove(this);
            assert (changed);
        }
    }

    public Set<Node> getCallersWithDeterministicOrder() {
        return this.callers;
    }

    public Set<Node> getCalleesWithDeterministicOrder() {
        return this.callees;
    }

    public Set<Node> getReadersWithDeterministicOrder() {
        return this.readers;
    }

    public Set<Node> getWritersWithDeterministicOrder() {
        return this.writers;
    }

    public int getNumberOfCallSites() {
        return this.numberOfCallSites;
    }

    public boolean hasCallee(Node method) {
        return this.callees.contains(method);
    }

    public boolean hasCaller(Node method) {
        return this.callers.contains(method);
    }

    public boolean hasReader(Node method) {
        return this.readers.contains(method);
    }

    public boolean hasWriter(Node method) {
        return this.writers.contains(method);
    }

    public boolean isRoot() {
        return this.callers.isEmpty() && this.readers.isEmpty();
    }

    public boolean isLeaf() {
        return this.callees.isEmpty() && this.writers.isEmpty();
    }

    @Override
    public int compareTo(Node other) {
        return ((DexMethod)this.getProgramMethod().getReference()).compareTo((DexMethod)other.getProgramMethod().getReference());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MethodNode for: ");
        builder.append(this.getProgramMethod().toSourceString());
        builder.append(" (");
        builder.append(this.callees.size());
        builder.append(" callees, ");
        builder.append(this.callers.size());
        builder.append(" callers");
        builder.append(", invoke count ").append(this.numberOfCallSites);
        builder.append(").");
        builder.append(System.lineSeparator());
        if (this.callees.size() > 0) {
            builder.append("Callees:");
            builder.append(System.lineSeparator());
            for (Node call : this.callees) {
                builder.append("  ");
                builder.append(call.getProgramMethod().toSourceString());
                builder.append(System.lineSeparator());
            }
        }
        if (this.callers.size() > 0) {
            builder.append("Callers:");
            builder.append(System.lineSeparator());
            for (Node caller : this.callers) {
                builder.append("  ");
                builder.append(caller.getProgramMethod().toSourceString());
                builder.append(System.lineSeparator());
            }
        }
        return builder.toString();
    }
}

