/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import java.util.Collection;

public class BufferCovariantReturnTypeRewriter
implements CfInstructionDesugaring {
    private final AppView<?> appView;
    private final DexItemFactory factory;

    public BufferCovariantReturnTypeRewriter(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
    }

    private DexMethod matchingBufferCovariantMethod(DexMethod invokedMethod) {
        if (invokedMethod.getArity() > 1 || invokedMethod.getArity() == 1 && !invokedMethod.getParameter(0).isIntType() || invokedMethod.getReturnType() == this.factory.bufferType || !this.factory.typeSpecificBuffers.contains(invokedMethod.holder) || !this.factory.typeSpecificBuffers.contains(invokedMethod.getReturnType())) {
            return null;
        }
        for (DexMethod covariantMethod : this.factory.bufferMembers.bufferCovariantMethods) {
            if (covariantMethod.name != invokedMethod.name || !covariantMethod.getParameters().equals(invokedMethod.getParameters())) continue;
            return covariantMethod;
        }
        return null;
    }

    private boolean isInvokeCandidate(CfInstruction instruction) {
        return instruction.isInvoke() || instruction.isInvokeStatic() || instruction.isInvokeInterface();
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (!this.isInvokeCandidate(instruction)) {
            return null;
        }
        CfInvoke cfInvoke = instruction.asInvoke();
        DexMethod invokedMethod = cfInvoke.getMethod();
        DexMethod covariantMethod = this.matchingBufferCovariantMethod(invokedMethod);
        if (covariantMethod == null) {
            return null;
        }
        DexProto proto = this.factory.createProto(this.factory.bufferType, invokedMethod.getProto().parameters.values);
        CfInvoke newInvoke = new CfInvoke(cfInvoke.getOpcode(), invokedMethod.withProto(proto, this.factory), cfInvoke.isInterface());
        return ImmutableList.of(newInvoke, new CfCheckCast(invokedMethod.getReturnType()));
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (!this.isInvokeCandidate(instruction)) {
            return false;
        }
        DexMethod invokedMethod = instruction.asInvoke().getMethod();
        return this.matchingBufferCovariantMethod(invokedMethod) != null;
    }
}

