/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaring;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryWrapperSynthesizer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterL8Synthesizer;
import com.android.tools.r8.ir.desugar.itf.ProgramEmulatedInterfaceSynthesizer;
import com.android.tools.r8.ir.desugar.records.RecordDesugaring;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public abstract class CfClassSynthesizerDesugaringCollection {
    public static CfClassSynthesizerDesugaringCollection create(AppView<?> appView) {
        RecordDesugaring recordRewriter;
        ArrayList<CfClassSynthesizerDesugaring> synthesizers = new ArrayList<CfClassSynthesizerDesugaring>();
        if (appView.options().isDesugaredLibraryCompilation()) {
            DesugaredLibraryRetargeterL8Synthesizer retargeterL8Synthesizer;
            ProgramEmulatedInterfaceSynthesizer emulatedInterfaceSynthesizer = ProgramEmulatedInterfaceSynthesizer.create(appView);
            if (emulatedInterfaceSynthesizer != null) {
                synthesizers.add(emulatedInterfaceSynthesizer);
            }
            if ((retargeterL8Synthesizer = DesugaredLibraryRetargeterL8Synthesizer.create(appView)) != null) {
                synthesizers.add(retargeterL8Synthesizer);
            }
            synthesizers.add(new DesugaredLibraryWrapperSynthesizer(appView));
        }
        if ((recordRewriter = RecordDesugaring.create(appView)) != null) {
            synthesizers.add(recordRewriter);
        }
        if (synthesizers.isEmpty()) {
            return new EmptyCfClassSynthesizerCollection();
        }
        return new NonEmptyCfClassSynthesizerCollection(appView, synthesizers);
    }

    public abstract void synthesizeClasses(ExecutorService var1, CfClassSynthesizerDesugaringEventConsumer var2) throws ExecutionException;

    static class EmptyCfClassSynthesizerCollection
    extends CfClassSynthesizerDesugaringCollection {
        EmptyCfClassSynthesizerCollection() {
        }

        @Override
        public void synthesizeClasses(ExecutorService executorService, CfClassSynthesizerDesugaringEventConsumer eventConsumer) throws ExecutionException {
        }
    }

    static class NonEmptyCfClassSynthesizerCollection
    extends CfClassSynthesizerDesugaringCollection {
        private final AppView<?> appView;
        private final Collection<CfClassSynthesizerDesugaring> synthesizers;

        public NonEmptyCfClassSynthesizerCollection(AppView<?> appView, Collection<CfClassSynthesizerDesugaring> synthesizers) {
            assert (!synthesizers.isEmpty());
            this.appView = appView;
            this.synthesizers = synthesizers;
        }

        @Override
        public void synthesizeClasses(ExecutorService executorService, CfClassSynthesizerDesugaringEventConsumer eventConsumer) throws ExecutionException {
            assert (this.synthesizers.stream().map(CfClassSynthesizerDesugaring::uniqueIdentifier).collect(Collectors.toSet()).size() == this.synthesizers.size());
            CompilationContext.ProcessorContext processorContext = this.appView.createProcessorContext();
            ThreadUtils.processItems(this.synthesizers, synthesizer -> {
                CompilationContext.ClassSynthesisDesugaringContext classSynthesisDesugaringContext = processorContext.createClassSynthesisDesugaringContext((CfClassSynthesizerDesugaring)synthesizer);
                synthesizer.synthesizeClasses(classSynthesisDesugaringContext, eventConsumer);
            }, executorService);
        }
    }
}

