/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.ClassConverterResult;
import com.android.tools.r8.ir.conversion.D8MethodProcessor;
import com.android.tools.r8.ir.desugar.LambdaClass;
import com.android.tools.r8.ir.desugar.apimodel.ApiInvokeOutlinerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.backports.BackportedMethodDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicClass;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryWrapperSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.invokespecial.InvokeSpecialBridgeInfo;
import com.android.tools.r8.ir.desugar.invokespecial.InvokeSpecialToSelfDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.itf.EmulatedInterfaceSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.lambda.LambdaDeserializationMethodRemover;
import com.android.tools.r8.ir.desugar.lambda.LambdaDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.nest.NestBasedAccessDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.records.RecordDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.twr.TwrCloseResourceDesugaringEventConsumer;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.KeepMethodInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class CfInstructionDesugaringEventConsumer
implements BackportedMethodDesugaringEventConsumer,
InvokeSpecialToSelfDesugaringEventConsumer,
LambdaDesugaringEventConsumer,
ConstantDynamicDesugaringEventConsumer,
NestBasedAccessDesugaringEventConsumer,
RecordDesugaringEventConsumer.RecordInstructionDesugaringEventConsumer,
TwrCloseResourceDesugaringEventConsumer,
InterfaceMethodDesugaringEventConsumer,
DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer,
DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryAPIConverterEventConsumer,
EmulatedInterfaceSynthesizerEventConsumer.ClasspathEmulatedInterfaceSynthesizerEventConsumer,
ApiInvokeOutlinerDesugaringEventConsumer {
    public static D8CfInstructionDesugaringEventConsumer createForD8(D8MethodProcessor methodProcessor) {
        return new D8CfInstructionDesugaringEventConsumer(methodProcessor);
    }

    public static R8CfInstructionDesugaringEventConsumer createForR8(AppView<? extends AppInfoWithClassHierarchy> appView, BiConsumer<LambdaClass, ProgramMethod> lambdaClassConsumer, BiConsumer<ConstantDynamicClass, ProgramMethod> constantDynamicClassConsumer, BiConsumer<ProgramMethod, ProgramMethod> twrCloseResourceMethodConsumer, Enqueuer.SyntheticAdditions additions, BiConsumer<ProgramMethod, ProgramMethod> companionMethodConsumer) {
        return new R8CfInstructionDesugaringEventConsumer(appView, lambdaClassConsumer, constantDynamicClassConsumer, twrCloseResourceMethodConsumer, additions, companionMethodConsumer);
    }

    public static class R8CfInstructionDesugaringEventConsumer
    extends CfInstructionDesugaringEventConsumer {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        private final BiConsumer<LambdaClass, ProgramMethod> lambdaClassConsumer;
        private final BiConsumer<ConstantDynamicClass, ProgramMethod> constantDynamicClassConsumer;
        private final BiConsumer<ProgramMethod, ProgramMethod> twrCloseResourceMethodConsumer;
        private final Enqueuer.SyntheticAdditions additions;
        private final Map<LambdaClass, ProgramMethod> synthesizedLambdaClasses = new IdentityHashMap<LambdaClass, ProgramMethod>();
        private final List<InvokeSpecialBridgeInfo> pendingInvokeSpecialBridges = new ArrayList<InvokeSpecialBridgeInfo>();
        private final List<ConstantDynamicClass> synthesizedConstantDynamicClasses = new ArrayList<ConstantDynamicClass>();
        private final BiConsumer<ProgramMethod, ProgramMethod> onCompanionMethodCallback;

        public R8CfInstructionDesugaringEventConsumer(AppView<? extends AppInfoWithClassHierarchy> appView, BiConsumer<LambdaClass, ProgramMethod> lambdaClassConsumer, BiConsumer<ConstantDynamicClass, ProgramMethod> constantDynamicClassConsumer, BiConsumer<ProgramMethod, ProgramMethod> twrCloseResourceMethodConsumer, Enqueuer.SyntheticAdditions additions, BiConsumer<ProgramMethod, ProgramMethod> onCompanionMethodCallback) {
            this.appView = appView;
            this.lambdaClassConsumer = lambdaClassConsumer;
            this.constantDynamicClassConsumer = constantDynamicClassConsumer;
            this.twrCloseResourceMethodConsumer = twrCloseResourceMethodConsumer;
            this.additions = additions;
            this.onCompanionMethodCallback = onCompanionMethodCallback;
        }

        private void finalizeInvokeSpecialDesugaring() {
            Collections.sort(this.pendingInvokeSpecialBridges);
            this.pendingInvokeSpecialBridges.forEach(info -> info.getVirtualMethod().setCode(info.getVirtualMethodCode(), this.appView));
        }

        private void finalizeLambdaDesugaring() {
            ArrayList<Map.Entry<LambdaClass, ProgramMethod>> sortedSynthesizedLambdaClasses = new ArrayList<Map.Entry<LambdaClass, ProgramMethod>>(this.synthesizedLambdaClasses.entrySet());
            sortedSynthesizedLambdaClasses.sort(Comparator.comparing(entry -> ((LambdaClass)entry.getKey()).getType()));
            Set<DexProgramClass> classesWithSerializableLambdas = Sets.newIdentityHashSet();
            sortedSynthesizedLambdaClasses.forEach(entry -> {
                LambdaClass lambdaClass = (LambdaClass)entry.getKey();
                ProgramMethod context = (ProgramMethod)entry.getValue();
                lambdaClass.target.ensureAccessibilityIfNeeded();
                if (lambdaClass.descriptor.interfaces.contains(this.appView.dexItemFactory().serializableType)) {
                    classesWithSerializableLambdas.add(context.getHolder());
                }
            });
            LambdaDeserializationMethodRemover.run(this.appView, classesWithSerializableLambdas);
        }

        @Override
        public void acceptCompanionMethod(ProgramMethod method, ProgramMethod companionMethod) {
            this.onCompanionMethodCallback.accept(method, companionMethod);
        }

        @Override
        public void acceptDesugaredLibraryRetargeterDispatchClasspathClass(DexClasspathClass clazz) {
            this.additions.addLiveClasspathClass(clazz);
        }

        @Override
        public void acceptClasspathEmulatedInterface(DexClasspathClass clazz) {
            this.additions.addLiveClasspathClass(clazz);
        }

        @Override
        public void acceptCompanionClassClinit(ProgramMethod method) {
        }

        @Override
        public void acceptRecordClass(DexProgramClass recordClass) {
        }

        @Override
        public void acceptArrayConversion(ProgramMethod arrayConversion) {
        }

        @Override
        public void acceptRecordMethod(ProgramMethod method) {
        }

        @Override
        public void acceptThrowMethod(ProgramMethod method, ProgramMethod context) {
        }

        @Override
        public void acceptInvokeStaticInterfaceOutliningMethod(ProgramMethod method, ProgramMethod context) {
            this.additions.addMinimumKeepInfo(method, KeepMethodInfo.Joiner::disallowInlining);
        }

        @Override
        public void acceptWrapperClasspathClass(DexClasspathClass clazz) {
            this.additions.addLiveClasspathClass(clazz);
        }

        @Override
        public void acceptEnumConversionClasspathClass(DexClasspathClass clazz) {
            this.additions.addLiveClasspathClass(clazz);
        }

        @Override
        public void acceptAPIConversion(ProgramMethod method) {
        }

        @Override
        public void acceptBackportedMethod(ProgramMethod backportedMethod, ProgramMethod context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptInvokeSpecialBridgeInfo(InvokeSpecialBridgeInfo info) {
            List<InvokeSpecialBridgeInfo> list = this.pendingInvokeSpecialBridges;
            synchronized (list) {
                this.pendingInvokeSpecialBridges.add(info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptLambdaClass(LambdaClass lambdaClass, ProgramMethod context) {
            Map<LambdaClass, ProgramMethod> map = this.synthesizedLambdaClasses;
            synchronized (map) {
                this.synthesizedLambdaClasses.put(lambdaClass, context);
            }
            this.lambdaClassConsumer.accept(lambdaClass, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptConstantDynamicClass(ConstantDynamicClass constantDynamicClass, ProgramMethod context) {
            List<ConstantDynamicClass> list = this.synthesizedConstantDynamicClasses;
            synchronized (list) {
                this.synthesizedConstantDynamicClasses.add(constantDynamicClass);
            }
            this.constantDynamicClassConsumer.accept(constantDynamicClass, context);
        }

        @Override
        public void acceptNestFieldGetBridge(ProgramField target, ProgramMethod bridge) {
            assert (false);
        }

        @Override
        public void acceptNestFieldPutBridge(ProgramField target, ProgramMethod bridge) {
            assert (false);
        }

        @Override
        public void acceptNestMethodBridge(ProgramMethod target, ProgramMethod bridge) {
            assert (false);
        }

        @Override
        public void acceptTwrCloseResourceMethod(ProgramMethod closeMethod, ProgramMethod context) {
            this.twrCloseResourceMethodConsumer.accept(closeMethod, context);
        }

        public void finalizeDesugaring() {
            this.finalizeInvokeSpecialDesugaring();
            this.finalizeLambdaDesugaring();
        }

        @Override
        public void acceptOutlinedMethod(ProgramMethod outlinedMethod, ProgramMethod context) {
        }
    }

    public static class D8CfInstructionDesugaringEventConsumer
    extends CfInstructionDesugaringEventConsumer {
        private final D8MethodProcessor methodProcessor;
        private final Map<DexReference, InvokeSpecialBridgeInfo> pendingInvokeSpecialBridges = new LinkedHashMap<DexReference, InvokeSpecialBridgeInfo>();
        private final List<LambdaClass> synthesizedLambdaClasses = new ArrayList<LambdaClass>();
        private final List<ConstantDynamicClass> synthesizedConstantDynamicClasses = new ArrayList<ConstantDynamicClass>();

        private D8CfInstructionDesugaringEventConsumer(D8MethodProcessor methodProcessor) {
            this.methodProcessor = methodProcessor;
        }

        private void finalizeInvokeSpecialDesugaring(AppView<?> appView, Consumer<ProgramMethod> needsProcessing) {
            this.pendingInvokeSpecialBridges.values().forEach(info -> {
                ProgramMethod newDirectMethod = info.getNewDirectMethod();
                newDirectMethod.setCode(((DexEncodedMethod)info.getVirtualMethod().getDefinition()).getCode(), appView);
            });
            this.pendingInvokeSpecialBridges.values().forEach(info -> {
                info.getVirtualMethod().setCode(info.getVirtualMethodCode(), appView);
                needsProcessing.accept(info.getVirtualMethod());
            });
            this.pendingInvokeSpecialBridges.clear();
        }

        private void finalizeLambdaDesugaring(ClassConverterResult.Builder classConverterResultBuilder, Consumer<ProgramMethod> needsProcessing) {
            this.synthesizedLambdaClasses.sort(Comparator.comparing(LambdaClass::getType));
            for (LambdaClass lambdaClass : this.synthesizedLambdaClasses) {
                lambdaClass.target.ensureAccessibilityIfNeeded(classConverterResultBuilder, needsProcessing);
                lambdaClass.getLambdaProgramClass().forEachProgramMethod(needsProcessing);
            }
            this.synthesizedLambdaClasses.clear();
        }

        private void finalizeConstantDynamicDesugaring(Consumer<ProgramMethod> needsProcessing) {
            for (ConstantDynamicClass constantDynamicClass : this.synthesizedConstantDynamicClasses) {
                constantDynamicClass.rewriteBootstrapMethodSignatureIfNeeded();
                constantDynamicClass.getConstantDynamicProgramClass().forEachProgramMethod(needsProcessing);
            }
            this.synthesizedConstantDynamicClasses.clear();
        }

        @Override
        public void acceptCompanionMethod(ProgramMethod method, ProgramMethod companionMethod) {
        }

        @Override
        public void acceptDesugaredLibraryRetargeterDispatchClasspathClass(DexClasspathClass clazz) {
        }

        @Override
        public void acceptClasspathEmulatedInterface(DexClasspathClass clazz) {
        }

        @Override
        public void acceptArrayConversion(ProgramMethod arrayConversion) {
            this.methodProcessor.scheduleMethodForProcessing(arrayConversion, this);
        }

        @Override
        public void acceptBackportedMethod(ProgramMethod backportedMethod, ProgramMethod context) {
            this.methodProcessor.scheduleMethodForProcessing(backportedMethod, this);
        }

        @Override
        public void acceptRecordMethod(ProgramMethod method) {
            this.methodProcessor.scheduleDesugaredMethodForProcessing(method);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptInvokeSpecialBridgeInfo(InvokeSpecialBridgeInfo info) {
            Map<DexReference, InvokeSpecialBridgeInfo> map = this.pendingInvokeSpecialBridges;
            synchronized (map) {
                assert (!this.pendingInvokeSpecialBridges.containsKey(info.getNewDirectMethod().getReference()));
                this.pendingInvokeSpecialBridges.put(info.getNewDirectMethod().getReference(), info);
            }
        }

        @Override
        public void acceptRecordClass(DexProgramClass recordClass) {
            this.methodProcessor.scheduleDesugaredMethodsForProcessing(recordClass.programMethods());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptLambdaClass(LambdaClass lambdaClass, ProgramMethod context) {
            List<LambdaClass> list = this.synthesizedLambdaClasses;
            synchronized (list) {
                this.synthesizedLambdaClasses.add(lambdaClass);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acceptConstantDynamicClass(ConstantDynamicClass constantDynamicClass, ProgramMethod context) {
            List<ConstantDynamicClass> list = this.synthesizedConstantDynamicClasses;
            synchronized (list) {
                this.synthesizedConstantDynamicClasses.add(constantDynamicClass);
            }
        }

        @Override
        public void acceptNestFieldGetBridge(ProgramField target, ProgramMethod bridge) {
            assert (false);
        }

        @Override
        public void acceptNestFieldPutBridge(ProgramField target, ProgramMethod bridge) {
            assert (false);
        }

        @Override
        public void acceptNestMethodBridge(ProgramMethod target, ProgramMethod bridge) {
            assert (false);
        }

        @Override
        public void acceptTwrCloseResourceMethod(ProgramMethod closeMethod, ProgramMethod context) {
            this.methodProcessor.scheduleMethodForProcessing(closeMethod, this);
        }

        @Override
        public void acceptThrowMethod(ProgramMethod method, ProgramMethod context) {
            this.methodProcessor.scheduleDesugaredMethodForProcessing(method);
        }

        @Override
        public void acceptInvokeStaticInterfaceOutliningMethod(ProgramMethod method, ProgramMethod context) {
            this.methodProcessor.scheduleDesugaredMethodForProcessing(method);
        }

        @Override
        public void acceptWrapperClasspathClass(DexClasspathClass clazz) {
        }

        @Override
        public void acceptEnumConversionClasspathClass(DexClasspathClass clazz) {
        }

        @Override
        public void acceptAPIConversion(ProgramMethod method) {
            this.methodProcessor.scheduleDesugaredMethodForProcessing(method);
        }

        @Override
        public void acceptCompanionClassClinit(ProgramMethod method) {
            this.methodProcessor.scheduleDesugaredMethodForProcessing(method);
        }

        public List<ProgramMethod> finalizeDesugaring(AppView<?> appView, ClassConverterResult.Builder classConverterResultBuilder) {
            ArrayList<ProgramMethod> needsProcessing = new ArrayList<ProgramMethod>();
            this.finalizeInvokeSpecialDesugaring(appView, needsProcessing::add);
            this.finalizeLambdaDesugaring(classConverterResultBuilder, needsProcessing::add);
            this.finalizeConstantDynamicDesugaring(needsProcessing::add);
            return needsProcessing;
        }

        public boolean verifyNothingToFinalize() {
            assert (this.pendingInvokeSpecialBridges.isEmpty());
            assert (this.synthesizedLambdaClasses.isEmpty());
            assert (this.synthesizedConstantDynamicClasses.isEmpty());
            return true;
        }

        @Override
        public void acceptOutlinedMethod(ProgramMethod outlinedMethod, ProgramMethod context) {
            this.methodProcessor.scheduleDesugaredMethodForProcessing(outlinedMethod);
        }
    }
}

