/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaring;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryAPICallbackSynthesizer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterPostProcessor;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodProcessorFacade;
import com.android.tools.r8.ir.desugar.records.RecordDesugaring;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

public abstract class CfPostProcessingDesugaringCollection {
    public static CfPostProcessingDesugaringCollection create(AppView<?> appView, InterfaceMethodProcessorFacade interfaceMethodProcessorFacade) {
        if (appView.options().desugarState.isOn()) {
            return NonEmptyCfPostProcessingDesugaringCollection.create(appView, interfaceMethodProcessorFacade);
        }
        return CfPostProcessingDesugaringCollection.empty();
    }

    static CfPostProcessingDesugaringCollection empty() {
        return EmptyCfPostProcessingDesugaringCollection.getInstance();
    }

    public abstract void postProcessingDesugaring(Collection<DexProgramClass> var1, Predicate<ProgramMethod> var2, CfPostProcessingDesugaringEventConsumer var3, ExecutorService var4) throws ExecutionException;

    public static class EmptyCfPostProcessingDesugaringCollection
    extends CfPostProcessingDesugaringCollection {
        private static final EmptyCfPostProcessingDesugaringCollection INSTANCE = new EmptyCfPostProcessingDesugaringCollection();

        private EmptyCfPostProcessingDesugaringCollection() {
        }

        private static EmptyCfPostProcessingDesugaringCollection getInstance() {
            return INSTANCE;
        }

        @Override
        public void postProcessingDesugaring(Collection<DexProgramClass> programClasses, Predicate<ProgramMethod> isLiveMethod, CfPostProcessingDesugaringEventConsumer eventConsumer, ExecutorService executorService) throws ExecutionException {
        }
    }

    public static class NonEmptyCfPostProcessingDesugaringCollection
    extends CfPostProcessingDesugaringCollection {
        private final List<CfPostProcessingDesugaring> desugarings;

        public NonEmptyCfPostProcessingDesugaringCollection(List<CfPostProcessingDesugaring> desugarings) {
            this.desugarings = desugarings;
        }

        public static CfPostProcessingDesugaringCollection create(AppView<?> appView, InterfaceMethodProcessorFacade interfaceMethodProcessorFacade) {
            RecordDesugaring recordRewriter;
            DesugaredLibraryAPICallbackSynthesizer apiCallbackSynthesizor;
            ArrayList<CfPostProcessingDesugaring> desugarings = new ArrayList<CfPostProcessingDesugaring>();
            if (appView.options().machineDesugaredLibrarySpecification.hasRetargeting() && !appView.options().isDesugaredLibraryCompilation()) {
                desugarings.add(new DesugaredLibraryRetargeterPostProcessor(appView));
            }
            if (interfaceMethodProcessorFacade != null) {
                desugarings.add(interfaceMethodProcessorFacade);
            }
            DesugaredLibraryAPICallbackSynthesizer desugaredLibraryAPICallbackSynthesizer = apiCallbackSynthesizor = appView.typeRewriter.isRewriting() ? new DesugaredLibraryAPICallbackSynthesizer(appView) : null;
            if (apiCallbackSynthesizor != null) {
                desugarings.add(apiCallbackSynthesizor);
            }
            if ((recordRewriter = RecordDesugaring.create(appView)) != null) {
                desugarings.add(recordRewriter);
            }
            if (desugarings.isEmpty()) {
                return NonEmptyCfPostProcessingDesugaringCollection.empty();
            }
            return new NonEmptyCfPostProcessingDesugaringCollection(desugarings);
        }

        @Override
        public void postProcessingDesugaring(Collection<DexProgramClass> programClasses, Predicate<ProgramMethod> isLiveMethod, CfPostProcessingDesugaringEventConsumer eventConsumer, ExecutorService executorService) throws ExecutionException {
            for (CfPostProcessingDesugaring desugaring : this.desugarings) {
                desugaring.postProcessingDesugaring(programClasses, eventConsumer, executorService);
            }
        }
    }
}

