/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import java.util.Collection;

public class InvokeToPrivateRewriter
implements CfInstructionDesugaring {
    private DexEncodedMethod privateMethodInvokedOnSelf(CfInvoke invoke, ProgramMethod context) {
        DexMethod method = invoke.getMethod();
        if (method.getHolderType() != context.getHolderType()) {
            return null;
        }
        DexEncodedMethod directTarget = context.getHolder().lookupDirectMethod(method);
        if (directTarget != null && !directTarget.isStatic()) {
            assert (method.holder == directTarget.getHolderType());
            return directTarget;
        }
        return null;
    }

    private boolean isInvokingPrivateMethodOnSelf(CfInvoke invoke, ProgramMethod context) {
        return this.privateMethodInvokedOnSelf(invoke, context) != null;
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (!instruction.isInvokeVirtual() && !instruction.isInvokeInterface()) {
            return null;
        }
        CfInvoke invoke = instruction.asInvoke();
        DexMethod method = invoke.getMethod();
        DexEncodedMethod privateMethod = this.privateMethodInvokedOnSelf(invoke, context);
        if (privateMethod == null) {
            return null;
        }
        return ImmutableList.of(new CfInvoke(183, method, invoke.isInterface()));
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (!instruction.isInvokeVirtual() && !instruction.isInvokeInterface()) {
            return false;
        }
        return this.isInvokingPrivateMethodOnSelf(instruction.asInvoke(), context);
    }
}

