/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class LambdaDescriptor {
    private static final int LAMBDA_ALT_SERIALIZABLE = 1;
    private static final int LAMBDA_ALT_HAS_EXTRA_INTERFACES = 2;
    private static final int LAMBDA_ALT_HAS_BRIDGES = 4;
    private static final int LAMBDA_ALT_MASK = 7;
    static final LambdaDescriptor MATCH_FAILED = new LambdaDescriptor();
    final String uniqueId;
    final DexMethod mainMethod;
    public final DexString name;
    final DexProto erasedProto;
    final DexProto enforcedProto;
    public final DexMethodHandle implHandle;
    public final List<DexType> interfaces = new ArrayList<DexType>();
    public final Set<DexProto> bridges = Sets.newIdentityHashSet();
    public final DexTypeList captures;
    private final MethodAccessFlags targetAccessFlags;
    private final DexType targetHolder;

    private LambdaDescriptor() {
        this.uniqueId = null;
        this.name = null;
        this.erasedProto = null;
        this.enforcedProto = null;
        this.implHandle = null;
        this.captures = null;
        this.targetAccessFlags = null;
        this.targetHolder = null;
        this.mainMethod = null;
    }

    private LambdaDescriptor(AppInfoWithClassHierarchy appInfo, ProgramMethod context, DexCallSite callSite, DexString name, DexProto erasedProto, DexProto enforcedProto, DexMethodHandle implHandle, DexType mainInterface, DexTypeList captures) {
        DexEncodedMethod targetMethod;
        assert (appInfo != null);
        assert (callSite != null);
        assert (name != null);
        assert (erasedProto != null);
        assert (enforcedProto != null);
        assert (implHandle != null);
        assert (mainInterface != null);
        assert (captures != null);
        this.mainMethod = appInfo.dexItemFactory().createMethod(mainInterface, erasedProto, name);
        this.uniqueId = callSite.getHash();
        this.name = name;
        this.erasedProto = erasedProto;
        this.enforcedProto = enforcedProto;
        this.implHandle = implHandle;
        this.captures = captures;
        this.interfaces.add(mainInterface);
        DexEncodedMethod dexEncodedMethod = targetMethod = context == null ? null : this.lookupTargetMethod(appInfo, context);
        if (targetMethod != null) {
            this.targetAccessFlags = targetMethod.accessFlags.copy();
            this.targetHolder = targetMethod.getHolderType();
        } else {
            this.targetAccessFlags = null;
            this.targetHolder = null;
        }
    }

    private DexEncodedMethod lookupTargetMethod(AppInfoWithClassHierarchy appInfo, ProgramMethod context) {
        assert (context != null);
        DexMethod method = this.implHandle.asMethod();
        switch (this.implHandle.type) {
            case INVOKE_DIRECT: 
            case INVOKE_INSTANCE: {
                DexEncodedMethod target = appInfo.resolveMethodOn(this.getImplReceiverType(), method, this.implHandle.isInterface).getSingleTarget();
                if (target == null) {
                    target = appInfo.lookupDirectTarget(method, context);
                }
                assert (target == null || this.implHandle.type.isInvokeInstance() && this.isInstanceMethod(target) || this.implHandle.type.isInvokeDirect() && this.isPrivateInstanceMethod(target) || this.implHandle.type.isInvokeDirect() && this.isPublicizedInstanceMethod(target));
                return target;
            }
            case INVOKE_STATIC: {
                DexEncodedMethod target = appInfo.lookupStaticTarget(method, context);
                assert (target == null || target.accessFlags.isStatic());
                return target;
            }
            case INVOKE_CONSTRUCTOR: {
                DexEncodedMethod target = appInfo.lookupDirectTarget(method, context);
                assert (target == null || target.accessFlags.isConstructor());
                return target;
            }
            case INVOKE_INTERFACE: {
                DexEncodedMethod target = appInfo.resolveMethodOnInterface(this.getImplReceiverType(), method).getSingleTarget();
                assert (target == null || this.isInstanceMethod(target));
                return target;
            }
        }
        throw new Unreachable("Unexpected method handle kind in " + this.implHandle);
    }

    private boolean isInstanceMethod(DexEncodedMethod encodedMethod) {
        assert (encodedMethod != null);
        return !encodedMethod.accessFlags.isConstructor() && !encodedMethod.isStatic();
    }

    private boolean isPrivateInstanceMethod(DexEncodedMethod encodedMethod) {
        assert (encodedMethod != null);
        return encodedMethod.isPrivateMethod() && this.isInstanceMethod(encodedMethod);
    }

    private boolean isPublicizedInstanceMethod(DexEncodedMethod encodedMethod) {
        assert (encodedMethod != null);
        return encodedMethod.isPublicized() && this.isInstanceMethod(encodedMethod);
    }

    public static LambdaDescriptor tryInfer(DexCallSite callSite, AppInfoWithClassHierarchy appInfo, ProgramMethod context) {
        LambdaDescriptor descriptor = LambdaDescriptor.infer(callSite, appInfo, context);
        return descriptor == MATCH_FAILED ? null : descriptor;
    }

    public static DexMethod getMainFunctionalInterfaceMethodReference(DexCallSite callSite, DexItemFactory factory) {
        DexProto proto = (DexProto)callSite.getBootstrapArgs().get((int)0).asDexValueMethodType().value;
        DexProto lambdaFactoryProto = callSite.methodProto;
        DexType mainInterface = lambdaFactoryProto.returnType;
        DexString funcMethodName = callSite.methodName;
        return factory.createMethod(mainInterface, proto, funcMethodName);
    }

    public static boolean isLambdaMetafactoryMethod(DexCallSite callSite, DexDefinitionSupplier definitions) {
        return callSite.bootstrapMethod.type.isInvokeStatic() && definitions.dexItemFactory().isLambdaMetafactoryMethod(callSite.bootstrapMethod.asMethod());
    }

    static LambdaDescriptor infer(DexCallSite callSite, AppInfoWithClassHierarchy appInfo, ProgramMethod context) {
        if (!LambdaDescriptor.isLambdaMetafactoryMethod(callSite, appInfo)) {
            return MATCH_FAILED;
        }
        DexItemFactory factory = appInfo.dexItemFactory();
        DexMethod bootstrapMethod = callSite.bootstrapMethod.asMethod();
        DexString funcMethodName = callSite.methodName;
        DexValue.DexValueMethodType funcErasedSignature = LambdaDescriptor.getBootstrapArgument(callSite.bootstrapArgs, 0, DexValue.DexValueMethodType.class);
        DexMethodHandle lambdaImplMethodHandle = (DexMethodHandle)LambdaDescriptor.getBootstrapArgument(callSite.bootstrapArgs, (int)1, DexValue.DexValueMethodHandle.class).value;
        DexValue.DexValueMethodType funcEnforcedSignature = LambdaDescriptor.getBootstrapArgument(callSite.bootstrapArgs, 2, DexValue.DexValueMethodType.class);
        if (!LambdaDescriptor.isEnforcedSignatureValid(factory, (DexProto)funcEnforcedSignature.value, (DexProto)funcErasedSignature.value)) {
            throw new Unreachable("Enforced and erased signatures are inconsistent in " + callSite.toString());
        }
        DexProto lambdaFactoryProto = callSite.methodProto;
        DexType mainFuncInterface = lambdaFactoryProto.returnType;
        DexTypeList captures = lambdaFactoryProto.parameters;
        LambdaDescriptor match = new LambdaDescriptor(appInfo, context, callSite, funcMethodName, (DexProto)funcErasedSignature.value, (DexProto)funcEnforcedSignature.value, lambdaImplMethodHandle, mainFuncInterface, captures);
        if (bootstrapMethod == factory.metafactoryMethod) {
            if (callSite.bootstrapArgs.size() != 3) {
                throw new Unreachable("Unexpected number of metafactory method arguments in " + callSite.toString());
            }
        } else {
            LambdaDescriptor.extractAltMetafactory(factory, callSite.bootstrapArgs, interfaceType -> {
                if (!match.interfaces.contains(interfaceType)) {
                    match.interfaces.add((DexType)interfaceType);
                }
            }, match.bridges::add);
        }
        return match;
    }

    private static void extractAltMetafactory(DexItemFactory dexItemFactory, List<DexValue> bootstrapArgs, Consumer<DexType> interfaceConsumer, Consumer<DexProto> bridgeConsumer) {
        int i;
        int count;
        int argIndex = 3;
        int flagsArg = LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueInt.class).value;
        assert ((flagsArg & 0xFFFFFFF8) == 0);
        if ((flagsArg & 2) != 0) {
            count = LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueInt.class).value;
            for (i = 0; i < count; ++i) {
                DexType interfaceType = (DexType)LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueType.class).value;
                interfaceConsumer.accept(interfaceType);
            }
        }
        if ((flagsArg & 1) != 0) {
            interfaceConsumer.accept(dexItemFactory.serializableType);
        }
        if ((flagsArg & 4) != 0) {
            count = LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueInt.class).value;
            for (i = 0; i < count; ++i) {
                DexProto bridgeProto = (DexProto)LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueMethodType.class).value;
                bridgeConsumer.accept(bridgeProto);
            }
        }
        if (bootstrapArgs.size() != argIndex) {
            throw new Unreachable("Unexpected number of metafactory method arguments in DexCallSite");
        }
    }

    public static List<DexType> getInterfaces(DexCallSite callSite, AppInfoWithClassHierarchy appInfo) {
        LambdaDescriptor descriptor = LambdaDescriptor.infer(callSite, appInfo, null);
        if (descriptor == MATCH_FAILED) {
            return null;
        }
        return descriptor.interfaces;
    }

    private static <T> T getBootstrapArgument(List<DexValue> bootstrapArgs, int i, Class<T> clazz) {
        if (bootstrapArgs.size() < i) {
            throw new Unreachable("Expected to find at least " + i + " bootstrap arguments in DexCallSite");
        }
        DexValue value = bootstrapArgs.get(i);
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new Unreachable("Unexpected type of bootstrap arguments #" + i + " in DexCallSite");
        }
        return (T)value;
    }

    private static boolean isEnforcedSignatureValid(DexItemFactory factory, DexProto enforced, DexProto erased) {
        if (!LambdaDescriptor.isSameOrDerived(factory, enforced.returnType, erased.returnType)) {
            return false;
        }
        DexType[] enforcedValues = enforced.parameters.values;
        int count = enforcedValues.length;
        DexType[] erasedValues = erased.parameters.values;
        if (count != erasedValues.length) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (LambdaDescriptor.isSameOrDerived(factory, enforcedValues[i], erasedValues[i])) continue;
            return false;
        }
        return true;
    }

    static boolean isSameOrDerived(DexItemFactory factory, DexType subType, DexType superType) {
        if (subType == superType || subType.isClassType() && superType.isClassType()) {
            return true;
        }
        if (subType.isArrayType()) {
            if (superType.isArrayType()) {
                return LambdaDescriptor.isSameOrDerived(factory, subType.toArrayElementType(factory), superType.toArrayElementType(factory));
            }
            return superType == factory.objectType;
        }
        return false;
    }

    public DexMethod getMainMethod() {
        return this.mainMethod;
    }

    final DexType getImplReceiverType() {
        DexType[] params = this.enforcedProto.parameters.values;
        DexType[] captures = this.captures.values;
        assert (captures.length > 0 || params.length > 0);
        return captures.length > 0 ? captures[0] : params[0];
    }

    public final boolean verifyTargetFoundInClass(DexType type) {
        return this.targetHolder == type;
    }

    public boolean delegatesToLambdaImplMethod(DexItemFactory factory) {
        return this.implHandle.asMethod().getName().startsWith(factory.javacLambdaMethodPrefix);
    }

    public void forEachErasedAndEnforcedTypes(BiConsumer<DexType, DexType> consumer) {
        consumer.accept(this.erasedProto.returnType, this.enforcedProto.returnType);
        for (int i = 0; i < this.enforcedProto.getArity(); ++i) {
            consumer.accept(this.erasedProto.getParameter(i), this.enforcedProto.getParameter(i));
        }
    }

    public Iterable<DexType> getReferencedBaseTypes(DexItemFactory dexItemFactory) {
        return this.enforcedProto.getBaseTypes(dexItemFactory);
    }

    final boolean isStateless() {
        return this.captures.isEmpty();
    }

    boolean needsAccessor(ProgramMethod accessedFrom) {
        if (this.implHandle.type.isInvokeInterface()) {
            return false;
        }
        boolean staticTarget = this.implHandle.type.isInvokeStatic();
        boolean instanceTarget = this.implHandle.type.isInvokeInstance() || this.implHandle.type.isInvokeDirect();
        boolean initTarget = this.implHandle.type.isInvokeConstructor();
        assert (instanceTarget || staticTarget || initTarget);
        assert (!this.implHandle.type.isInvokeDirect() || this.targetAccessFlags.isPrivate() && !this.targetAccessFlags.isConstructor() && !this.targetAccessFlags.isStatic());
        if (this.targetAccessFlags == null) {
            if (staticTarget || initTarget) {
                boolean accessedFromSamePackage = accessedFrom.getHolderType().getPackageDescriptor().equals(this.implHandle.asMethod().holder.getPackageDescriptor());
                return !accessedFromSamePackage;
            }
            return true;
        }
        MethodAccessFlags flags = this.targetAccessFlags;
        if (flags.isPrivate()) {
            return true;
        }
        if (flags.isPublic()) {
            return false;
        }
        boolean accessedFromSamePackage = accessedFrom.getHolderType().getPackageDescriptor().equals(this.targetHolder.getPackageDescriptor());
        assert (flags.isProtected() || accessedFromSamePackage);
        return flags.isProtected() && !accessedFromSamePackage;
    }
}

