/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.apimodel;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.apimodel.ApiInvokeOutlinerDesugaringEventConsumer;
import com.android.tools.r8.ir.synthetic.ForwardMethodBuilder;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.Collection;

public class ApiInvokeOutlinerDesugaring
implements CfInstructionDesugaring {
    private final AppView<?> appView;
    private final AndroidApiLevelCompute apiLevelCompute;

    public ApiInvokeOutlinerDesugaring(AppView<?> appView, AndroidApiLevelCompute apiLevelCompute) {
        this.appView = appView;
        this.apiLevelCompute = apiLevelCompute;
    }

    private ComputedApiLevel getComputedApiLevelForMethodOnHolderWithMinApi(CfInstruction instruction) {
        if (!instruction.isInvoke()) {
            return this.appView.computedMinApiLevel();
        }
        CfInvoke cfInvoke = instruction.asInvoke();
        if (cfInvoke.isInvokeSpecial()) {
            return this.appView.computedMinApiLevel();
        }
        DexType holderType = cfInvoke.getMethod().getHolderType();
        if (!holderType.isClassType()) {
            return this.appView.computedMinApiLevel();
        }
        DexClass holder = this.appView.definitionFor(holderType);
        if (holder == null || !holder.isLibraryClass()) {
            return this.appView.computedMinApiLevel();
        }
        ComputedApiLevel methodApiLevel = this.apiLevelCompute.computeApiLevelForLibraryReference(cfInvoke.getMethod(), ComputedApiLevel.unknown());
        if (this.appView.computedMinApiLevel().isGreaterThanOrEqualTo(methodApiLevel) || this.isApiLevelLessThanOrEqualTo9(methodApiLevel) || methodApiLevel.isUnknownApiLevel()) {
            return this.appView.computedMinApiLevel();
        }
        ComputedApiLevel holderApiLevel = this.apiLevelCompute.computeApiLevelForLibraryReference(holderType, ComputedApiLevel.unknown());
        if (holderApiLevel.isGreaterThanOrEqualTo(methodApiLevel)) {
            return this.appView.computedMinApiLevel();
        }
        if (holder.isInterface()) {
            return methodApiLevel;
        }
        DexEncodedMethod methodDefinition = this.simpleLookupInClassHierarchy(holder.asLibraryClass(), cfInvoke.getMethod());
        return methodDefinition != null && methodDefinition.isPublic() ? methodApiLevel : this.appView.computedMinApiLevel();
    }

    private DexEncodedMethod simpleLookupInClassHierarchy(DexLibraryClass holder, DexMethod method) {
        DexEncodedMethod result = holder.lookupMethod(method);
        if (result != null) {
            return result;
        }
        TraversalContinuation traversalResult = this.appView.appInfoForDesugaring().traverseSuperClasses(holder, (ignored, superClass, ignored_) -> {
            DexEncodedMethod definition = superClass.lookupMethod(method);
            if (definition != null) {
                return TraversalContinuation.doBreak(definition);
            }
            return TraversalContinuation.doContinue();
        });
        return traversalResult.isBreak() ? (DexEncodedMethod)traversalResult.asBreak().getValue() : null;
    }

    private boolean isApiLevelLessThanOrEqualTo9(ComputedApiLevel apiLevel) {
        return apiLevel.isKnownApiLevel() && apiLevel.asKnownApiLevel().getApiLevel().isLessThanOrEqualTo(AndroidApiLevel.G);
    }

    private Collection<CfInstruction> desugarLibraryCall(CompilationContext.UniqueContext uniqueContext, CfInvoke invoke, ComputedApiLevel computedApiLevel, DexItemFactory factory, ApiInvokeOutlinerDesugaringEventConsumer eventConsumer, ProgramMethod context) {
        DexMethod method = invoke.getMethod();
        ProgramMethod outlinedMethod = this.ensureOutlineMethod(uniqueContext, method, computedApiLevel, factory, invoke);
        eventConsumer.acceptOutlinedMethod(outlinedMethod, context);
        return ImmutableList.of(new CfInvoke(184, (DexMethod)outlinedMethod.getReference(), false));
    }

    private ProgramMethod ensureOutlineMethod(CompilationContext.UniqueContext context, DexMethod apiMethod, ComputedApiLevel apiLevel, DexItemFactory factory, CfInvoke invoke) {
        boolean isVirtualMethod;
        DexClass libraryHolder = this.appView.definitionFor(apiMethod.getHolderType());
        assert (libraryHolder != null);
        boolean bl = isVirtualMethod = invoke.isInvokeVirtual() || invoke.isInvokeInterface();
        assert (this.verifyLibraryHolderAndInvoke(libraryHolder, apiMethod, isVirtualMethod));
        DexProto proto = factory.prependHolderToProtoIf(apiMethod, isVirtualMethod);
        return this.appView.getSyntheticItems().createMethod(kinds -> kinds.API_MODEL_OUTLINE, context, this.appView, syntheticMethodBuilder -> syntheticMethodBuilder.setProto(proto).setAccessFlags((MethodAccessFlags)((MethodAccessFlags.Builder)((MethodAccessFlags.Builder)((MethodAccessFlags.Builder)MethodAccessFlags.builder().setPublic()).setSynthetic()).setStatic()).setBridge().build()).setApiLevelForDefinition(apiLevel).setApiLevelForCode(apiLevel).setCode(m3 -> {
            if (isVirtualMethod) {
                return ForwardMethodBuilder.builder(factory).setVirtualTarget(apiMethod, libraryHolder.isInterface()).setNonStaticSource(apiMethod).build();
            }
            return ForwardMethodBuilder.builder(factory).setStaticTarget(apiMethod, libraryHolder.isInterface()).setStaticSource(apiMethod).build();
        }));
    }

    private boolean verifyLibraryHolderAndInvoke(DexClass libraryHolder, DexMethod apiMethod, boolean isVirtualInvoke) {
        DexEncodedMethod libraryApiMethodDefinition = libraryHolder.lookupMethod(apiMethod);
        return libraryApiMethodDefinition == null || libraryApiMethodDefinition.isVirtualMethod() == isVirtualInvoke;
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        ComputedApiLevel computedApiLevel = this.getComputedApiLevelForMethodOnHolderWithMinApi(instruction);
        if (computedApiLevel.isGreaterThan(this.appView.computedMinApiLevel())) {
            return this.desugarLibraryCall(methodProcessingContext.createUniqueContext(), instruction.asInvoke(), computedApiLevel, dexItemFactory, eventConsumer, context);
        }
        return null;
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (((DexEncodedMethod)context.getDefinition()).isD8R8Synthesized()) {
            return false;
        }
        return this.getComputedApiLevelForMethodOnHolderWithMinApi(instruction).isGreaterThan(this.appView.computedMinApiLevel());
    }
}

