/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.backports;

import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfNewArray;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;

public final class CollectionMethodGenerators {
    private CollectionMethodGenerators() {
    }

    public static CfCode generateListOf(InternalOptions options, DexMethod method, int formalCount) {
        return CollectionMethodGenerators.generateFixedMethods(options, method, formalCount, options.itemFactory.listType);
    }

    public static CfCode generateSetOf(InternalOptions options, DexMethod method, int formalCount) {
        return CollectionMethodGenerators.generateFixedMethods(options, method, formalCount, options.itemFactory.setType);
    }

    private static CfCode generateFixedMethods(InternalOptions options, DexMethod method, int formalCount, DexType returnType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(new CfInstruction[]{new CfConstNumber(formalCount, ValueType.INT), new CfNewArray(options.itemFactory.objectArrayType)});
        for (int i = 0; i < formalCount; ++i) {
            builder.add(new CfInstruction[]{new CfStackInstruction(CfStackInstruction.Opcode.Dup), new CfConstNumber(i, ValueType.INT), new CfLoad(ValueType.OBJECT, i), new CfArrayStore(MemberType.OBJECT)});
        }
        builder.add(new CfInstruction[]{new CfInvoke(184, options.itemFactory.createMethod(returnType, options.itemFactory.createProto(returnType, options.itemFactory.objectArrayType), options.itemFactory.createString("of")), false), new CfReturn(ValueType.OBJECT)});
        return new CfCode(method.holder, 4, formalCount, (List<CfInstruction>)((Object)builder.build()));
    }

    public static CfCode generateMapOf(InternalOptions options, DexMethod method, int formalCount) {
        DexType mapEntryArray = options.itemFactory.createArrayType(1, options.itemFactory.mapEntryType);
        DexType simpleEntry = options.itemFactory.abstractMapSimpleEntryType;
        DexMethod simpleEntryConstructor = options.itemFactory.createMethod(simpleEntry, options.itemFactory.createProto(options.itemFactory.voidType, options.itemFactory.objectType, options.itemFactory.objectType), "<init>");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(new CfInstruction[]{new CfConstNumber(formalCount, ValueType.INT), new CfNewArray(mapEntryArray)});
        for (int i = 0; i < formalCount; ++i) {
            builder.add(new CfInstruction[]{new CfStackInstruction(CfStackInstruction.Opcode.Dup), new CfConstNumber(i, ValueType.INT), new CfNew(simpleEntry), new CfStackInstruction(CfStackInstruction.Opcode.Dup), new CfLoad(ValueType.OBJECT, i * 2), new CfLoad(ValueType.OBJECT, i * 2 + 1), new CfInvoke(183, simpleEntryConstructor, false), new CfArrayStore(MemberType.OBJECT)});
        }
        builder.add(new CfInstruction[]{new CfInvoke(184, options.itemFactory.createMethod(options.itemFactory.mapType, options.itemFactory.createProto(options.itemFactory.mapType, mapEntryArray), options.itemFactory.createString("ofEntries")), false), new CfReturn(ValueType.OBJECT)});
        return new CfCode(method.holder, 7, formalCount * 2, (List<CfInstruction>)((Object)builder.build()));
    }
}

