/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.constantdynamic;

import com.android.tools.r8.cf.code.CfConstDynamic;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicClass;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicReference;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.Box;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConstantDynamicInstructionDesugaring
implements CfInstructionDesugaring {
    private final AppView<?> appView;
    private final Map<DexType, Map<ConstantDynamicReference, ConstantDynamicClass>> dynamicConstantSyntheticsPerClass = new ConcurrentHashMap<DexType, Map<ConstantDynamicReference, ConstantDynamicClass>>();

    public ConstantDynamicInstructionDesugaring(AppView<?> appView) {
        this.appView = appView;
    }

    private Collection<CfInstruction> desugarConstDynamicInstruction(CfConstDynamic invoke, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, ConstantDynamicDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext) {
        ConstantDynamicClass constantDynamicClass = this.ensureConstantDynamicClass(invoke, context, methodProcessingContext, eventConsumer);
        return constantDynamicClass.desugarConstDynamicInstruction(invoke, freshLocalProvider, localStackAllocator, eventConsumer, context, methodProcessingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstantDynamicClass ensureConstantDynamicClass(CfConstDynamic constantDynamic, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, ConstantDynamicDesugaringEventConsumer eventConsumer) {
        Map dynamicConstantSyntheticsForClass = this.dynamicConstantSyntheticsPerClass.computeIfAbsent(context.getHolderType(), ignore -> new HashMap());
        ConstantDynamicClass result = (ConstantDynamicClass)dynamicConstantSyntheticsForClass.get(constantDynamic.getReference());
        if (result == null) {
            Map map = dynamicConstantSyntheticsForClass;
            synchronized (map) {
                result = (ConstantDynamicClass)dynamicConstantSyntheticsForClass.get(constantDynamic.getReference());
                if (result == null) {
                    result = this.createConstantDynamicClass(constantDynamic, context, methodProcessingContext, eventConsumer);
                    dynamicConstantSyntheticsForClass.put(constantDynamic.getReference(), result);
                }
            }
        }
        return result;
    }

    private ConstantDynamicClass createConstantDynamicClass(CfConstDynamic constantDynamic, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, ConstantDynamicDesugaringEventConsumer eventConsumer) {
        Box box = new Box();
        DexProgramClass clazz = this.appView.getSyntheticItems().createClass(kinds -> kinds.CONST_DYNAMIC, methodProcessingContext.createUniqueContext(), this.appView, builder -> box.set(new ConstantDynamicClass((SyntheticProgramClassBuilder)builder, this.appView, this, context, constantDynamic)));
        ConstantDynamicClass constantDynamicClass = (ConstantDynamicClass)box.get();
        constantDynamicClass.setClass(clazz);
        eventConsumer.acceptConstantDynamicClass(constantDynamicClass, context);
        return constantDynamicClass;
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        return instruction.isConstDynamic();
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (instruction.isConstDynamic()) {
            return this.desugarConstDynamicInstruction(instruction.asConstDynamic(), freshLocalProvider, localStackAllocator, eventConsumer, context, methodProcessingContext);
        }
        return null;
    }
}

