/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.constantdynamic;

import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import java.util.Objects;

public class ConstantDynamicReference {
    private final DexString name;
    private final DexType type;
    private final DexMethodHandle bootstrapMethod;
    private final Object[] bootstrapMethodArguments;

    public ConstantDynamicReference(DexString name, DexType type, DexMethodHandle bootstrapMethod, Object[] bootstrapMethodArguments) {
        assert (bootstrapMethodArguments.length == 0);
        this.name = name;
        this.type = type;
        this.bootstrapMethod = bootstrapMethod;
        this.bootstrapMethodArguments = bootstrapMethodArguments;
    }

    public DexString getName() {
        return this.name;
    }

    public DexType getType() {
        return this.type;
    }

    public DexMethodHandle getBootstrapMethod() {
        return this.bootstrapMethod;
    }

    public Object[] getBootstrapMethodArguments() {
        return this.bootstrapMethodArguments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstantDynamicReference)) {
            return false;
        }
        ConstantDynamicReference other = (ConstantDynamicReference)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.bootstrapMethod, other.bootstrapMethod);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.bootstrapMethod);
    }
}

