/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.utils.Reporter;
import java.util.Map;

public class DesugaredLibraryAmender {
    private final DexDefinitionSupplier definitions;
    private final Reporter reporter;
    private final ComputedApiLevel minAPILevel;

    public static void run(AppView<?> appView) {
        DesugaredLibraryAmender.run(appView.options().machineDesugaredLibrarySpecification.getAmendLibraryMethods(), appView, appView.options().reporter, appView.computedMinApiLevel());
    }

    public static void run(Map<DexMethod, MethodAccessFlags> amendLibrary, DexDefinitionSupplier definitions, Reporter reporter, ComputedApiLevel minAPILevel) {
        if (amendLibrary.isEmpty()) {
            return;
        }
        new DesugaredLibraryAmender(definitions, reporter, minAPILevel).run(amendLibrary);
    }

    private DesugaredLibraryAmender(DexDefinitionSupplier definitions, Reporter reporter, ComputedApiLevel minAPILevel) {
        this.definitions = definitions;
        this.reporter = reporter;
        this.minAPILevel = minAPILevel;
    }

    private void run(Map<DexMethod, MethodAccessFlags> amendLibrary) {
        amendLibrary.forEach(this::amendLibraryMethod);
    }

    private void amendLibraryMethod(DexMethod method, MethodAccessFlags methodAccessFlags) {
        DexClass dexClass = this.definitions.contextIndependentDefinitionFor(method.getHolderType());
        if (dexClass == null || !dexClass.isLibraryClass()) {
            this.reporter.warning("Desugared library: Cannot amend library method " + method + " because the holder is not a library class" + (dexClass == null ? "(null)." : "."));
            return;
        }
        if (dexClass.lookupMethod(method) != null) {
            return;
        }
        DexEncodedMethod encodedMethod = DexEncodedMethod.syntheticBuilder().setMethod(method).setAccessFlags(methodAccessFlags).setCode(null).setApiLevelForDefinition(this.minAPILevel).build();
        dexClass.getMethodCollection().addMethod(encodedMethod);
    }
}

