/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaring;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryAPIConverter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryWrapperSynthesizer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryWrapperSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.ir.synthetic.DesugaredLibraryAPIConversionCfCodeProvider;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class DesugaredLibraryAPICallbackSynthesizer
implements CfPostProcessingDesugaring {
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final DesugaredLibraryWrapperSynthesizer wrapperSynthesizor;
    private final Set<DexMethod> trackedCallBackAPIs;

    public DesugaredLibraryAPICallbackSynthesizer(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.wrapperSynthesizor = new DesugaredLibraryWrapperSynthesizer(appView);
        this.trackedCallBackAPIs = appView.options().testing.trackDesugaredAPIConversions ? Sets.newConcurrentHashSet() : null;
    }

    private boolean noPendingWrappersOrConversions() {
        for (DexProgramClass pendingSyntheticClass : this.appView.getSyntheticItems().getPendingSyntheticClasses()) {
            assert (!DesugaredLibraryAPIConverter.isAPIConversionSyntheticType(pendingSyntheticClass.type, this.wrapperSynthesizor, this.appView));
        }
        return true;
    }

    private boolean overridesNonFinalLibraryMethod(ProgramMethod method) {
        DexProgramClass holder = method.getHolder();
        WorkList<DexType> workList = WorkList.newIdentityWorkList();
        workList.addIfNotSeen(holder.interfaces.values);
        boolean foundOverrideToRewrite = false;
        if (holder.superType != this.factory.objectType) {
            workList.addIfNotSeen(holder.superType);
        }
        while (workList.hasNext()) {
            DexEncodedMethod dexEncodedMethod;
            DexType current = (DexType)workList.next();
            DexClass dexClass = this.appView.definitionFor(current);
            if (dexClass == null) continue;
            workList.addIfNotSeen(dexClass.interfaces.values);
            if (dexClass.superType != this.factory.objectType) {
                workList.addIfNotSeen(dexClass.superType);
            }
            if (!dexClass.isLibraryClass() && !this.appView.options().isDesugaredLibraryCompilation() || !this.shouldGenerateCallbacksForEmulateInterfaceAPIs(dexClass) || (dexEncodedMethod = dexClass.lookupVirtualMethod((DexMethod)method.getReference())) == null) continue;
            if (this.appView.typeRewriter.hasRewrittenType(dexClass.type, this.appView)) {
                return false;
            }
            if (dexEncodedMethod.isFinal()) {
                return false;
            }
            foundOverrideToRewrite = true;
        }
        return foundOverrideToRewrite;
    }

    private boolean shouldGenerateCallbacksForEmulateInterfaceAPIs(DexClass dexClass) {
        if (this.appView.options().machineDesugaredLibrarySpecification.supportAllCallbacksFromLibrary()) {
            return true;
        }
        MachineDesugaredLibrarySpecification specification = this.appView.options().machineDesugaredLibrarySpecification;
        return !specification.getEmulatedInterfaces().containsKey(dexClass.type) && !specification.isEmulatedInterfaceRewrittenType(dexClass.type);
    }

    private ProgramMethod generateCallbackMethod(DexEncodedMethod originalMethod, DexProgramClass clazz, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryAPICallbackSynthesizorEventConsumer eventConsumer, CompilationContext.MainThreadContext context) {
        DexMethod methodToInstall = DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature((DexMethod)originalMethod.getReference(), clazz.type, this.appView);
        CfCode cfCode = new DesugaredLibraryAPIConversionCfCodeProvider.APICallbackWrapperCfCodeProvider(this.appView, (DexMethod)originalMethod.getReference(), this.wrapperSynthesizor, clazz.isInterface(), eventConsumer, () -> context.createUniqueContext(clazz)).generateCfCode();
        DexEncodedMethod newMethod = this.wrapperSynthesizor.newSynthesizedMethod(methodToInstall, cfCode);
        newMethod.setCode(cfCode, DexEncodedMethod.NO_PARAMETER_INFO);
        if (originalMethod.isLibraryMethodOverride().isTrue()) {
            newMethod.setLibraryMethodOverride(OptionalBool.TRUE);
        }
        ProgramMethod callback = new ProgramMethod(clazz, newMethod);
        assert (eventConsumer != null);
        eventConsumer.acceptAPIConversionCallback(callback);
        return callback;
    }

    private void generateTrackingWarnings() {
        DesugaredLibraryAPIConverter.generateTrackDesugaredAPIWarnings(this.trackedCallBackAPIs, "callback ", this.appView);
    }

    @Override
    public void postProcessingDesugaring(Collection<DexProgramClass> programClasses, CfPostProcessingDesugaringEventConsumer eventConsumer, ExecutorService executorService) {
        CompilationContext.ProcessorContext processorContext = this.appView.createProcessorContext();
        CompilationContext.MainThreadContext mainThreadContext = processorContext.createMainThreadContext();
        assert (this.noPendingWrappersOrConversions());
        for (DexProgramClass clazz : programClasses) {
            if (this.appView.isAlreadyLibraryDesugared(clazz)) continue;
            ArrayList<DexEncodedMethod> callbacks = new ArrayList<DexEncodedMethod>();
            for (ProgramMethod virtualProgramMethod : clazz.virtualProgramMethods()) {
                if (!this.shouldRegisterCallback(virtualProgramMethod)) continue;
                if (this.trackedCallBackAPIs != null) {
                    this.trackedCallBackAPIs.add((DexMethod)virtualProgramMethod.getReference());
                }
                ProgramMethod callback = this.generateCallbackMethod((DexEncodedMethod)virtualProgramMethod.getDefinition(), virtualProgramMethod.getHolder(), eventConsumer, mainThreadContext);
                callbacks.add((DexEncodedMethod)callback.getDefinition());
            }
            if (callbacks.isEmpty()) continue;
            clazz.addVirtualMethods(callbacks);
        }
        assert (this.noPendingWrappersOrConversions());
        this.generateTrackingWarnings();
    }

    public boolean shouldRegisterCallback(ProgramMethod method) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (definition.isPrivateMethod() || definition.isStatic() || definition.isAbstract() || definition.isLibraryMethodOverride().isFalse()) {
            return false;
        }
        if (!this.appView.typeRewriter.hasRewrittenTypeInSignature(definition.getProto(), this.appView) || this.appView.options().machineDesugaredLibrarySpecification.getEmulatedInterfaces().containsKey(method.getHolderType())) {
            return false;
        }
        if (!this.appView.enableWholeProgramOptimizations() && method.getHolder().isInterface() && ((DexEncodedMethod)method.getDefinition()).isDefaultMethod() && (!this.appView.options().canUseDefaultAndStaticInterfaceMethods() || this.appView.options().isDesugaredLibraryCompilation())) {
            return false;
        }
        if (!this.appView.options().machineDesugaredLibrarySpecification.supportAllCallbacksFromLibrary() && this.appView.options().isDesugaredLibraryCompilation()) {
            return false;
        }
        return this.overridesNonFinalLibraryMethod(method);
    }
}

