/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.ClasspathOrLibraryClass;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaring;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryAPIConverter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryEnumConversionSynthesizer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryWrapperSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.CustomConversionDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.ir.synthetic.DesugaredLibraryAPIConversionCfCodeProvider;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.MethodPosition;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.synthesis.SyntheticClassBuilder;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DesugaredLibraryWrapperSynthesizer
implements CfClassSynthesizerDesugaring {
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final DesugaredLibraryEnumConversionSynthesizer enumConverter;

    public DesugaredLibraryWrapperSynthesizer(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.enumConverter = new DesugaredLibraryEnumConversionSynthesizer(appView);
    }

    private DexMethod ensureArrayConversionMethod(DexType type, DexType srcType, DexType destType, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryClasspathWrapperSynthesizeEventConsumer eventConsumer, Supplier<CompilationContext.UniqueContext> contextSupplier) {
        DexMethod conversion = this.ensureConversionMethod(type.toDimensionMinusOneType(this.factory), srcType.toDimensionMinusOneType(this.factory), destType.toDimensionMinusOneType(this.factory), eventConsumer, contextSupplier);
        return this.ensureArrayConversionMethod(srcType, destType, eventConsumer, contextSupplier, conversion);
    }

    private DexMethod ensureArrayConversionMethodFromExistingBaseConversion(DexType type, DexType srcType, DexType destType, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryL8ProgramWrapperSynthesizerEventConsumer eventConsumer, Supplier<CompilationContext.UniqueContext> contextSupplier) {
        DexMethod conversion = this.getExistingProgramConversionMethod(type.toDimensionMinusOneType(this.factory), srcType.toDimensionMinusOneType(this.factory), destType.toDimensionMinusOneType(this.factory), eventConsumer, contextSupplier);
        return this.ensureArrayConversionMethod(srcType, destType, eventConsumer, contextSupplier, conversion);
    }

    private DexMethod ensureArrayConversionMethod(DexType srcType, DexType destType, DesugaredLibraryWrapperSynthesizerEventConsumer eventConsumer, Supplier<CompilationContext.UniqueContext> contextSupplier, DexMethod conversion) {
        ProgramMethod arrayConversion = this.appView.getSyntheticItems().createMethod(kinds -> kinds.ARRAY_CONVERSION, contextSupplier.get(), this.appView, builder -> builder.setProto(this.factory.createProto(destType, srcType)).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(codeSynthesizor -> new DesugaredLibraryAPIConversionCfCodeProvider.ArrayConversionCfCodeProvider(this.appView, codeSynthesizor.getHolderType(), srcType, destType, conversion).generateCfCode()));
        eventConsumer.acceptArrayConversion(arrayConversion);
        return (DexMethod)arrayConversion.getReference();
    }

    private DexMethod getCustomConversion(DexType type, DexType srcType, DexType destType) {
        DexMethod conversion;
        CustomConversionDescriptor descriptor = this.appView.options().machineDesugaredLibrarySpecification.getCustomConversions().get(type);
        if (descriptor == null) {
            return null;
        }
        DexMethod dexMethod = conversion = type == srcType ? descriptor.getTo() : descriptor.getFrom();
        assert (type != srcType ? type == conversion.getArgumentType(0, true) : type == conversion.getReturnType());
        return this.factory.createMethod(conversion.getHolderType(), this.factory.createProto(destType, srcType), conversion.getName());
    }

    private boolean canConvert(DexType type) {
        return this.appView.options().machineDesugaredLibrarySpecification.getCustomConversions().containsKey(type) || this.canGenerateWrapper(type);
    }

    private void reportInvalidInvoke(DexType type, DexMethod invokedMethod, ProgramMethod context) {
        DexType desugaredType = this.appView.typeRewriter.rewrittenType(type, this.appView);
        Origin origin = context != null ? context.getOrigin() : Origin.unknown();
        Position position = context != null ? new MethodPosition(context.getMethodReference()) : Position.UNKNOWN;
        StringDiagnostic diagnostic = new StringDiagnostic("Invoke to " + invokedMethod.holder + "#" + invokedMethod.name + " may not work correctly at runtime (Cannot convert type " + desugaredType + ").", origin, position);
        if (this.appView.options().isDesugaredLibraryCompilation()) {
            throw this.appView.options().reporter.fatalError(diagnostic);
        }
        this.appView.options().reporter.info(diagnostic);
    }

    private boolean canGenerateWrapper(DexType type) {
        return this.appView.options().machineDesugaredLibrarySpecification.getWrappers().containsKey(type);
    }

    private DexClass getValidClassToWrap(DexType type) {
        assert (!type.isArrayType());
        DexClass dexClass = this.appView.definitionFor(type);
        assert (dexClass != null);
        assert (dexClass.isLibraryClass() || this.appView.options().isDesugaredLibraryCompilation());
        assert (!dexClass.accessFlags.isFinal() || dexClass.isEnum());
        return dexClass;
    }

    private DexType vivifiedTypeFor(DexType type) {
        return DesugaredLibraryAPIConverter.vivifiedTypeFor(type, this.appView);
    }

    private WrapperConversions ensureWrappers(DexClass context, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryClasspathWrapperSynthesizeEventConsumer eventConsumer) {
        assert (eventConsumer != null);
        if (context.isProgramClass()) {
            return this.getExistingProgramWrapperConversions(context);
        }
        assert (context.isNotProgramClass());
        Iterable methods = this.appView.options().machineDesugaredLibrarySpecification.getWrappers().get(context.type);
        assert (methods != null);
        ClasspathOrLibraryClass classpathOrLibraryContext = context.asClasspathOrLibraryClass();
        DexType type = context.type;
        DexType vivifiedType = this.vivifiedTypeFor(type);
        DexClasspathClass wrapper = this.ensureClasspathWrapper(kinds -> kinds.WRAPPER, vivifiedType, type, classpathOrLibraryContext, eventConsumer, wrapperField -> this.synthesizeVirtualMethodsForTypeWrapper(methods, (DexEncodedField)wrapperField, DesugaredLibraryWrapperSynthesizer::codeForClasspathMethod));
        DexClasspathClass vivifiedWrapper = this.ensureClasspathWrapper(kinds -> kinds.VIVIFIED_WRAPPER, type, vivifiedType, classpathOrLibraryContext, eventConsumer, wrapperField -> this.synthesizeVirtualMethodsForVivifiedTypeWrapper(methods, (DexEncodedField)wrapperField, DesugaredLibraryWrapperSynthesizer::codeForClasspathMethod));
        return new WrapperConversions(this.getConversion(wrapper, vivifiedType, type), this.getConversion(vivifiedWrapper, type, vivifiedType));
    }

    private WrapperConversions getExistingProgramWrapperConversions(DexClass context) {
        assert (this.appView.options().isDesugaredLibraryCompilation());
        DexProgramClass wrapper = this.getExistingProgramWrapper(context, kinds -> kinds.WRAPPER);
        DexProgramClass vivifiedWrapper = this.getExistingProgramWrapper(context, kinds -> kinds.VIVIFIED_WRAPPER);
        DexField wrapperField = this.getWrapperUniqueField(wrapper);
        DexField vivifiedWrapperField = this.getWrapperUniqueField(vivifiedWrapper);
        return new WrapperConversions(this.getConversion(wrapper, vivifiedWrapperField.type, wrapperField.type), this.getConversion(vivifiedWrapper, wrapperField.type, vivifiedWrapperField.type));
    }

    private DexProgramClass getExistingProgramWrapper(DexClass context, SyntheticItems.SyntheticKindSelector kindSelector) {
        return this.appView.getSyntheticItems().getExistingFixedClass(kindSelector, context, this.appView);
    }

    private DexMethod getConversion(DexClass wrapper, DexType returnType, DexType argType) {
        DexMethod convertMethod = this.factory.createMethod(wrapper.type, this.factory.createProto(returnType, argType), this.factory.convertMethodName);
        return (DexMethod)wrapper.lookupDirectMethod(convertMethod).getReference();
    }

    private DexEncodedField getWrapperUniqueEncodedField(DexClass wrapper) {
        assert (wrapper.instanceFields().size() == 1);
        return wrapper.instanceFields().get(0);
    }

    private DexField getWrapperUniqueField(DexClass wrapper) {
        return (DexField)this.getWrapperUniqueEncodedField(wrapper).getReference();
    }

    private DexProgramClass ensureProgramWrapper(SyntheticItems.SyntheticKindSelector kindSelector, DexType wrappingType, DexType wrappedType, DexProgramClass programContext, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryL8ProgramWrapperSynthesizerEventConsumer eventConsumer) {
        assert (this.appView.options().isDesugaredLibraryCompilation());
        assert (eventConsumer != null);
        return this.appView.getSyntheticItems().ensureFixedClass(kindSelector, programContext, this.appView, builder -> this.buildWrapper(wrappingType, wrappedType, programContext, (SyntheticClassBuilder<?, ?>)builder), eventConsumer::acceptWrapperProgramClass);
    }

    private DexClasspathClass ensureClasspathWrapper(SyntheticItems.SyntheticKindSelector kindSelector, DexType wrappingType, DexType wrappedType, ClasspathOrLibraryClass classpathOrLibraryContext, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryClasspathWrapperSynthesizeEventConsumer eventConsumer, Function<DexEncodedField, Collection<DexEncodedMethod>> virtualMethodProvider) {
        assert (eventConsumer != null);
        return this.appView.getSyntheticItems().ensureFixedClasspathClass(kindSelector, classpathOrLibraryContext, this.appView, builder -> {
            DexEncodedField wrapperField = this.buildWrapper(wrappingType, wrappedType, classpathOrLibraryContext.asDexClass(), (SyntheticClassBuilder<?, ?>)builder);
            builder.addMethod(methodBuilder -> this.buildConversionMethod((SyntheticMethodBuilder)methodBuilder, this.factory.createProto(wrappingType, wrappedType), null));
            builder.setVirtualMethods((Iterable)virtualMethodProvider.apply(wrapperField));
        }, eventConsumer::acceptWrapperClasspathClass);
    }

    private void getExistingProgramConversionMethod(SyntheticItems.SyntheticKindSelector kindSelector, DexProgramClass context, DexClass wrapper, DexClass reverseWrapper) {
        DexField wrapperField = this.getWrapperUniqueField(wrapper);
        DexField reverseWrapperField = this.getWrapperUniqueField(reverseWrapper);
        DexProto proto = this.factory.createProto(reverseWrapperField.type, wrapperField.type);
        this.appView.getSyntheticItems().ensureFixedClassMethod(this.factory.convertMethodName, proto, kindSelector, context, this.appView, ignored -> {}, methodBuilder -> this.buildConversionMethod((SyntheticMethodBuilder)methodBuilder, proto, this.computeProgramConversionMethodCode(wrapperField, reverseWrapperField, context)));
    }

    private CfCode computeProgramConversionMethodCode(DexField wrapperField, DexField reverseWrapperField, DexClass context) {
        assert (context.isProgramClass());
        return new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterWrapperConversionCfCodeProvider(this.appView, reverseWrapperField, wrapperField).generateCfCode();
    }

    private void buildConversionMethod(SyntheticMethodBuilder methodBuilder, DexProto proto, CfCode cfCode) {
        methodBuilder.setName(this.factory.convertMethodName).setProto(proto).setAccessFlags(MethodAccessFlags.fromCfAccessFlags(4105, false)).disableAndroidApiLevelCheck().setCode(methodSignature -> cfCode);
    }

    private DexEncodedField buildWrapper(DexType wrappingType, DexType wrappedType, DexClass clazz, SyntheticClassBuilder<?, ?> builder) {
        boolean isItf = clazz.isInterface();
        DexType superType = isItf ? this.factory.objectType : wrappingType;
        List<DexType> interfaces = isItf ? Collections.singletonList(wrappingType) : Collections.emptyList();
        DexEncodedField wrapperField = this.synthesizeWrappedValueEncodedField(builder.getType(), wrappedType);
        ((SyntheticClassBuilder)((SyntheticClassBuilder)((SyntheticClassBuilder)builder.setInterfaces(interfaces)).setSuperType(superType)).setInstanceFields(Collections.singletonList(wrapperField))).addMethod(methodBuilder -> this.buildWrapperConstructor(wrapperField, (SyntheticMethodBuilder)methodBuilder));
        return wrapperField;
    }

    private void buildWrapperConstructor(DexEncodedField wrappedValueField, SyntheticMethodBuilder methodBuilder) {
        methodBuilder.setName(this.factory.constructorMethodName).setProto(this.factory.createProto(this.factory.voidType, wrappedValueField.getType())).setAccessFlags(MethodAccessFlags.fromCfAccessFlags(4098, true)).disableAndroidApiLevelCheck().setCode(codeSynthesizor -> new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterConstructorCfCodeProvider(this.appView, (DexField)wrappedValueField.getReference()).generateCfCode());
    }

    private static CfCode codeForClasspathMethod(DexMethod ignore) {
        return null;
    }

    private Collection<DexEncodedMethod> synthesizeVirtualMethodsForVivifiedTypeWrapper(Iterable<DexMethod> allImplementedMethods, DexEncodedField wrapperField, Function<DexMethod, CfCode> cfCodeProvider) {
        ArrayList<DexEncodedMethod> generatedMethods = new ArrayList<DexEncodedMethod>();
        for (DexMethod method : allImplementedMethods) {
            DexMethod methodToInstall = this.factory.createMethod(wrapperField.getHolderType(), method.proto, method.name);
            CfCode cfCode = cfCodeProvider.apply(method);
            DexEncodedMethod newDexEncodedMethod = this.newSynthesizedMethod(methodToInstall, cfCode);
            generatedMethods.add(newDexEncodedMethod);
        }
        return generatedMethods;
    }

    private CfCode synthesizeCfCodeForVivifiedTypeWrapper(DexMethod method, DexField wrapperField, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryL8ProgramWrapperSynthesizerEventConsumer eventConsumer, Supplier<CompilationContext.UniqueContext> contextSupplier) {
        boolean isInterface;
        DexClass holderClass = this.appView.definitionFor(method.getHolderType());
        if (holderClass == null) {
            assert (this.appView.options().machineDesugaredLibrarySpecification.isEmulatedInterfaceRewrittenType(method.getHolderType()));
            isInterface = true;
        } else {
            isInterface = holderClass.isInterface();
        }
        return new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterVivifiedWrapperCfCodeProvider(this.appView, method, wrapperField, this, isInterface, eventConsumer, contextSupplier).generateCfCode();
    }

    private Collection<DexEncodedMethod> synthesizeVirtualMethodsForTypeWrapper(Iterable<DexMethod> dexMethods, DexEncodedField wrapperField, Function<DexMethod, CfCode> cfCodeProvider) {
        ArrayList<DexEncodedMethod> generatedMethods = new ArrayList<DexEncodedMethod>();
        for (DexMethod method : dexMethods) {
            DexMethod methodToInstall = DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature(method, wrapperField.getHolderType(), this.appView);
            CfCode cfCode = cfCodeProvider.apply(method);
            DexEncodedMethod newDexEncodedMethod = this.newSynthesizedMethod(methodToInstall, cfCode);
            generatedMethods.add(newDexEncodedMethod);
        }
        return generatedMethods;
    }

    private CfCode synthesizeCfCodeForTypeWrapper(DexMethod method, DexField wrapperField, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryL8ProgramWrapperSynthesizerEventConsumer eventConsumer, Supplier<CompilationContext.UniqueContext> contextSupplier) {
        DexClass holderClass = this.appView.definitionFor(method.getHolderType());
        assert (holderClass != null || this.appView.options().isDesugaredLibraryCompilation());
        boolean isInterface = holderClass == null || holderClass.isInterface();
        return new DesugaredLibraryAPIConversionCfCodeProvider.APIConverterWrapperCfCodeProvider(this.appView, method, wrapperField, this, isInterface, eventConsumer, contextSupplier).generateCfCode();
    }

    private DexField wrappedValueField(DexType holder, DexType fieldType) {
        return this.factory.createField(holder, fieldType, this.factory.wrapperFieldName);
    }

    private DexEncodedField synthesizeWrappedValueEncodedField(DexType holder, DexType fieldType) {
        DexField field = this.wrappedValueField(holder, fieldType);
        FieldAccessFlags fieldAccessFlags = FieldAccessFlags.fromCfAccessFlags(4112);
        return DexEncodedField.syntheticBuilder().setField(field).setAccessFlags(fieldAccessFlags).disableAndroidApiLevelCheck().build();
    }

    private void ensureProgramWrappersWithoutVirtualMethods(DexClass context, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryL8ProgramWrapperSynthesizerEventConsumer eventConsumer) {
        assert (eventConsumer != null);
        assert (context.isProgramClass());
        DexType type = context.type;
        assert (this.appView.options().isDesugaredLibraryCompilation());
        DexProgramClass programContext = context.asProgramClass();
        DexProgramClass wrapper = this.ensureProgramWrapper(kinds -> kinds.WRAPPER, this.vivifiedTypeFor(type), type, programContext, eventConsumer);
        DexProgramClass vivifiedWrapper = this.ensureProgramWrapper(kinds -> kinds.VIVIFIED_WRAPPER, type, this.vivifiedTypeFor(type), programContext, eventConsumer);
        this.getExistingProgramConversionMethod(kinds -> kinds.WRAPPER, programContext, wrapper, vivifiedWrapper);
        this.getExistingProgramConversionMethod(kinds -> kinds.VIVIFIED_WRAPPER, programContext, vivifiedWrapper, wrapper);
    }

    private void ensureProgramWrappersVirtualMethods(DexProgramClass context, Iterable<DexMethod> methods, CfClassSynthesizerDesugaringEventConsumer eventConsumer, CompilationContext.ClassSynthesisDesugaringContext processingContext) {
        DexProgramClass wrapper = this.getExistingProgramWrapper(context, kinds -> kinds.WRAPPER);
        DexEncodedField wrapperField = this.getWrapperUniqueEncodedField(wrapper);
        wrapper.addVirtualMethods(this.synthesizeVirtualMethodsForTypeWrapper(methods, wrapperField, m3 -> this.synthesizeCfCodeForTypeWrapper((DexMethod)m3, (DexField)wrapperField.getReference(), eventConsumer, () -> processingContext.createUniqueContext(wrapper))));
        DexProgramClass vivifiedWrapper = this.getExistingProgramWrapper(context, kinds -> kinds.VIVIFIED_WRAPPER);
        DexEncodedField vivifiedWrapperField = this.getWrapperUniqueEncodedField(vivifiedWrapper);
        vivifiedWrapper.addVirtualMethods(this.synthesizeVirtualMethodsForVivifiedTypeWrapper(methods, vivifiedWrapperField, m3 -> this.synthesizeCfCodeForVivifiedTypeWrapper((DexMethod)m3, (DexField)vivifiedWrapperField.getReference(), eventConsumer, () -> processingContext.createUniqueContext(vivifiedWrapper))));
    }

    public boolean isSyntheticWrapper(DexType type) {
        return this.appView.getSyntheticItems().isSyntheticOfKind(type, kinds -> kinds.WRAPPER) || this.appView.getSyntheticItems().isSyntheticOfKind(type, kinds -> kinds.VIVIFIED_WRAPPER);
    }

    public boolean shouldConvert(DexType type, DexMethod method) {
        return this.shouldConvert(type, method, null);
    }

    public boolean shouldConvert(DexType type, DexMethod method, ProgramMethod context) {
        if (type.isArrayType()) {
            return this.shouldConvert(type.toBaseType(this.appView.dexItemFactory()), method, context);
        }
        if (!this.appView.typeRewriter.hasRewrittenType(type, this.appView)) {
            return false;
        }
        if (this.canConvert(type)) {
            return true;
        }
        this.reportInvalidInvoke(type, method, context);
        return false;
    }

    public DexMethod ensureConversionMethod(DexType type, DexType srcType, DexType destType, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryClasspathWrapperSynthesizeEventConsumer eventConsumer, Supplier<CompilationContext.UniqueContext> contextSupplier) {
        DexMethod conversion;
        if (type.isArrayType()) {
            return this.ensureArrayConversionMethod(type, srcType, destType, eventConsumer, contextSupplier);
        }
        DexMethod customConversion = this.getCustomConversion(type, srcType, destType);
        if (customConversion != null) {
            return customConversion;
        }
        DexClass clazz = this.getValidClassToWrap(type);
        if (clazz.isEnum()) {
            return this.enumConverter.ensureEnumConversionMethod(clazz, srcType, destType, eventConsumer);
        }
        assert (this.canGenerateWrapper(type)) : type;
        WrapperConversions wrapperConversions = this.ensureWrappers(clazz, eventConsumer);
        DexMethod dexMethod = conversion = type == srcType ? wrapperConversions.getConversion() : wrapperConversions.getVivifiedConversion();
        assert (srcType == conversion.getArgumentType(0, true));
        assert (destType == conversion.getReturnType());
        return conversion;
    }

    public DexMethod getExistingProgramConversionMethod(DexType type, DexType srcType, DexType destType, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryL8ProgramWrapperSynthesizerEventConsumer eventConsumer, Supplier<CompilationContext.UniqueContext> contextSupplier) {
        DexMethod conversion;
        if (type.isArrayType()) {
            return this.ensureArrayConversionMethodFromExistingBaseConversion(type, srcType, destType, eventConsumer, contextSupplier);
        }
        DexMethod customConversion = this.getCustomConversion(type, srcType, destType);
        if (customConversion != null) {
            return customConversion;
        }
        DexClass clazz = this.getValidClassToWrap(type);
        if (clazz.isEnum()) {
            return this.enumConverter.getExistingProgramEnumConversionMethod(clazz, srcType, destType);
        }
        WrapperConversions wrapperConversions = this.getExistingProgramWrapperConversions(clazz);
        DexMethod dexMethod = conversion = type == srcType ? wrapperConversions.getConversion() : wrapperConversions.getVivifiedConversion();
        assert (srcType == conversion.getArgumentType(0, true));
        return conversion;
    }

    DexEncodedMethod newSynthesizedMethod(DexMethod methodToInstall, Code code) {
        ComputedApiLevel.NotSetApiLevel apiLevelForDefinition;
        MethodAccessFlags newFlags = MethodAccessFlags.fromSharedAccessFlags(4097, false);
        ComputedApiLevel.NotSetApiLevel apiLevelForCode = apiLevelForDefinition = this.appView.enableWholeProgramOptimizations() ? ComputedApiLevel.notSet() : this.appView.apiLevelCompute().computeApiLevelForDefinition(methodToInstall, this.factory, ComputedApiLevel.unknown());
        return DexEncodedMethod.syntheticBuilder().setMethod(methodToInstall).setAccessFlags(newFlags).setCode(code).setApiLevelForDefinition(apiLevelForDefinition).setApiLevelForCode(code == null ? ComputedApiLevel.notSet() : apiLevelForCode).build();
    }

    @Override
    public String uniqueIdentifier() {
        return "$wrapper$";
    }

    @Override
    public void synthesizeClasses(CompilationContext.ClassSynthesisDesugaringContext processingContext, CfClassSynthesizerDesugaringEventConsumer eventConsumer) {
        MachineDesugaredLibrarySpecification librarySpecification = this.appView.options().machineDesugaredLibrarySpecification;
        IdentityHashMap<DexProgramClass, Iterable> validClassesToWrap = new IdentityHashMap<DexProgramClass, Iterable>();
        librarySpecification.getWrappers().forEach((type, methods) -> {
            assert (!librarySpecification.getCustomConversions().containsKey(type));
            DexClass validClassToWrap = this.getValidClassToWrap((DexType)type);
            if (validClassToWrap.isProgramClass()) {
                if (validClassToWrap.isEnum()) {
                    this.enumConverter.ensureProgramEnumConversionClass(validClassToWrap, eventConsumer);
                } else {
                    validClassesToWrap.put(validClassToWrap.asProgramClass(), (Iterable)methods);
                    this.ensureProgramWrappersWithoutVirtualMethods(validClassToWrap, eventConsumer);
                }
            }
        });
        validClassesToWrap.forEach((clazz, methods) -> this.ensureProgramWrappersVirtualMethods((DexProgramClass)clazz, (Iterable<DexMethod>)methods, eventConsumer, processingContext));
    }

    static class WrapperConversions {
        private final DexMethod conversion;
        private final DexMethod vivifiedConversion;

        WrapperConversions(DexMethod conversion, DexMethod vivifiedConversion) {
            this.conversion = conversion;
            this.vivifiedConversion = vivifiedConversion;
        }

        public DexMethod getConversion() {
            return this.conversion;
        }

        public DexMethod getVivifiedConversion() {
            return this.vivifiedConversion;
        }
    }
}

