/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Map;

public abstract class AbstractMethodParser {
    private static final String SEPARATORS = "\\s+|,\\s+|#|\\(|\\)";
    private static final Map<String, Integer> modifiers = ImmutableMap.builder().put("public", 1).put("private", 2).put("protected", 4).put("final", 16).put("abstract", 1024).put("static", 8).build();
    final DexItemFactory factory;

    protected AbstractMethodParser(DexItemFactory factory) {
        this.factory = factory;
    }

    private DexType stringTypeToDexType(String stringType) {
        return this.factory.createType(DescriptorUtils.javaTypeToDescriptor(stringType));
    }

    private int parseModifiers(String[] split) {
        int index = 0;
        while (modifiers.containsKey(split[index])) {
            this.modifier(modifiers.get(split[index]));
            ++index;
        }
        return index;
    }

    public void parseMethod(String signature) {
        String[] tokens = signature.split(SEPARATORS);
        if (tokens.length < 3) {
            throw new CompilationError("Desugared library: cannot parse method " + signature);
        }
        this.methodStart();
        int first = this.parseModifiers(tokens);
        this.returnType(this.stringTypeToDexType(tokens[first]));
        this.holderType(this.stringTypeToDexType(tokens[first + 1]));
        this.methodName(this.factory.createString(tokens[first + 1 + 1]));
        for (int i = first + 3; i < tokens.length; ++i) {
            this.argType(this.stringTypeToDexType(tokens[i]));
        }
        this.methodEnd();
    }

    protected abstract void methodStart();

    protected abstract void methodEnd();

    protected abstract void returnType(DexType var1);

    protected abstract void argType(DexType var1);

    protected abstract void modifier(int var1);

    protected abstract void holderType(DexType var1);

    protected abstract void methodName(DexString var1);
}

