/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.ir.desugar.desugaredlibrary.TopLevelFlagsBuilder;
import com.android.tools.r8.utils.AndroidApiLevel;
import java.util.List;

public class HumanTopLevelFlags {
    private final AndroidApiLevel requiredCompilationAPILevel;
    private final String synthesizedLibraryClassesPackagePrefix;
    private final String identifier;
    private final String jsonSource;
    private final boolean supportAllCallbacksFromLibrary;
    private final List<String> extraKeepRules;

    HumanTopLevelFlags(AndroidApiLevel requiredCompilationAPILevel, String synthesizedLibraryClassesPackagePrefix, String identifier, String jsonSource, boolean supportAllCallbacksFromLibrary, List<String> extraKeepRules) {
        this.requiredCompilationAPILevel = requiredCompilationAPILevel;
        this.synthesizedLibraryClassesPackagePrefix = synthesizedLibraryClassesPackagePrefix;
        this.identifier = identifier;
        this.jsonSource = jsonSource;
        this.supportAllCallbacksFromLibrary = supportAllCallbacksFromLibrary;
        this.extraKeepRules = extraKeepRules;
    }

    public static HumanTopLevelFlags empty() {
        return new HumanTopLevelFlags(AndroidApiLevel.B, "unused", null, null, true, ImmutableList.of());
    }

    public static HumanTopLevelFlags testing() {
        return new HumanTopLevelFlags(AndroidApiLevel.R, "unused", "testing", null, true, ImmutableList.of());
    }

    public static Builder builder() {
        return new Builder();
    }

    public AndroidApiLevel getRequiredCompilationAPILevel() {
        return this.requiredCompilationAPILevel;
    }

    public String getSynthesizedLibraryClassesPackagePrefix() {
        return this.synthesizedLibraryClassesPackagePrefix;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getJsonSource() {
        return this.jsonSource;
    }

    public boolean supportAllCallbacksFromLibrary() {
        return this.supportAllCallbacksFromLibrary;
    }

    public List<String> getExtraKeepRules() {
        return this.extraKeepRules;
    }

    public static class Builder
    implements TopLevelFlagsBuilder<Builder> {
        private AndroidApiLevel requiredCompilationAPILevel;
        private String synthesizedLibraryClassesPackagePrefix;
        private String identifier;
        private String jsonSource;
        private Boolean supportAllCallbacksFromLibrary;
        private List<String> extraKeepRules;

        Builder() {
        }

        public Builder setRequiredCompilationAPILevel(AndroidApiLevel requiredCompilationAPILevel) {
            this.requiredCompilationAPILevel = requiredCompilationAPILevel;
            return this;
        }

        public Builder setSynthesizedLibraryClassesPackagePrefix(String prefix) {
            this.synthesizedLibraryClassesPackagePrefix = prefix.replace('.', '/');
            return this;
        }

        public Builder setDesugaredLibraryIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setJsonSource(String jsonSource) {
            this.jsonSource = jsonSource;
            return this;
        }

        @Override
        public Builder setSupportAllCallbacksFromLibrary(boolean supportAllCallbacksFromLibrary) {
            this.supportAllCallbacksFromLibrary = supportAllCallbacksFromLibrary;
            return this;
        }

        public Builder setExtraKeepRules(List<String> rules) {
            this.extraKeepRules = rules;
            return this;
        }

        public HumanTopLevelFlags build() {
            assert (this.synthesizedLibraryClassesPackagePrefix != null);
            assert (this.supportAllCallbacksFromLibrary != null);
            return new HumanTopLevelFlags(this.requiredCompilationAPILevel, this.synthesizedLibraryClassesPackagePrefix, this.identifier, this.jsonSource, this.supportAllCallbacksFromLibrary, this.extraKeepRules);
        }
    }
}

