/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanDesugaredLibrarySpecificationParser;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanTopLevelFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.MultiAPILevelHumanDesugaredLibrarySpecification;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import com.android.tools.r8.utils.Reporter;

public class MultiAPILevelHumanDesugaredLibrarySpecificationParser
extends HumanDesugaredLibrarySpecificationParser {
    public MultiAPILevelHumanDesugaredLibrarySpecificationParser(DexItemFactory dexItemFactory, Reporter reporter) {
        super(dexItemFactory, reporter, false, 1);
    }

    private Int2ObjectMap<HumanRewritingFlags> parseAllFlags(String flagKey) {
        JsonElement jsonFlags = this.required(this.getJsonConfig(), flagKey);
        Int2ObjectArrayMap<HumanRewritingFlags> flags = new Int2ObjectArrayMap<HumanRewritingFlags>();
        for (JsonElement jsonFlagSet : jsonFlags.getAsJsonArray()) {
            JsonObject flag = jsonFlagSet.getAsJsonObject();
            int api_level_below_or_equal = this.required(flag, "api_level_below_or_equal").getAsInt();
            HumanRewritingFlags.Builder builder = flags.containsKey(api_level_below_or_equal) ? ((HumanRewritingFlags)flags.get(api_level_below_or_equal)).newBuilder(this.reporter(), this.getOrigin()) : HumanRewritingFlags.builder(this.reporter(), this.getOrigin());
            this.parseFlags(flag, builder);
            flags.put(api_level_below_or_equal, builder.build());
        }
        return flags;
    }

    public MultiAPILevelHumanDesugaredLibrarySpecification parseMultiLevelConfiguration(StringResource stringResource) {
        String jsonConfigString = this.parseJson(stringResource);
        HumanTopLevelFlags topLevelFlags = this.parseTopLevelFlags(jsonConfigString, builder -> {});
        Int2ObjectMap<HumanRewritingFlags> commonFlags = this.parseAllFlags("common_flags");
        Int2ObjectMap<HumanRewritingFlags> libraryFlags = this.parseAllFlags("library_flags");
        Int2ObjectMap<HumanRewritingFlags> programFlags = this.parseAllFlags("program_flags");
        return new MultiAPILevelHumanDesugaredLibrarySpecification(this.getOrigin(), topLevelFlags, commonFlags, libraryFlags, programFlags);
    }
}

