/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.LegacyRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.LegacyTopLevelFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.LegacyToHumanSpecificationConverter;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LegacyDesugaredLibrarySpecification
implements DesugaredLibrarySpecification {
    private final boolean libraryCompilation;
    private final LegacyTopLevelFlags topLevelFlags;
    private final LegacyRewritingFlags rewritingFlags;

    public LegacyDesugaredLibrarySpecification(LegacyTopLevelFlags topLevelFlags, LegacyRewritingFlags rewritingFlags, boolean libraryCompilation) {
        this.libraryCompilation = libraryCompilation;
        this.topLevelFlags = topLevelFlags;
        this.rewritingFlags = rewritingFlags;
    }

    @Override
    public boolean isEmpty() {
        return this.rewritingFlags.isEmpty();
    }

    @Override
    public boolean isLegacy() {
        return true;
    }

    public LegacyTopLevelFlags getTopLevelFlags() {
        return this.topLevelFlags;
    }

    public LegacyRewritingFlags getRewritingFlags() {
        return this.rewritingFlags;
    }

    public boolean supportAllCallbacksFromLibrary() {
        return this.topLevelFlags.supportAllCallbacksFromLibrary();
    }

    @Override
    public AndroidApiLevel getRequiredCompilationApiLevel() {
        return this.topLevelFlags.getRequiredCompilationAPILevel();
    }

    @Override
    public boolean isLibraryCompilation() {
        return this.libraryCompilation;
    }

    @Override
    public String getSynthesizedLibraryClassesPackagePrefix() {
        return this.topLevelFlags.getSynthesizedLibraryClassesPackagePrefix();
    }

    public String getIdentifier() {
        return this.topLevelFlags.getIdentifier();
    }

    public DexMethod retargetMethod(DexEncodedMethod method, AppView<?> appView) {
        Map<DexString, Map<DexType, DexType>> retargetCoreLibMember = this.rewritingFlags.getRetargetCoreLibMember();
        Map<DexType, DexType> typeMap = retargetCoreLibMember.get(method.getName());
        if (typeMap != null && typeMap.containsKey(method.getHolderType())) {
            return appView.dexItemFactory().createMethod(typeMap.get(method.getHolderType()), appView.dexItemFactory().prependHolderToProto((DexMethod)method.getReference()), method.getName());
        }
        return null;
    }

    public DexMethod retargetMethod(DexClassAndMethod method, AppView<?> appView) {
        return this.retargetMethod((DexEncodedMethod)method.getDefinition(), appView);
    }

    public Map<DexType, DexType> getCustomConversions() {
        return this.rewritingFlags.getCustomConversions();
    }

    public Set<DexType> getWrapperConversions() {
        return this.rewritingFlags.getWrapperConversions();
    }

    @Override
    public List<String> getExtraKeepRules() {
        return this.topLevelFlags.getExtraKeepRules();
    }

    @Override
    public String getJsonSource() {
        return this.topLevelFlags.getJsonSource();
    }

    @Override
    public MachineDesugaredLibrarySpecification toMachineSpecification(DexApplication app, Timing timing) throws IOException {
        return new LegacyToHumanSpecificationConverter(timing).convert(this, app).toMachineSpecification(app, timing);
    }

    @Override
    public MachineDesugaredLibrarySpecification toMachineSpecification(InternalOptions options, Path library, Timing timing, Path desugaredJDKLib) throws IOException {
        return new LegacyToHumanSpecificationConverter(timing).convertForTesting(this, desugaredJDKLib, library, options).toMachineSpecification(options, library, timing, desugaredJDKLib);
    }
}

