/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification;

import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.gson.JsonArray;
import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonParser;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecificationParser;
import com.android.tools.r8.ir.desugar.desugaredlibrary.TopLevelFlagsBuilder;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.LegacyDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.LegacyRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.LegacyTopLevelFlags;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.SemanticVersion;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;

public class LegacyDesugaredLibrarySpecificationParser {
    public static final int MAX_SUPPORTED_VERSION = 4;
    public static final SemanticVersion MIN_SUPPORTED_VERSION = SemanticVersion.create(1, 0, 9);
    static final String VERSION_KEY = "version";
    static final String GROUP_ID_KEY = "group_id";
    static final String ARTIFACT_ID_KEY = "artifact_id";
    static final String REQUIRED_COMPILATION_API_LEVEL_KEY = "required_compilation_api_level";
    static final String SYNTHESIZED_LIBRARY_CLASSES_PACKAGE_PREFIX_KEY = "synthesized_library_classes_package_prefix";
    static final String COMMON_FLAGS_KEY = "common_flags";
    static final String LIBRARY_FLAGS_KEY = "library_flags";
    static final String PROGRAM_FLAGS_KEY = "program_flags";
    static final String API_LEVEL_BELOW_OR_EQUAL_KEY = "api_level_below_or_equal";
    static final String WRAPPER_CONVERSION_KEY = "wrapper_conversion";
    static final String CUSTOM_CONVERSION_KEY = "custom_conversion";
    static final String REWRITE_PREFIX_KEY = "rewrite_prefix";
    static final String RETARGET_LIB_MEMBER_KEY = "retarget_lib_member";
    static final String EMULATE_INTERFACE_KEY = "emulate_interface";
    static final String DONT_REWRITE_KEY = "dont_rewrite";
    static final String DONT_RETARGET_LIB_MEMBER_KEY = "dont_retarget_lib_member";
    static final String BACKPORT_KEY = "backport";
    static final String SHRINKER_CONFIG_KEY = "shrinker_config";
    static final String SUPPORT_ALL_CALLBACKS_FROM_LIBRARY_KEY = "support_all_callbacks_from_library";
    private final DexItemFactory dexItemFactory;
    private final Reporter reporter;
    private final boolean libraryCompilation;
    private final int minAPILevel;
    private Origin origin;
    private JsonObject jsonConfig;

    public LegacyDesugaredLibrarySpecificationParser(DexItemFactory dexItemFactory, Reporter reporter, boolean libraryCompilation, int minAPILevel) {
        this.dexItemFactory = dexItemFactory;
        this.reporter = reporter;
        this.minAPILevel = minAPILevel;
        this.libraryCompilation = libraryCompilation;
    }

    private LegacyRewritingFlags parseRewritingFlags() {
        LegacyRewritingFlags.Builder builder = LegacyRewritingFlags.builder(this.dexItemFactory, this.reporter, this.origin);
        JsonElement commonFlags = this.required(this.jsonConfig, COMMON_FLAGS_KEY);
        JsonElement libraryFlags = this.required(this.jsonConfig, LIBRARY_FLAGS_KEY);
        JsonElement programFlags = this.required(this.jsonConfig, PROGRAM_FLAGS_KEY);
        this.parseFlagsList(commonFlags.getAsJsonArray(), builder);
        this.parseFlagsList(this.libraryCompilation ? libraryFlags.getAsJsonArray() : programFlags.getAsJsonArray(), builder);
        return builder.build();
    }

    private void parseFlagsList(JsonArray jsonFlags, LegacyRewritingFlags.Builder builder) {
        for (JsonElement jsonFlagSet : jsonFlags) {
            JsonObject flag = jsonFlagSet.getAsJsonObject();
            int api_level_below_or_equal = this.required(flag, API_LEVEL_BELOW_OR_EQUAL_KEY).getAsInt();
            if (this.minAPILevel > api_level_below_or_equal) continue;
            this.parseFlags(flag, builder);
        }
    }

    public DexItemFactory dexItemFactory() {
        return this.dexItemFactory;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public JsonObject getJsonConfig() {
        return this.jsonConfig;
    }

    public Origin getOrigin() {
        assert (this.origin != null);
        return this.origin;
    }

    JsonElement required(JsonObject json, String key) {
        if (!json.has(key)) {
            throw this.reporter.fatalError(new StringDiagnostic("Invalid desugared library configuration. Expected required key '" + key + "'", this.origin));
        }
        return json.get(key);
    }

    public LegacyDesugaredLibrarySpecification parse(StringResource stringResource) {
        String jsonConfigString = this.parseJson(stringResource);
        return this.parse(this.origin, jsonConfigString, this.jsonConfig, ignored -> {});
    }

    public LegacyDesugaredLibrarySpecification parse(Origin origin, String jsonConfigString, JsonObject jsonConfig) {
        return this.parse(origin, jsonConfigString, jsonConfig, ignored -> {});
    }

    public LegacyDesugaredLibrarySpecification parse(Origin origin, String jsonConfigString, JsonObject jsonConfig, Consumer<TopLevelFlagsBuilder<?>> topLevelFlagAmender) {
        if (DesugaredLibrarySpecificationParser.isHumanSpecification(jsonConfig, this.reporter, origin)) {
            this.reporter.error("Attempt to parse a desugared library human specification as a legacy specification.");
        }
        this.origin = origin;
        this.jsonConfig = jsonConfig;
        LegacyTopLevelFlags topLevelFlags = this.parseTopLevelFlags(jsonConfigString, topLevelFlagAmender);
        LegacyRewritingFlags legacyRewritingFlags = this.parseRewritingFlags();
        LegacyDesugaredLibrarySpecification config = new LegacyDesugaredLibrarySpecification(topLevelFlags, legacyRewritingFlags, this.libraryCompilation);
        this.origin = null;
        return config;
    }

    String parseJson(StringResource stringResource) {
        String jsonConfigString;
        this.setOrigin(stringResource);
        try {
            jsonConfigString = stringResource.getString();
            JsonParser parser = new JsonParser();
            this.jsonConfig = parser.parse(jsonConfigString).getAsJsonObject();
        }
        catch (Exception e) {
            throw this.reporter.fatalError(new ExceptionDiagnostic(e, this.origin));
        }
        return jsonConfigString;
    }

    void setOrigin(StringResource stringResource) {
        this.origin = stringResource.getOrigin();
        assert (this.origin != null);
    }

    LegacyTopLevelFlags parseTopLevelFlags(String jsonConfigString, Consumer<TopLevelFlagsBuilder<?>> topLevelFlagAmender) {
        LegacyTopLevelFlags.Builder builder = LegacyTopLevelFlags.builder();
        builder.setJsonSource(jsonConfigString);
        JsonElement formatVersionElement = this.required(this.jsonConfig, "configuration_format_version");
        int formatVersion = formatVersionElement.getAsInt();
        if (formatVersion > 4) {
            throw this.reporter.fatalError(new StringDiagnostic("Unsupported desugared library configuration version, please upgrade the D8/R8 compiler.", this.origin));
        }
        String version = this.required(this.jsonConfig, VERSION_KEY).getAsString();
        SemanticVersion semanticVersion = SemanticVersion.parse(version);
        if (!semanticVersion.isNewerOrEqual(MIN_SUPPORTED_VERSION)) {
            throw this.reporter.fatalError(new StringDiagnostic("Unsupported desugared library version: " + version + ", please upgrade the desugared library to at least version " + MIN_SUPPORTED_VERSION + ".", this.origin));
        }
        String groupID = this.required(this.jsonConfig, GROUP_ID_KEY).getAsString();
        String artifactID = this.required(this.jsonConfig, ARTIFACT_ID_KEY).getAsString();
        String identifier = String.join((CharSequence)":", groupID, artifactID, version);
        builder.setDesugaredLibraryIdentifier(identifier);
        builder.setSynthesizedLibraryClassesPackagePrefix(this.required(this.jsonConfig, SYNTHESIZED_LIBRARY_CLASSES_PACKAGE_PREFIX_KEY).getAsString());
        int required_compilation_api_level = this.required(this.jsonConfig, REQUIRED_COMPILATION_API_LEVEL_KEY).getAsInt();
        builder.setRequiredCompilationAPILevel(AndroidApiLevel.getAndroidApiLevel(required_compilation_api_level));
        if (this.jsonConfig.has(SHRINKER_CONFIG_KEY)) {
            JsonArray jsonKeepRules = this.jsonConfig.get(SHRINKER_CONFIG_KEY).getAsJsonArray();
            ArrayList<String> extraKeepRules = new ArrayList<String>(jsonKeepRules.size());
            for (JsonElement keepRule : jsonKeepRules) {
                extraKeepRules.add(keepRule.getAsString());
            }
            builder.setExtraKeepRules(extraKeepRules);
        }
        if (this.jsonConfig.has(SUPPORT_ALL_CALLBACKS_FROM_LIBRARY_KEY)) {
            boolean supportAllCallbacksFromLibrary = this.jsonConfig.get(SUPPORT_ALL_CALLBACKS_FROM_LIBRARY_KEY).getAsBoolean();
            builder.setSupportAllCallbacksFromLibrary(supportAllCallbacksFromLibrary);
        }
        topLevelFlagAmender.accept(builder);
        return builder.build();
    }

    void parseFlags(JsonObject jsonFlagSet, LegacyRewritingFlags.Builder builder) {
        if (jsonFlagSet.has(REWRITE_PREFIX_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(REWRITE_PREFIX_KEY).getAsJsonObject().entrySet()) {
                builder.putRewritePrefix(entry.getKey(), entry.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has(RETARGET_LIB_MEMBER_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(RETARGET_LIB_MEMBER_KEY).getAsJsonObject().entrySet()) {
                builder.putRetargetCoreLibMember(entry.getKey(), entry.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has(BACKPORT_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(BACKPORT_KEY).getAsJsonObject().entrySet()) {
                builder.putBackportCoreLibraryMember(entry.getKey(), entry.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has(EMULATE_INTERFACE_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(EMULATE_INTERFACE_KEY).getAsJsonObject().entrySet()) {
                builder.putEmulateLibraryInterface(entry.getKey(), entry.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has(CUSTOM_CONVERSION_KEY)) {
            for (Map.Entry entry : jsonFlagSet.get(CUSTOM_CONVERSION_KEY).getAsJsonObject().entrySet()) {
                builder.putCustomConversion((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        if (jsonFlagSet.has(WRAPPER_CONVERSION_KEY)) {
            for (JsonElement jsonElement : jsonFlagSet.get(WRAPPER_CONVERSION_KEY).getAsJsonArray()) {
                builder.addWrapperConversion(jsonElement.getAsString());
            }
        }
        if (jsonFlagSet.has(DONT_REWRITE_KEY)) {
            JsonArray dontRewrite = jsonFlagSet.get(DONT_REWRITE_KEY).getAsJsonArray();
            for (JsonElement rewrite : dontRewrite) {
                builder.addDontRewriteInvocation(rewrite.getAsString());
            }
        }
        if (jsonFlagSet.has(DONT_RETARGET_LIB_MEMBER_KEY)) {
            JsonArray dontRetarget = jsonFlagSet.get(DONT_RETARGET_LIB_MEMBER_KEY).getAsJsonArray();
            for (JsonElement rewrite : dontRetarget) {
                builder.addDontRetargetLibMember(rewrite.getAsString());
            }
        }
    }
}

