/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterSyntheticHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class DesugaredLibraryRetargeter
implements CfInstructionDesugaring {
    private final AppView<?> appView;
    private final DesugaredLibraryRetargeterSyntheticHelper syntheticHelper;
    private final Map<DexMethod, DexMethod> staticRetarget;
    private final Map<DexMethod, DexMethod> nonEmulatedVirtualRetarget;
    private final Map<DexMethod, EmulatedDispatchMethodDescriptor> emulatedVirtualRetarget;

    public DesugaredLibraryRetargeter(AppView<?> appView) {
        this.appView = appView;
        this.syntheticHelper = new DesugaredLibraryRetargeterSyntheticHelper(appView);
        MachineDesugaredLibrarySpecification specification = appView.options().machineDesugaredLibrarySpecification;
        this.staticRetarget = specification.getStaticRetarget();
        this.nonEmulatedVirtualRetarget = specification.getNonEmulatedVirtualRetarget();
        this.emulatedVirtualRetarget = specification.getEmulatedVirtualRetarget();
    }

    private InvokeRetargetingResult computeNewInvokeTarget(CfInstruction instruction, ProgramMethod context) {
        DexClassAndMethod superTarget;
        if (!instruction.isInvoke()) {
            return InvokeRetargetingResult.NO_REWRITING;
        }
        if (this.appView.options().machineDesugaredLibrarySpecification.getDontRetarget().contains(context.getContextType())) {
            return InvokeRetargetingResult.NO_REWRITING;
        }
        CfInvoke cfInvoke = instruction.asInvoke();
        DexMethod invokedMethod = cfInvoke.getMethod();
        AppInfoWithClassHierarchy appInfo = this.appView.appInfoForDesugaring();
        MethodResolutionResult resolutionResult = appInfo.resolveMethod(invokedMethod, cfInvoke.isInterface());
        if (!resolutionResult.isSingleResolution()) {
            return InvokeRetargetingResult.NO_REWRITING;
        }
        assert (resolutionResult.getSingleTarget() != null);
        DexMethod singleTarget = (DexMethod)resolutionResult.getSingleTarget().getReference();
        if (cfInvoke.isInvokeStatic()) {
            DexMethod retarget = this.staticRetarget.get(singleTarget);
            return retarget == null ? InvokeRetargetingResult.NO_REWRITING : this.ensureInvokeRetargetingResult(retarget);
        }
        InvokeRetargetingResult retarget = this.computeNonStaticRetarget(singleTarget, false);
        if (!retarget.hasNewInvokeTarget()) {
            return InvokeRetargetingResult.NO_REWRITING;
        }
        if (cfInvoke.isInvokeSuper(context.getHolderType()) && (superTarget = appInfo.lookupSuperTarget(invokedMethod, context)) != null) {
            assert (!((DexEncodedMethod)superTarget.getDefinition()).isStatic());
            return this.computeNonStaticRetarget((DexMethod)superTarget.getReference(), true);
        }
        return retarget;
    }

    private InvokeRetargetingResult computeNonStaticRetarget(DexMethod singleTarget, boolean superInvoke) {
        EmulatedDispatchMethodDescriptor descriptor = this.emulatedVirtualRetarget.get(singleTarget);
        if (descriptor != null) {
            return new InvokeRetargetingResult(true, eventConsumer -> superInvoke ? this.syntheticHelper.ensureForwardingMethod(descriptor, (DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer)eventConsumer) : this.syntheticHelper.ensureEmulatedHolderDispatchMethod(descriptor, (DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer)eventConsumer));
        }
        return this.ensureInvokeRetargetingResult(this.nonEmulatedVirtualRetarget.get(singleTarget));
    }

    public void visit(Consumer<DexMethod> consumer) {
        this.staticRetarget.keySet().forEach(consumer);
        this.nonEmulatedVirtualRetarget.keySet().forEach(consumer);
        this.emulatedVirtualRetarget.keySet().forEach(consumer);
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        InvokeRetargetingResult invokeRetargetingResult = this.computeNewInvokeTarget(instruction, context);
        if (!invokeRetargetingResult.hasNewInvokeTarget()) {
            return null;
        }
        DexMethod newInvokeTarget = invokeRetargetingResult.getNewInvokeTarget(eventConsumer);
        return Collections.singletonList(new CfInvoke(184, newInvokeTarget, instruction.asInvoke().isInterface()));
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        return this.computeNewInvokeTarget(instruction, context).hasNewInvokeTarget();
    }

    InvokeRetargetingResult ensureInvokeRetargetingResult(DexMethod retarget) {
        if (retarget == null) {
            return InvokeRetargetingResult.NO_REWRITING;
        }
        return new InvokeRetargetingResult(true, eventConsumer -> {
            this.syntheticHelper.ensureRetargetMethod(retarget, (DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer)eventConsumer);
            return retarget;
        });
    }

    static class InvokeRetargetingResult {
        static InvokeRetargetingResult NO_REWRITING = new InvokeRetargetingResult(false, ignored -> null);
        private final boolean hasNewInvokeTarget;
        private final Function<DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer, DexMethod> newInvokeTargetSupplier;

        private InvokeRetargetingResult(boolean hasNewInvokeTarget, Function<DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer, DexMethod> newInvokeTargetSupplier) {
            this.hasNewInvokeTarget = hasNewInvokeTarget;
            this.newInvokeTargetSupplier = newInvokeTargetSupplier;
        }

        public boolean hasNewInvokeTarget() {
            return this.hasNewInvokeTarget;
        }

        public DexMethod getNewInvokeTarget(DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer eventConsumer) {
            assert (this.hasNewInvokeTarget());
            return this.newInvokeTargetSupplier.apply(eventConsumer);
        }
    }
}

