/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter;

import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaring;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterSyntheticHelper;
import com.android.tools.r8.utils.OptionalBool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class DesugaredLibraryRetargeterPostProcessor
implements CfPostProcessingDesugaring {
    private final AppView<?> appView;
    private final DesugaredLibraryRetargeterSyntheticHelper syntheticHelper;
    private final Map<DexMethod, EmulatedDispatchMethodDescriptor> emulatedDispatchMethods;

    public DesugaredLibraryRetargeterPostProcessor(AppView<?> appView) {
        this.appView = appView;
        this.syntheticHelper = new DesugaredLibraryRetargeterSyntheticHelper(appView);
        this.emulatedDispatchMethods = appView.options().machineDesugaredLibrarySpecification.getEmulatedVirtualRetarget();
    }

    private void ensureInterfacesAndForwardingMethodsSynthesized(Collection<DexProgramClass> programClasses, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterPostProcessingEventConsumer eventConsumer) {
        assert (!this.appView.options().isDesugaredLibraryCompilation());
        IdentityHashMap<DexType, List> map = Maps.newIdentityHashMap();
        this.emulatedDispatchMethods.forEach((method, descriptor) -> {
            map.putIfAbsent(method.getHolderType(), new ArrayList(1));
            ((List)map.get(method.getHolderType())).add(method);
        });
        for (DexProgramClass clazz : programClasses) {
            if (clazz.superType == null) {
                assert (clazz.type == this.appView.dexItemFactory().objectType) : clazz.type.toSourceString();
                continue;
            }
            DexClass superclass = this.appView.definitionFor(clazz.superType);
            if (superclass == null || !superclass.isLibraryClass() || superclass.type == this.appView.dexItemFactory().objectType) continue;
            map.forEach((type, methods) -> {
                if (this.inherit(superclass.asLibraryClass(), (DexType)type, this.emulatedDispatchMethods)) {
                    this.ensureInterfacesAndForwardingMethodsSynthesized(eventConsumer, clazz, (List<DexMethod>)methods);
                }
            });
        }
    }

    private boolean inherit(DexLibraryClass clazz, DexType typeToInherit, Map<DexMethod, EmulatedDispatchMethodDescriptor> retarget) {
        DexLibraryClass current = clazz;
        while (current.type != this.appView.dexItemFactory().objectType) {
            if (current.type == typeToInherit) {
                return true;
            }
            DexClass dexClass = this.appView.definitionFor(current.superType);
            if (dexClass == null || dexClass.isClasspathClass()) {
                this.reportInvalidLibrarySupertype(current, retarget.keySet());
                return false;
            }
            if (dexClass.isProgramClass()) {
                return false;
            }
            current = dexClass.asLibraryClass();
        }
        return false;
    }

    private void ensureInterfacesAndForwardingMethodsSynthesized(DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterPostProcessingEventConsumer eventConsumer, DexProgramClass clazz, List<DexMethod> methods) {
        if (this.appView.isAlreadyLibraryDesugared(clazz)) {
            return;
        }
        for (DexMethod method : methods) {
            EmulatedDispatchMethodDescriptor descriptor = this.emulatedDispatchMethods.get(method);
            DexClass newInterface = this.syntheticHelper.ensureEmulatedInterfaceDispatchMethod(descriptor, eventConsumer);
            if (clazz.interfaces.contains(newInterface.type) || this.appView.options().machineDesugaredLibrarySpecification.getDontRetarget().contains(clazz.getType())) continue;
            clazz.addExtraInterfaces(Collections.singletonList(new GenericSignature.ClassTypeSignature(newInterface.type)));
            eventConsumer.acceptInterfaceInjection(clazz, newInterface);
            DexMethod itfMethod = this.syntheticHelper.emulatedInterfaceDispatchMethod(newInterface, descriptor);
            if (clazz.lookupVirtualMethod(method) != null) continue;
            DexEncodedMethod newMethod = this.createForwardingMethod(itfMethod, descriptor, clazz);
            clazz.addVirtualMethod(newMethod);
            eventConsumer.acceptForwardingMethod(new ProgramMethod(clazz, newMethod));
        }
    }

    private DexEncodedMethod createForwardingMethod(DexMethod target, EmulatedDispatchMethodDescriptor descriptor, DexClass clazz) {
        DexMethod forwardMethod = this.syntheticHelper.forwardingMethod(descriptor);
        assert (forwardMethod != null && forwardMethod != target);
        DexEncodedMethod resolvedMethod = this.appView.appInfoForDesugaring().resolveMethod(target, true).getResolvedMethod();
        assert (resolvedMethod != null);
        DexEncodedMethod desugaringForwardingMethod = DexEncodedMethod.createDesugaringForwardingMethod(resolvedMethod, clazz, forwardMethod, this.appView.dexItemFactory());
        desugaringForwardingMethod.setLibraryMethodOverride(OptionalBool.TRUE);
        return desugaringForwardingMethod;
    }

    private void reportInvalidLibrarySupertype(DexLibraryClass libraryClass, Set<DexMethod> retarget) {
        String message;
        DexClass dexClass = this.appView.definitionFor(libraryClass.superType);
        if (dexClass == null) {
            message = "missing";
        } else if (dexClass.isClasspathClass()) {
            message = "a classpath class";
        } else {
            message = "INVALID";
            assert (false);
        }
        this.appView.options().warningInvalidLibrarySuperclassForDesugar(dexClass == null ? libraryClass.getOrigin() : dexClass.getOrigin(), libraryClass.type, libraryClass.superType, message, retarget);
    }

    @Override
    public void postProcessingDesugaring(Collection<DexProgramClass> programClasses, CfPostProcessingDesugaringEventConsumer eventConsumer, ExecutorService executorService) throws ExecutionException {
        assert (!this.appView.options().isDesugaredLibraryCompilation());
        this.ensureInterfacesAndForwardingMethodsSynthesized(programClasses, eventConsumer);
    }
}

