/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.ClasspathOrLibraryClass;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.DerivedMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterSynthesizerEventConsumer;
import com.android.tools.r8.ir.synthetic.EmulateDispatchSyntheticCfCodeProvider;
import com.android.tools.r8.synthesis.SyntheticClassBuilder;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.synthesis.SyntheticNaming;
import java.util.LinkedHashMap;

public class DesugaredLibraryRetargeterSyntheticHelper {
    private final AppView<?> appView;

    public DesugaredLibraryRetargeterSyntheticHelper(AppView<?> appView) {
        this.appView = appView;
    }

    private boolean verifyKind(DerivedMethod method, SyntheticItems.SyntheticKindSelector kindSelector) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.appView.getSyntheticItems().getNaming());
        assert (method.getHolderKind().equals(kind));
        return true;
    }

    private DexMethod emulatedHolderDispatchMethod(DexType holder, DerivedMethod method) {
        assert (this.verifyKind(method, kinds -> kinds.RETARGET_CLASS));
        DexProto newProto = this.appView.dexItemFactory().prependHolderToProto(method.getMethod());
        return this.appView.dexItemFactory().createMethod(holder, newProto, method.getName());
    }

    private void buildInterfaceDispatchMethod(SyntheticClassBuilder<?, ?> classBuilder, EmulatedDispatchMethodDescriptor descriptor) {
        ((SyntheticClassBuilder)classBuilder.setInterface()).addMethod(methodBuilder -> {
            DexMethod itfMethod = this.emulatedInterfaceDispatchMethod(classBuilder.getType(), descriptor.getInterfaceMethod());
            MethodAccessFlags flags = MethodAccessFlags.fromSharedAccessFlags(5121, false);
            methodBuilder.setName(itfMethod.getName()).setProto(itfMethod.getProto()).disableAndroidApiLevelCheck().setAccessFlags(flags);
        });
    }

    private <SCB extends SyntheticClassBuilder<?, ?>> void buildHolderDispatchMethod(SCB classBuilder, DexClass itfClass, EmulatedDispatchMethodDescriptor descriptor, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer eventConsumer) {
        classBuilder.addMethod(methodBuilder -> {
            DexMethod dispatchMethod = this.emulatedHolderDispatchMethod(classBuilder.getType(), descriptor.getEmulatedDispatchMethod());
            methodBuilder.setName(dispatchMethod.getName()).setProto(dispatchMethod.getProto()).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).disableAndroidApiLevelCheck().setCode(methodSig -> this.appView.options().isDesugaredLibraryCompilation() ? this.generateEmulatedDispatchCfCode(descriptor, itfClass, methodSig, eventConsumer) : null);
        });
    }

    private CfCode generateEmulatedDispatchCfCode(EmulatedDispatchMethodDescriptor descriptor, DexClass itfClass, DexMethod methodSig, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer eventConsumer) {
        DexMethod forwardingMethod = this.ensureForwardingMethod(descriptor, eventConsumer);
        DexMethod itfMethod = this.emulatedInterfaceDispatchMethod(itfClass, descriptor);
        assert (descriptor.getDispatchCases().isEmpty());
        return new EmulateDispatchSyntheticCfCodeProvider(methodSig.getHolderType(), forwardingMethod, itfMethod, new LinkedHashMap<DexType, DexMethod>(), this.appView).generateCfCode();
    }

    public DexMethod ensureRetargetMethod(DexMethod retarget, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer eventConsumer) {
        DexClass holderClass = this.appView.definitionFor(retarget.getHolderType());
        if (holderClass != null && !holderClass.isClasspathClass()) {
            assert (holderClass.lookupMethod(retarget) != null);
            return retarget;
        }
        assert (eventConsumer != null);
        ClasspathMethod ensuredMethod = this.appView.getSyntheticItems().ensureFixedClasspathMethodFromType(retarget.getName(), retarget.getProto(), kinds -> kinds.RETARGET_STUB, retarget.getHolderType(), this.appView, ignored -> {}, eventConsumer::acceptDesugaredLibraryRetargeterDispatchClasspathClass, methodBuilder -> methodBuilder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(null));
        assert (ensuredMethod.getReference() == retarget);
        return retarget;
    }

    DexMethod forwardingMethod(EmulatedDispatchMethodDescriptor descriptor) {
        assert (descriptor.getForwardingMethod().getHolderKind() == null);
        return descriptor.getForwardingMethod().getMethod();
    }

    public DexMethod ensureForwardingMethod(EmulatedDispatchMethodDescriptor descriptor, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer eventConsumer) {
        return this.ensureRetargetMethod(this.forwardingMethod(descriptor), eventConsumer);
    }

    DexMethod emulatedInterfaceDispatchMethod(DexType holder, DerivedMethod method) {
        assert (this.verifyKind(method, kinds -> kinds.RETARGET_INTERFACE));
        return this.appView.dexItemFactory().createMethod(holder, method.getProto(), method.getName());
    }

    public DexMethod emulatedInterfaceDispatchMethod(DexClass newInterface, EmulatedDispatchMethodDescriptor descriptor) {
        DexMethod method = this.emulatedInterfaceDispatchMethod(newInterface.type, descriptor.getInterfaceMethod());
        assert (newInterface.lookupMethod(method) != null);
        return method;
    }

    public DexMethod ensureEmulatedHolderDispatchMethod(EmulatedDispatchMethodDescriptor descriptor, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer eventConsumer) {
        assert (eventConsumer != null);
        DerivedMethod emulatedDispatchMethod = descriptor.getEmulatedDispatchMethod();
        DexClass holderContext = this.appView.contextIndependentDefinitionFor(emulatedDispatchMethod.getHolderContext());
        if (this.appView.options().isDesugaredLibraryCompilation()) {
            DexProgramClass syntheticClass = this.appView.getSyntheticItems().getExistingFixedClass(ignored -> emulatedDispatchMethod.getHolderKind(), holderContext, this.appView);
            DexMethod dispatchMethod = this.emulatedHolderDispatchMethod(syntheticClass.type, emulatedDispatchMethod);
            assert (syntheticClass.lookupMethod(dispatchMethod) != null);
            return dispatchMethod;
        }
        DexClass itfClass = this.ensureEmulatedInterfaceDispatchMethod(descriptor, eventConsumer);
        ClasspathOrLibraryClass context = holderContext.asClasspathOrLibraryClass();
        assert (context != null);
        DexClasspathClass syntheticClass = this.appView.getSyntheticItems().ensureFixedClasspathClass(kinds -> kinds.RETARGET_CLASS, context, this.appView, classBuilder -> this.buildHolderDispatchMethod(classBuilder, itfClass, descriptor, eventConsumer), eventConsumer::acceptDesugaredLibraryRetargeterDispatchClasspathClass);
        DexMethod dispatchMethod = this.emulatedHolderDispatchMethod(syntheticClass.type, emulatedDispatchMethod);
        assert (syntheticClass.lookupMethod(dispatchMethod) != null);
        return dispatchMethod;
    }

    public void ensureProgramEmulatedHolderDispatchMethod(EmulatedDispatchMethodDescriptor descriptor, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterL8SynthesizerEventConsumer eventConsumer) {
        assert (eventConsumer != null);
        assert (this.appView.options().isDesugaredLibraryCompilation());
        DerivedMethod emulatedDispatchMethod = descriptor.getEmulatedDispatchMethod();
        DexClass holderContext = this.appView.contextIndependentDefinitionFor(emulatedDispatchMethod.getHolderContext());
        DexClass itfClass = this.ensureEmulatedInterfaceDispatchMethod(descriptor, eventConsumer);
        this.appView.getSyntheticItems().ensureFixedClass(ignored -> emulatedDispatchMethod.getHolderKind(), holderContext, this.appView, classBuilder -> this.buildHolderDispatchMethod(classBuilder, itfClass, descriptor, null), eventConsumer::acceptDesugaredLibraryRetargeterDispatchProgramClass);
    }

    public DexClass ensureEmulatedInterfaceDispatchMethod(EmulatedDispatchMethodDescriptor descriptor, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterInstructionEventConsumer eventConsumer) {
        assert (eventConsumer != null);
        DerivedMethod itfMethod = descriptor.getInterfaceMethod();
        DexClass itfContext = this.appView.contextIndependentDefinitionFor(itfMethod.getHolderContext());
        if (this.appView.options().isDesugaredLibraryCompilation()) {
            return this.appView.getSyntheticItems().getExistingFixedClass(ignored -> itfMethod.getHolderKind(), itfContext, this.appView);
        }
        ClasspathOrLibraryClass context = itfContext.asClasspathOrLibraryClass();
        assert (context != null);
        return this.appView.getSyntheticItems().ensureFixedClasspathClass(kinds -> kinds.RETARGET_INTERFACE, context, this.appView, classBuilder -> this.buildInterfaceDispatchMethod((SyntheticClassBuilder<?, ?>)classBuilder, descriptor), eventConsumer::acceptDesugaredLibraryRetargeterDispatchClasspathClass);
    }

    public DexClass ensureEmulatedInterfaceDispatchMethod(EmulatedDispatchMethodDescriptor descriptor, DesugaredLibraryRetargeterSynthesizerEventConsumer.DesugaredLibraryRetargeterL8SynthesizerEventConsumer eventConsumer) {
        assert (this.appView.options().isDesugaredLibraryCompilation());
        assert (eventConsumer != null);
        DerivedMethod itfMethod = descriptor.getInterfaceMethod();
        DexClass itfContext = this.appView.contextIndependentDefinitionFor(itfMethod.getHolderContext());
        return this.appView.getSyntheticItems().ensureFixedClass(ignore -> itfMethod.getHolderKind(), itfContext, this.appView, classBuilder -> this.buildInterfaceDispatchMethod((SyntheticClassBuilder<?, ?>)classBuilder, descriptor), eventConsumer::acceptDesugaredLibraryRetargeterDispatchProgramClass);
    }
}

