/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion;

import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanTopLevelFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.MultiAPILevelHumanDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.MultiAPILevelHumanDesugaredLibrarySpecificationJsonExporter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.LegacyDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.LegacyRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.LegacyTopLevelFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.MultiAPILevelLegacyDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification.MultiAPILevelLegacyDesugaredLibrarySpecificationParser;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.AppForSpecConversion;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.LibraryValidator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LegacyToHumanSpecificationConverter {
    private static final String WRAPPER_PREFIX = "__wrapper__.";
    private static final AndroidApiLevel LEGACY_HACK_LEVEL = AndroidApiLevel.N_MR1;
    private final Timing timing;

    public LegacyToHumanSpecificationConverter(Timing timing) {
        this.timing = timing;
    }

    private void legacyLibraryFlagHacks(Int2ObjectArrayMap<HumanRewritingFlags> libraryFlags, DexApplication app, Origin origin) {
        int level = LEGACY_HACK_LEVEL.getLevel();
        HumanRewritingFlags humanRewritingFlags = libraryFlags.get(level);
        if (humanRewritingFlags == null) {
            return;
        }
        HumanRewritingFlags.Builder builder = humanRewritingFlags.newBuilder(app.options.reporter, origin);
        this.legacyLibraryFlagHacks(app.dexItemFactory(), builder);
        libraryFlags.put(level, builder.build());
    }

    private void legacyLibraryFlagHacks(DexItemFactory itemFactory, HumanRewritingFlags.Builder builder) {
        DexString name = itemFactory.createString("deepEquals0");
        DexProto proto = itemFactory.createProto(itemFactory.booleanType, itemFactory.objectType, itemFactory.objectType);
        DexMethod source = itemFactory.createMethod(itemFactory.createType(itemFactory.arraysDescriptor), proto, name);
        DexType target = itemFactory.createType("Ljava/util/DesugarArrays;");
        builder.retargetMethod(source, target);
        builder.amendLibraryMethod(source, MethodAccessFlags.fromSharedAccessFlags(10, false));
        name = itemFactory.createString("getTimeZone");
        proto = itemFactory.createProto(itemFactory.createType("Ljava/util/TimeZone;"), itemFactory.createType("Ljava/time/ZoneId;"));
        source = itemFactory.createMethod(itemFactory.createType("Ljava/util/TimeZone;"), proto, name);
        target = itemFactory.createType("Ljava/util/DesugarTimeZone;");
        builder.retargetMethod(source, target);
    }

    private Int2ObjectArrayMap<HumanRewritingFlags> convertRewritingFlagMap(Int2ObjectMap<LegacyRewritingFlags> libFlags, DexApplication app, Origin origin) {
        Int2ObjectArrayMap<HumanRewritingFlags> map = new Int2ObjectArrayMap<HumanRewritingFlags>();
        libFlags.forEach((key, flags) -> map.put((int)key, this.convertRewritingFlags((LegacyRewritingFlags)flags, app, origin)));
        return map;
    }

    private HumanRewritingFlags convertRewritingFlags(LegacyRewritingFlags flags, DexApplication app, Origin origin) {
        this.timing.begin("Convert rewriting flags");
        HumanRewritingFlags.Builder builder = HumanRewritingFlags.builder(app.options.reporter, origin);
        flags.getRewritePrefix().forEach((prefix, rewritten) -> this.rewritePrefix(builder, (String)prefix, (String)rewritten));
        flags.getEmulateLibraryInterface().forEach(builder::putEmulatedInterface);
        flags.getBackportCoreLibraryMember().forEach(builder::putLegacyBackport);
        flags.getCustomConversions().forEach(builder::putCustomConversion);
        flags.getDontRetargetLibMember().forEach(builder::addDontRetargetLibMember);
        flags.getWrapperConversions().forEach(builder::addWrapperConversion);
        flags.getRetargetCoreLibMember().forEach((name, typeMap) -> this.convertRetargetCoreLibMember(builder, app, (DexString)name, (Map<DexType, DexType>)typeMap));
        flags.getDontRewriteInvocation().forEach(pair -> this.convertDontRewriteInvocation(builder, app, (Pair<DexType, DexString>)pair));
        HumanRewritingFlags humanFlags = builder.build();
        this.timing.end();
        return humanFlags;
    }

    private void rewritePrefix(HumanRewritingFlags.Builder builder, String prefix, String rewritten) {
        if (prefix.startsWith("j$")) {
            assert (rewritten.startsWith("java"));
            builder.putRewriteDerivedPrefix(rewritten, prefix, rewritten);
            return;
        }
        if (prefix.equals(WRAPPER_PREFIX)) {
            ImmutableMap<String, String> map = ImmutableMap.of("java.nio.", "j$.nio.", "java.io.", "j$.io.");
            map.forEach((k, v) -> {
                builder.putRewriteDerivedPrefix((String)k, WRAPPER_PREFIX + k, (String)k);
                builder.putRewriteDerivedPrefix((String)k, WRAPPER_PREFIX + v, (String)v);
            });
            return;
        }
        builder.putRewritePrefix(prefix, rewritten);
    }

    private void convertDontRewriteInvocation(HumanRewritingFlags.Builder builder, DexApplication app, Pair<DexType, DexString> pair) {
        DexClass dexClass = app.definitionFor(pair.getFirst());
        assert (dexClass != null);
        List<DexClassAndMethod> methodsWithName = this.findMethodsWithName(pair.getSecond(), dexClass, builder, app);
        for (DexClassAndMethod dexClassAndMethod : methodsWithName) {
            builder.addDontRewriteInvocation((DexMethod)dexClassAndMethod.getReference());
        }
    }

    private void convertRetargetCoreLibMember(HumanRewritingFlags.Builder builder, DexApplication app, DexString name, Map<DexType, DexType> typeMap) {
        typeMap.forEach((type, rewrittenType) -> {
            DexClass dexClass = app.definitionFor((DexType)type);
            assert (dexClass != null);
            List<DexClassAndMethod> methodsWithName = this.findMethodsWithName(name, dexClass, builder, app);
            for (DexClassAndMethod dexClassAndMethod : methodsWithName) {
                DexEncodedMethod definition = (DexEncodedMethod)dexClassAndMethod.getDefinition();
                if (definition.isStatic() || definition.isFinal() || dexClassAndMethod.getHolder().isFinal()) {
                    builder.retargetMethod((DexMethod)dexClassAndMethod.getReference(), (DexType)rewrittenType);
                    continue;
                }
                builder.retargetMethodEmulatedDispatch((DexMethod)dexClassAndMethod.getReference(), (DexType)rewrittenType);
            }
        });
    }

    private List<DexClassAndMethod> findMethodsWithName(DexString methodName, DexClass clazz, HumanRewritingFlags.Builder builder, DexApplication app) {
        ArrayList<DexClassAndMethod> found = new ArrayList<DexClassAndMethod>();
        clazz.forEachClassMethodMatching(definition -> definition.getName() == methodName, found::add);
        if (found.isEmpty() && methodName.toString().equals("transferTo") && clazz.type.toString().equals("java.io.InputStream")) {
            DexItemFactory factory = app.dexItemFactory();
            DexProto proto = factory.createProto(factory.longType, factory.createType("Ljava/io/OutputStream;"));
            DexMethod method = factory.createMethod(clazz.type, proto, methodName);
            MethodAccessFlags flags = MethodAccessFlags.fromSharedAccessFlags(1, false);
            builder.amendLibraryMethod(method, flags);
            DexEncodedMethod build = DexEncodedMethod.builder().setMethod(method).setAccessFlags(flags).build();
            return ImmutableList.of(DexClassAndMethod.create(clazz, build));
        }
        assert (!found.isEmpty()) : "Should have found a method (library specifications) for " + clazz.toSourceString() + "." + methodName + ". Maybe the library used for the compilation should be newer.";
        return found;
    }

    private HumanTopLevelFlags convertTopLevelFlags(LegacyTopLevelFlags topLevelFlags) {
        return HumanTopLevelFlags.builder().setDesugaredLibraryIdentifier(topLevelFlags.getIdentifier()).setExtraKeepRules(topLevelFlags.getExtraKeepRules()).setJsonSource(topLevelFlags.getJsonSource()).setRequiredCompilationAPILevel(topLevelFlags.getRequiredCompilationAPILevel()).setSupportAllCallbacksFromLibrary(topLevelFlags.supportAllCallbacksFromLibrary()).setSynthesizedLibraryClassesPackagePrefix(topLevelFlags.getSynthesizedLibraryClassesPackagePrefix()).build();
    }

    public void convertAllAPILevels(StringResource inputSpecification, Path desugaredJDKLib, Path androidLib, StringConsumer output) throws IOException {
        InternalOptions options = new InternalOptions();
        MultiAPILevelLegacyDesugaredLibrarySpecification legacySpec = new MultiAPILevelLegacyDesugaredLibrarySpecificationParser(options.dexItemFactory(), options.reporter).parseMultiLevelConfiguration(inputSpecification);
        MultiAPILevelHumanDesugaredLibrarySpecification humanSpec = this.convertAllAPILevels(legacySpec, desugaredJDKLib, androidLib, options);
        MultiAPILevelHumanDesugaredLibrarySpecificationJsonExporter.export(humanSpec, output);
    }

    public MultiAPILevelHumanDesugaredLibrarySpecification convertAllAPILevels(MultiAPILevelLegacyDesugaredLibrarySpecification legacySpec, Path desugaredJDKLib, Path androidLib, InternalOptions options) throws IOException {
        this.timing.begin("Legacy to human all API convert");
        Origin origin = legacySpec.getOrigin();
        DexApplication app = AppForSpecConversion.readAppForTesting(desugaredJDKLib, androidLib, options, true, this.timing);
        HumanTopLevelFlags humanTopLevelFlags = this.convertTopLevelFlags(legacySpec.getTopLevelFlags());
        Int2ObjectArrayMap<HumanRewritingFlags> commonFlags = this.convertRewritingFlagMap(legacySpec.getCommonFlags(), app, origin);
        Int2ObjectArrayMap<HumanRewritingFlags> programFlags = this.convertRewritingFlagMap(legacySpec.getProgramFlags(), app, origin);
        Int2ObjectArrayMap<HumanRewritingFlags> libraryFlags = this.convertRewritingFlagMap(legacySpec.getLibraryFlags(), app, origin);
        this.legacyLibraryFlagHacks(libraryFlags, app, origin);
        MultiAPILevelHumanDesugaredLibrarySpecification humanSpec = new MultiAPILevelHumanDesugaredLibrarySpecification(origin, humanTopLevelFlags, commonFlags, libraryFlags, programFlags);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(humanSpec, options.reporter);
        this.timing.end();
        return humanSpec;
    }

    public HumanDesugaredLibrarySpecification convertForTesting(LegacyDesugaredLibrarySpecification legacySpec, Path desugaredJDKLib, Path androidLib, InternalOptions options) throws IOException {
        DexApplication app = AppForSpecConversion.readAppForTesting(desugaredJDKLib, androidLib, options, legacySpec.isLibraryCompilation(), this.timing);
        return this.convert(legacySpec, app);
    }

    public HumanDesugaredLibrarySpecification convert(LegacyDesugaredLibrarySpecification legacySpec, DexApplication app) throws IOException {
        this.timing.begin("Legacy to Human convert");
        LibraryValidator.validate(app, legacySpec.isLibraryCompilation(), legacySpec.getTopLevelFlags().getRequiredCompilationAPILevel());
        HumanTopLevelFlags humanTopLevelFlags = this.convertTopLevelFlags(legacySpec.getTopLevelFlags());
        Origin origin = Origin.unknown();
        HumanRewritingFlags humanRewritingFlags = this.convertRewritingFlags(legacySpec.getRewritingFlags(), app, origin);
        if (app.options.getMinApiLevel().isLessThanOrEqualTo(LEGACY_HACK_LEVEL) && legacySpec.isLibraryCompilation()) {
            this.timing.begin("Legacy hacks");
            HumanRewritingFlags.Builder builder = humanRewritingFlags.newBuilder(app.options.reporter, origin);
            this.legacyLibraryFlagHacks(app.dexItemFactory(), builder);
            humanRewritingFlags = builder.build();
            this.timing.end();
        }
        this.timing.end();
        return new HumanDesugaredLibrarySpecification(humanTopLevelFlags, humanRewritingFlags, legacySpec.isLibraryCompilation());
    }
}

