/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion;

import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.AndroidApiLevel;

public class LibraryValidator {
    public static void validate(DexApplication app, boolean libraryCompilation, AndroidApiLevel requiredCompilationAPILevel) {
        DexType levelType;
        if (libraryCompilation) {
            return;
        }
        if (requiredCompilationAPILevel.isEqualTo(AndroidApiLevel.O)) {
            levelType = app.dexItemFactory.createType("Ljava/time/LocalTime;");
        } else if (requiredCompilationAPILevel.isEqualTo(AndroidApiLevel.R)) {
            levelType = app.dexItemFactory.createType("Ljava/util/concurrent/Flow;");
        } else {
            app.options.reporter.warning("Unsupported requiredCompilationAPILevel: " + requiredCompilationAPILevel);
            return;
        }
        DexClass dexClass = app.definitionFor(levelType);
        if (dexClass == null) {
            app.options.reporter.warning("Desugared library requires to be compiled with a library file of API greater or equal to " + requiredCompilationAPILevel + ", but it seems the library file passed is of a lower API.");
        }
    }
}

