/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.invokespecial;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.invokespecial.InvokeSpecialBridgeInfo;
import com.android.tools.r8.ir.desugar.invokespecial.InvokeSpecialToSelfDesugaringEventConsumer;
import com.android.tools.r8.ir.synthetic.ForwardMethodBuilder;
import java.util.Collection;
import java.util.List;

public class InvokeSpecialToSelfDesugaring
implements CfInstructionDesugaring {
    private static final String INVOKE_SPECIAL_BRIDGE_PREFIX = "$invoke$special$";
    private final DexItemFactory dexItemFactory;

    public InvokeSpecialToSelfDesugaring(AppView<?> appView) {
        this.dexItemFactory = appView.dexItemFactory();
    }

    private ProgramMethod needsDesugaring(CfInvoke invoke, ProgramMethod context) {
        if (!invoke.isInvokeSpecial() || invoke.isInvokeConstructor(this.dexItemFactory)) {
            return null;
        }
        DexMethod invokedMethod = invoke.getMethod();
        if (invokedMethod.getHolderType() != context.getHolderType()) {
            return null;
        }
        ProgramMethod method = context.getHolder().lookupProgramMethod(invokedMethod);
        if (method == null || method.getAccessFlags().isPrivate() || ((DexEncodedMethod)method.getDefinition()).isStatic() || invoke.isInterface() && method.isDefaultMethod()) {
            return null;
        }
        return method;
    }

    private List<CfInstruction> desugarInvokeInstruction(CfInvoke invoke, InvokeSpecialToSelfDesugaringEventConsumer eventConsumer, ProgramMethod context) {
        ProgramMethod method = this.needsDesugaring(invoke, context);
        if (method == null) {
            return null;
        }
        if (method.getAccessFlags().isFinal()) {
            return ImmutableList.of(new CfInvoke(182, invoke.getMethod(), invoke.isInterface()));
        }
        DexMethod bridgeMethod = this.ensureInvokeSpecialBridge(method, eventConsumer);
        return ImmutableList.of(new CfInvoke(183, bridgeMethod, invoke.isInterface()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexMethod ensureInvokeSpecialBridge(ProgramMethod method, InvokeSpecialToSelfDesugaringEventConsumer eventConsumer) {
        DexMethod bridgeReference = this.getInvokeSpecialBridgeReference(method);
        DexProgramClass clazz = method.getHolder();
        MethodCollection methodCollection = clazz.getMethodCollection();
        synchronized (methodCollection) {
            if (clazz.lookupProgramMethod(bridgeReference) == null) {
                ProgramMethod newDirectMethod = ((DexEncodedMethod)method.getDefinition()).toPrivateSyntheticMethod(clazz, bridgeReference);
                CfCode virtualMethodCode = ForwardMethodBuilder.builder(this.dexItemFactory).setDirectTarget(bridgeReference, clazz.isInterface()).setNonStaticSource((DexMethod)method.getReference()).build();
                clazz.addDirectMethod((DexEncodedMethod)newDirectMethod.getDefinition());
                eventConsumer.acceptInvokeSpecialBridgeInfo(new InvokeSpecialBridgeInfo(newDirectMethod, method, virtualMethodCode));
            }
        }
        return bridgeReference;
    }

    private DexMethod getInvokeSpecialBridgeReference(DexClassAndMethod method) {
        return ((DexMethod)method.getReference()).withName(this.dexItemFactory.createString(INVOKE_SPECIAL_BRIDGE_PREFIX + method.getName().toString()), this.dexItemFactory);
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (instruction.isInvokeSpecial()) {
            return this.needsDesugaring(instruction.asInvoke(), context) != null;
        }
        return false;
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (instruction.isInvokeSpecial()) {
            return this.desugarInvokeInstruction(instruction.asInvoke(), eventConsumer, context);
        }
        return null;
    }
}

