/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaring;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.itf.ClassProcessor;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessingDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessor;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

public class InterfaceMethodProcessorFacade
implements CfPostProcessingDesugaring {
    private final AppView<?> appView;
    private final InterfaceMethodRewriter.Flavor flavour;
    private final InterfaceProcessor interfaceProcessor;
    private final ClassProcessor classProcessor;

    InterfaceMethodProcessorFacade(AppView<?> appView, InterfaceMethodRewriter.Flavor flavour, Predicate<ProgramMethod> isLiveMethod, InterfaceProcessor interfaceProcessor) {
        this.appView = appView;
        this.flavour = flavour;
        this.interfaceProcessor = interfaceProcessor;
        this.classProcessor = new ClassProcessor(appView, isLiveMethod);
    }

    private boolean shouldProcess(DexProgramClass clazz, InterfaceMethodRewriter.Flavor flavour) {
        if (this.appView.isAlreadyLibraryDesugared(clazz)) {
            return false;
        }
        return !clazz.originatesFromDexResource() || flavour == InterfaceMethodRewriter.Flavor.IncludeAllResources;
    }

    private void processClassesConcurrently(Collection<DexProgramClass> programClasses, InterfaceProcessingDesugaringEventConsumer eventConsumer, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(Iterables.filter(programClasses, clazz -> this.shouldProcess((DexProgramClass)clazz, this.flavour)), clazz -> this.classProcessor.process((DexProgramClass)clazz, eventConsumer), executorService);
        this.classProcessor.finalizeProcessing(eventConsumer);
        this.interfaceProcessor.finalizeProcessing();
    }

    @Override
    public void postProcessingDesugaring(Collection<DexProgramClass> programClasses, CfPostProcessingDesugaringEventConsumer eventConsumer, ExecutorService executorService) throws ExecutionException {
        this.processClassesConcurrently(programClasses, eventConsumer, executorService);
    }
}

