/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeSuper;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InvalidCode;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.itf.InterfaceDesugaringSyntheticHelper;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodDesugaringBaseEventConsumer;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodRewriterFixup;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.collections.BidirectionalManyToManyRepresentativeMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToOneMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class InterfaceProcessor {
    private final AppView<?> appView;
    private final InterfaceDesugaringSyntheticHelper helper;
    private final Map<DexProgramClass, PostProcessingInterfaceInfo> postProcessingInterfaceInfos = new ConcurrentHashMap<DexProgramClass, PostProcessingInterfaceInfo>();

    public InterfaceProcessor(AppView<?> appView) {
        this.appView = appView;
        this.helper = new InterfaceDesugaringSyntheticHelper(appView);
    }

    static ProgramMethod ensureCompanionMethod(DexProgramClass iface, DexString methodName, DexProto methodProto, AppView<?> appView, Consumer<SyntheticMethodBuilder> methodBuilderCallback, Consumer<ProgramMethod> newMethodCallback) {
        return appView.getSyntheticItems().ensureFixedClassMethod(methodName, methodProto, kinds -> kinds.COMPANION_CLASS, iface, appView, builder -> {
            SyntheticProgramClassBuilder cfr_ignored_0 = (SyntheticProgramClassBuilder)((SyntheticProgramClassBuilder)builder.setSourceFile(iface.sourceFile)).setGenericSignature(iface.getClassSignature().toObjectBoundWithSameFormals(new GenericSignature.ClassTypeSignature(appView.dexItemFactory().objectType)));
        }, methodBuilderCallback, newMethodCallback);
    }

    private void processVirtualInterfaceMethod(ProgramMethod method) {
        if (this.helper.isCompatibleDefaultMethod((DexEncodedMethod)method.getDefinition())) {
            ProgramMethod companion = this.helper.ensureDefaultAsMethodOfProgramCompanionClassStub(method);
            this.finalizeMoveToCompanionMethod(method, companion);
        }
    }

    private void processDirectInterfaceMethod(ProgramMethod method, InterfaceMethodDesugaringBaseEventConsumer eventConsumer) {
        if (!((DexEncodedMethod)method.getDefinition()).isClassInitializer()) {
            this.getPostProcessingInterfaceInfo(method.getHolder()).setHasNonClinitDirectMethods();
            ProgramMethod companion = this.helper.ensureMethodOfProgramCompanionClassStub(method, eventConsumer);
            this.finalizeMoveToCompanionMethod(method, companion);
        }
    }

    private void clearDirectMethods(DexProgramClass iface) {
        DexEncodedMethod clinit = iface.getClassInitializer();
        MethodCollection methodCollection = iface.getMethodCollection();
        if (clinit != null) {
            methodCollection.setSingleDirectMethod(clinit);
        } else {
            methodCollection.clearDirectMethods();
        }
    }

    private static boolean canMoveToCompanionClass(ProgramMethod method) {
        Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
        assert (code != null);
        if (code.isDexCode()) {
            for (Instruction insn : code.asDexCode().instructions) {
                if (!(insn instanceof InvokeSuper)) continue;
                return false;
            }
        } else {
            assert (code.isCfCode());
            for (CfInstruction insn : code.asCfCode().getInstructions()) {
                if (!(insn instanceof CfInvoke) || !((CfInvoke)insn).isInvokeSuper(method.getHolderType())) continue;
                return false;
            }
        }
        return true;
    }

    private DexClass definitionForDependency(DexType dependency, DexClass dependent) {
        return dependent.isProgramClass() ? ((AppInfo)this.appView.appInfo()).definitionForDesugarDependency(dependent.asProgramClass(), dependency) : this.appView.definitionFor(dependency);
    }

    private boolean interfaceMethodRemovalChangesApi(ProgramMethod method) {
        assert (!this.appView.enableWholeProgramOptimizations());
        DexProgramClass iface = method.getHolder();
        if (method.getAccessFlags().isBridge()) {
            if (this.appView.options().cfToCfDesugar) {
                return false;
            }
            ArrayDeque<Pair<DexClass, DexType>> worklist = new ArrayDeque<Pair<DexClass, DexType>>();
            HashSet<DexType> seenBefore = new HashSet<DexType>();
            InterfaceProcessor.addSuperTypes(iface, worklist);
            while (!worklist.isEmpty()) {
                Pair item = (Pair)worklist.pop();
                DexClass clazz = this.definitionForDependency((DexType)item.getSecond(), (DexClass)item.getFirst());
                if (clazz == null || !seenBefore.add(clazz.type)) continue;
                if (clazz.lookupVirtualMethod((DexMethod)method.getReference()) != null) {
                    return false;
                }
                InterfaceProcessor.addSuperTypes(clazz, worklist);
            }
        }
        return true;
    }

    private static void addSuperTypes(DexClass clazz, Deque<Pair<DexClass, DexType>> worklist) {
        if (clazz.superType != null) {
            worklist.add(new Pair<DexClass, DexType>(clazz, clazz.superType));
        }
        for (DexType iface : clazz.interfaces.values) {
            worklist.add(new Pair<DexClass, DexType>(clazz, iface));
        }
    }

    private InterfaceProcessorNestedGraphLens postProcessInterfaces() {
        InterfaceProcessorNestedGraphLens.Builder graphLensBuilder = InterfaceProcessorNestedGraphLens.builder();
        this.postProcessingInterfaceInfos.forEach((iface, info) -> {
            if (info.hasNonClinitDirectMethods() || this.appView.enableWholeProgramOptimizations()) {
                this.clearDirectMethods((DexProgramClass)iface);
            }
            if (info.hasDefaultMethodsToImplementationMap()) {
                info.getDefaultMethodsToImplementation().forEach((defaultMethod, companionMethod) -> {
                    assert (InvalidCode.isInvalidCode(defaultMethod.getCode()));
                    assert (!InvalidCode.isInvalidCode(companionMethod.getCode()));
                    defaultMethod.accessFlags.setAbstract();
                    defaultMethod.unsetCode();
                    graphLensBuilder.recordCodeMovedToCompanionClass((DexMethod)defaultMethod.getReference(), (DexMethod)companionMethod.getReference());
                });
            }
            if (info.hasMethodsToMove()) {
                info.getMethodsToMove().forEach(graphLensBuilder::move);
            }
            if (info.hasBridgesToRemove()) {
                assert (!this.appView.enableWholeProgramOptimizations());
                this.removeBridges((DexProgramClass)iface);
            }
        });
        return graphLensBuilder.build((AppView)this.appView);
    }

    private void removeBridges(DexProgramClass iface) {
        assert (!this.appView.enableWholeProgramOptimizations());
        ArrayList<DexEncodedMethod> newVirtualMethods = new ArrayList<DexEncodedMethod>();
        for (ProgramMethod method : iface.virtualProgramMethods()) {
            if (!this.interfaceMethodRemovalChangesApi(method)) continue;
            newVirtualMethods.add((DexEncodedMethod)method.getDefinition());
        }
        if (newVirtualMethods.size() < iface.getMethodCollection().numberOfVirtualMethods()) {
            iface.setVirtualMethods(newVirtualMethods.toArray(DexEncodedMethod.EMPTY_ARRAY));
        } else assert (false) : "Interface " + iface + " was analysed as having bridges to remove, but no bridges were found.";
    }

    private PostProcessingInterfaceInfo getPostProcessingInterfaceInfo(DexProgramClass iface) {
        return this.postProcessingInterfaceInfos.computeIfAbsent(iface, ignored -> new PostProcessingInterfaceInfo());
    }

    public InterfaceDesugaringSyntheticHelper getHelper() {
        return this.helper;
    }

    public void processMethod(ProgramMethod method, InterfaceMethodDesugaringBaseEventConsumer eventConsumer) {
        assert (!this.appView.enableWholeProgramOptimizations());
        if (!method.getHolder().isInterface()) {
            return;
        }
        if (((DexEncodedMethod)method.getDefinition()).belongsToDirectPool()) {
            this.processDirectInterfaceMethod(method, eventConsumer);
        } else {
            assert (((DexEncodedMethod)method.getDefinition()).belongsToVirtualPool());
            this.processVirtualInterfaceMethod(method);
            if (!this.interfaceMethodRemovalChangesApi(method)) {
                this.getPostProcessingInterfaceInfo(method.getHolder()).setHasBridgesToRemove();
            }
        }
    }

    public void finalizeMoveToCompanionMethod(ProgramMethod method, ProgramMethod companion) {
        assert (InvalidCode.isInvalidCode(((DexEncodedMethod)companion.getDefinition()).getCode()));
        if (((DexEncodedMethod)method.getDefinition()).getCode() == null) {
            throw new CompilationError("Code is missing for private instance interface method: " + ((DexMethod)method.getReference()).toSourceString(), method.getOrigin());
        }
        if (!InterfaceProcessor.canMoveToCompanionClass(method)) {
            throw new CompilationError("One or more instruction is preventing default interface method from being desugared: " + method.toSourceString(), method.getOrigin());
        }
        DexProgramClass iface = method.getHolder();
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        assert (!definition.isInitializer());
        assert (!definition.isStatic() || definition.isPrivate() || definition.isPublic()) : "Static interface method " + method.toSourceString() + " is expected to either be public or private in " + method.getOrigin();
        if (definition.isStatic() || definition.isPrivate()) {
            this.getPostProcessingInterfaceInfo(iface).setHasNonClinitDirectMethods();
            this.getPostProcessingInterfaceInfo(iface).moveMethod((DexMethod)method.getReference(), (DexMethod)companion.getReference());
        } else {
            assert (this.helper.isCompatibleDefaultMethod(definition));
            this.getPostProcessingInterfaceInfo(iface).mapDefaultMethodToCompanionMethod((DexEncodedMethod)method.getDefinition(), (DexEncodedMethod)companion.getDefinition());
        }
        if (definition.hasClassFileVersion()) {
            ((DexEncodedMethod)companion.getDefinition()).downgradeClassFileVersion(definition.getClassFileVersion());
        }
        Code code = definition.getCode().getCodeAsInlining((DexMethod)companion.getReference(), (DexMethod)method.getReference(), this.appView.dexItemFactory());
        if (!definition.isStatic()) {
            DexEncodedMethod.setDebugInfoWithFakeThisParameter(code, ((DexMethod)companion.getReference()).getArity(), this.appView);
        }
        companion.setCode(code, this.appView);
        method.setCode(InvalidCode.getInstance(), this.appView);
    }

    public void finalizeProcessing() {
        InterfaceProcessorNestedGraphLens graphLens = this.postProcessInterfaces();
        if (graphLens != null) {
            new InterfaceMethodRewriterFixup(this.appView, graphLens).run();
        }
    }

    public void forEachMethodToMove(BiConsumer<DexMethod, DexMethod> fn) {
        this.postProcessingInterfaceInfos.forEach((iface, info) -> {
            if (((PostProcessingInterfaceInfo)info).methodsToMove != null) {
                ((PostProcessingInterfaceInfo)info).methodsToMove.forEach(fn);
            }
        });
    }

    public static class InterfaceProcessorNestedGraphLens
    extends NestedGraphLens {
        private final BidirectionalManyToManyRepresentativeMap<DexMethod, DexMethod> extraNewMethodSignatures;

        public InterfaceProcessorNestedGraphLens(AppView<?> appView, BidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap, BidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> methodMap, Map<DexType, DexType> typeMap, BidirectionalOneToOneMap<DexMethod, DexMethod> extraNewMethodSignatures) {
            super(appView, fieldMap, methodMap, typeMap);
            this.extraNewMethodSignatures = extraNewMethodSignatures;
        }

        public static Builder builder() {
            return new Builder();
        }

        public BidirectionalManyToManyRepresentativeMap<DexMethod, DexMethod> getExtraNewMethodSignatures() {
            return this.extraNewMethodSignatures;
        }

        @Override
        public boolean isLegitimateToHaveEmptyMappings() {
            return true;
        }

        @Override
        public DexMethod getPreviousMethodSignature(DexMethod method) {
            return this.extraNewMethodSignatures.getRepresentativeKeyOrDefault(method, this.newMethodSignatures.getRepresentativeKeyOrDefault(method, method));
        }

        @Override
        public DexMethod getNextMethodSignature(DexMethod method) {
            return this.newMethodSignatures.getRepresentativeValueOrDefault(method, this.extraNewMethodSignatures.getRepresentativeValueOrDefault(method, method));
        }

        public static class Builder
        extends GraphLens.Builder {
            private final MutableBidirectionalOneToOneMap<DexMethod, DexMethod> extraNewMethodSignatures = new BidirectionalOneToOneHashMap<DexMethod, DexMethod>();

            public void recordCodeMovedToCompanionClass(DexMethod from, DexMethod to) {
                this.extraNewMethodSignatures.put(from, to);
            }

            @Override
            public InterfaceProcessorNestedGraphLens build(AppView<?> appView) {
                if (this.fieldMap.isEmpty() && this.methodMap.isEmpty() && this.extraNewMethodSignatures.isEmpty()) {
                    return null;
                }
                return new InterfaceProcessorNestedGraphLens(appView, (BidirectionalManyToOneRepresentativeMap<DexField, DexField>)this.fieldMap, this.methodMap, (Map<DexType, DexType>)this.typeMap, this.extraNewMethodSignatures);
            }
        }
    }

    static class PostProcessingInterfaceInfo {
        private Map<DexEncodedMethod, DexEncodedMethod> defaultMethodsToImplementation;
        private Map<DexMethod, DexMethod> methodsToMove;
        private boolean hasNonClinitDirectMethods;
        private boolean hasBridgesToRemove;

        PostProcessingInterfaceInfo() {
        }

        public void mapDefaultMethodToCompanionMethod(DexEncodedMethod defaultMethod, DexEncodedMethod companionMethod) {
            if (this.defaultMethodsToImplementation == null) {
                this.defaultMethodsToImplementation = new IdentityHashMap<DexEncodedMethod, DexEncodedMethod>();
            }
            this.defaultMethodsToImplementation.put(defaultMethod, companionMethod);
        }

        public Map<DexEncodedMethod, DexEncodedMethod> getDefaultMethodsToImplementation() {
            return this.defaultMethodsToImplementation;
        }

        boolean hasDefaultMethodsToImplementationMap() {
            return this.defaultMethodsToImplementation != null;
        }

        public void moveMethod(DexMethod ifaceMethod, DexMethod companionMethod) {
            if (this.methodsToMove == null) {
                this.methodsToMove = new IdentityHashMap<DexMethod, DexMethod>();
            }
            this.methodsToMove.put(ifaceMethod, companionMethod);
        }

        public Map<DexMethod, DexMethod> getMethodsToMove() {
            return this.methodsToMove;
        }

        public boolean hasMethodsToMove() {
            return this.methodsToMove != null;
        }

        boolean hasNonClinitDirectMethods() {
            return this.hasNonClinitDirectMethods;
        }

        void setHasNonClinitDirectMethods() {
            this.hasNonClinitDirectMethods = true;
        }

        boolean hasBridgesToRemove() {
            return this.hasBridgesToRemove;
        }

        void setHasBridgesToRemove() {
            this.hasBridgesToRemove = true;
        }
    }
}

