/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaring;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.DerivedMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedInterfaceDescriptor;
import com.android.tools.r8.ir.desugar.itf.EmulatedInterfaceSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.itf.InterfaceDesugaringSyntheticHelper;
import com.android.tools.r8.ir.synthetic.EmulateDispatchSyntheticCfCodeProvider;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.LinkedHashMap;

public final class ProgramEmulatedInterfaceSynthesizer
implements CfClassSynthesizerDesugaring {
    private final AppView<?> appView;
    private final InterfaceDesugaringSyntheticHelper helper;

    public static ProgramEmulatedInterfaceSynthesizer create(AppView<?> appView) {
        if (!appView.options().isDesugaredLibraryCompilation() || !appView.options().machineDesugaredLibrarySpecification.hasEmulatedInterfaces()) {
            return null;
        }
        return new ProgramEmulatedInterfaceSynthesizer(appView);
    }

    public ProgramEmulatedInterfaceSynthesizer(AppView<?> appView) {
        this.appView = appView;
        this.helper = new InterfaceDesugaringSyntheticHelper(appView);
    }

    private void synthesizeEmulateInterfaceMethods(DexProgramClass emulatedInterface, EmulatedInterfaceDescriptor emulatedInterfaceDescriptor, SyntheticProgramClassBuilder builder) {
        emulatedInterface.forEachProgramVirtualMethodMatching(m3 -> emulatedInterfaceDescriptor.getEmulatedMethods().containsKey(m3.getReference()), method -> {
            SyntheticProgramClassBuilder cfr_ignored_0 = (SyntheticProgramClassBuilder)builder.addMethod(methodBuilder -> this.synthesizeEmulatedInterfaceMethod((ProgramMethod)method, emulatedInterfaceDescriptor.getEmulatedMethods().get(method.getReference()), builder.getType(), (SyntheticMethodBuilder)methodBuilder));
        });
    }

    private void synthesizeEmulatedInterfaceMethod(ProgramMethod method, EmulatedDispatchMethodDescriptor descriptor, DexType dispatchType, SyntheticMethodBuilder methodBuilder) {
        assert (!((DexEncodedMethod)method.getDefinition()).isStatic());
        DexMethod emulatedMethod = this.helper.emulatedInterfaceDispatchMethod(descriptor.getEmulatedDispatchMethod(), dispatchType);
        DexMethod itfMethod = this.helper.emulatedInterfaceInterfaceMethod(descriptor.getInterfaceMethod());
        DexMethod companionMethod = this.helper.ensureEmulatedInterfaceForwardingMethod(descriptor.getForwardingMethod());
        LinkedHashMap<DexType, DexMethod> extraDispatchCases = this.resolveDispatchCases(descriptor);
        methodBuilder.setName(emulatedMethod.getName()).setProto(emulatedMethod.getProto()).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(emulatedInterfaceMethod -> new EmulateDispatchSyntheticCfCodeProvider(emulatedMethod.getHolderType(), companionMethod, itfMethod, extraDispatchCases, this.appView).generateCfCode());
    }

    private LinkedHashMap<DexType, DexMethod> resolveDispatchCases(EmulatedDispatchMethodDescriptor descriptor) {
        LinkedHashMap<DexType, DexMethod> extraDispatchCases = new LinkedHashMap<DexType, DexMethod>();
        descriptor.getDispatchCases().forEach((type, derivedMethod) -> extraDispatchCases.put((DexType)type, this.helper.ensureEmulatedInterfaceForwardingMethod((DerivedMethod)derivedMethod)));
        return extraDispatchCases;
    }

    private void warnMissingEmulatedInterface(DexType interfaceType) {
        StringDiagnostic warning = new StringDiagnostic("Cannot emulate interface " + interfaceType.getName() + " because the interface is missing.");
        this.appView.options().reporter.warning(warning);
    }

    DexProgramClass synthesizeProgramEmulatedInterface(DexProgramClass emulatedInterface, EmulatedInterfaceDescriptor emulatedInterfaceDescriptor, EmulatedInterfaceSynthesizerEventConsumer.L8ProgramEmulatedInterfaceSynthesizerEventConsumer eventConsumer) {
        return this.appView.getSyntheticItems().ensureFixedClass(kinds -> kinds.EMULATED_INTERFACE_CLASS, emulatedInterface, this.appView, builder -> this.synthesizeEmulateInterfaceMethods(emulatedInterface, emulatedInterfaceDescriptor, (SyntheticProgramClassBuilder)builder), eventConsumer::acceptProgramEmulatedInterface);
    }

    @Override
    public String uniqueIdentifier() {
        return "$emulatedInterface$";
    }

    @Override
    public void synthesizeClasses(CompilationContext.ClassSynthesisDesugaringContext processingContext, CfClassSynthesizerDesugaringEventConsumer eventConsumer) {
        assert (this.appView.options().isDesugaredLibraryCompilation());
        this.appView.options().machineDesugaredLibrarySpecification.getEmulatedInterfaces().forEach((emulatedInterfaceType, emulatedInterfaceDescriptor) -> {
            DexClass emulatedInterfaceClazz = this.appView.definitionFor((DexType)emulatedInterfaceType);
            if (emulatedInterfaceClazz == null || !emulatedInterfaceClazz.isProgramClass()) {
                this.warnMissingEmulatedInterface((DexType)emulatedInterfaceType);
                return;
            }
            DexProgramClass emulatedInterface = emulatedInterfaceClazz.asProgramClass();
            assert (emulatedInterface != null);
            if (!this.appView.isAlreadyLibraryDesugared(emulatedInterface) && !emulatedInterfaceDescriptor.getEmulatedMethods().isEmpty()) {
                this.synthesizeProgramEmulatedInterface(emulatedInterface, (EmulatedInterfaceDescriptor)emulatedInterfaceDescriptor, eventConsumer);
            }
        });
    }
}

