/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.nest;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.nest.Nest;
import com.android.tools.r8.ir.desugar.nest.NestBasedAccessDesugaring;
import com.android.tools.r8.ir.desugar.nest.NestBasedAccessDesugaringEventConsumer;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class D8NestBasedAccessDesugaring
extends NestBasedAccessDesugaring {
    D8NestBasedAccessDesugaring(AppView<?> appView) {
        super(appView);
    }

    public void reportDesugarDependencies() {
        this.forEachNest(nest -> {
            if (nest.hasMissingMembers()) {
                throw this.appView.options().errorMissingNestMember((Nest)nest);
            }
            DexClass hostClass = nest.getHostClass();
            for (DexClass memberClass : nest.getMembers()) {
                if (!hostClass.isProgramClass() && !memberClass.isProgramClass()) continue;
                InterfaceMethodRewriter.reportDependencyEdge(hostClass, memberClass, this.appView.appInfo());
                InterfaceMethodRewriter.reportDependencyEdge(memberClass, hostClass, this.appView.appInfo());
            }
        }, classWithoutHost -> {
            throw this.appView.options().errorMissingNestHost((DexClass)classWithoutHost);
        });
    }

    public void clearNestAttributes() {
        this.forEachNest(nest -> {
            nest.getHostClass().clearNestMembers();
            nest.getMembers().forEach(DexClass::clearNestHost);
        }, classWithoutHost -> {});
    }

    public void synthesizeBridgesForNestBasedAccessesOnClasspath(final MethodProcessor methodProcessor, ExecutorService executorService) throws ExecutionException {
        ArrayList classpathClassesInNests = new ArrayList();
        this.forEachNest(nest -> {
            if (nest.getHostClass().isClasspathClass()) {
                classpathClassesInNests.add(nest.getHostClass().asClasspathClass());
            }
            Iterables.addAll(classpathClassesInNests, nest.getClasspathMembers());
        });
        NestBasedAccessDesugaringEventConsumer eventConsumer = new NestBasedAccessDesugaringEventConsumer(){

            @Override
            public void acceptNestFieldGetBridge(ProgramField target, ProgramMethod bridge) {
                methodProcessor.scheduleDesugaredMethodForProcessing(bridge);
            }

            @Override
            public void acceptNestFieldPutBridge(ProgramField target, ProgramMethod bridge) {
                methodProcessor.scheduleDesugaredMethodForProcessing(bridge);
            }

            @Override
            public void acceptNestMethodBridge(ProgramMethod target, ProgramMethod bridge) {
                methodProcessor.scheduleDesugaredMethodForProcessing(bridge);
            }
        };
        ThreadUtils.processItems(classpathClassesInNests, clazz -> this.synthesizeBridgesForNestBasedAccessesOnClasspath((DexClasspathClass)clazz, eventConsumer), executorService);
    }

    public void synthesizeBridgesForNestBasedAccessesOnClasspath(DexClasspathClass clazz, NestBasedAccessDesugaringEventConsumer eventConsumer) {
        clazz.forEachClasspathMethod(method -> method.registerCodeReferencesForDesugaring(new NestBasedAccessDesugaringUseRegistry((ClasspathMethod)method, eventConsumer)));
    }

    private class NestBasedAccessDesugaringUseRegistry
    extends UseRegistry<ClasspathMethod> {
        private final NestBasedAccessDesugaringEventConsumer eventConsumer;

        NestBasedAccessDesugaringUseRegistry(ClasspathMethod context, NestBasedAccessDesugaringEventConsumer eventConsumer) {
            super(D8NestBasedAccessDesugaring.this.appView, context);
            this.eventConsumer = eventConsumer;
        }

        private void registerFieldAccess(DexField reference, boolean isGet) {
            DexClassAndField field = reference.lookupMemberOnClass(D8NestBasedAccessDesugaring.this.appView.definitionForHolder(reference));
            if (field != null && D8NestBasedAccessDesugaring.this.needsDesugaring(field, (DexClassAndMethod)this.getContext())) {
                D8NestBasedAccessDesugaring.this.ensureFieldAccessBridge(field, isGet, this.eventConsumer);
            }
        }

        private void registerInvoke(DexMethod reference) {
            if (!reference.getHolderType().isClassType()) {
                return;
            }
            DexClassAndMethod method = reference.lookupMemberOnClass(D8NestBasedAccessDesugaring.this.appView.definitionForHolder(reference));
            if (method != null && D8NestBasedAccessDesugaring.this.needsDesugaring(method, (DexClassAndMethod)this.getContext())) {
                D8NestBasedAccessDesugaring.this.ensureMethodBridge(method, this.eventConsumer);
            }
        }

        @Override
        public void registerInvokeDirect(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInvokeInterface(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInvokeStatic(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInvokeSuper(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInvokeVirtual(DexMethod method) {
            this.registerInvoke(method);
        }

        @Override
        public void registerInstanceFieldWrite(DexField field) {
            this.registerFieldAccess(field, false);
        }

        @Override
        public void registerInstanceFieldRead(DexField field) {
            this.registerFieldAccess(field, true);
        }

        @Override
        public void registerStaticFieldRead(DexField field) {
            this.registerFieldAccess(field, true);
        }

        @Override
        public void registerStaticFieldWrite(DexField field) {
            this.registerFieldAccess(field, false);
        }

        @Override
        public void registerInitClass(DexType clazz) {
        }

        @Override
        public void registerInstanceOf(DexType type) {
        }

        @Override
        public void registerNewInstance(DexType type) {
        }

        @Override
        public void registerTypeReference(DexType type) {
        }
    }
}

