/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.nest;

import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.LibraryMember;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.ProgramAdditions;
import com.android.tools.r8.ir.desugar.nest.AccessBridgeFactory;
import com.android.tools.r8.ir.desugar.nest.D8NestBasedAccessDesugaring;
import com.android.tools.r8.ir.desugar.nest.Nest;
import com.android.tools.r8.ir.desugar.nest.NestBasedAccessDesugaringEventConsumer;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.ConsumerUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class NestBasedAccessDesugaring
implements CfInstructionDesugaring {
    public static final String NEST_ACCESS_NAME_PREFIX = "-$$Nest$";
    private static final String NEST_ACCESS_METHOD_NAME_PREFIX = "-$$Nest$m";
    private static final String NEST_ACCESS_STATIC_METHOD_NAME_PREFIX = "-$$Nest$sm";
    private static final String NEST_ACCESS_FIELD_GET_NAME_PREFIX = "-$$Nest$fget";
    private static final String NEST_ACCESS_STATIC_GET_FIELD_NAME_PREFIX = "-$$Nest$sfget";
    private static final String NEST_ACCESS_FIELD_PUT_NAME_PREFIX = "-$$Nest$fput";
    private static final String NEST_ACCESS_STATIC_PUT_FIELD_NAME_PREFIX = "-$$Nest$sfput";
    protected final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final Map<DexType, DexType> syntheticNestConstructorTypes = new ConcurrentHashMap<DexType, DexType>();

    NestBasedAccessDesugaring(AppView<?> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    public static NestBasedAccessDesugaring create(AppView<?> appView) {
        if (appView.options().shouldDesugarNests()) {
            return appView.enableWholeProgramOptimizations() ? new NestBasedAccessDesugaring(appView) : new D8NestBasedAccessDesugaring(appView);
        }
        return null;
    }

    private void prepareDesugarFieldInstruction(DexField field, boolean isGet, ProgramMethod context, ProgramAdditions programAdditions) {
        BridgeAndTarget<DexClassAndField> bridgeAndTarget = this.bridgeAndTargetForDesugaring(field, isGet, context);
        if (bridgeAndTarget == null || !bridgeAndTarget.shouldAddBridge()) {
            return;
        }
        programAdditions.accept(bridgeAndTarget.getBridge(), () -> AccessBridgeFactory.createFieldAccessorBridge(bridgeAndTarget.getBridge(), ((DexClassAndField)bridgeAndTarget.getTarget()).asProgramField(), isGet));
    }

    private void prepareDesugarMethodInstruction(DexMethod method, ProgramMethod context, ProgramAdditions programAdditions) {
        BridgeAndTarget<DexClassAndMethod> bridgeAndTarget = this.bridgeAndTargetForDesugaring(method, context);
        if (bridgeAndTarget == null || !bridgeAndTarget.shouldAddBridge()) {
            return;
        }
        programAdditions.accept(bridgeAndTarget.getBridge(), () -> ((DexEncodedMethod)((DexClassAndMethod)bridgeAndTarget.getTarget()).getDefinition()).isInstanceInitializer() ? AccessBridgeFactory.createInitializerAccessorBridge(bridgeAndTarget.getBridge(), ((DexClassAndMethod)bridgeAndTarget.getTarget()).asProgramMethod(), this.dexItemFactory) : AccessBridgeFactory.createMethodAccessorBridge(bridgeAndTarget.getBridge(), ((DexClassAndMethod)bridgeAndTarget.getTarget()).asProgramMethod(), this.dexItemFactory));
    }

    private BridgeAndTarget<DexClassAndMethod> bridgeAndTargetForDesugaring(DexMethod method, ProgramMethod context) {
        if (!method.getHolderType().isClassType()) {
            return null;
        }
        DexClass holder = this.appView.definitionForHolder(method, context);
        DexClassAndMethod target = method.lookupMemberOnClass(holder);
        if (target == null || !this.needsDesugaring(target, (DexClassAndMethod)context)) {
            return null;
        }
        return new BridgeAndTarget<DexClassAndMethod>(this.getMethodBridgeReference(target), target);
    }

    private BridgeAndTarget<DexClassAndField> bridgeAndTargetForDesugaring(DexField field, boolean isGet, ProgramMethod context) {
        DexClass holder = this.appView.definitionForHolder(field, context);
        DexClassAndField target = field.lookupMemberOnClass(holder);
        if (target == null || !this.needsDesugaring(target, (DexClassAndMethod)context)) {
            return null;
        }
        return new BridgeAndTarget<DexClassAndField>(this.getFieldAccessBridgeReference(target, isGet), target);
    }

    private List<CfInstruction> desugarFieldInstruction(CfFieldInstruction instruction, ProgramMethod context, NestBasedAccessDesugaringEventConsumer eventConsumer) {
        BridgeAndTarget<DexClassAndField> bridgeAndTarget = this.bridgeAndTargetForDesugaring(instruction.getField(), instruction.isFieldGet(), context);
        if (bridgeAndTarget == null) {
            return null;
        }
        assert (!bridgeAndTarget.getTarget().isProgramField() || bridgeAndTarget.getTarget().getHolder().lookupDirectMethod(bridgeAndTarget.getBridge()) != null);
        return ImmutableList.of(new CfInvoke(184, bridgeAndTarget.getBridge(), bridgeAndTarget.getTarget().getHolder().isInterface()));
    }

    private List<CfInstruction> desugarInvokeInstruction(CfInvoke invoke, LocalStackAllocator localStackAllocator, ProgramMethod context, NestBasedAccessDesugaringEventConsumer eventConsumer) {
        DexMethod invokedMethod = invoke.getMethod();
        BridgeAndTarget<DexClassAndMethod> bridgeAndTarget = this.bridgeAndTargetForDesugaring(invokedMethod, context);
        if (bridgeAndTarget == null) {
            return null;
        }
        assert (!bridgeAndTarget.getTarget().isProgramMethod() || bridgeAndTarget.getTarget().getHolder().lookupDirectMethod(bridgeAndTarget.getBridge()) != null);
        if (((DexEncodedMethod)bridgeAndTarget.getTarget().getDefinition()).isInstanceInitializer()) {
            assert (!invoke.isInterface());
            localStackAllocator.allocateLocalStack(1);
            return ImmutableList.of(new CfConstNull(), new CfInvoke(183, bridgeAndTarget.getBridge(), false));
        }
        return ImmutableList.of(new CfInvoke(184, bridgeAndTarget.getBridge(), invoke.isInterface()));
    }

    private RuntimeException reportIncompleteNest(LibraryMember<?, ?> member) {
        Nest nest = Nest.create(this.appView, member.getHolder());
        assert (nest != null) : "Should be a compilation error if missing nest host on library class.";
        throw this.appView.options().errorMissingNestMember(nest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexMethod ensureFieldAccessBridge(ProgramField field, boolean isGet, NestBasedAccessDesugaringEventConsumer eventConsumer) {
        DexMethod bridgeReference = this.getFieldAccessBridgeReference(field, isGet);
        MethodCollection methodCollection = field.getHolder().getMethodCollection();
        synchronized (methodCollection) {
            ProgramMethod bridge = field.getHolder().lookupProgramMethod(bridgeReference);
            if (bridge == null) {
                bridge = AccessBridgeFactory.createFieldAccessorBridge(bridgeReference, field, isGet);
                bridge.getHolder().addDirectMethod((DexEncodedMethod)bridge.getDefinition());
                if (eventConsumer != null) {
                    if (isGet) {
                        eventConsumer.acceptNestFieldGetBridge(field, bridge);
                    } else {
                        eventConsumer.acceptNestFieldPutBridge(field, bridge);
                    }
                }
            }
            return (DexMethod)bridge.getReference();
        }
    }

    private DexMethod getFieldAccessBridgeReference(DexClassAndField field, boolean isGet) {
        int bridgeParameterCount = BooleanUtils.intValue(!field.getAccessFlags().isStatic()) + BooleanUtils.intValue(!isGet);
        DexType[] parameters = new DexType[bridgeParameterCount];
        if (!isGet) {
            parameters[parameters.length - 1] = field.getType();
        }
        if (!field.getAccessFlags().isStatic()) {
            parameters[0] = field.getHolderType();
        }
        DexType returnType = isGet ? field.getType() : this.dexItemFactory.voidType;
        DexProto proto = this.dexItemFactory.createProto(returnType, parameters);
        return this.dexItemFactory.createMethod(field.getHolderType(), proto, this.getFieldAccessBridgeName(field, isGet));
    }

    private DexString getFieldAccessBridgeName(DexClassAndField field, boolean isGet) {
        String prefix = isGet && !field.getAccessFlags().isStatic() ? NEST_ACCESS_FIELD_GET_NAME_PREFIX : (isGet ? NEST_ACCESS_STATIC_GET_FIELD_NAME_PREFIX : (!field.getAccessFlags().isStatic() ? NEST_ACCESS_FIELD_PUT_NAME_PREFIX : NEST_ACCESS_STATIC_PUT_FIELD_NAME_PREFIX));
        return this.dexItemFactory.createString(prefix + field.getName().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexMethod ensureMethodBridge(ProgramMethod method, NestBasedAccessDesugaringEventConsumer eventConsumer) {
        DexMethod bridgeReference = this.getMethodBridgeReference(method);
        MethodCollection methodCollection = method.getHolder().getMethodCollection();
        synchronized (methodCollection) {
            ProgramMethod bridge = method.getHolder().lookupProgramMethod(bridgeReference);
            if (bridge == null) {
                DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
                bridge = definition.isInstanceInitializer() ? AccessBridgeFactory.createInitializerAccessorBridge(bridgeReference, method, this.dexItemFactory) : AccessBridgeFactory.createMethodAccessorBridge(bridgeReference, method, this.dexItemFactory);
                bridge.getHolder().addDirectMethod((DexEncodedMethod)bridge.getDefinition());
                if (eventConsumer != null) {
                    eventConsumer.acceptNestMethodBridge(method, bridge);
                }
            }
        }
        return bridgeReference;
    }

    private DexMethod getMethodBridgeReference(DexClassAndMethod method) {
        if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
            DexType nestConstructorType = this.syntheticNestConstructorTypes.computeIfAbsent(method.getHolderType(), holder -> {
                if (method.isProgramMethod()) {
                    return this.appView.getSyntheticItems().createFixedClass(kinds -> kinds.INIT_TYPE_ARGUMENT, method.asProgramMethod().getHolder(), this.appView, builder -> {}).getType();
                }
                assert (method.isClasspathMethod());
                return this.appView.getSyntheticItems().ensureFixedClasspathClass(kinds -> kinds.INIT_TYPE_ARGUMENT, method.asClasspathMethod().getHolder(), this.appView, ignored -> {}, ignored -> {}).getType();
            });
            DexProto newProto = this.dexItemFactory.appendTypeToProto(method.getProto(), nestConstructorType);
            return ((DexMethod)method.getReference()).withProto(newProto, this.dexItemFactory);
        }
        DexProto proto = method.getAccessFlags().isStatic() ? method.getProto() : this.dexItemFactory.prependHolderToProto((DexMethod)method.getReference());
        return this.dexItemFactory.createMethod(method.getHolderType(), proto, this.getMethodBridgeName(method));
    }

    private DexString getMethodBridgeName(DexClassAndMethod method) {
        String prefix = method.getAccessFlags().isStatic() ? NEST_ACCESS_STATIC_METHOD_NAME_PREFIX : NEST_ACCESS_METHOD_NAME_PREFIX;
        return this.dexItemFactory.createString(prefix + method.getName().toString());
    }

    void forEachNest(Consumer<Nest> consumer) {
        this.forEachNest(consumer, ConsumerUtils.emptyConsumer());
    }

    void forEachNest(Consumer<Nest> consumer, Consumer<DexClass> missingHostConsumer) {
        Set<DexType> seenNestHosts = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
            Nest nest;
            if (!clazz.isInANest() || !seenNestHosts.add(clazz.getNestHost()) || (nest = Nest.create(this.appView, clazz, missingHostConsumer)) == null) continue;
            consumer.accept(nest);
        }
    }

    @Override
    public void prepare(ProgramMethod method, ProgramAdditions programAdditions) {
        ((DexEncodedMethod)method.getDefinition()).getCode().asCfCode().getInstructions().forEach(instruction -> {
            DexMethod invokedMethod;
            if (instruction.isFieldInstruction()) {
                DexField field = instruction.asFieldInstruction().getField();
                if (this.needsDesugaring(field, method)) {
                    this.prepareDesugarFieldInstruction(field, instruction.asFieldInstruction().isFieldGet(), method, programAdditions);
                }
            } else if (instruction.isInvoke() && this.needsDesugaring(invokedMethod = instruction.asInvoke().getMethod(), method)) {
                this.prepareDesugarMethodInstruction(invokedMethod, method, programAdditions);
            }
        });
    }

    public boolean needsDesugaring(ProgramMethod method) {
        if (!method.getHolder().isInANest() || !((DexEncodedMethod)method.getDefinition()).hasCode()) {
            return false;
        }
        Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
        if (code.isDexCode()) {
            return false;
        }
        if (!code.isCfCode()) {
            throw new Unreachable("Unexpected attempt to determine if non-CF code needs desugaring");
        }
        return Iterables.any(code.asCfCode().getInstructions(), instruction -> this.needsDesugaring((CfInstruction)instruction, method));
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (instruction.isFieldInstruction()) {
            return this.needsDesugaring(instruction.asFieldInstruction().getField(), context);
        }
        if (instruction.isInvoke()) {
            return this.needsDesugaring(instruction.asInvoke().getMethod(), context);
        }
        return false;
    }

    public boolean needsDesugaring(DexMember<?, ?> memberReference, ProgramMethod context) {
        if (!context.getHolder().isInANest() || !memberReference.getHolderType().isClassType()) {
            return false;
        }
        DexClass holder = this.appView.definitionForHolder(memberReference, context);
        DexClassAndMember<?, ?> member = memberReference.lookupMemberOnClass(holder);
        return member != null && this.needsDesugaring(member, (DexClassAndMethod)context);
    }

    public boolean needsDesugaring(DexClassAndMember<?, ?> member, DexClassAndMethod context) {
        return member.getAccessFlags().isPrivate() && member.getHolderType() != context.getHolderType() && member.getHolder().isInANest() && member.getHolder().getNestHost() == context.getHolder().getNestHost();
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (instruction.isFieldInstruction()) {
            return this.desugarFieldInstruction(instruction.asFieldInstruction(), context, eventConsumer);
        }
        if (instruction.isInvoke()) {
            return this.desugarInvokeInstruction(instruction.asInvoke(), localStackAllocator, context, eventConsumer);
        }
        return null;
    }

    DexMethod ensureFieldAccessBridge(DexClassAndField field, boolean isGet, NestBasedAccessDesugaringEventConsumer eventConsumer) {
        if (field.isProgramField()) {
            return this.ensureFieldAccessBridge(field.asProgramField(), isGet, eventConsumer);
        }
        if (field.isClasspathField()) {
            return this.getFieldAccessBridgeReference(field, isGet);
        }
        assert (field.isLibraryField());
        throw this.reportIncompleteNest(field.asLibraryField());
    }

    DexMethod ensureMethodBridge(DexClassAndMethod method, NestBasedAccessDesugaringEventConsumer eventConsumer) {
        if (method.isProgramMethod()) {
            return this.ensureMethodBridge(method.asProgramMethod(), eventConsumer);
        }
        if (method.isClasspathMethod()) {
            return this.getMethodBridgeReference(method);
        }
        assert (method.isLibraryMethod());
        throw this.reportIncompleteNest(method.asLibraryMethod());
    }

    private static class BridgeAndTarget<T extends DexClassAndMember<?, ?>> {
        private final DexMethod bridge;
        private final T target;

        public BridgeAndTarget(DexMethod bridge, T target) {
            this.bridge = bridge;
            this.target = target;
            assert (bridge.holder == ((DexClassAndMember)target).getHolderType());
        }

        public DexMethod getBridge() {
            return this.bridge;
        }

        public T getTarget() {
            return this.target;
        }

        public boolean shouldAddBridge() {
            return this.target.isProgramMember() && ((DexClassAndMember)this.target).getHolder().lookupDirectMethod(this.bridge) == null;
        }
    }
}

