/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.records;

import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.records.RecordRewriterHelper;
import com.android.tools.r8.naming.NamingLens;
import java.util.ArrayList;

public class RecordCfToCfRewriter {
    private final AppView<?> appView;

    public static RecordCfToCfRewriter create(AppView<?> appView) {
        if (appView.enableWholeProgramOptimizations() && appView.options().isGeneratingClassFiles() && appView.options().testing.enableRecordModeling) {
            return new RecordCfToCfRewriter(appView);
        }
        return null;
    }

    private RecordCfToCfRewriter(AppView<?> appView) {
        this.appView = appView;
    }

    private DexField[] computePresentFields(GraphLens graphLens, RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic) {
        ArrayList<DexField> finalFields = new ArrayList<DexField>();
        for (DexField field : recordInvokeDynamic.getFields()) {
            DexEncodedField dexEncodedField = recordInvokeDynamic.getRecordClass().lookupInstanceField(graphLens.getRenamedFieldSignature(field));
            if (dexEncodedField == null) continue;
            finalFields.add(field);
        }
        DexField[] newFields = new DexField[finalFields.size()];
        for (int i = 0; i < finalFields.size(); ++i) {
            newFields[i] = (DexField)finalFields.get(i);
        }
        return newFields;
    }

    private CfInvokeDynamic writeRecordInvokeDynamic(RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic) {
        DexItemFactory factory = this.appView.dexItemFactory();
        DexMethodHandle bootstrapMethod = new DexMethodHandle(DexMethodHandle.MethodHandleType.INVOKE_STATIC, factory.objectMethodsMembers.bootstrap, false, null);
        ArrayList<DexValue> bootstrapArgs = new ArrayList<DexValue>();
        bootstrapArgs.add(new DexValue.DexValueType(recordInvokeDynamic.getRecordType()));
        bootstrapArgs.add(new DexValue.DexValueString(recordInvokeDynamic.getFieldNames()));
        for (DexField field : recordInvokeDynamic.getFields()) {
            bootstrapArgs.add(new DexValue.DexValueMethodHandle(new DexMethodHandle(DexMethodHandle.MethodHandleType.INSTANCE_GET, field, false, null)));
        }
        return new CfInvokeDynamic(factory.createCallSite(recordInvokeDynamic.getMethodName(), recordInvokeDynamic.getMethodProto(), bootstrapMethod, bootstrapArgs));
    }

    public CfInvokeDynamic rewriteRecordInvokeDynamic(CfInvokeDynamic invokeDynamic, ProgramMethod context, NamingLens namingLens) {
        if (!RecordRewriterHelper.isInvokeDynamicOnRecord(invokeDynamic, this.appView, context)) {
            return invokeDynamic;
        }
        RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic = RecordRewriterHelper.parseInvokeDynamicOnRecord(invokeDynamic, this.appView, context);
        DexString newFieldNames = recordInvokeDynamic.computeRecordFieldNamesComputationInfo().internalComputeNameFor(recordInvokeDynamic.getRecordType(), this.appView, this.appView.graphLens(), namingLens);
        DexField[] newFields = this.computePresentFields(this.appView.graphLens(), recordInvokeDynamic);
        return this.writeRecordInvokeDynamic(recordInvokeDynamic.withFieldNamesAndFields(newFieldNames, newFields));
    }
}

