/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.records;

import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.naming.dexitembasedstring.RecordFieldNamesComputationInfo;

public class RecordRewriterHelper {
    public static boolean isInvokeDynamicOnRecord(CfInvokeDynamic invokeDynamic, AppView<?> appView, ProgramMethod context) {
        return RecordRewriterHelper.isInvokeDynamicOnRecord(invokeDynamic.getCallSite(), appView, context);
    }

    public static boolean isInvokeDynamicOnRecord(DexCallSite callSite, AppView<?> appView, ProgramMethod context) {
        DexItemFactory factory = appView.dexItemFactory();
        DexMethodHandle bootstrapMethod = callSite.bootstrapMethod;
        if (!bootstrapMethod.type.isInvokeStatic()) {
            return false;
        }
        if (bootstrapMethod.member != factory.objectMethodsMembers.bootstrap) {
            return false;
        }
        if (bootstrapMethod.isInterface) {
            assert (false) : "Invoke-dynamic invoking non interface method ObjectMethods#bootstrap as an interface method.";
            return false;
        }
        if (callSite.bootstrapArgs.size() < 2) {
            assert (false) : "Invoke-dynamic invoking method ObjectMethods#bootstrap with less than 2 parameters.";
            return false;
        }
        DexValue.DexValueType recordType = callSite.bootstrapArgs.get(0).asDexValueType();
        if (recordType == null) {
            assert (false) : "Invoke-dynamic invoking method ObjectMethods#bootstrap with an invalid type.";
            return false;
        }
        DexClass recordClass = appView.definitionFor((DexType)recordType.getValue(), context);
        if (recordClass == null || recordClass.isNotProgramClass()) {
            return false;
        }
        DexValue.DexValueString valueString = callSite.bootstrapArgs.get(1).asDexValueString();
        if (valueString == null) {
            assert (false) : "Invoke-dynamic invoking method ObjectMethods#bootstrap with invalid field names.";
            return false;
        }
        DexString fieldNames = (DexString)valueString.getValue();
        assert (fieldNames.toString().isEmpty() || fieldNames.toString().split(";").length == callSite.bootstrapArgs.size() - 2);
        assert (recordClass.instanceFields().size() <= callSite.bootstrapArgs.size() - 2);
        for (int i = 2; i < callSite.bootstrapArgs.size(); ++i) {
            DexValue.DexValueMethodHandle handle = callSite.bootstrapArgs.get(i).asDexValueMethodHandle();
            if (handle != null && ((DexMethodHandle)handle.value).type.isInstanceGet() && ((DexMethodHandle)handle.value).member.isDexField()) continue;
            assert (false) : "Invoke-dynamic invoking method ObjectMethods#bootstrap with invalid getters.";
            return false;
        }
        if (callSite.methodName == factory.toStringMethodName) {
            assert (callSite.methodProto == factory.createProto(factory.stringType, recordClass.getType()));
            return true;
        }
        if (callSite.methodName == factory.hashCodeMethodName) {
            assert (callSite.methodProto == factory.createProto(factory.intType, recordClass.getType()));
            return true;
        }
        if (callSite.methodName == factory.equalsMethodName) {
            assert (callSite.methodProto == factory.createProto(factory.booleanType, recordClass.getType(), factory.objectType));
            return true;
        }
        return false;
    }

    public static RecordInvokeDynamic parseInvokeDynamicOnRecord(CfInvokeDynamic invokeDynamic, AppView<?> appView, ProgramMethod context) {
        assert (RecordRewriterHelper.isInvokeDynamicOnRecord(invokeDynamic, appView, context));
        DexCallSite callSite = invokeDynamic.getCallSite();
        DexValue.DexValueType recordValueType = callSite.bootstrapArgs.get(0).asDexValueType();
        DexValue.DexValueString valueString = callSite.bootstrapArgs.get(1).asDexValueString();
        DexString fieldNames = (DexString)valueString.getValue();
        DexField[] fields = new DexField[callSite.bootstrapArgs.size() - 2];
        for (int i = 2; i < callSite.bootstrapArgs.size(); ++i) {
            DexValue.DexValueMethodHandle handle = callSite.bootstrapArgs.get(i).asDexValueMethodHandle();
            fields[i - 2] = ((DexMethodHandle)handle.value).member.asDexField();
        }
        DexProgramClass recordClass = appView.definitionFor((DexType)recordValueType.getValue()).asProgramClass();
        return new RecordInvokeDynamic(callSite.methodName, callSite.methodProto, fieldNames, fields, recordClass);
    }

    static class RecordInvokeDynamic {
        private final DexString methodName;
        private final DexProto methodProto;
        private final DexString fieldNames;
        private final DexField[] fields;
        private final DexProgramClass recordClass;

        private RecordInvokeDynamic(DexString methodName, DexProto methodProto, DexString fieldNames, DexField[] fields, DexProgramClass recordClass) {
            this.methodName = methodName;
            this.methodProto = methodProto;
            this.fieldNames = fieldNames;
            this.fields = fields;
            this.recordClass = recordClass;
        }

        RecordInvokeDynamic withFieldNamesAndFields(DexString fieldNames, DexField[] fields) {
            return new RecordInvokeDynamic(this.methodName, this.methodProto, fieldNames, fields, this.recordClass);
        }

        DexField[] getFields() {
            return this.fields;
        }

        DexType getRecordType() {
            return this.recordClass.getType();
        }

        DexProgramClass getRecordClass() {
            return this.recordClass;
        }

        DexString getFieldNames() {
            return this.fieldNames;
        }

        DexString getMethodName() {
            return this.methodName;
        }

        DexProto getMethodProto() {
            return this.methodProto;
        }

        RecordFieldNamesComputationInfo computeRecordFieldNamesComputationInfo() {
            return RecordFieldNamesComputationInfo.forFieldNamesAndFields(this.getFieldNames(), this.getFields());
        }
    }
}

