/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.twr;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.backports.BackportedMethods;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class TwrInstructionDesugaring
implements CfInstructionDesugaring {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final DexProto twrCloseResourceProto;
    private final DexMethod addSuppressed;
    private final DexMethod getSuppressed;

    public TwrInstructionDesugaring(AppView<?> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.twrCloseResourceProto = this.dexItemFactory.createProto(this.dexItemFactory.voidType, this.dexItemFactory.throwableType, this.dexItemFactory.objectType);
        this.addSuppressed = this.dexItemFactory.throwableMethods.addSuppressed;
        this.getSuppressed = this.dexItemFactory.throwableMethods.getSuppressed;
    }

    private Collection<CfInstruction> rewriteTwrAddSuppressedInvoke(CfInstructionDesugaringEventConsumer eventConsumer, CompilationContext.MethodProcessingContext methodProcessingContext) {
        DexItemFactory factory = this.appView.dexItemFactory();
        DexProto proto = factory.createProto(factory.voidType, factory.throwableType, factory.throwableType);
        return this.createAndCallSyntheticMethod(kinds -> kinds.BACKPORT, proto, BackportedMethods::ThrowableMethods_addSuppressed, methodProcessingContext, eventConsumer::acceptBackportedMethod, methodProcessingContext.getMethodContext());
    }

    private Collection<CfInstruction> rewriteTwrGetSuppressedInvoke(CfInstructionDesugaringEventConsumer eventConsumer, CompilationContext.MethodProcessingContext methodProcessingContext) {
        DexItemFactory factory = this.appView.dexItemFactory();
        DexProto proto = factory.createProto(factory.createArrayType(1, factory.throwableType), factory.throwableType);
        return this.createAndCallSyntheticMethod(kinds -> kinds.BACKPORT, proto, BackportedMethods::ThrowableMethods_getSuppressed, methodProcessingContext, eventConsumer::acceptBackportedMethod, methodProcessingContext.getMethodContext());
    }

    private ImmutableList<CfInstruction> rewriteTwrCloseResourceInvoke(CfInstructionDesugaringEventConsumer eventConsumer, CompilationContext.MethodProcessingContext methodProcessingContext) {
        return this.createAndCallSyntheticMethod(kinds -> kinds.TWR_CLOSE_RESOURCE, this.twrCloseResourceProto, BackportedMethods::CloseResourceMethod_closeResourceImpl, methodProcessingContext, eventConsumer::acceptTwrCloseResourceMethod, methodProcessingContext.getMethodContext());
    }

    private ImmutableList<CfInstruction> createAndCallSyntheticMethod(SyntheticItems.SyntheticKindSelector kindSelector, DexProto proto, BiFunction<InternalOptions, DexMethod, CfCode> generator, CompilationContext.MethodProcessingContext methodProcessingContext, BiConsumer<ProgramMethod, ProgramMethod> eventConsumerCallback, ProgramMethod context) {
        ProgramMethod method = this.appView.getSyntheticItems().createMethod(kindSelector, methodProcessingContext.createUniqueContext(), this.appView, builder -> builder.disableAndroidApiLevelCheck().setProto(proto).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(methodSig -> (CfCode)generator.apply(this.appView.options(), methodSig)));
        eventConsumerCallback.accept(method, context);
        return ImmutableList.of(new CfInvoke(184, (DexMethod)method.getReference(), false));
    }

    private boolean isTwrSuppressedInvoke(CfInstruction instruction, DexMethod suppressed) {
        return instruction.isInvoke() && this.matchesMethodOfThrowable(instruction.asInvoke().getMethod(), suppressed);
    }

    private boolean matchesMethodOfThrowable(DexMethod invoked, DexMethod expected) {
        return invoked.name == expected.name && invoked.proto == expected.proto && this.isSubtypeOfThrowable(invoked.holder);
    }

    private boolean isSubtypeOfThrowable(DexType type) {
        while (type != null && type != this.dexItemFactory.objectType) {
            if (type == this.dexItemFactory.throwableType) {
                return true;
            }
            DexClass dexClass = this.appView.definitionFor(type);
            if (dexClass == null) {
                throw new CompilationError("Class or interface " + type.toSourceString() + " required for desugaring of try-with-resources is not found.");
            }
            type = dexClass.superType;
        }
        return false;
    }

    private boolean isTwrCloseResourceInvoke(CfInstruction instruction) {
        return instruction.isInvokeStatic() && this.isTwrCloseResourceMethod(instruction.asInvoke().getMethod());
    }

    private boolean isTwrCloseResourceMethod(DexMethod method) {
        return method.name == this.dexItemFactory.twrCloseResourceMethodName && method.proto == this.dexItemFactory.twrCloseResourceMethodProto;
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (!instruction.isInvoke()) {
            return null;
        }
        if (this.isTwrCloseResourceInvoke(instruction)) {
            return this.rewriteTwrCloseResourceInvoke(eventConsumer, methodProcessingContext);
        }
        if (!this.appView.options().canUseSuppressedExceptions()) {
            if (this.isTwrSuppressedInvoke(instruction, this.addSuppressed)) {
                return this.rewriteTwrAddSuppressedInvoke(eventConsumer, methodProcessingContext);
            }
            if (this.isTwrSuppressedInvoke(instruction, this.getSuppressed)) {
                return this.rewriteTwrGetSuppressedInvoke(eventConsumer, methodProcessingContext);
            }
        }
        return null;
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (!instruction.isInvoke()) {
            return false;
        }
        return this.isTwrCloseResourceInvoke(instruction) || this.isTwrSuppressedInvoke(instruction, this.addSuppressed) || this.isTwrSuppressedInvoke(instruction, this.getSuppressed);
    }
}

