/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.AssertionsConfiguration;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LazyBox;
import com.android.tools.r8.utils.ThrowingCharIterator;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.WorkList;
import java.io.UTFDataFormatException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class AssertionsRewriter {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final ConfigurationEntryWithDexString defaultConfiguration;
    private final List<ConfigurationEntryWithDexString> configuration;
    private final ConfigurationEntryWithDexString kotlinTransformation;
    private final boolean enabled;

    public AssertionsRewriter(AppView<?> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.enabled = AssertionsRewriter.isEnabled(appView.options());
        if (!this.enabled) {
            this.defaultConfiguration = null;
            this.configuration = null;
            this.kotlinTransformation = null;
            return;
        }
        this.defaultConfiguration = new ConfigurationEntryWithDexString(appView.options().assertionsConfiguration.defaultConfiguration, this.dexItemFactory);
        this.configuration = appView.options().assertionsConfiguration.assertionsConfigurations.stream().map(entry -> new ConfigurationEntryWithDexString((AssertionsConfiguration)entry, appView.dexItemFactory())).collect(Collectors.toList());
        this.kotlinTransformation = this.getTransformationForType(appView.dexItemFactory().kotlin.assertions.type);
    }

    public static boolean isEnabled(InternalOptions options) {
        AssertionConfigurationWithDefault configuration = options.assertionsConfiguration;
        return configuration != null && !configuration.isPassthroughAll();
    }

    private ConfigurationEntryWithDexString getTransformationForMethod(DexEncodedMethod method) {
        return this.getTransformationForType(method.getHolderType());
    }

    private ConfigurationEntryWithDexString getTransformationForType(DexType type) {
        ConfigurationEntryWithDexString result = this.defaultConfiguration;
        block5: for (ConfigurationEntryWithDexString entry : this.configuration) {
            switch (entry.entry.getScope()) {
                case ALL: {
                    result = entry;
                    continue block5;
                }
                case PACKAGE: {
                    if (((ConfigurationEntryWithDexString)entry).value.size == 0) {
                        if (type.descriptor.contains(this.dexItemFactory.descriptorSeparator)) continue block5;
                        result = entry;
                        continue block5;
                    }
                    if (!type.descriptor.startsWith(entry.value)) continue block5;
                    result = entry;
                    continue block5;
                }
                case CLASS: {
                    if (type.descriptor.equals(entry.value)) {
                        result = entry;
                    }
                    if (!this.isDescriptorForClassOrInnerClass(entry.value, type.descriptor)) continue block5;
                    result = entry;
                    continue block5;
                }
            }
            throw new Unreachable();
        }
        assert (result != null);
        return result;
    }

    private boolean isDescriptorForClassOrInnerClass(DexString classDescriptor, DexString classOrInnerClassDescriptor) {
        if (classOrInnerClassDescriptor == classDescriptor) {
            return true;
        }
        if (classOrInnerClassDescriptor.size < classDescriptor.size) {
            return false;
        }
        ThrowingCharIterator<UTFDataFormatException> i1 = classDescriptor.iterator();
        ThrowingCharIterator<UTFDataFormatException> i2 = classOrInnerClassDescriptor.iterator();
        try {
            while (i1.hasNext()) {
                char c1 = i1.nextChar();
                char c2 = i2.nextChar();
                if (c1 == ';' && c2 == '$') {
                    while (i2.hasNext()) {
                        if (i2.nextChar() != '/') continue;
                        return false;
                    }
                    return true;
                }
                if (c1 == c2) continue;
                return false;
            }
            assert (i2.hasNext());
            return false;
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    private void runInternal(DexEncodedMethod method, IRCode code) {
        DexEncodedMethod clinit;
        ConfigurationEntryWithDexString configuration = this.getTransformationForMethod(method);
        if (configuration.isPassthrough()) {
            return;
        }
        if (method.isClassInitializer()) {
            clinit = method;
        } else {
            DexClass clazz = this.appView.definitionFor(method.getHolderType());
            if (clazz == null) {
                return;
            }
            clinit = clazz.getClassInitializer();
        }
        IdentityHashMap assertionEntryIfs = new IdentityHashMap();
        IdentityHashMap throwSuccessorAfterHandler = new IdentityHashMap();
        if (configuration.isAssertionHandler()) {
            LazyBox<DominatorTree> dominatorTree = new LazyBox<DominatorTree>(() -> new DominatorTree(code));
            code.getBlocks().forEach(basicBlock -> {
                List<BasicBlock> blocks;
                boolean conditionForAssertionBlock;
                BasicBlock assertionBlockEntry;
                Throw throwInstruction;
                If theIf = this.isCheckAssertionsEnabledBlock((BasicBlock)basicBlock);
                if (theIf != null && (throwInstruction = this.isAlwaysThrowingEntry(assertionBlockEntry = theIf.targetFromBoolean(conditionForAssertionBlock = !this.isUsingJavaAssertionsDisabledField(theIf.lhs().getDefinition().asStaticGet())), blocks = ((DominatorTree)dominatorTree.computeIfAbsent()).dominatedBlocks(assertionBlockEntry))) != null) {
                    assertionEntryIfs.put(theIf, conditionForAssertionBlock);
                    throwSuccessorAfterHandler.put(throwInstruction, theIf.targetFromBoolean(!conditionForAssertionBlock));
                }
            });
        }
        assert (assertionEntryIfs.size() == throwSuccessorAfterHandler.size());
        boolean isInitializerEnablingJavaVmAssertions = clinit != null && clinit.getOptimizationInfo().isInitializerEnablingJavaVmAssertions();
        InstructionListIterator iterator2 = code.instructionListIterator();
        while (iterator2.hasNext()) {
            Throw throwInstruction;
            Instruction current = (Instruction)iterator2.next();
            if (current.isInvokeMethod()) {
                InvokeMethod invoke = current.asInvokeMethod();
                if (invoke.getInvokedMethod() == this.dexItemFactory.classMethods.desiredAssertionStatus) {
                    if (method.getHolderType() == this.dexItemFactory.kotlin.assertions.type) {
                        this.rewriteKotlinAssertionEnable(code, configuration, iterator2, invoke);
                    } else {
                        iterator2.replaceCurrentInstruction(code.createIntConstant(0, current.getLocalInfo()));
                    }
                }
            } else if (current.isStaticPut()) {
                StaticPut staticPut = current.asStaticPut();
                if (isInitializerEnablingJavaVmAssertions && this.isUsingJavaAssertionsDisabledField(staticPut)) {
                    iterator2.remove();
                }
            } else if (current.isStaticGet()) {
                StaticGet staticGet = current.asStaticGet();
                if (isInitializerEnablingJavaVmAssertions && this.isUsingJavaAssertionsDisabledField(staticGet) && !configuration.isAssertionHandler()) {
                    iterator2.replaceCurrentInstruction(code.createIntConstant(configuration.isCompileTimeDisabled() ? 1 : 0, current.getLocalInfo()));
                }
                if (staticGet.getField() == this.dexItemFactory.kotlin.assertions.enabledField && !configuration.isAssertionHandler()) {
                    iterator2.replaceCurrentInstruction(code.createIntConstant(this.kotlinTransformation.isCompileTimeDisabled() ? 0 : 1, current.getLocalInfo()));
                }
            }
            if (!configuration.isAssertionHandler()) continue;
            if (current.isIf()) {
                If ifInstruction = current.asIf();
                if (!assertionEntryIfs.containsKey(ifInstruction)) continue;
                ifInstruction.targetFromBoolean((Boolean)assertionEntryIfs.get(ifInstruction) == false).unlinkSinglePredecessorSiblingsAllowed();
                ifInstruction.lhs().removeUser(ifInstruction);
                iterator2.replaceCurrentInstruction(new Goto());
                continue;
            }
            if (!current.isThrow() || !throwSuccessorAfterHandler.containsKey(throwInstruction = current.asThrow())) continue;
            BasicBlock throwingBlock = throwInstruction.getBlock();
            iterator2.replaceCurrentInstruction(new InvokeStatic(this.dexItemFactory.createMethod(configuration.getAssertionHandler()), null, ImmutableList.of(throwInstruction.exception())));
            Goto gotoBlockAfterAssertion = new Goto(throwingBlock);
            gotoBlockAfterAssertion.setPosition(throwInstruction.getPosition());
            throwingBlock.link((BasicBlock)throwSuccessorAfterHandler.get(throwInstruction));
            iterator2.add(gotoBlockAfterAssertion);
        }
    }

    private void rewriteKotlinAssertionEnable(IRCode code, ConfigurationEntryWithDexString configuration, InstructionListIterator iterator2, InvokeMethod invoke) {
        if (iterator2.hasNext() && configuration.isCompileTimeDisabled()) {
            Instruction nextInstruction = (Instruction)iterator2.next();
            if (nextInstruction.isStaticPut() && nextInstruction.asStaticPut().getField().holder == this.dexItemFactory.kotlin.assertions.type && nextInstruction.asStaticPut().getField().name == this.dexItemFactory.enabledFieldName && invoke.outValue().numberOfUsers() == 1 && invoke.outValue().numberOfPhiUsers() == 0 && invoke.outValue().singleUniqueUser() == nextInstruction) {
                iterator2.removeOrReplaceByDebugLocalRead();
                Instruction prevInstruction = (Instruction)iterator2.previous();
                assert (prevInstruction == invoke);
                iterator2.removeOrReplaceByDebugLocalRead();
            } else {
                Instruction instruction = (Instruction)iterator2.previous();
                assert (instruction == nextInstruction);
                instruction = (Instruction)iterator2.previous();
                assert (instruction == invoke);
                instruction = (Instruction)iterator2.next();
                assert (instruction == invoke);
                iterator2.replaceCurrentInstruction(code.createIntConstant(0));
            }
        } else {
            iterator2.replaceCurrentInstruction(code.createIntConstant(configuration.isCompileTimeEnabled() ? 1 : 0));
        }
    }

    private boolean isUsingAssertionsControlField(FieldInstruction instruction) {
        return this.isUsingJavaAssertionsDisabledField(instruction) || this.isUsingKotlinAssertionsEnabledField(instruction);
    }

    private boolean isUsingJavaAssertionsDisabledField(FieldInstruction instruction) {
        return instruction.getField().getName() == this.dexItemFactory.assertionsDisabled && instruction.getField().getType() == this.dexItemFactory.booleanType;
    }

    private boolean isUsingKotlinAssertionsEnabledField(FieldInstruction instruction) {
        return instruction.getField() == this.dexItemFactory.kotlin.assertions.enabledField;
    }

    private If isCheckAssertionsEnabledBlock(BasicBlock basicBlock) {
        if (!basicBlock.exit().isIf()) {
            return null;
        }
        If theIf = basicBlock.exit().asIf();
        if (!theIf.isZeroTest() || !theIf.lhs().isDefinedByInstructionSatisfying(Instruction::isStaticGet)) {
            return null;
        }
        StaticGet staticGet = theIf.lhs().getDefinition().asStaticGet();
        return this.isUsingAssertionsControlField(staticGet) && staticGet.value().hasSingleUniqueUser() && !staticGet.value().hasPhiUsers() ? theIf : null;
    }

    private Throw isAlwaysThrowingEntry(BasicBlock block, List<BasicBlock> blocks) {
        WorkList<BasicBlock> workList = WorkList.newIdentityWorkList(block);
        Throw theThrow = null;
        while (workList.hasNext()) {
            BasicBlock current = workList.next();
            workList.addIfNotSeen(current.getNormalSuccessors());
            if (!blocks.containsAll(current.getNormalSuccessors())) {
                return null;
            }
            if (current.exit().isReturn()) {
                return null;
            }
            if (!current.exit().isThrow()) continue;
            if (theThrow != null) {
                return null;
            }
            theThrow = current.exit().asThrow();
        }
        return theThrow;
    }

    public void run(DexEncodedMethod method, IRCode code, Timing timing) {
        if (this.enabled) {
            timing.begin("Rewrite assertions");
            this.runInternal(method, code);
            assert (code.isConsistentSSA(this.appView));
            timing.end();
        }
    }

    private static class ConfigurationEntryWithDexString {
        private final AssertionsConfiguration entry;
        private final DexString value;

        private ConfigurationEntryWithDexString(AssertionsConfiguration configuration, DexItemFactory dexItemFactory) {
            this.entry = configuration;
            switch (configuration.getScope()) {
                case PACKAGE: {
                    if (configuration.getValue().length() == 0) {
                        this.value = dexItemFactory.createString("");
                        break;
                    }
                    this.value = dexItemFactory.createString("L" + configuration.getValue().replace('.', '/') + "/");
                    break;
                }
                case CLASS: {
                    this.value = dexItemFactory.createString("L" + configuration.getValue().replace('.', '/') + ";");
                    break;
                }
                case ALL: {
                    this.value = null;
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
        }

        public boolean isCompileTimeEnabled() {
            return this.entry.isCompileTimeEnabled();
        }

        public boolean isCompileTimeDisabled() {
            return this.entry.isCompileTimeDisabled();
        }

        public boolean isPassthrough() {
            return this.entry.isPassthrough();
        }

        public boolean isAssertionHandler() {
            return this.entry.isAssertionHandler();
        }

        public MethodReference getAssertionHandler() {
            assert (this.isAssertionHandler());
            return this.entry.getAssertionHandler();
        }
    }
}

