/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import java.util.Collection;
import java.util.Set;

public class AssumeRemover {
    private final AppView<?> appView;
    private final IRCode code;
    private final Set<Value> affectedValues;
    private final Set<Assume> assumeInstructionsToRemove = Sets.newIdentityHashSet();
    private boolean mayHaveIntroducedTrivialPhi = false;

    public AssumeRemover(AppView<?> appView, IRCode code) {
        this(appView, code, Sets.newIdentityHashSet());
    }

    public AssumeRemover(AppView<?> appView, IRCode code, Set<Value> affectedValues) {
        this.appView = appView;
        this.code = code;
        this.affectedValues = affectedValues;
    }

    private void markForRemoval(Assume assumeInstruction) {
        this.assumeInstructionsToRemove.add(assumeInstruction);
    }

    public Set<Value> getAffectedValues() {
        return this.affectedValues;
    }

    public boolean mayHaveIntroducedTrivialPhi() {
        return this.mayHaveIntroducedTrivialPhi;
    }

    public void markAssumeDynamicTypeUsersForRemoval(Value value) {
        for (Instruction user : value.aliasedUsers()) {
            if (!user.isAssume()) continue;
            Assume assumeInstruction = user.asAssume();
            assumeInstruction.unsetDynamicTypeAssumption();
            if (assumeInstruction.hasNonNullAssumption()) continue;
            this.markForRemoval(assumeInstruction);
        }
    }

    public void markUnusedAssumeValuesForRemoval(Collection<Value> values2) {
        for (Value value : values2) {
            if (!value.isDefinedByInstructionSatisfying(Instruction::isAssume) || value.hasAnyUsers()) continue;
            this.markForRemoval(value.getDefinition().asAssume());
        }
    }

    public void removeIfMarked(Assume assumeInstruction, InstructionListIterator instructionIterator) {
        if (this.assumeInstructionsToRemove.remove(assumeInstruction)) {
            Value inValue = assumeInstruction.src();
            Value outValue = assumeInstruction.outValue();
            if (!outValue.getType().equals(inValue.getType())) {
                this.affectedValues.addAll(outValue.affectedValues());
            }
            if (outValue.hasPhiUsers()) {
                this.mayHaveIntroducedTrivialPhi = true;
            }
            outValue.replaceUsers(inValue);
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    public AssumeRemover removeMarkedInstructions() {
        return this.removeMarkedInstructions(null);
    }

    public AssumeRemover removeMarkedInstructions(Set<BasicBlock> blocksToBeRemoved) {
        if (!this.assumeInstructionsToRemove.isEmpty()) {
            for (BasicBlock block : this.code.blocks) {
                if (blocksToBeRemoved != null && blocksToBeRemoved.contains(block)) continue;
                InstructionListIterator instructionIterator = block.listIterator(this.code);
                while (instructionIterator.hasNext()) {
                    Instruction instruction = (Instruction)instructionIterator.next();
                    if (!instruction.isAssume()) continue;
                    this.removeIfMarked(instruction.asAssume(), instructionIterator);
                }
            }
        }
        return this;
    }

    public void finish() {
        if (!this.affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(this.affectedValues);
        }
    }
}

