/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.it.unimi.dsi.fastutil.Hash;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConstantCanonicalizer {
    private static final int MAX_CANONICALIZED_CONSTANT = 22;
    private final CodeRewriter codeRewriter;
    private int numberOfConstNumberCanonicalization = 0;
    private int numberOfConstStringCanonicalization = 0;
    private int numberOfDexItemBasedConstStringCanonicalization = 0;
    private int numberOfConstClassCanonicalization = 0;
    private int numberOfEffectivelyFinalFieldCanonicalization = 0;
    private final Object2IntMap<Long> histogramOfCanonicalizationCandidatesPerMethod;

    public ConstantCanonicalizer(CodeRewriter codeRewriter) {
        this.codeRewriter = codeRewriter;
        this.histogramOfCanonicalizationCandidatesPerMethod = Log.ENABLED ? new Object2IntArrayMap<Long>() : null;
    }

    private static void insertCanonicalizedConstant(IRCode code, Instruction canonicalizedConstant) {
        BasicBlock entryBlock = code.entryBlock();
        InstructionListIterator it = entryBlock.listIterator(code);
        while (it.hasNext()) {
            if (((Instruction)it.next()).isArgument()) continue;
            it.previous();
            break;
        }
        it.add(canonicalizedConstant);
    }

    private static boolean constantUsedByInvokeRange(Instruction constant) {
        for (Instruction user : constant.outValue().uniqueUsers()) {
            if (!user.isInvoke() || user.asInvoke().requiredArgumentRegisters() <= 5) continue;
            return true;
        }
        return false;
    }

    public void logResults() {
        assert (Log.ENABLED);
        Log.info(this.getClass(), "# const-number canonicalization: %s", this.numberOfConstNumberCanonicalization);
        Log.info(this.getClass(), "# const-string canonicalization: %s", this.numberOfConstStringCanonicalization);
        Log.info(this.getClass(), "# item-based const-string canonicalization: %s", this.numberOfDexItemBasedConstStringCanonicalization);
        Log.info(this.getClass(), "# const-class canonicalization: %s", this.numberOfConstClassCanonicalization);
        Log.info(this.getClass(), "# effectively final field canonicalization: %s", this.numberOfEffectivelyFinalFieldCanonicalization);
        assert (this.histogramOfCanonicalizationCandidatesPerMethod != null);
        Log.info(this.getClass(), "------ histogram of constant canonicalization candidates ------", new Object[0]);
        this.histogramOfCanonicalizationCandidatesPerMethod.forEach((length, count) -> Log.info(this.getClass(), "%s: %s (%s)", length, StringUtils.times("*", Math.min(count, 53)), count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void canonicalize(AppView<?> appView, IRCode code) {
        Iterator iterator2;
        Object singleFieldValue;
        ProgramMethod context = code.context();
        Object2ObjectLinkedOpenCustomHashMap<Instruction, List> valuesDefinedByConstant = new Object2ObjectLinkedOpenCustomHashMap<Instruction, List>(new Hash.Strategy<Instruction>(){

            @Override
            public int hashCode(Instruction candidate) {
                assert (candidate.instructionTypeCanBeCanonicalized());
                switch (candidate.opcode()) {
                    case 12: {
                        return candidate.asConstClass().getValue().hashCode();
                    }
                    case 15: {
                        return Long.hashCode(candidate.asConstNumber().getRawValue()) + 13 * candidate.outType().hashCode();
                    }
                    case 16: {
                        return candidate.asConstString().getValue().hashCode();
                    }
                    case 20: {
                        return candidate.asDexItemBasedConstString().getItem().hashCode();
                    }
                    case 59: {
                        return candidate.asStaticGet().getField().hashCode();
                    }
                }
                throw new Unreachable();
            }

            @Override
            public boolean equals(Instruction a, Instruction b) {
                assert (a == null || !a.outValue().hasLocalInfo());
                assert (b == null || !b.outValue().hasLocalInfo());
                return a == b || a != null && b != null && a.identicalNonValueNonPositionParts(b);
            }
        });
        for (Instruction current : code.instructions()) {
            if (!current.instructionTypeCanBeCanonicalized() || current.isConstClass() && current.instructionMayHaveSideEffects(appView, context) || (current.isConstString() || current.isDexItemBasedConstString()) && code.metadata().mayHaveMonitorInstruction()) continue;
            if (current.isStaticGet()) {
                AbstractValue abstractValue = current.outValue().getAbstractValue(appView, context);
                if (!abstractValue.isSingleFieldValue()) continue;
                singleFieldValue = abstractValue.asSingleFieldValue();
                DexType fieldHolderType = ((SingleFieldValue)singleFieldValue).getField().getHolderType();
                if (((DexEncodedMethod)context.getDefinition()).isClassInitializer() && context.getHolderType() == fieldHolderType) continue;
                DexClass fieldHolder = appView.definitionFor(fieldHolderType);
                DexEncodedField field = ((SingleFieldValue)singleFieldValue).getField().lookupOnClass(fieldHolder);
                if (field == null || !field.isEnum() || current.instructionMayHaveSideEffects(appView, context)) continue;
            }
            if (current.outValue().hasLocalInfo() || ConstantCanonicalizer.constantUsedByInvokeRange(current)) continue;
            List oldValuesDefinedByConstant = valuesDefinedByConstant.computeIfAbsent(current, k -> new ArrayList());
            oldValuesDefinedByConstant.add(current.outValue());
        }
        if (valuesDefinedByConstant.isEmpty()) {
            return;
        }
        assert (!code.entryBlock().hasCatchHandlers());
        Position firstNonNonePosition = code.findFirstNonNonePosition(Position.syntheticNone());
        ObjectSortedSet entries = valuesDefinedByConstant.object2ObjectEntrySet();
        if (Log.ENABLED && Log.isLoggingEnabledFor(ConstantCanonicalizer.class)) {
            Long numOfCandidates = entries.stream().filter(a -> ((List)a.getValue()).size() > 1).count();
            singleFieldValue = this.histogramOfCanonicalizationCandidatesPerMethod;
            synchronized (singleFieldValue) {
                int count = this.histogramOfCanonicalizationCandidatesPerMethod.getOrDefault(numOfCandidates, 0);
                this.histogramOfCanonicalizationCandidatesPerMethod.put(numOfCandidates, count + 1);
            }
        }
        if (!(iterator2 = entries.stream().filter(a -> ((List)a.getValue()).size() > 1).sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).limit(22L).iterator()).hasNext()) {
            return;
        }
        boolean shouldSimplifyIfs = false;
        do {
            Instruction newConst;
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iterator2.next();
            Instruction canonicalizedConstant = (Instruction)entry.getKey();
            assert (canonicalizedConstant.instructionTypeCanBeCanonicalized());
            switch (canonicalizedConstant.opcode()) {
                case 12: {
                    if (Log.ENABLED) {
                        ++this.numberOfConstClassCanonicalization;
                    }
                    newConst = ConstClass.copyOf(code, canonicalizedConstant.asConstClass());
                    break;
                }
                case 15: {
                    if (Log.ENABLED) {
                        ++this.numberOfConstNumberCanonicalization;
                    }
                    newConst = ConstNumber.copyOf(code, canonicalizedConstant.asConstNumber());
                    break;
                }
                case 16: {
                    if (Log.ENABLED) {
                        ++this.numberOfConstStringCanonicalization;
                    }
                    newConst = ConstString.copyOf(code, canonicalizedConstant.asConstString());
                    break;
                }
                case 20: {
                    if (Log.ENABLED) {
                        ++this.numberOfDexItemBasedConstStringCanonicalization;
                    }
                    newConst = DexItemBasedConstString.copyOf(code, canonicalizedConstant.asDexItemBasedConstString());
                    break;
                }
                case 59: {
                    if (Log.ENABLED) {
                        ++this.numberOfEffectivelyFinalFieldCanonicalization;
                    }
                    newConst = StaticGet.copyOf(code, canonicalizedConstant.asStaticGet());
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
            newConst.setPosition(firstNonNonePosition);
            ConstantCanonicalizer.insertCanonicalizedConstant(code, newConst);
            for (Value outValue : (List)entry.getValue()) {
                outValue.replaceUsers(newConst.outValue());
            }
            shouldSimplifyIfs |= newConst.outValue().hasUserThatMatches(Instruction::isIf);
        } while (iterator2.hasNext());
        if (shouldSimplifyIfs |= code.removeAllDeadAndTrivialPhis()) {
            this.codeRewriter.simplifyIf(code);
        }
        assert (code.isConsistentSSA(appView));
    }
}

