/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.SafeCheckCast;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.AssumeRemover;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class Devirtualizer {
    private final AppView<AppInfoWithLiveness> appView;
    private final InternalOptions options;

    public Devirtualizer(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.options = appView.options();
    }

    private DexClass rebindSuperInvokeToMostSpecific(DexMethod target, ProgramMethod context) {
        DexClassAndMethod method = this.appView.appInfo().lookupSuperTarget(target, context);
        if (method == null) {
            return null;
        }
        if (method.getHolder().isInterface() && method.getHolderType() != context.getHolder().superType) {
            return null;
        }
        if (AccessControl.isMemberAccessible(method, method.getHolder(), context, this.appView).isPossiblyFalse()) {
            return null;
        }
        if (method.getHolder().isLibraryClass()) {
            DexClass lowerBound = this.appView.definitionFor(target.getHolderType(), context);
            while (lowerBound != null && lowerBound.isProgramClass() && lowerBound != method.getHolder()) {
                lowerBound = this.appView.definitionFor(lowerBound.superType, lowerBound.asProgramClass());
            }
            return lowerBound;
        }
        return method.getHolder();
    }

    private DexMethod rebindVirtualInvokeToMostSpecific(DexMethod target, Value receiver, ProgramMethod context) {
        if (!receiver.getType().isClassType()) {
            return target;
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnClass(target).asSingleResolution();
        if (resolutionResult == null || resolutionResult.isAccessibleForVirtualDispatchFrom(context, this.appView.appInfo()).isPossiblyFalse()) {
            return target;
        }
        DexType receiverType = receiver.getType().asClassType().getClassType();
        if (receiverType == target.holder) {
            return target;
        }
        MethodResolutionResult.SingleResolutionResult newResolutionResult = this.appView.appInfo().resolveMethodOnClass(target, receiverType).asSingleResolution();
        if (newResolutionResult == null || newResolutionResult.isAccessibleForVirtualDispatchFrom(context, this.appView.appInfo()).isPossiblyFalse() || !newResolutionResult.getResolvedMethod().getAccessFlags().isAtLeastAsVisibleAs(resolutionResult.getResolvedMethod().getAccessFlags()) || !newResolutionResult.getResolvedMethod().isPrivateMethod() && !MethodResolutionResult.SingleResolutionResult.isOverriding(resolutionResult.getResolvedMethod(), newResolutionResult.getResolvedMethod())) {
            return target;
        }
        DexClass newTargetHolder = newResolutionResult.getResolvedHolder();
        if (!newTargetHolder.isProgramClass() || newTargetHolder.isInterface()) {
            return target;
        }
        return (DexMethod)newResolutionResult.getResolvedMethod().getReference();
    }

    private boolean isRebindingNewClassIntoMainDex(ProgramMethod context, DexMethod reboundMethod) {
        return !this.appView.appInfo().getMainDexInfo().canRebindReference(context, reboundMethod, this.appView.getSyntheticItems());
    }

    public void devirtualizeInvokeInterface(IRCode code) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        AssumeRemover assumeRemover = new AssumeRemover(this.appView, code);
        ProgramMethod context = code.context();
        IdentityHashMap<InvokeMethodWithReceiver, InvokeVirtual> devirtualizedCall = new IdentityHashMap<InvokeMethodWithReceiver, InvokeVirtual>();
        DominatorTree dominatorTree = new DominatorTree(code);
        IdentityHashMap castedReceiverCache = new IdentityHashMap();
        Set<SafeCheckCast> newCheckCastInstructions = Sets.newIdentityHashSet();
        BasicBlockIterator blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = (BasicBlock)blocks.next();
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                TypeElement castTypeLattice;
                Value receiver;
                TypeElement receiverTypeLattice;
                DexClass holderClass;
                DexClassAndMethod target;
                DexMethod invokedMethod;
                InvokeMethodWithReceiver invoke;
                Instruction current = (Instruction)it.next();
                if (current.isAssumeWithNonNullAssumption()) {
                    SafeCheckCast definition;
                    Assume nonNull = current.asAssume();
                    Instruction origin = nonNull.origin();
                    if (!origin.isInvokeInterface() || origin.asInvokeInterface().getReceiver().hasLocalInfo() || !devirtualizedCall.containsKey(origin.asInvokeInterface()) || origin.asInvokeInterface().getReceiver() != nonNull.getAliasForOutValue()) continue;
                    InvokeVirtual devirtualizedInvoke = (InvokeVirtual)devirtualizedCall.get(origin.asInvokeInterface());
                    CheckCast newCheckCast = null;
                    Value newReceiver = devirtualizedInvoke.getReceiver();
                    if (!newReceiver.isPhi() && newReceiver.definition.isSafeCheckCast() && newCheckCastInstructions.contains(definition = newReceiver.definition.asSafeCheckCast())) {
                        newCheckCast = definition;
                    }
                    if (newCheckCast == null) continue;
                    Value oldReceiver = newCheckCast.object();
                    TypeElement oldReceiverType = oldReceiver.getType();
                    TypeElement newReceiverType = newReceiver.getType();
                    if (!newReceiverType.lessThanOrEqual(oldReceiverType, this.appView) || !dominatorTree.dominatedBy(block, devirtualizedInvoke.getBlock())) continue;
                    assert (nonNull.src() == oldReceiver);
                    assert (!oldReceiver.hasLocalInfo());
                    oldReceiver.replaceSelectiveUsers(newReceiver, ImmutableSet.of(nonNull), ImmutableMap.of());
                    continue;
                }
                if (current.isInvokeSuper()) {
                    DexMethod reboundMethod;
                    DexClass reboundTargetClass;
                    DexClassAndMethod singleTarget;
                    invoke = current.asInvokeSuper();
                    if (this.options.testing.enableInvokeSuperToInvokeVirtualRewriting && (singleTarget = invoke.lookupSingleTarget(this.appView, context)) != null) {
                        DexMethod invokedMethod2 = invoke.getInvokedMethod();
                        DexClassAndMethod newSingleTarget = InvokeVirtual.lookupSingleTarget(this.appView, context, invoke.getReceiver().getDynamicType(this.appView), invokedMethod2);
                        if (newSingleTarget != null && newSingleTarget.getReference() == singleTarget.getReference()) {
                            it.replaceCurrentInstruction(new InvokeVirtual(invokedMethod2, invoke.outValue(), invoke.arguments()));
                            continue;
                        }
                    }
                    if ((reboundTargetClass = this.rebindSuperInvokeToMostSpecific(invokedMethod = invoke.getInvokedMethod(), context)) == null || (reboundMethod = invokedMethod.withHolder(reboundTargetClass, this.appView.dexItemFactory())) == invokedMethod || this.isRebindingNewClassIntoMainDex(context, reboundMethod)) continue;
                    it.replaceCurrentInstruction(new InvokeSuper(reboundMethod, invoke.outValue(), invoke.arguments(), reboundTargetClass.isInterface()));
                    continue;
                }
                if (current.isInvokeVirtual()) {
                    invoke = current.asInvokeVirtual();
                    invokedMethod = invoke.getInvokedMethod();
                    DexMethod reboundTarget = this.rebindVirtualInvokeToMostSpecific(invokedMethod, invoke.getReceiver(), context);
                    if (reboundTarget == invokedMethod) continue;
                    it.replaceCurrentInstruction(new InvokeVirtual(reboundTarget, invoke.outValue(), invoke.arguments()));
                    continue;
                }
                if (!current.isInvokeInterface() || (target = (invoke = current.asInvokeInterface()).lookupSingleTarget(this.appView, context)) == null || (holderClass = target.getHolder()) == null || holderClass.isInterface() || AccessControl.isClassAccessible(holderClass, context, this.appView).isPossiblyFalse() || this.isRebindingNewClassIntoMainDex(context, (DexMethod)target.getReference())) continue;
                InvokeVirtual devirtualizedInvoke = new InvokeVirtual((DexMethod)target.getReference(), invoke.outValue(), invoke.inValues());
                it.replaceCurrentInstruction(devirtualizedInvoke);
                devirtualizedCall.put(invoke, devirtualizedInvoke);
                if (holderClass.getType() == invoke.getInvokedMethod().holder || (receiverTypeLattice = (receiver = invoke.getReceiver()).getType()).lessThanOrEqual(castTypeLattice = TypeElement.fromDexType(holderClass.getType(), receiverTypeLattice.nullability(), this.appView), this.appView)) continue;
                Value newReceiver = null;
                if (castedReceiverCache.containsKey(receiver) && ((Map)castedReceiverCache.get(receiver)).containsKey(holderClass.getType())) {
                    Value cachedReceiver = (Value)((Map)castedReceiverCache.get(receiver)).get(holderClass.getType());
                    BasicBlock cachedReceiverBlock = cachedReceiver.definition.getBlock();
                    BasicBlock dominatorBlock = null;
                    if (cachedReceiverBlock.hasCatchHandlers()) {
                        if (cachedReceiverBlock.hasUniqueNormalSuccessor()) {
                            dominatorBlock = cachedReceiverBlock.getUniqueNormalSuccessor();
                        } else assert (false);
                    } else {
                        dominatorBlock = cachedReceiverBlock;
                    }
                    if (dominatorBlock != null && dominatorTree.dominatedBy(block, dominatorBlock)) {
                        newReceiver = cachedReceiver;
                    }
                }
                if (newReceiver == null) {
                    BasicBlock blockWithDevirtualizedInvoke;
                    newReceiver = code.createValue(castTypeLattice);
                    if (!receiver.hasLocalInfo()) {
                        castedReceiverCache.putIfAbsent(receiver, new IdentityHashMap());
                        ((Map)castedReceiverCache.get(receiver)).put(holderClass.getType(), newReceiver);
                    }
                    SafeCheckCast checkCast = new SafeCheckCast(newReceiver, receiver, holderClass.getType());
                    checkCast.setPosition(invoke.getPosition());
                    newCheckCastInstructions.add(checkCast);
                    assert (it.peekPrevious() == devirtualizedInvoke);
                    it.previous();
                    BasicBlock basicBlock = blockWithDevirtualizedInvoke = block.hasCatchHandlers() ? it.splitCopyCatchHandlers(code, blocks, this.options) : block;
                    if (blockWithDevirtualizedInvoke != block) {
                        block.listIterator(code, block.getInstructions().size() - 1).add(checkCast);
                        dominatorTree = new DominatorTree(code);
                        it = blockWithDevirtualizedInvoke.listIterator(code);
                        assert (it.peekNext() == devirtualizedInvoke);
                        it.next();
                    } else {
                        it.add(checkCast);
                        assert (it.peekNext() == devirtualizedInvoke);
                        it.next();
                    }
                }
                affectedValues.addAll(receiver.affectedValues());
                assumeRemover.markAssumeDynamicTypeUsersForRemoval(receiver);
                if (!receiver.hasLocalInfo()) {
                    receiver.replaceSelectiveUsers(newReceiver, ImmutableSet.of(devirtualizedInvoke), ImmutableMap.of());
                    continue;
                }
                receiver.removeUser(devirtualizedInvoke);
                devirtualizedInvoke.replaceValue(receiver, newReceiver);
            }
        }
        assumeRemover.removeMarkedInstructions();
        affectedValues.addAll(assumeRemover.getAffectedValues());
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA(this.appView));
    }
}

