/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.it.unimi.dsi.fastutil.Hash;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IdempotentFunctionCallCanonicalizer {
    private static final int MAX_CANONICALIZED_CALL = 15;
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private int numberOfLibraryCallCanonicalization = 0;
    private int numberOfProgramCallCanonicalization = 0;
    private final Object2IntMap<Long> histogramOfCanonicalizationCandidatesPerMethod;

    public IdempotentFunctionCallCanonicalizer(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.histogramOfCanonicalizationCandidatesPerMethod = Log.ENABLED ? new Object2IntArrayMap<Long>() : null;
    }

    private boolean isIdempotentLibraryMethodInvoke(InvokeMethod invoke) {
        DexMethod invokedMethod = invoke.getInvokedMethod();
        return this.appView.getLibraryMethodSideEffectModelCollection().isCallToSideEffectFreeFinalMethod(invoke) && this.factory.libraryMethodsWithReturnValueDependingOnlyOnArguments.contains(invokedMethod);
    }

    private static void insertCanonicalizedInvokeWithInValues(IRCode code, Invoke canonicalizedInvoke) {
        BasicBlock entryBlock = code.entryBlock();
        int numberOfInValuePassed = 0;
        InstructionListIterator it = entryBlock.listIterator(code);
        while (it.hasNext()) {
            Instruction current = (Instruction)it.next();
            if (current.hasOutValue()) {
                for (Value inValue : canonicalizedInvoke.inValues()) {
                    if (inValue != current.outValue()) continue;
                    ++numberOfInValuePassed;
                }
            }
            if (numberOfInValuePassed != canonicalizedInvoke.inValues().size()) continue;
            if (!it.hasNext() || !it.peekNext().isArgument()) break;
            it.nextUntil(instr -> !instr.isArgument());
            break;
        }
        it.add(canonicalizedInvoke);
    }

    private static void insertCanonicalizedInvokeWithoutInValues(IRCode code, Invoke canonicalizedInvoke) {
        BasicBlock entryBlock = code.entryBlock();
        InstructionListIterator it = entryBlock.listIterator(code);
        while (it.hasNext()) {
            if (((Instruction)it.next()).isArgument()) continue;
            it.previous();
            break;
        }
        it.add(canonicalizedInvoke);
    }

    public void logResults() {
        assert (Log.ENABLED);
        Log.info(this.getClass(), "# invoke canonicalization (library): %s", this.numberOfLibraryCallCanonicalization);
        Log.info(this.getClass(), "# invoke canonicalization (program): %s", this.numberOfProgramCallCanonicalization);
        assert (this.histogramOfCanonicalizationCandidatesPerMethod != null);
        Log.info(this.getClass(), "------ histogram of invoke canonicalization candidates ------", new Object[0]);
        this.histogramOfCanonicalizationCandidatesPerMethod.forEach((length, count) -> Log.info(this.getClass(), "%s: %s (%s)", length, StringUtils.times("*", Math.min(count, 53)), count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void canonicalize(IRCode code) {
        Object2ObjectLinkedOpenCustomHashMap<InvokeMethod, List> returnValues = new Object2ObjectLinkedOpenCustomHashMap<InvokeMethod, List>(new Hash.Strategy<InvokeMethod>(){

            @Override
            public int hashCode(InvokeMethod o) {
                return o.getInvokedMethod().hashCode() * 31 + o.inValues().hashCode();
            }

            @Override
            public boolean equals(InvokeMethod a, InvokeMethod b) {
                assert (a == null || !a.outValue().hasLocalInfo());
                assert (b == null || !b.outValue().hasLocalInfo());
                return a == b || a != null && b != null && a.identicalNonValueNonPositionParts(b) && a.inValues().equals(b.inValues());
            }
        });
        ProgramMethod context = code.context();
        for (BasicBlock block : code.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                InvokeMethod invoke;
                if (!instruction.isInvokeMethod() || (invoke = instruction.asInvokeMethod()).outValue() == null || instruction.outValue().hasLocalInfo()) continue;
                if (!this.isIdempotentLibraryMethodInvoke(invoke)) {
                    Value receiver;
                    MethodOptimizationInfo optimizationInfo;
                    DexClassAndMethod target;
                    if (!this.appView.enableWholeProgramOptimizations()) continue;
                    assert (((AppInfo)this.appView.appInfo()).hasLiveness());
                    AppView<AppInfoWithLiveness> appViewWithLiveness = this.appView.withLiveness();
                    AppInfoWithLiveness appInfoWithLiveness = appViewWithLiveness.appInfo();
                    MethodResolutionResult.SingleResolutionResult resolutionResult = appInfoWithLiveness.resolveMethod(invoke.getInvokedMethod(), invoke.getInterfaceBit()).asSingleResolution();
                    if (resolutionResult == null || resolutionResult.isAccessibleFrom((ProgramDefinition)context, appInfoWithLiveness).isPossiblyFalse() || (target = invoke.lookupSingleTarget(appViewWithLiveness, context)) == null || (optimizationInfo = ((DexEncodedMethod)target.getDefinition()).getOptimizationInfo()).mayHaveSideEffects(invoke, appViewWithLiveness.options()) || !optimizationInfo.returnValueOnlyDependsOnArguments() || instruction.isInvokeMethodWithReceiver() && (receiver = instruction.asInvokeMethodWithReceiver().getReceiver().getAliasedValue()).getType().isNullable()) continue;
                }
                boolean invocationCanBeMovedToEntryBlock = true;
                for (Value in : instruction.inValues()) {
                    if (!in.isPhi() && in.definition.isConstInstruction() && in.definition.getBlock().getNumber() == 0) continue;
                    invocationCanBeMovedToEntryBlock = false;
                    break;
                }
                if (!invocationCanBeMovedToEntryBlock) continue;
                List oldReturnValues = returnValues.computeIfAbsent(invoke, k -> new ArrayList());
                oldReturnValues.add(instruction.outValue());
            }
        }
        if (returnValues.isEmpty()) {
            return;
        }
        assert (!code.entryBlock().hasCatchHandlers());
        HashMap deadInvocations = Maps.newHashMap();
        ObjectSortedSet entries = returnValues.object2ObjectEntrySet();
        if (Log.ENABLED && Log.isLoggingEnabledFor(IdempotentFunctionCallCanonicalizer.class)) {
            Long numOfCandidates = entries.stream().filter(a -> ((List)a.getValue()).size() > 1).count();
            Object2IntMap<Long> object2IntMap = this.histogramOfCanonicalizationCandidatesPerMethod;
            synchronized (object2IntMap) {
                int count = this.histogramOfCanonicalizationCandidatesPerMethod.getOrDefault(numOfCandidates, 0);
                this.histogramOfCanonicalizationCandidatesPerMethod.put(numOfCandidates, count + 1);
            }
        }
        entries.stream().filter(a -> ((List)a.getValue()).size() > 1).sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).limit(15L).forEach(entry -> {
            InvokeMethod invoke = (InvokeMethod)entry.getKey();
            if (Log.ENABLED) {
                if (this.factory.libraryMethodsWithReturnValueDependingOnlyOnArguments.contains(invoke.getInvokedMethod())) {
                    this.numberOfLibraryCallCanonicalization += ((List)entry.getValue()).size() - 1;
                } else {
                    this.numberOfProgramCallCanonicalization += ((List)entry.getValue()).size() - 1;
                }
            }
            Value canonicalizedValue = code.createValue(invoke.getOutType(), invoke.outValue().getLocalInfo());
            Invoke canonicalizedInvoke = Invoke.create(invoke.getType(), invoke.getInvokedMethod(), null, canonicalizedValue, invoke.inValues());
            Position firstInvocationPosition = ((Value)((List)entry.getValue()).get((int)0)).definition.getPosition();
            canonicalizedInvoke.setPosition(firstInvocationPosition);
            if (invoke.inValues().size() > 0) {
                IdempotentFunctionCallCanonicalizer.insertCanonicalizedInvokeWithInValues(code, canonicalizedInvoke);
            } else {
                IdempotentFunctionCallCanonicalizer.insertCanonicalizedInvokeWithoutInValues(code, canonicalizedInvoke);
            }
            for (Value oldOutValue : (List)entry.getValue()) {
                deadInvocations.put(oldOutValue.definition.asInvokeMethod(), canonicalizedValue);
            }
        });
        if (!deadInvocations.isEmpty()) {
            for (BasicBlock basicBlock : code.blocks) {
                InstructionListIterator it = basicBlock.listIterator(code);
                while (it.hasNext()) {
                    InvokeMethod invoke;
                    Instruction current = (Instruction)it.next();
                    if (!current.isInvokeMethod() || !deadInvocations.containsKey(invoke = current.asInvokeMethod())) continue;
                    Value newOutValue = (Value)deadInvocations.get(invoke);
                    assert (newOutValue != null);
                    invoke.outValue().replaceUsers(newOutValue);
                    it.removeOrReplaceByDebugLocalRead();
                }
            }
        }
        code.removeAllDeadAndTrivialPhis();
        assert (code.isConsistentSSA(this.appView));
    }
}

