/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public abstract class MemberPoolCollection<R extends DexMember<?, R>> {
    final Equivalence<R> equivalence;
    final AppView<AppInfoWithLiveness> appView;
    final SubtypingInfo subtypingInfo;
    final Map<DexClass, MemberPool<R>> memberPools = new ConcurrentHashMap<DexClass, MemberPool<R>>();

    MemberPoolCollection(AppView<AppInfoWithLiveness> appView, Equivalence<R> equivalence, SubtypingInfo subtypingInfo) {
        this.appView = appView;
        this.equivalence = equivalence;
        this.subtypingInfo = subtypingInfo;
    }

    private void submitAll(Iterable<? extends DexClass> classes, List<Future<?>> futures, ExecutorService executorService) {
        for (DexClass dexClass : classes) {
            this.submit(dexClass, futures, executorService);
        }
    }

    private void submit(DexClass clazz, List<Future<?>> futures, ExecutorService executorService) {
        futures.add(executorService.submit(this.computeMemberPoolForClass(clazz)));
    }

    private Set<DexClass> getAllSuperTypesInclusive(DexClass subject, Predicate<DexClass> stoppingCriterion) {
        HashSet<DexClass> superTypes = new HashSet<DexClass>();
        ArrayDeque<DexClass> worklist = new ArrayDeque<DexClass>();
        worklist.add(subject);
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.pop();
            if (stoppingCriterion.test(clazz) || !superTypes.add(clazz)) continue;
            if (clazz.superType != null) {
                MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor(clazz.superType));
            }
            for (DexType interfaceType : clazz.interfaces.values) {
                MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor(interfaceType));
            }
        }
        return superTypes;
    }

    private Set<DexClass> getAllSubTypesExclusive(DexClass subject, Predicate<DexClass> stoppingCriterion) {
        HashSet<DexClass> subTypes = new HashSet<DexClass>();
        ArrayDeque worklist = new ArrayDeque();
        this.subtypingInfo.forAllImmediateExtendsSubtypes(subject.type, type -> MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        this.subtypingInfo.forAllImmediateImplementsSubtypes(subject.type, type -> MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.pop();
            if (stoppingCriterion.test(clazz) || !subTypes.add(clazz)) continue;
            this.subtypingInfo.forAllImmediateExtendsSubtypes(clazz.type, type -> MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
            this.subtypingInfo.forAllImmediateImplementsSubtypes(clazz.type, type -> MemberPoolCollection.addNonNull(worklist, this.appView.definitionFor((DexType)type)));
        }
        return subTypes;
    }

    private static <T> void addNonNull(Collection<T> collection, T item) {
        if (item != null) {
            collection.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAll(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Building member pool collection");
        try {
            ArrayList futures = new ArrayList();
            TopDownClassHierarchyTraversal.forAllClasses(this.appView).visit(this.appView.appInfo().classes(), clazz -> this.submit((DexClass)clazz, futures, executorService));
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberPool<R> buildForHierarchy(DexClass clazz, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Building member pool collection");
        try {
            ArrayList futures = new ArrayList();
            this.submitAll(this.getAllSuperTypesInclusive(clazz, this.memberPools::containsKey), futures, executorService);
            this.submitAll(this.getAllSubTypesExclusive(clazz, this.memberPools::containsKey), futures, executorService);
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
        return this.get(clazz);
    }

    public boolean hasPool(DexClass clazz) {
        return this.memberPools.containsKey(clazz);
    }

    public MemberPool<R> get(DexClass clazz) {
        assert (this.hasPool(clazz));
        return this.memberPools.get(clazz);
    }

    public boolean markIfNotSeen(DexClass clazz, R reference) {
        Equivalence.Wrapper<R> key;
        MemberPool<R> memberPool = this.get(clazz);
        if (memberPool.hasSeen(key = this.equivalence.wrap(reference))) {
            return true;
        }
        memberPool.seen(key);
        return false;
    }

    abstract Runnable computeMemberPoolForClass(DexClass var1);

    public static class MemberPool<T> {
        private final DexClass clazz;
        private final Equivalence<T> equivalence;
        private MemberPool<T> superType;
        private final Set<MemberPool<T>> interfaces = new HashSet<MemberPool<T>>();
        private final Set<MemberPool<T>> subTypes = new HashSet<MemberPool<T>>();
        private final Set<Equivalence.Wrapper<T>> memberPool = new HashSet<Equivalence.Wrapper<T>>();

        MemberPool(Equivalence<T> equivalence, DexClass clazz) {
            this.equivalence = equivalence;
            this.clazz = clazz;
        }

        private <S> S above(Equivalence.Wrapper<T> member, boolean inclusive, S value, S terminator, BiFunction<DexClass, S, S> accumulator) {
            WorkList<MemberPool> workList = WorkList.newIdentityWorkList(this);
            while (workList.hasNext()) {
                MemberPool next = workList.next();
                if (inclusive && (value = next.here(member, value, accumulator)) == terminator) {
                    return value;
                }
                inclusive = true;
                if (next.superType != null) {
                    workList.addIfNotSeen(next.superType);
                }
                workList.addIfNotSeen(next.interfaces);
            }
            return value;
        }

        private <S> S here(Equivalence.Wrapper<T> member, S value, BiFunction<DexClass, S, S> accumulator) {
            if (this.memberPool.contains(member)) {
                return accumulator.apply(this.clazz, value);
            }
            return value;
        }

        synchronized void linkSupertype(MemberPool<T> superType) {
            assert (this.superType == null);
            this.superType = superType;
        }

        synchronized void linkSubtype(MemberPool<T> subType) {
            boolean added = this.subTypes.add(subType);
            assert (added);
        }

        synchronized void linkInterface(MemberPool<T> itf) {
            boolean added = this.interfaces.add(itf);
            assert (added);
        }

        public void seen(T member) {
            this.seen(this.equivalence.wrap(member));
        }

        public synchronized void seen(Equivalence.Wrapper<T> member) {
            boolean added = this.memberPool.add(member);
            assert (added);
        }

        public boolean hasSeen(Equivalence.Wrapper<T> member) {
            return this.fold(member, false, true, (t, ignored) -> true);
        }

        public boolean hasSeenDirectly(Equivalence.Wrapper<T> member) {
            return this.here(member, false, (t, ignored) -> true);
        }

        public boolean hasSeenStrictlyAbove(Equivalence.Wrapper<T> member) {
            return this.above(member, false, false, true, (t, ignored) -> true);
        }

        public boolean hasSeenStrictlyBelow(Equivalence.Wrapper<T> member) {
            return this.below(member, false, true, (t, ignored) -> true);
        }

        public <S> S below(Equivalence.Wrapper<T> member, S value, S terminator, BiFunction<DexClass, S, S> accumulator) {
            WorkList<MemberPool<MemberPool<T>>> workList = WorkList.newIdentityWorkList(this.subTypes);
            while (workList.hasNext()) {
                MemberPool<T> next = workList.next();
                value = super.here(member, value, accumulator);
                if (value == terminator) {
                    return value;
                }
                workList.addIfNotSeen(next.interfaces);
                workList.addIfNotSeen(next.subTypes);
            }
            return value;
        }

        public <S> S fold(Equivalence.Wrapper<T> member, S initialValue, S terminator, BiFunction<DexClass, S, S> accumulator) {
            S value = this.above(member, true, initialValue, terminator, accumulator);
            if (value == terminator) {
                return value;
            }
            return this.below(member, initialValue, terminator, accumulator);
        }
    }
}

