/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRMetadata;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.ir.optimize.membervaluepropagation.assume.AssumeInfo;
import com.android.tools.r8.ir.optimize.membervaluepropagation.assume.AssumeInfoLookup;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;

public class MemberValuePropagation {
    private static final OptimizationFeedback feedback = OptimizationFeedbackSimple.getInstance();
    private final AppView<AppInfoWithLiveness> appView;
    private final Reporter reporter;
    private final Set<DexField> warnedFields = Sets.newIdentityHashSet();

    public MemberValuePropagation(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.reporter = appView.options().reporter;
    }

    private void rewriteArrayGet(IRCode code, ProgramMethod context, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, ArrayGet arrayGet) {
        TypeElement arrayType = arrayGet.array().getType();
        if (!arrayType.isArrayType()) {
            return;
        }
        TypeElement memberType = arrayType.asArrayType().getMemberType();
        if (!memberType.isClassType()) {
            return;
        }
        boolean isAlwaysNull = false;
        ClassTypeElement memberClassType = memberType.asClassType();
        if (memberClassType.getClassType().isAlwaysNull(this.appView)) {
            isAlwaysNull = true;
        } else if (memberClassType.getInterfaces().hasSingleKnownInterface()) {
            isAlwaysNull = memberClassType.getInterfaces().getSingleKnownInterface().isAlwaysNull(this.appView);
        }
        if (!isAlwaysNull) {
            return;
        }
        BasicBlock block = arrayGet.getBlock();
        Position position = arrayGet.getPosition();
        Instruction replacement = this.appView.abstractValueFactory().createNullValue().createMaterializingInstruction(this.appView, code, arrayGet);
        affectedValues.addAll(arrayGet.outValue().affectedValues());
        arrayGet.outValue().replaceUsers(replacement.outValue());
        replacement.setPosition(position);
        if (block.hasCatchHandlers()) {
            iterator2.splitCopyCatchHandlers(code, blocks, this.appView.options()).listIterator(code).add(replacement);
        } else {
            iterator2.add(replacement);
        }
    }

    private boolean mayPropagateValueFor(DexClassAndField field) {
        if (field.isProgramField()) {
            return this.appView.appInfo().mayPropagateValueFor(this.appView, (DexField)field.getReference());
        }
        return this.appView.appInfo().assumedValues.containsKey(field.getReference()) || this.appView.appInfo().noSideEffects.containsKey(field.getReference());
    }

    private boolean mayPropagateValueFor(DexClassAndMethod method) {
        if (method.isProgramMethod()) {
            return this.appView.appInfo().mayPropagateValueFor(this.appView, (DexMethod)method.getReference());
        }
        return this.appView.appInfo().assumedValues.containsKey(method.getReference()) || this.appView.appInfo().noSideEffects.containsKey(method.getReference());
    }

    private Instruction createReplacementFromAssumeInfo(AssumeInfo assumeInfo, IRCode code, Instruction instruction) {
        if (!assumeInfo.hasReturnInfo()) {
            return null;
        }
        ProguardMemberRuleReturnValue returnValueRule = assumeInfo.getReturnInfo();
        if (returnValueRule.isSingleValue()) {
            if (instruction.getOutType().isReferenceType()) {
                if (returnValueRule.getSingleValue() == 0L) {
                    return this.appView.abstractValueFactory().createNullValue().createMaterializingInstruction(this.appView, code, instruction);
                }
                return null;
            }
            return this.appView.abstractValueFactory().createSingleNumberValue(returnValueRule.getSingleValue()).createMaterializingInstruction(this.appView, code, instruction);
        }
        if (returnValueRule.isField()) {
            DexField field = returnValueRule.getField();
            assert (instruction.getOutType() == TypeElement.fromDexType(field.type, Nullability.maybeNull(), this.appView));
            DexClassAndField staticField = this.appView.appInfo().lookupStaticTarget(field);
            if (staticField == null) {
                if (this.warnedFields.add(field)) {
                    this.reporter.warning(new StringDiagnostic("Field `" + field.toSourceString() + "` is used in an -assumevalues rule but does not exist.", code.origin));
                }
                return null;
            }
            if (AccessControl.isMemberAccessible(staticField, staticField.getHolder(), code.context(), this.appView).isTrue()) {
                return ((StaticGet.Builder)StaticGet.builder().setField(field).setFreshOutValue(code, field.getTypeElement(this.appView), instruction.getLocalInfo())).build();
            }
            Instruction replacement = ((DexEncodedField)staticField.getDefinition()).valueAsConstInstruction(code, instruction.getLocalInfo(), this.appView);
            if (replacement == null) {
                this.reporter.warning(new StringDiagnostic("Unable to apply the rule `" + returnValueRule.toString() + "`: Could not determine the value of field `" + field.toSourceString() + "`", code.origin));
                return null;
            }
            return replacement;
        }
        return null;
    }

    private void setValueRangeFromAssumeInfo(AssumeInfo assumeInfo, Value value) {
        if (assumeInfo.hasReturnInfo() && assumeInfo.getReturnInfo().isValueRange()) {
            assert (!assumeInfo.getReturnInfo().isSingleValue());
            value.setValueRange(assumeInfo.getReturnInfo().getValueRange());
        }
    }

    private boolean applyAssumeInfoIfPossible(IRCode code, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, Instruction current, AssumeInfo assumeInfo) {
        Instruction replacement = this.createReplacementFromAssumeInfo(assumeInfo, code, current);
        if (replacement == null) {
            if (current.getOutType().isPrimitiveType()) {
                this.setValueRangeFromAssumeInfo(assumeInfo, current.outValue());
            }
            return false;
        }
        affectedValues.addAll(current.outValue().affectedValues());
        if (assumeInfo.isAssumeNoSideEffects()) {
            iterator2.replaceCurrentInstruction(replacement);
        } else {
            assert (assumeInfo.isAssumeValues());
            BasicBlock block = current.getBlock();
            Position position = current.getPosition();
            if (current.hasOutValue()) {
                assert (replacement.outValue() != null);
                current.outValue().replaceUsers(replacement.outValue());
            }
            if (current.isInstanceGet()) {
                iterator2.replaceCurrentInstructionByNullCheckIfPossible(this.appView, code.context());
            } else if (current.isStaticGet()) {
                StaticGet staticGet = current.asStaticGet();
                iterator2.removeOrReplaceCurrentInstructionByInitClassIfPossible(this.appView, code, staticGet.getField().holder);
            }
            replacement.setPosition(position);
            if (block.hasCatchHandlers()) {
                BasicBlock splitBlock = iterator2.split(code, blocks);
                splitBlock.listIterator(code).add(replacement);
                blocks.previous();
                assert (!iterator2.hasNext());
                assert (IteratorUtils.peekNext(blocks) == splitBlock);
                return true;
            }
            iterator2.add(replacement);
        }
        iterator2.previous();
        assert (iterator2.peekNext() == replacement);
        return true;
    }

    private void rewriteInvokeMethodWithConstantValues(IRCode code, ProgramMethod context, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, InvokeMethod invoke) {
        SingleValue singleReturnValue;
        if (invoke.hasUnusedOutValue()) {
            return;
        }
        DexMethod invokedMethod = invoke.getInvokedMethod();
        DexType invokedHolder = invokedMethod.getHolderType();
        if (!invokedHolder.isClassType()) {
            return;
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(invokedMethod).asSingleResolution();
        if (resolutionResult == null) {
            return;
        }
        DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, context);
        AssumeInfo lookup = AssumeInfoLookup.lookupAssumeInfo(this.appView, resolutionResult, singleTarget);
        if (lookup != null && this.applyAssumeInfoIfPossible(code, affectedValues, blocks, iterator2, invoke, lookup)) {
            return;
        }
        if (singleTarget != null && !this.mayPropagateValueFor(singleTarget)) {
            return;
        }
        AbstractValue abstractReturnValue = invokedMethod.getReturnType().isAlwaysNull(this.appView) ? this.appView.abstractValueFactory().createNullValue() : (singleTarget != null ? ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getAbstractReturnValue() : UnknownValue.getInstance());
        if (abstractReturnValue.isSingleValue() && (singleReturnValue = abstractReturnValue.asSingleValue()).isMaterializableInContext(this.appView, context)) {
            BasicBlock block = invoke.getBlock();
            Position position = invoke.getPosition();
            Instruction replacement = singleReturnValue.createMaterializingInstruction(this.appView, code, invoke);
            affectedValues.addAll(invoke.outValue().affectedValues());
            invoke.moveDebugValues(replacement);
            invoke.outValue().replaceUsers(replacement.outValue());
            invoke.setOutValue(null);
            if (invoke.isInvokeMethodWithReceiver()) {
                iterator2.replaceCurrentInstructionByNullCheckIfPossible(this.appView, context);
            } else if (invoke.isInvokeStatic() && singleTarget != null) {
                iterator2.removeOrReplaceCurrentInstructionByInitClassIfPossible(this.appView, code, singleTarget.getHolderType());
            }
            replacement.setPosition(position);
            if (block.hasCatchHandlers()) {
                iterator2.splitCopyCatchHandlers(code, blocks, this.appView.options()).listIterator(code).add(replacement);
            } else {
                iterator2.add(replacement);
            }
            if (singleTarget != null) {
                ((DexEncodedMethod)singleTarget.getDefinition()).getMutableOptimizationInfo().markAsPropagated();
            }
        }
    }

    private void rewriteFieldGetWithConstantValues(IRCode code, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, FieldInstruction current) {
        AbstractValue abstractValue;
        DexField field = current.getField();
        FieldResolutionResult.SingleFieldResolutionResult<?> resolutionResult = this.appView.appInfo().resolveField(field).asSingleFieldResolutionResult();
        if (resolutionResult == null) {
            boolean replaceCurrentInstructionWithConstNull = this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.wasRemoved(field), false);
            if (replaceCurrentInstructionWithConstNull) {
                iterator2.replaceCurrentInstruction(code.createConstNull());
            }
            return;
        }
        DexClassAndField target = resolutionResult.getResolutionPair();
        DexEncodedField definition = (DexEncodedField)target.getDefinition();
        if (definition.isStatic() != current.isStaticGet()) {
            return;
        }
        if (!this.mayPropagateValueFor(target)) {
            return;
        }
        AssumeInfo lookup = AssumeInfoLookup.lookupAssumeInfo(this.appView, target);
        if (lookup != null && this.applyAssumeInfoIfPossible(code, affectedValues, blocks, iterator2, current, lookup)) {
            return;
        }
        if (field.getType().isAlwaysNull(this.appView)) {
            abstractValue = this.appView.abstractValueFactory().createSingleNumberValue(0L);
        } else if (this.appView.appInfo().isFieldWrittenByFieldPutInstruction(definition)) {
            AbstractValue abstractReceiverValue;
            abstractValue = definition.getOptimizationInfo().getAbstractValue();
            if (abstractValue.isUnknown() && !definition.isStatic() && (abstractReceiverValue = current.asInstanceGet().object().getAbstractValue(this.appView, code.context())).hasObjectState()) {
                abstractValue = abstractReceiverValue.getObjectState().getAbstractFieldValue(definition);
            }
        } else if (definition.isStatic()) {
            abstractValue = definition.getStaticValue().toAbstractValue(this.appView.abstractValueFactory());
            assert (definition.getOptimizationInfo().getAbstractValue().isUnknown() || !definition.hasExplicitStaticValue() || abstractValue.equals(definition.getOptimizationInfo().getAbstractValue()));
        } else {
            abstractValue = this.appView.abstractValueFactory().createSingleNumberValue(0L);
        }
        if (abstractValue.isSingleValue()) {
            SingleValue singleValue = abstractValue.asSingleValue();
            if (singleValue.isSingleFieldValue() && singleValue.asSingleFieldValue().getField() == field) {
                return;
            }
            if (singleValue.isMaterializableInContext(this.appView, code.context())) {
                BasicBlock block = current.getBlock();
                ProgramMethod context = code.context();
                Position position = current.getPosition();
                Instruction replacement = singleValue.createMaterializingInstruction(this.appView, code, current);
                affectedValues.addAll(current.outValue().affectedValues());
                current.outValue().replaceUsers(replacement.outValue());
                if (current.isInstanceGet()) {
                    iterator2.replaceCurrentInstructionByNullCheckIfPossible(this.appView, context);
                } else {
                    assert (current.isStaticGet());
                    iterator2.removeOrReplaceCurrentInstructionByInitClassIfPossible(this.appView, code, target.getHolderType());
                }
                replacement.setPosition(position);
                if (block.hasCatchHandlers()) {
                    iterator2.splitCopyCatchHandlers(code, blocks, this.appView.options()).listIterator(code).add(replacement);
                } else {
                    iterator2.add(replacement);
                }
                feedback.markFieldAsPropagated(definition);
            }
        }
    }

    private void replaceInstancePutByNullCheckIfNeverRead(IRCode code, InstructionListIterator iterator2, InstancePut current) {
        DexEncodedField field = this.appView.appInfo().resolveField(current.getField()).getResolvedField();
        if (field == null || field.isStatic()) {
            return;
        }
        if (!field.type().isAlwaysNull(this.appView) && this.appView.appInfo().isFieldRead(field)) {
            return;
        }
        iterator2.replaceCurrentInstructionByNullCheckIfPossible(this.appView, code.context());
    }

    private void replaceStaticPutByInitClassIfNeverRead(IRCode code, InstructionListIterator iterator2, StaticPut current) {
        DexEncodedField field = this.appView.appInfo().resolveField(current.getField()).getResolvedField();
        if (field == null || !field.isStatic()) {
            return;
        }
        if (!field.type().isAlwaysNull(this.appView) && this.appView.appInfo().isFieldRead(field)) {
            return;
        }
        iterator2.removeOrReplaceCurrentInstructionByInitClassIfPossible(this.appView, code, field.getHolderType());
    }

    public void run(IRCode code) {
        IRMetadata metadata = code.metadata();
        if (!metadata.mayHaveFieldInstruction() && !metadata.mayHaveInvokeMethod()) {
            return;
        }
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        this.run(code, code.listIterator(), affectedValues, Predicates.alwaysTrue());
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA(this.appView));
        assert (code.verifyTypes(this.appView));
    }

    public void run(IRCode code, ListIterator<BasicBlock> blockIterator, Set<Value> affectedValues, Predicate<BasicBlock> blockTester) {
        ProgramMethod context = code.context();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!blockTester.test(block)) continue;
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (current.isArrayGet()) {
                    this.rewriteArrayGet(code, context, affectedValues, blockIterator, iterator2, current.asArrayGet());
                    continue;
                }
                if (current.isInvokeMethod()) {
                    this.rewriteInvokeMethodWithConstantValues(code, context, affectedValues, blockIterator, iterator2, current.asInvokeMethod());
                    continue;
                }
                if (current.isFieldGet()) {
                    this.rewriteFieldGetWithConstantValues(code, affectedValues, blockIterator, iterator2, current.asFieldInstruction());
                    continue;
                }
                if (current.isInstancePut()) {
                    this.replaceInstancePutByNullCheckIfNeverRead(code, iterator2, current.asInstancePut());
                    continue;
                }
                if (!current.isStaticPut()) continue;
                this.replaceStaticPutByInitClassIfNeverRead(code, iterator2, current.asStaticPut());
            }
        }
    }
}

