/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.ir.optimize.MemberPoolCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.function.Predicate;

public class MethodPoolCollection
extends MemberPoolCollection<DexMethod> {
    private final Predicate<DexEncodedMethod> methodTester;

    public MethodPoolCollection(AppView<AppInfoWithLiveness> appView, SubtypingInfo subtypingInfo) {
        this(appView, subtypingInfo, Predicates.alwaysTrue());
    }

    public MethodPoolCollection(AppView<AppInfoWithLiveness> appView, SubtypingInfo subtypingInfo, Predicate<DexEncodedMethod> methodTester) {
        super(appView, MethodSignatureEquivalence.get(), subtypingInfo);
        this.methodTester = methodTester;
    }

    public static boolean excludesPrivateInstanceMethod(DexEncodedMethod method) {
        return !method.isPrivateMethod() || method.isStatic();
    }

    @Override
    Runnable computeMemberPoolForClass(DexClass clazz) {
        return () -> {
            DexClass superClazz;
            MemberPoolCollection.MemberPool methodPool = this.memberPools.computeIfAbsent(clazz, k -> new MemberPoolCollection.MemberPool(this.equivalence, (DexClass)k));
            clazz.forEachMethod(encodedMethod -> {
                if (this.methodTester.test((DexEncodedMethod)encodedMethod)) {
                    methodPool.seen(this.equivalence.wrap((DexMethod)encodedMethod.getReference()));
                }
            });
            if (clazz.superType != null && (superClazz = this.appView.definitionFor(clazz.superType)) != null) {
                MemberPoolCollection.MemberPool superPool = this.memberPools.computeIfAbsent(superClazz, k -> new MemberPoolCollection.MemberPool(this.equivalence, superClazz));
                superPool.linkSubtype(methodPool);
                methodPool.linkSupertype(superPool);
            }
            if (clazz.isInterface()) {
                for (DexType subtype : this.subtypingInfo.allImmediateSubtypes(clazz.type)) {
                    DexClass subClazz = this.appView.definitionFor(subtype);
                    if (subClazz == null) continue;
                    MemberPoolCollection.MemberPool childPool = this.memberPools.computeIfAbsent(subClazz, k -> new MemberPoolCollection.MemberPool(this.equivalence, subClazz));
                    methodPool.linkSubtype(childPool);
                    childPool.linkInterface(methodPool);
                }
            }
        };
    }
}

