/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.conversion.PostMethodProcessor;
import com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.inliner.FixedInliningReasonStrategy;
import com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import com.android.tools.r8.ir.optimize.inliner.NopWhyAreYouNotInliningReporter;
import com.android.tools.r8.ir.optimize.inliner.multicallerinliner.MultiCallerInlinerCallGraph;
import com.android.tools.r8.ir.optimize.inliner.multicallerinliner.MultiCallerInlinerNode;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.IntBox;
import com.android.tools.r8.utils.LazyBox;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.LongLivedProgramMethodSetBuilder;
import com.android.tools.r8.utils.collections.ProgramMethodMap;
import com.android.tools.r8.utils.collections.ProgramMethodMultiset;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class MultiCallerInliner {
    private final AppView<AppInfoWithLiveness> appView;
    private final ProgramMethodMap<Optional<ProgramMethodMultiset>> multiInlineCallEdges = ProgramMethodMap.createConcurrent();
    private final int[] multiCallerInliningInstructionLimits;

    MultiCallerInliner(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.multiCallerInliningInstructionLimits = appView.options().inlinerOptions().multiCallerInliningInstructionLimits;
    }

    private void recordCallEdgesForMultiCallerInlining(ProgramMethod method, IRCode code, MethodProcessor methodProcessor) {
        LazyBox<DefaultInliningOracle> lazyOracle = new LazyBox<DefaultInliningOracle>(() -> {
            int inliningInstructionAllowance = Integer.MAX_VALUE;
            return new DefaultInliningOracle(this.appView, new FixedInliningReasonStrategy(Inliner.Reason.MULTI_CALLER_CANDIDATE), method, methodProcessor, inliningInstructionAllowance);
        });
        for (InvokeMethod invoke : code.instructions(Instruction::isInvokeMethod)) {
            ProgramMethod singleTarget;
            MethodResolutionResult.SingleResolutionResult resolutionResult;
            if (invoke.isInvokeConstructor(this.appView.dexItemFactory()) || (resolutionResult = this.appView.appInfo().resolveMethod(invoke.getInvokedMethod(), invoke.getInterfaceBit()).asSingleResolution()) == null || resolutionResult.isAccessibleFrom((ProgramDefinition)method, this.appView).isPossiblyFalse() || (singleTarget = invoke.lookupSingleProgramTarget(this.appView, method)) == null || !methodProcessor.getCallSiteInformation().isMultiCallerInlineCandidate(singleTarget)) continue;
            Inliner.InlineResult inlineResult = lazyOracle.computeIfAbsent().computeInlining(code, invoke, resolutionResult, singleTarget, method, ClassInitializationAnalysis.trivial(), InliningIRProvider.getThrowingInstance(), NopWhyAreYouNotInliningReporter.getInstance());
            if (inlineResult == null || inlineResult.isRetryAction()) {
                this.stopTrackingCallSitesForMethod(singleTarget);
                continue;
            }
            Inliner.InlineAction action = inlineResult.asInlineAction();
            assert (action.reason == Inliner.Reason.MULTI_CALLER_CANDIDATE);
            this.recordCallEdgeForMultiCallerInlining(method, singleTarget, methodProcessor);
        }
    }

    private void stopTrackingCallSitesForMethodIfDefinitelyIneligibleForMultiCallerInlining(ProgramMethod method, ProgramMethod singleTarget, MethodProcessor methodProcessor, ProgramMethodMultiset callers) {
        callers.removeIf(caller -> caller.getOptimizationInfo().hasBeenInlinedIntoSingleCallSite());
        IntBox minimumCallers = new IntBox();
        callers.forEachEntry((caller, calls) -> {
            if (!methodProcessor.getCallSiteInformation().hasSingleCallSite((ProgramMethod)caller)) {
                minimumCallers.increment(calls);
            }
        });
        if (minimumCallers.get() > this.multiCallerInliningInstructionLimits.length) {
            this.stopTrackingCallSitesForMethod(singleTarget);
        }
    }

    private void stopTrackingCallSitesForMethod(ProgramMethod method) {
        this.multiInlineCallEdges.put(method, Optional.empty());
    }

    private LongLivedProgramMethodSetBuilder<ProgramMethodSet> computeMultiInlineCallerMethods(MultiCallerInlinerCallGraph callGraph) {
        GraphLens currentGraphLens = this.appView.graphLens();
        LongLivedProgramMethodSetBuilder<ProgramMethodSet> multiInlineCallers = LongLivedProgramMethodSetBuilder.createForIdentitySet(currentGraphLens);
        this.multiInlineCallEdges.forEach((singleTarget, value) -> {
            if (((DexEncodedMethod)singleTarget.getDefinition()).isLibraryMethodOverride().isPossiblyTrue()) {
                return;
            }
            if (!value.isPresent()) {
                return;
            }
            if (((DexEncodedMethod)singleTarget.getDefinition()).isInstance() && !this.appView.appInfo().isInstantiatedDirectlyOrIndirectly(singleTarget.getHolder())) {
                return;
            }
            ProgramMethodMultiset callers = (ProgramMethodMultiset)value.get();
            callers.removeIf(method -> method.getOptimizationInfo().hasBeenInlinedIntoSingleCallSite());
            if (callers.size() == 0 || callers.size() > this.multiCallerInliningInstructionLimits.length) {
                return;
            }
            int numberOfCallSites = ((MultiCallerInlinerNode)callGraph.getNode((ProgramMethod)singleTarget)).getNumberOfCallSites();
            if (numberOfCallSites < callers.size()) {
                return;
            }
            if (callers.size() < numberOfCallSites) {
                return;
            }
            int multiCallerInliningInstructionLimit = this.multiCallerInliningInstructionLimits[callers.size() - 1];
            if (!((DexEncodedMethod)singleTarget.getDefinition()).getCode().estimatedSizeForInliningAtMost(multiCallerInliningInstructionLimit)) {
                return;
            }
            callers.forEachEntry((caller, count) -> {
                if (!caller.getOptimizationInfo().hasBeenInlinedIntoSingleCallSite()) {
                    multiInlineCallers.add((ProgramMethod)caller, currentGraphLens);
                }
            });
            OptimizationFeedback.getSimpleFeedback().setMultiCallerMethod((ProgramMethod)singleTarget);
        });
        this.multiInlineCallEdges.clear();
        return multiInlineCallers;
    }

    void recordCallEdgesForMultiCallerInlining(ProgramMethod method, IRCode code, MethodProcessor methodProcessor, Timing timing) {
        if (!methodProcessor.isPrimaryMethodProcessor()) {
            return;
        }
        timing.time("Multi caller inliner: Record call edges", () -> this.recordCallEdgesForMultiCallerInlining(method, code, methodProcessor));
    }

    void recordCallEdgeForMultiCallerInlining(ProgramMethod method, ProgramMethod singleTarget, MethodProcessor methodProcessor) {
        Optional value = this.multiInlineCallEdges.computeIfAbsent(singleTarget, MapUtils.ignoreKey(() -> Optional.of(ProgramMethodMultiset.createConcurrent())));
        if (!value.isPresent()) {
            return;
        }
        ProgramMethodMultiset callers = (ProgramMethodMultiset)value.get();
        callers.add(method);
        if (callers.size() > this.multiCallerInliningInstructionLimits.length) {
            this.stopTrackingCallSitesForMethodIfDefinitelyIneligibleForMultiCallerInlining(method, singleTarget, methodProcessor, callers);
        }
    }

    void onMethodPruned(ProgramMethod method) {
        assert (!this.multiInlineCallEdges.containsKey(method));
    }

    public void onLastWaveDone(PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Multi caller inliner");
        MultiCallerInlinerCallGraph callGraph = timing.time("Call graph construction", () -> MultiCallerInlinerCallGraph.builder(this.appView).build(executorService));
        LongLivedProgramMethodSetBuilder multiInlineCallers = timing.time("Needs inlining analysis", () -> this.computeMultiInlineCallerMethods(callGraph));
        postMethodProcessorBuilder.rewrittenWithLens(this.appView).merge(multiInlineCallers);
        timing.end();
    }
}

