/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.utils.WorkList;
import java.util.Set;

public class NaturalIntLoopRemover {
    private boolean isComparisonBlock(BasicBlock comparisonBlockCandidate) {
        if (!comparisonBlockCandidate.exit().isIf() || comparisonBlockCandidate.exit().asIf().isZeroTest()) {
            return false;
        }
        for (Instruction instruction : comparisonBlockCandidate.getInstructions()) {
            if (instruction.isIf()) {
                return true;
            }
            if (instruction.isConstNumber()) continue;
            return false;
        }
        throw new Unreachable();
    }

    private boolean tryRemoveLoop(IRCode code, If comparison) {
        Phi loopPhi = this.computeLoopPhi(comparison);
        if (loopPhi == null) {
            return false;
        }
        NaturalIntLoopWithKnowIterations.Builder builder = NaturalIntLoopWithKnowIterations.builder(comparison);
        if (!this.analyzeLoopIterator(comparison, loopPhi, builder)) {
            return false;
        }
        Set<BasicBlock> loopBody = this.computeLoopBody(builder.getBackPredecessor(), comparison.getBlock());
        if (loopBody == null) {
            return false;
        }
        if (loopBody.contains(builder.getLoopEntry())) {
            assert (false);
            return false;
        }
        builder.setLoopBody(loopBody);
        if (!this.analyzeLoopExit(loopBody, comparison, builder)) {
            return false;
        }
        NaturalIntLoopWithKnowIterations loop = builder.build();
        if (loop.has1Iteration()) {
            loop.remove1IterationLoop(code);
            return true;
        }
        return false;
    }

    private boolean analyzeLoopExit(Set<BasicBlock> loopBody, If comparison, NaturalIntLoopWithKnowIterations.Builder builder) {
        if (loopBody.contains(comparison.getTrueTarget())) {
            if (loopBody.contains(comparison.fallthroughBlock())) {
                return false;
            }
            builder.setLoop(comparison.fallthroughBlock(), comparison.getTrueTarget());
        } else {
            if (!loopBody.contains(comparison.fallthroughBlock())) {
                return false;
            }
            builder.setLoop(comparison.getTrueTarget(), comparison.fallthroughBlock());
        }
        return true;
    }

    private boolean analyzeLoopIterator(If comparison, Phi loopPhi, NaturalIntLoopWithKnowIterations.Builder builder) {
        for (int i = 0; i < loopPhi.getOperands().size(); ++i) {
            Value operand = loopPhi.getOperand(i);
            if (operand.isPhi()) {
                return false;
            }
            BasicBlock predecessor = comparison.getBlock().getPredecessors().get(i);
            if (operand.isConstNumber()) {
                if (!operand.getType().isInt() || builder.getLoopEntry() != null) {
                    return false;
                }
                builder.setLoopEntry(predecessor);
                builder.setInitCounter(operand.definition.asConstNumber().getIntValue());
                continue;
            }
            if (operand.definition.isAdd()) {
                if (builder.getBackPredecessor() != null) {
                    return false;
                }
                builder.setBackPredecessor(predecessor);
                boolean metPhiOperand = false;
                for (Value inValue : operand.definition.inValues()) {
                    if (inValue.isConstNumber() && inValue.getType().isInt()) {
                        int counterIncrement = inValue.definition.asConstNumber().getIntValue();
                        if (counterIncrement == 0 || builder.getCounterIncrement() != 0) {
                            return false;
                        }
                        builder.setCounterIncrement(counterIncrement);
                        continue;
                    }
                    if (inValue == loopPhi) {
                        if (metPhiOperand) {
                            return false;
                        }
                        metPhiOperand = true;
                        continue;
                    }
                    return false;
                }
                continue;
            }
            if (operand.definition.isSub()) {
                if (builder.getBackPredecessor() != null) {
                    return false;
                }
                builder.setBackPredecessor(predecessor);
                Sub sub = operand.definition.asSub();
                if (sub.leftValue() != loopPhi) {
                    return false;
                }
                Value subValue = sub.rightValue();
                if (subValue.isConstNumber() && subValue.getType().isInt()) {
                    assert (builder.getCounterIncrement() == 0);
                    int counterIncrement = -subValue.definition.asConstNumber().getIntValue();
                    if (counterIncrement == 0) {
                        return false;
                    }
                    builder.setCounterIncrement(counterIncrement);
                    continue;
                }
                return false;
            }
            return false;
        }
        assert (builder.getLoopEntry() != null);
        assert (builder.getLoopEntry().exit().isGoto());
        assert (builder.getBackPredecessor() != null);
        assert (builder.getBackPredecessor().exit().isGoto());
        assert (builder.getCounterIncrement() != 0);
        return true;
    }

    private Phi computeLoopPhi(If comparison) {
        Phi loopPhi = null;
        if (comparison.rhs().isConstant() && comparison.lhs().isPhi()) {
            loopPhi = comparison.lhs().asPhi();
        } else if (comparison.lhs().isConstant() && comparison.rhs().isPhi()) {
            loopPhi = comparison.rhs().asPhi();
        }
        if (loopPhi == null) {
            return null;
        }
        if (loopPhi.getOperands().size() != 2) {
            return null;
        }
        if (loopPhi.getBlock() != comparison.getBlock()) {
            return null;
        }
        return loopPhi;
    }

    private Set<BasicBlock> computeLoopBody(BasicBlock backPredecessor, BasicBlock comparisonBlock) {
        WorkList<BasicBlock> workList = WorkList.newIdentityWorkList();
        workList.addIfNotSeen(backPredecessor);
        workList.markAsSeen(comparisonBlock);
        while (!workList.isEmpty()) {
            BasicBlock basicBlock = (BasicBlock)workList.next();
            if (basicBlock.isEntry()) {
                return null;
            }
            for (BasicBlock predecessor : basicBlock.getPredecessors()) {
                workList.addIfNotSeen(predecessor);
            }
        }
        return workList.getSeenSet();
    }

    public void run(AppView<?> appView, IRCode code) {
        if (!appView.testing().enableExperimentalLoopUnrolling) {
            return;
        }
        boolean loopRemoved = false;
        for (BasicBlock comparisonBlockCandidate : code.blocks) {
            if (!this.isComparisonBlock(comparisonBlockCandidate)) continue;
            loopRemoved |= this.tryRemoveLoop(code, comparisonBlockCandidate.exit().asIf());
        }
        if (loopRemoved) {
            code.removeAllDeadAndTrivialPhis();
            assert (code.isConsistentSSA(appView));
        }
    }

    static class NaturalIntLoopWithKnowIterations {
        private final int initCounter;
        private final int counterIncrement;
        private final If comparison;
        private final BasicBlock loopExit;
        private final BasicBlock loopBodyEntry;
        private final BasicBlock backPredecessor;
        private final Set<BasicBlock> loopBody;

        NaturalIntLoopWithKnowIterations(int initCounter, int counterIncrement, If comparison, BasicBlock loopExit, BasicBlock loopBodyEntry, BasicBlock backPredecessor, Set<BasicBlock> loopBody) {
            this.initCounter = initCounter;
            this.counterIncrement = counterIncrement;
            this.comparison = comparison;
            this.loopExit = loopExit;
            this.loopBodyEntry = loopBodyEntry;
            this.backPredecessor = backPredecessor;
            this.loopBody = loopBody;
        }

        static Builder builder(If comparison) {
            return new Builder(comparison);
        }

        private BasicBlock target(int phiValue) {
            if (this.comparison.rhs().isConstNumber()) {
                int comp = this.comparison.rhs().getDefinition().asConstNumber().getIntValue();
                return this.comparison.targetFromCondition(Integer.signum(phiValue - comp));
            }
            int comp = this.comparison.lhs().getDefinition().asConstNumber().getIntValue();
            return this.comparison.targetFromCondition(Integer.signum(comp - phiValue));
        }

        private void remove1IterationLoop(IRCode code) {
            BasicBlock comparisonBlock = this.comparison.getBlock();
            this.updatePhis(comparisonBlock);
            this.patchControlFlow(code, comparisonBlock);
        }

        private void patchControlFlow(IRCode code, BasicBlock comparisonBlock) {
            assert (this.loopExit.getPhis().isEmpty());
            comparisonBlock.replaceLastInstruction(new Goto(this.loopBodyEntry), code);
            comparisonBlock.removeSuccessor(this.loopExit);
            this.backPredecessor.replaceSuccessor(comparisonBlock, this.loopExit);
            this.backPredecessor.replaceLastInstruction(new Goto(this.loopExit), code);
            comparisonBlock.removePredecessor(this.backPredecessor, Sets.newIdentityHashSet());
            this.loopExit.replacePredecessor(comparisonBlock, this.backPredecessor);
        }

        private void updatePhis(BasicBlock comparisonBlock) {
            int backIndex = comparisonBlock.getPredecessors().indexOf(this.backPredecessor);
            for (Phi phi : comparisonBlock.getPhis()) {
                Value loopEntryValue = phi.getOperand(1 - backIndex);
                Value loopExitValue = phi.getOperand(backIndex);
                for (Instruction uniqueUser : phi.uniqueUsers()) {
                    if (this.loopBody.contains(uniqueUser.getBlock())) {
                        uniqueUser.replaceValue(phi, loopEntryValue);
                        continue;
                    }
                    uniqueUser.replaceValue(phi, loopExitValue);
                }
                for (Phi phiUser : phi.uniquePhiUsers()) {
                    if (this.loopBody.contains(phiUser.getBlock())) {
                        phiUser.replaceOperand(phi, loopEntryValue);
                        continue;
                    }
                    phiUser.replaceOperand(phi, loopExitValue);
                }
            }
        }

        public boolean has1Iteration() {
            return this.target(this.initCounter) == this.loopBodyEntry && this.target(this.initCounter + this.counterIncrement) == this.loopExit;
        }

        static class Builder {
            private int initCounter;
            private int counterIncrement;
            private final If comparison;
            private BasicBlock loopExit;
            private BasicBlock loopBodyEntry;
            private BasicBlock loopEntry;
            private BasicBlock backPredecessor;
            private Set<BasicBlock> loopBody;

            Builder(If comparison) {
                this.comparison = comparison;
            }

            public void setInitCounter(int initCounter) {
                this.initCounter = initCounter;
            }

            public int getCounterIncrement() {
                return this.counterIncrement;
            }

            public void setCounterIncrement(int counterIncrement) {
                this.counterIncrement = counterIncrement;
            }

            public BasicBlock getLoopEntry() {
                return this.loopEntry;
            }

            public void setLoopEntry(BasicBlock loopEntry) {
                this.loopEntry = loopEntry;
            }

            public BasicBlock getBackPredecessor() {
                return this.backPredecessor;
            }

            public void setBackPredecessor(BasicBlock backPredecessor) {
                this.backPredecessor = backPredecessor;
            }

            public void setLoop(BasicBlock loopExit, BasicBlock loopBodyEntry) {
                this.loopExit = loopExit;
                this.loopBodyEntry = loopBodyEntry;
            }

            public void setLoopBody(Set<BasicBlock> loopBody) {
                this.loopBody = loopBody;
            }

            public NaturalIntLoopWithKnowIterations build() {
                return new NaturalIntLoopWithKnowIterations(this.initCounter, this.counterIncrement, this.comparison, this.loopExit, this.loopBodyEntry, this.backPredecessor, this.loopBody);
            }
        }
    }
}

