/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class NestReducer {
    private AppView<AppInfoWithLiveness> appView;

    public NestReducer(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private void removeNests() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (!clazz.isInANest()) continue;
            if (clazz.isNestHost()) {
                clazz.clearNestMembers();
                continue;
            }
            clazz.clearNestHost();
        }
    }

    private void reduceNests(ExecutorService executorService) throws ExecutionException {
        Set<DexProgramClass> nestHosts = Sets.newIdentityHashSet();
        Set<DexProgramClass> nestMembers = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (!clazz.isInANest()) continue;
            if (clazz.isNestHost()) {
                nestHosts.add(clazz);
                continue;
            }
            nestMembers.add(clazz);
        }
        ThreadUtils.processItems(nestHosts, this::processNestHost, executorService);
        ThreadUtils.processItems(nestMembers, this::processNestMember, executorService);
    }

    private void processNestHost(DexProgramClass clazz) {
        BooleanBox nestHasPrivateMembers = new BooleanBox(IterableUtils.hasNext(clazz.members(DexEncodedMember::isPrivate)));
        clazz.getNestMembersClassAttributes().removeIf(attribute -> {
            DexProgramClass member = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(attribute.getNestMember(), clazz));
            if (member == null) {
                return true;
            }
            nestHasPrivateMembers.computeIfNotSet(() -> IterableUtils.hasNext(member.members(DexEncodedMember::isPrivate)));
            return false;
        });
        if (nestHasPrivateMembers.isFalse() && this.appView.options().enableNestReduction) {
            clazz.getNestMembersClassAttributes().clear();
        }
    }

    private void processNestMember(DexProgramClass clazz) {
        DexProgramClass hostClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(clazz.getNestHost(), clazz));
        if (hostClass == null || !hostClass.isNestHost()) {
            clazz.clearNestHost();
        }
    }

    public void run(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("NestReduction");
        if (this.appView.options().shouldDesugarNests()) {
            this.removeNests();
        } else {
            this.reduceNests(executorService);
        }
        timing.end();
    }
}

