/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClasspathMethod;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.ArithmeticBinop;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Div;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.LinearFlowInstructionListIterator;
import com.android.tools.r8.ir.code.Mul;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Rem;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackDelayed;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.ir.optimize.outliner.OutlineCollection;
import com.android.tools.r8.ir.optimize.outliner.Outliner;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class OutlinerImpl
extends Outliner {
    static final int MAX_IN_SIZE = 5;
    private OutlineCollection outlineCollection;
    private final Map<Outline, List<ProgramMethod>> outlineSites = new HashMap<Outline, List<ProgramMethod>>();
    private final Map<Outline, DexMethod> generatedOutlines = new HashMap<Outline, DexMethod>();
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory dexItemFactory;
    private final InliningConstraints inliningConstraints;

    public OutlinerImpl(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.inliningConstraints = new InliningConstraints(appView, GraphLens.getIdentityLens());
    }

    private void forEachSelectedOutliningMethod(IRConverter converter, ProgramMethodSet methodsSelectedForOutlining, Consumer<IRCode> consumer, ExecutorService executorService) throws ExecutionException {
        assert (!this.appView.options().skipIR);
        ThreadUtils.processItems(methodsSelectedForOutlining, method -> {
            IRCode code = method.buildIR(this.appView);
            assert (code != null);
            assert (!((DexEncodedMethod)method.getDefinition()).getCode().isOutlineCode());
            converter.codeRewriter.rewriteMoveResult(code);
            converter.deadCodeRemover.run(code, Timing.empty());
            CodeRewriter.removeAssumeInstructions(this.appView, code);
            consumer.accept(code);
        }, executorService);
    }

    public static void getInstructions(AppView<?> appView, IRCode code, Consumer<List<Instruction>> consumer) {
        int maxNumberOfInstructionsToBeConsidered = appView.options().outline.maxNumberOfInstructionsToBeConsidered;
        int minSize = appView.options().outline.minSize;
        Set<BasicBlock> seenBlocks = Sets.newIdentityHashSet();
        for (BasicBlock block : code.blocks) {
            if (!seenBlocks.add(block)) continue;
            ImmutableList.Builder builder = ImmutableList.builder();
            LinearFlowInstructionListIterator instructionIterator = new LinearFlowInstructionListIterator(code, block);
            BasicBlock lastSeenBlock = block;
            int counter = 0;
            boolean sawLinearFlowWithCatchHandlers = false;
            while (instructionIterator.hasNext()) {
                Instruction instruction = instructionIterator.next();
                if (instruction.getBlock() != block) {
                    if (block.hasCatchHandlers() || instruction.getBlock().hasCatchHandlers()) {
                        lastSeenBlock = instruction.getBlock();
                        sawLinearFlowWithCatchHandlers = true;
                        break;
                    }
                    if (seenBlocks.contains(instruction.getBlock())) break;
                }
                builder.add(instruction);
                if (++counter > maxNumberOfInstructionsToBeConsidered && instruction.getBlock() != lastSeenBlock) break;
                lastSeenBlock = instruction.getBlock();
            }
            seenBlocks.addAll(instructionIterator.getSeenBlocks());
            if (sawLinearFlowWithCatchHandlers) {
                assert (lastSeenBlock != block);
                seenBlocks.remove(lastSeenBlock);
            }
            if (counter < minSize) continue;
            consumer.accept((List<Instruction>)((Object)builder.build()));
        }
    }

    private List<Outline> selectOutlines() {
        assert (!this.outlineSites.isEmpty());
        ArrayList<Outline> result = new ArrayList<Outline>();
        for (Map.Entry<Outline, List<ProgramMethod>> entry : this.outlineSites.entrySet()) {
            if (entry.getValue().size() < this.appView.options().outline.threshold) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private static ProgramMethod findDeterministicRepresentative(List<ProgramMethod> members) {
        ProgramMethod smallest = members.get(0);
        for (int i = 1; i < members.size(); ++i) {
            ProgramMethod next = members.get(i);
            if (((DexMethod)next.getReference()).compareTo((DexMethod)smallest.getReference()) >= 0) continue;
            smallest = next;
        }
        return smallest;
    }

    @Override
    public void onMethodPruned(ProgramMethod method) {
        this.onMethodCodePruned(method);
    }

    @Override
    public void onMethodCodePruned(ProgramMethod method) {
        this.outlineCollection.remove(this.appView, method);
    }

    @Override
    public void prepareForPrimaryOptimizationPass(GraphLens graphLensForPrimaryOptimizationPass) {
        assert (this.appView.graphLens() == graphLensForPrimaryOptimizationPass);
        assert (this.outlineCollection == null);
        this.outlineCollection = new OutlineCollection(graphLensForPrimaryOptimizationPass);
    }

    @Override
    public void performOutlining(IRConverter converter, OptimizationFeedbackDelayed feedback, ExecutorService executorService, Timing timing) throws ExecutionException {
        assert (feedback.noUpdatesLeft());
        converter.printPhase("Outlining");
        timing.begin("IR conversion phase 3");
        ProgramMethodSet methodsSelectedForOutlining = this.selectMethodsForOutlining();
        if (!methodsSelectedForOutlining.isEmpty()) {
            this.forEachSelectedOutliningMethod(converter, methodsSelectedForOutlining, code -> {
                converter.printMethod((IRCode)code, "IR before outlining (SSA)", null);
                this.identifyOutlineSites((IRCode)code);
            }, executorService);
            List<ProgramMethod> outlineMethods = this.buildOutlineMethods();
            converter.optimizeSynthesizedMethods(outlineMethods, executorService);
            feedback.updateVisibleOptimizationInfo();
            this.forEachSelectedOutliningMethod(converter, methodsSelectedForOutlining, code -> {
                this.applyOutliningCandidate((IRCode)code);
                converter.printMethod((IRCode)code, "IR after outlining (SSA)", null);
                converter.memberValuePropagation.run((IRCode)code);
                converter.codeRewriter.rewriteMoveResult((IRCode)code);
                converter.removeDeadCodeAndFinalizeIR((IRCode)code, OptimizationFeedbackIgnore.getInstance(), Timing.empty());
            }, executorService);
            feedback.updateVisibleOptimizationInfo();
            assert (this.checkAllOutlineSitesFoundAgain());
            outlineMethods.forEach(m3 -> ((DexEncodedMethod)m3.getDefinition()).markNotProcessed());
        }
        timing.end();
    }

    @Override
    public void rewriteWithLens() {
        this.outlineCollection.rewriteWithLens(this.appView.graphLens());
    }

    @Override
    public void collectOutlineSites(IRCode code, Timing timing) {
        if (this.outlineCollection == null) {
            return;
        }
        ProgramMethod context = code.context();
        assert (!((DexEncodedMethod)context.getDefinition()).getCode().isOutlineCode());
        if (ClassToFeatureSplitMap.isInFeature(context.getHolder(), this.appView)) {
            return;
        }
        timing.begin("Collect outlines");
        ArrayList<Outline> outlinesForMethod = new ArrayList<Outline>();
        OutlinerImpl.getInstructions(this.appView, code, instructions -> new OutlineMethodIdentifier(context, code, (List<Instruction>)instructions, (List<Outline>)outlinesForMethod).process());
        this.outlineCollection.set(this.appView, context, outlinesForMethod);
        timing.end();
    }

    public void identifyOutlineSites(IRCode code) {
        ProgramMethod context = code.context();
        assert (!((DexEncodedMethod)context.getDefinition()).getCode().isOutlineCode());
        assert (!ClassToFeatureSplitMap.isInFeature(context.getHolder(), this.appView));
        OutlinerImpl.getInstructions(this.appView, code, instructions -> new OutlineSiteIdentifier(context, code, (List<Instruction>)instructions).process());
    }

    public ProgramMethodSet selectMethodsForOutlining() {
        ProgramMethodSet result = this.outlineCollection.computeMethodsSubjectToOutlining(this.appView);
        this.outlineCollection = null;
        return result;
    }

    public List<ProgramMethod> buildOutlineMethods() {
        CompilationContext.ProcessorContext outlineProcessorContext = this.appView.createProcessorContext();
        IdentityHashMap<DexMethod, CompilationContext.MethodProcessingContext> methodProcessingContexts = new IdentityHashMap<DexMethod, CompilationContext.MethodProcessingContext>();
        ArrayList<ProgramMethod> outlineMethods = new ArrayList<ProgramMethod>();
        List<Outline> outlines = this.selectOutlines();
        outlines.sort(Comparator.naturalOrder());
        for (Outline outline : outlines) {
            List<ProgramMethod> sites = this.outlineSites.get(outline);
            assert (!sites.isEmpty());
            ProgramMethod representative = OutlinerImpl.findDeterministicRepresentative(sites);
            CompilationContext.MethodProcessingContext methodProcessingContext = methodProcessingContexts.computeIfAbsent((DexMethod)representative.getReference(), key -> outlineProcessorContext.createMethodProcessingContext(representative));
            ProgramMethod outlineMethod = this.appView.getSyntheticItems().createMethod(kinds -> kinds.OUTLINE, methodProcessingContext.createUniqueContext(), this.appView, builder -> {
                builder.setAccessFlags(MethodAccessFlags.fromSharedAccessFlags(9, false)).setProto(outline.buildProto()).setApiLevelForDefinition(ComputedApiLevel.unknown()).setApiLevelForCode(ComputedApiLevel.unknown()).setCode(m3 -> new OutlineCode(outline));
                if (this.appView.options().isGeneratingClassFiles()) {
                    builder.setClassFileVersion(((DexEncodedMethod)representative.getDefinition()).getClassFileVersion());
                }
            });
            this.generatedOutlines.put(outline, (DexMethod)outlineMethod.getReference());
            outlineMethods.add(outlineMethod);
        }
        return outlineMethods;
    }

    public void applyOutliningCandidate(IRCode code) {
        assert (!((DexEncodedMethod)code.context().getDefinition()).getCode().isOutlineCode());
        Set toRemove = Sets.newIdentityHashSet();
        Set invokesToOutlineMethods = Sets.newIdentityHashSet();
        OutlinerImpl.getInstructions(this.appView, code, instructions -> new OutlineRewriter(code, (List<Instruction>)instructions, toRemove, invokesToOutlineMethods).process());
        if (!toRemove.isEmpty()) {
            assert (!invokesToOutlineMethods.isEmpty());
            BasicBlockIterator blocksIterator = code.listIterator();
            while (blocksIterator.hasNext()) {
                BasicBlock block = (BasicBlock)blocksIterator.next();
                InstructionListIterator instructionListIterator = block.listIterator(code);
                instructionListIterator.forEachRemaining(instruction -> {
                    if (toRemove.contains(instruction)) {
                        instructionListIterator.removeInstructionIgnoreOutValue();
                    } else if (invokesToOutlineMethods.contains(instruction) && block.hasCatchHandlers()) {
                        instructionListIterator.split(code, blocksIterator);
                    }
                });
            }
        }
    }

    public boolean checkAllOutlineSitesFoundAgain() {
        for (Outline outline : this.generatedOutlines.keySet()) {
            assert (this.outlineSites.get(outline).isEmpty()) : this.outlineSites.get(outline);
        }
        return true;
    }

    public class OutlineCode
    extends Code {
        private final Outline outline;

        OutlineCode(Outline outline) {
            this.outline = outline;
        }

        @Override
        public boolean isOutlineCode() {
            return true;
        }

        @Override
        public int estimatedSizeForInlining() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int estimatedDexCodeSizeUpperBoundInBytes() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isEmptyVoidMethod() {
            return false;
        }

        @Override
        public IRCode buildIR(ProgramMethod method, AppView<?> appView, Origin origin, MethodConversionOptions.MutableMethodConversionOptions conversionOptions) {
            OutlineSourceCode source = new OutlineSourceCode(this.outline, (DexMethod)method.getReference());
            return IRBuilder.create(method, appView, source, origin).build(method, conversionOptions);
        }

        @Override
        public String toString() {
            return this.outline.toString();
        }

        @Override
        public void registerCodeReferences(ProgramMethod method, UseRegistry registry) {
            throw new Unreachable();
        }

        @Override
        public void registerCodeReferencesForDesugaring(ClasspathMethod method, UseRegistry registry) {
            throw new Unreachable();
        }

        @Override
        protected int computeHashCode() {
            return this.outline.hashCode();
        }

        @Override
        protected boolean computeEquals(Object other) {
            return this.outline.equals(other);
        }

        @Override
        public String toString(DexEncodedMethod method, ClassNameMapper naming) {
            return null;
        }
    }

    private class OutlineSourceCode
    implements SourceCode {
        private final Outline outline;
        private final DexMethod method;
        private int position;
        private int argumentMapIndex = 0;

        OutlineSourceCode(Outline outline, DexMethod method) {
            this.outline = outline;
            this.method = method;
        }

        @Override
        public int instructionCount() {
            return this.outline.templateInstructions.size() + 1;
        }

        @Override
        public int instructionIndex(int instructionOffset) {
            return instructionOffset;
        }

        @Override
        public int instructionOffset(int instructionIndex) {
            return instructionIndex;
        }

        @Override
        public DebugLocalInfo getIncomingLocalAtBlock(int register, int blockOffset) {
            return null;
        }

        @Override
        public DebugLocalInfo getIncomingLocal(int register) {
            return null;
        }

        @Override
        public DebugLocalInfo getOutgoingLocal(int register) {
            return null;
        }

        @Override
        public int traceInstruction(int instructionIndex, IRBuilder builder) {
            return instructionIndex == this.outline.templateInstructions.size() ? instructionIndex : -1;
        }

        @Override
        public void setUp() {
        }

        @Override
        public void clear() {
        }

        @Override
        public void buildPrelude(IRBuilder builder) {
            assert (builder.getPrototypeChanges().isEmpty());
            for (int i = 0; i < this.outline.argumentTypes.size(); ++i) {
                if (this.outline.argumentTypes.get(i).isBooleanType()) {
                    builder.addBooleanNonThisArgument(i);
                    continue;
                }
                TypeElement typeLattice = TypeElement.fromDexType(this.outline.argumentTypes.get(i), Nullability.maybeNull(), OutlinerImpl.this.appView);
                builder.addNonThisArgument(i, typeLattice);
            }
        }

        @Override
        public void buildBlockTransfer(IRBuilder builder, int predecessorOffset, int successorOffset, boolean isExceptional) {
            throw new Unreachable("Outliner does not support control flow");
        }

        @Override
        public void buildPostlude(IRBuilder builder) {
        }

        @Override
        public void buildInstruction(IRBuilder builder, int instructionIndex, boolean firstBlockInstruction) {
            if (instructionIndex == this.outline.templateInstructions.size()) {
                if (this.outline.returnType == ((OutlinerImpl)OutlinerImpl.this).dexItemFactory.voidType) {
                    builder.addReturn();
                } else {
                    builder.addReturn(this.outline.argumentCount());
                }
                return;
            }
            this.position = instructionIndex;
            this.argumentMapIndex = this.outline.templateInstructions.get(instructionIndex).createInstruction(builder, this.outline, this.argumentMapIndex);
        }

        @Override
        public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
            throw new Unreachable("Unexpected call to resolveAndBuildSwitch");
        }

        @Override
        public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
            throw new Unreachable("Unexpected call to resolveAndBuildNewArrayFilledData");
        }

        @Override
        public CatchHandlers<Integer> getCurrentCatchHandlers(IRBuilder builder) {
            return null;
        }

        @Override
        public int getMoveExceptionRegister(int instructionIndex) {
            throw new Unreachable();
        }

        @Override
        public Position getCanonicalDebugPositionAtOffset(int offset) {
            throw new Unreachable();
        }

        @Override
        public Position getCurrentPosition() {
            return ((Position.OutlinePosition.OutlinePositionBuilder)((Position.OutlinePosition.OutlinePositionBuilder)Position.OutlinePosition.builder().setLine(this.position)).setMethod(this.method)).build();
        }

        @Override
        public boolean verifyCurrentInstructionCanThrow() {
            return true;
        }

        @Override
        public boolean verifyLocalInScope(DebugLocalInfo local) {
            return true;
        }

        @Override
        public boolean verifyRegister(int register) {
            return true;
        }
    }

    private class OutlineRewriter
    extends OutlineSpotter {
        private final IRCode code;
        private final Set<Instruction> toRemove;
        private final Set<Instruction> invokesToOutlineMethods;
        int argumentsMapIndex;

        OutlineRewriter(IRCode code, List<Instruction> currentCandidateInstructions, Set<Instruction> toRemove, Set<Instruction> invokesToOutlineMethods) {
            super(code.context(), code, currentCandidateInstructions);
            this.code = code;
            this.toRemove = toRemove;
            this.invokesToOutlineMethods = invokesToOutlineMethods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removeMethodFromOutlineList(Outline outline) {
            Map map = OutlinerImpl.this.outlineSites;
            synchronized (map) {
                assert (ListUtils.removeFirstMatch((List)OutlinerImpl.this.outlineSites.get(outline), element -> element.getDefinition() == this.method.getDefinition()).isPresent());
            }
            return true;
        }

        @Override
        protected void handle(int start, int end, Outline outline) {
            DexMethod outlineMethod = (DexMethod)OutlinerImpl.this.generatedOutlines.get(outline);
            if (outlineMethod != null) {
                assert (this.removeMethodFromOutlineList(outline));
                ArrayList<Value> in = new ArrayList<Value>();
                Value returnValue = null;
                this.argumentsMapIndex = 0;
                Position.OutlineCallerPosition.OutlineCallerPositionBuilder positionBuilder = (Position.OutlineCallerPosition.OutlineCallerPositionBuilder)((Position.OutlineCallerPosition.OutlineCallerPositionBuilder)Position.OutlineCallerPosition.builder().setMethod(OutlinerImpl.this.appView.graphLens().getOriginalMethodSignature((DexMethod)this.method.getReference()))).setOutlineCallee(outlineMethod).setLine(0);
                Instruction lastInstruction = null;
                int outlinePositionIndex = 0;
                for (int i = start; i < end; ++i) {
                    Instruction current = (Instruction)this.currentCandidateInstructions.get(i);
                    if (current.isConstInstruction()) continue;
                    int currentPositionIndex = outlinePositionIndex++;
                    if (current.getPosition() != null && current.instructionInstanceCanThrow()) {
                        positionBuilder.addOutlinePosition(currentPositionIndex, current.getPosition());
                    }
                    List<Value> inValues = this.orderedInValues(current, returnValue);
                    for (Value value : inValues) {
                        int argumentIndex;
                        value.removeUser(current);
                        if ((argumentIndex = outline.argumentMap.get(this.argumentsMapIndex++).intValue()) < in.size()) continue;
                        assert (argumentIndex == in.size());
                        in.add(value);
                    }
                    if (current.outValue() != null) {
                        returnValue = current.outValue();
                    }
                    if (i < end - 1) {
                        this.toRemove.add(current);
                    }
                    lastInstruction = current;
                }
                assert (lastInstruction != null);
                assert (outlineMethod.proto.shorty.toString().length() - 1 == in.size());
                if (returnValue != null && !returnValue.isUsed()) {
                    returnValue = null;
                }
                InvokeStatic outlineInvoke = new InvokeStatic(outlineMethod, returnValue, in);
                outlineInvoke.setBlock(lastInstruction.getBlock());
                outlineInvoke.setPosition(positionBuilder.hasOutlinePositions() ? positionBuilder.build() : Position.syntheticNone());
                InstructionListIterator endIterator = lastInstruction.getBlock().listIterator(this.code, lastInstruction);
                Instruction instructionBeforeEnd = (Instruction)endIterator.previous();
                assert (instructionBeforeEnd == lastInstruction);
                endIterator.set(outlineInvoke);
                this.invokesToOutlineMethods.add(outlineInvoke);
            }
        }
    }

    private class OutlineSiteIdentifier
    extends OutlineSpotter {
        OutlineSiteIdentifier(ProgramMethod method, IRCode irCode, List<Instruction> currentCandidateInstructions) {
            super(method, irCode, currentCandidateInstructions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handle(int start, int end, Outline outline) {
            Map map = OutlinerImpl.this.outlineSites;
            synchronized (map) {
                OutlinerImpl.this.outlineSites.computeIfAbsent(outline, k -> new ArrayList()).add(this.method);
            }
        }
    }

    private class OutlineMethodIdentifier
    extends OutlineSpotter {
        private final List<Outline> outlinesForMethod;

        OutlineMethodIdentifier(ProgramMethod method, IRCode irCode, List<Instruction> currentCandidateInstructions, List<Outline> outlinesForMethod) {
            super(method, irCode, currentCandidateInstructions);
            this.outlinesForMethod = outlinesForMethod;
        }

        @Override
        protected void handle(int start, int end, Outline outline) {
            this.outlinesForMethod.add(outline);
        }
    }

    private abstract class OutlineSpotter {
        final ProgramMethod method;
        final IRCode irCode;
        final List<Instruction> currentCandidateInstructions;
        int start;
        int index;
        int actualInstructions;
        List<Value> arguments;
        List<DexType> argumentTypes;
        List<Integer> argumentsMap;
        int argumentRegisters;
        DexType returnType;
        Value returnValue;
        int returnValueUniqueUsersLeft;
        int pendingNewInstanceIndex = -1;

        OutlineSpotter(ProgramMethod method, IRCode irCode, List<Instruction> currentCandidateInstructions) {
            this.method = method;
            this.irCode = irCode;
            this.currentCandidateInstructions = currentCandidateInstructions;
            this.reset(0);
        }

        private void processInstruction(Instruction instruction) {
            boolean include;
            int instructionIncrement = 1;
            if (instruction.isConstInstruction()) {
                if (this.index == this.start) {
                    this.reset(this.index + 1);
                    return;
                }
                include = true;
                instructionIncrement = 0;
            } else if (instruction.isAssume()) {
                include = true;
                instructionIncrement = 0;
            } else {
                include = this.canIncludeInstruction(instruction);
            }
            if (include) {
                this.actualInstructions += instructionIncrement;
                this.includeInstruction(instruction);
                if (this.actualInstructions >= ((OutlinerImpl)OutlinerImpl.this).appView.options().outline.maxSize) {
                    this.candidate(this.start, this.index + 1);
                } else {
                    ++this.index;
                }
            } else if (this.index > this.start) {
                this.candidate(this.start, this.index);
            } else {
                this.reset(this.index + 1);
            }
        }

        private boolean canIncludeInstruction(Instruction instruction) {
            int returnValueUniqueUsersLeftIfIncluded = this.returnValueUniqueUsersLeft;
            if (this.returnValue != null && Iterables.any(instruction.inValues(), value -> value.getAliasedValue() == this.returnValue)) {
                --returnValueUniqueUsersLeftIfIncluded;
            }
            if (instruction.outValue() != null && returnValueUniqueUsersLeftIfIncluded > 0) {
                return false;
            }
            if (instruction.isNewInstance()) {
                if (instruction.outValue().isUsed()) {
                    this.pendingNewInstanceIndex = this.index;
                }
                return true;
            }
            if (instruction.isArithmeticBinop()) {
                return true;
            }
            if (!instruction.isInvokeMethod()) {
                return false;
            }
            InvokeMethod invoke = instruction.asInvokeMethod();
            boolean constructor = OutlinerImpl.this.dexItemFactory.isConstructor(invoke.getInvokedMethod());
            Inliner.ConstraintWithTarget constraint = invoke.inliningConstraint(OutlinerImpl.this.inliningConstraints, this.method);
            if (constraint != Inliner.ConstraintWithTarget.ALWAYS) {
                return false;
            }
            int newArgumentRegisters = this.argumentRegisters;
            if (invoke.hasArguments()) {
                for (int i = 0; i < invoke.arguments().size(); ++i) {
                    Value value2 = invoke.getArgument(i).getAliasedValue();
                    if (value2 == this.returnValue) continue;
                    if (!this.supportedArgumentType(value2)) {
                        return false;
                    }
                    if (invoke.isInvokeStatic()) {
                        newArgumentRegisters += value2.requiredRegisters();
                        continue;
                    }
                    Value receiver = invoke.asInvokeMethodWithReceiver().getReceiver().getAliasedValue();
                    if (value2 == receiver && this.arguments.contains(value2)) continue;
                    newArgumentRegisters += value2.requiredRegisters();
                }
            }
            if (newArgumentRegisters > 5) {
                return false;
            }
            if (constructor) {
                Instruction previous;
                if (this.start == this.index) {
                    return false;
                }
                assert (this.index > 0);
                int offset = 0;
                while ((previous = this.currentCandidateInstructions.get(this.index - ++offset)).isConstInstruction()) {
                }
                if (!previous.isNewInstance() || invoke != previous.asNewInstance().getUniqueConstructorInvoke(OutlinerImpl.this.dexItemFactory)) {
                    return false;
                }
                if (this.returnValue == null || this.returnValue != previous.outValue()) {
                    assert (false);
                    return false;
                }
                this.pendingNewInstanceIndex = -1;
            }
            return true;
        }

        private DexType argumentTypeFromInvoke(InvokeMethod invoke, int index) {
            boolean withReceiver;
            boolean bl = withReceiver = invoke.isInvokeMethodWithReceiver() || invoke.isInvokePolymorphic();
            if (withReceiver && index == 0) {
                return invoke.getInvokedMethod().holder;
            }
            DexProto methodProto = invoke.isInvokePolymorphic() ? invoke.asInvokePolymorphic().getProto() : invoke.getInvokedMethod().proto;
            return methodProto.parameters.values[index - (withReceiver ? 1 : 0)];
        }

        private boolean supportedArgumentType(Value value) {
            if (!value.getType().isArrayType()) {
                return true;
            }
            if (((OutlinerImpl)OutlinerImpl.this).appView.options().testing.allowOutlinerInterfaceArrayArguments && OutlinerImpl.this.appView.options().isGeneratingClassFiles()) {
                return true;
            }
            ArrayTypeElement arrayType = value.getType().asArrayType();
            TypeElement arrayBaseType = arrayType.getBaseType();
            if (arrayBaseType.isPrimitiveType()) {
                return true;
            }
            if (arrayBaseType.isClassType()) {
                return arrayBaseType.asClassType().getInterfaces().isEmpty();
            }
            return false;
        }

        private DexType argumentTypeFromValue(Value value, InvokeMethod invoke, int argumentIndex) {
            assert (this.supportedArgumentType(value));
            DexItemFactory itemFactory = ((OutlinerImpl)OutlinerImpl.this).appView.options().itemFactory;
            DexType objectType = itemFactory.objectType;
            TypeElement valueType = value.getType();
            if (valueType.isClassType()) {
                ClassTypeElement valueClassType = value.getType().asClassType();
                if (valueClassType.getClassType() == objectType && valueClassType.getInterfaces().hasSingleKnownInterface()) {
                    return valueClassType.getInterfaces().getSingleKnownInterface();
                }
                return valueClassType.getClassType();
            }
            if (valueType.isArrayType()) {
                return value.getType().asArrayType().toDexType(itemFactory);
            }
            if (valueType.isNullType()) {
                return this.argumentTypeFromInvoke(invoke, argumentIndex);
            }
            assert (valueType.isPrimitiveType());
            assert (valueType.asPrimitiveType().hasDexType());
            DexType type = valueType.asPrimitiveType().toDexType(itemFactory);
            if (valueType.isInt()) {
                assert (type == itemFactory.intType);
                type = this.argumentTypeFromInvoke(invoke, argumentIndex);
            } else assert (type == this.argumentTypeFromInvoke(invoke, argumentIndex));
            return type;
        }

        private void includeInstruction(Instruction instruction) {
            if (instruction.isAssume()) {
                Assume assume = instruction.asAssume();
                if (this.returnValue != null && assume.src().getAliasedValue() == this.returnValue) {
                    this.adjustReturnValueUsersLeft(assume.outValue().numberOfAllUsers() - 1);
                }
                return;
            }
            List<Value> inValues = this.orderedInValues(instruction, this.returnValue);
            Value prevReturnValue = this.returnValue;
            if (this.returnValue != null) {
                for (Value value : inValues) {
                    if (value.getAliasedValue() != this.returnValue) continue;
                    this.adjustReturnValueUsersLeft(-1);
                }
            }
            if (instruction.isNewInstance()) {
                assert (this.returnValue == null);
                this.updateReturnValueState(instruction.outValue(), instruction.asNewInstance().clazz);
                return;
            }
            assert (instruction.isInvoke() || instruction.isConstInstruction() || instruction.isArithmeticBinop());
            if (inValues.size() > 0) {
                for (int i = 0; i < inValues.size(); ++i) {
                    Value value;
                    value = inValues.get(i).getAliasedValue();
                    if (value == prevReturnValue) {
                        this.argumentsMap.add(-1);
                        continue;
                    }
                    if (instruction.isInvokeMethodWithReceiver() || instruction.isInvokePolymorphic()) {
                        int argumentIndex = this.arguments.indexOf(value);
                        if (i == 0 && argumentIndex != -1) {
                            this.argumentsMap.add(argumentIndex);
                            continue;
                        }
                        this.arguments.add(value);
                        this.argumentRegisters += value.requiredRegisters();
                        this.argumentTypes.add(this.argumentTypeFromValue(value, instruction.asInvokeMethod(), i));
                        this.argumentsMap.add(this.argumentTypes.size() - 1);
                        continue;
                    }
                    this.arguments.add(value);
                    if (instruction.isInvokeMethod()) {
                        this.argumentTypes.add(this.argumentTypeFromValue(value, instruction.asInvokeMethod(), i));
                    } else {
                        this.argumentTypes.add(instruction.asBinop().getNumericType().dexTypeFor(OutlinerImpl.this.dexItemFactory));
                    }
                    this.argumentsMap.add(this.argumentTypes.size() - 1);
                }
            }
            if (!instruction.isConstInstruction() && instruction.outValue() != null) {
                assert (this.returnValue == null);
                if (instruction.isInvokeMethod()) {
                    this.updateReturnValueState(instruction.outValue(), instruction.asInvokeMethod().getInvokedMethod().proto.returnType);
                } else {
                    this.updateReturnValueState(instruction.outValue(), instruction.asBinop().getNumericType().dexTypeFor(OutlinerImpl.this.dexItemFactory));
                }
            }
        }

        private void updateReturnValueState(Value newReturnValue, DexType newReturnType) {
            this.returnValueUniqueUsersLeft = newReturnValue.numberOfAllUsers();
            if (this.returnValueUniqueUsersLeft == 0) {
                this.returnValue = null;
                this.returnType = ((OutlinerImpl)OutlinerImpl.this).dexItemFactory.voidType;
            } else {
                this.returnValue = newReturnValue;
                this.returnType = newReturnType;
            }
        }

        private void adjustReturnValueUsersLeft(int change) {
            this.returnValueUniqueUsersLeft += change;
            assert (this.returnValueUniqueUsersLeft >= 0);
            if (this.returnValueUniqueUsersLeft == 0) {
                this.returnValue = null;
                this.returnType = ((OutlinerImpl)OutlinerImpl.this).dexItemFactory.voidType;
            }
        }

        private void candidate(int start, int index) {
            assert (!this.currentCandidateInstructions.get(start).isConstInstruction());
            if (this.pendingNewInstanceIndex != -1) {
                if (this.pendingNewInstanceIndex == start) {
                    this.reset(index);
                } else {
                    this.reset(this.pendingNewInstanceIndex);
                }
                return;
            }
            int end = index;
            while (this.currentCandidateInstructions.get(end - 1).isConstInstruction()) {
                --end;
            }
            if (this.actualInstructions < ((OutlinerImpl)OutlinerImpl.this).appView.options().outline.minSize) {
                this.reset(start + 1);
                return;
            }
            Outline outline = new Outline(this.currentCandidateInstructions, this.argumentTypes, this.argumentsMap, this.returnType, start, end);
            this.handle(start, end, outline);
            this.reset(index);
        }

        private void reset(int startIndex) {
            this.start = startIndex;
            this.index = startIndex;
            this.actualInstructions = 0;
            this.arguments = new ArrayList<Value>(5);
            this.argumentTypes = new ArrayList<DexType>(5);
            this.argumentsMap = new ArrayList<Integer>(5);
            this.argumentRegisters = 0;
            this.returnType = ((OutlinerImpl)OutlinerImpl.this).dexItemFactory.voidType;
            this.returnValue = null;
            this.returnValueUniqueUsersLeft = 0;
            this.pendingNewInstanceIndex = -1;
        }

        protected void process() {
            while (this.index < this.currentCandidateInstructions.size()) {
                this.processInstruction(this.currentCandidateInstructions.get(this.index));
            }
            if (this.actualInstructions > 0) {
                this.candidate(this.start, this.index);
            }
        }

        protected List<Value> orderedInValues(Instruction instruction, Value returnValue) {
            List<Value> inValues = instruction.inValues();
            if (instruction.isBinop() && instruction.asBinop().isCommutative() && inValues.get(1) == returnValue) {
                Value tmp = inValues.get(0);
                inValues.set(0, inValues.get(1));
                inValues.set(1, tmp);
            }
            return inValues;
        }

        protected abstract void handle(int var1, int var2, Outline var3);
    }

    public class Outline
    implements Comparable<Outline> {
        final List<DexType> argumentTypes;
        final List<Integer> argumentMap;
        final List<OutlineInstruction> templateInstructions = new ArrayList<OutlineInstruction>();
        public final DexType returnType;
        private DexProto proto;

        Outline(List<Instruction> instructions, List<DexType> argumentTypes, List<Integer> argumentMap, DexType returnType, int start, int end) {
            this.argumentTypes = argumentTypes;
            this.argumentMap = argumentMap;
            this.returnType = returnType;
            for (int i = start; i < end; ++i) {
                Instruction current = instructions.get(i);
                if (current.isInvoke() || current.isNewInstance() || current.isArithmeticBinop()) {
                    this.templateInstructions.add(OutlineInstruction.fromInstruction(current));
                    continue;
                }
                if (!current.isConstInstruction() && !current.isAssume()) assert (false) : "Unexpected type of instruction in outlining template.";
            }
        }

        private boolean needsLensRewriting(GraphLens currentGraphLens) {
            for (DexType argumentType : this.argumentTypes) {
                if (currentGraphLens.lookupType(argumentType) == argumentType) continue;
                return true;
            }
            if (currentGraphLens.lookupType(this.returnType) != this.returnType) {
                return true;
            }
            return Iterables.any(this.templateInstructions, templateInstruction -> templateInstruction.needsLensRewriting(currentGraphLens));
        }

        int argumentCount() {
            return this.argumentTypes.size();
        }

        DexProto buildProto() {
            if (this.proto == null) {
                DexType[] argumentTypesArray = this.argumentTypes.toArray(DexType.EMPTY_ARRAY);
                this.proto = OutlinerImpl.this.dexItemFactory.createProto(this.returnType, argumentTypesArray);
            }
            return this.proto;
        }

        public Outline rewrittenWithLens(GraphLens currentGraphLens) {
            if (this.needsLensRewriting(currentGraphLens)) {
                return null;
            }
            return this;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Outline)) {
                return false;
            }
            Outline otherOutline = (Outline)other;
            List<OutlineInstruction> instructions0 = this.templateInstructions;
            List<OutlineInstruction> instructions1 = otherOutline.templateInstructions;
            if (instructions0.size() != instructions1.size()) {
                return false;
            }
            for (int i = 0; i < instructions0.size(); ++i) {
                OutlineInstruction i1;
                OutlineInstruction i0 = instructions0.get(i);
                if (i0.equals(i1 = instructions1.get(i))) continue;
                return false;
            }
            return this.argumentTypes.equals(otherOutline.argumentTypes) && this.argumentMap.equals(otherOutline.argumentMap) && this.returnType == otherOutline.returnType;
        }

        public int hashCode() {
            int MAX_HASH_INSTRUCTIONS = 5;
            int hash = this.templateInstructions.size();
            int hashPart = 0;
            for (int i = 0; i < this.templateInstructions.size() && i < 5; ++i) {
                OutlineInstruction instruction = this.templateInstructions.get(i);
                hashPart <<= 4;
                hash = hash * 3 + (hashPart += instruction.hashCode());
            }
            return hash;
        }

        @Override
        public int compareTo(Outline other) {
            int i;
            if (this == other) {
                return 0;
            }
            int result = this.buildProto().compareTo(other.buildProto());
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            assert (this.argumentCount() == other.argumentCount());
            List<OutlineInstruction> instructions0 = this.templateInstructions;
            List<OutlineInstruction> instructions1 = other.templateInstructions;
            result = instructions0.size() - instructions1.size();
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            for (i = 0; i < instructions0.size(); ++i) {
                OutlineInstruction i1;
                OutlineInstruction i0 = instructions0.get(i);
                result = i0.compareTo(i1 = instructions1.get(i));
                if (result == 0) continue;
                assert (!i0.equals(i1));
                return result;
            }
            result = this.argumentMap.size() - other.argumentMap.size();
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            for (i = 0; i < this.argumentMap.size(); ++i) {
                result = this.argumentMap.get(i) - other.argumentMap.get(i);
                if (result == 0) continue;
                assert (!this.equals(other));
                return result;
            }
            assert (this.equals(other));
            return 0;
        }

        public String toString() {
            int outRegisterNumber = this.argumentTypes.size();
            StringBuilder builder = new StringBuilder();
            builder.append(this.returnType);
            builder.append(" anOutline");
            StringUtils.append(builder, this.argumentTypes, ", ", StringUtils.BraceType.PARENS);
            builder.append("\n");
            int argumentMapIndex = 0;
            for (OutlineInstruction instruction : this.templateInstructions) {
                builder.append(instruction.toString());
                String name = instruction.getInstructionName();
                StringUtils.appendRightPadded(builder, name, 20);
                if (instruction.hasOutValue()) {
                    builder.append("v" + outRegisterNumber);
                    builder.append(" <- ");
                }
                for (int i = 0; i < instruction.numberOfInputs(); ++i) {
                    builder.append(i > 0 ? ", " : "");
                    builder.append("v");
                    int index = this.argumentMap.get(argumentMapIndex++);
                    if (index >= 0) {
                        builder.append(index);
                        continue;
                    }
                    builder.append(outRegisterNumber);
                }
                builder.append(instruction.getDetailsString());
                builder.append("\n");
            }
            if (this.returnType == ((OutlinerImpl)OutlinerImpl.this).dexItemFactory.voidType) {
                builder.append("Return-Void");
            } else {
                StringUtils.appendRightPadded(builder, "Return", 20);
                builder.append("v" + outRegisterNumber);
            }
            builder.append("\n");
            builder.append(this.argumentMap);
            return builder.toString();
        }
    }

    private static class InvokeOutlineInstruction
    extends OutlineInstruction {
        private final DexMethod method;
        private final Invoke.Type invokeType;
        private final boolean hasOutValue;
        private final DexProto proto;
        private final boolean hasReceiver;

        private InvokeOutlineInstruction(DexMethod method, Invoke.Type type, boolean hasOutValue, ValueType[] inputTypes, DexProto proto) {
            super(OutlineInstruction.OutlineInstructionType.INVOKE);
            boolean bl = this.hasReceiver = inputTypes.length != method.proto.parameters.values.length;
            assert (!this.hasReceiver || inputTypes[0].isObject());
            this.method = method;
            this.invokeType = type;
            this.hasOutValue = hasOutValue;
            this.proto = proto;
        }

        static InvokeOutlineInstruction fromInstruction(InvokeMethod invoke) {
            ValueType[] inputTypes = new ValueType[invoke.inValues().size()];
            int i = 0;
            for (Value value : invoke.inValues()) {
                inputTypes[i++] = value.outType();
            }
            return new InvokeOutlineInstruction(invoke.getInvokedMethod(), invoke.getType(), invoke.outValue() != null, inputTypes, invoke.isInvokePolymorphic() ? invoke.asInvokePolymorphic().getProto() : null);
        }

        private ValueTypeConstraint getArgumentConstraint(int index) {
            if (this.hasReceiver) {
                return index == 0 ? ValueTypeConstraint.OBJECT : ValueTypeConstraint.fromDexType(this.method.proto.parameters.values[index - 1]);
            }
            return ValueTypeConstraint.fromDexType(this.method.proto.parameters.values[index]);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 7 + this.method.hashCode() * 13 + this.invokeType.hashCode() + Boolean.hashCode(this.hasOutValue) + Objects.hashCode(this.proto);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof InvokeOutlineInstruction)) {
                return false;
            }
            InvokeOutlineInstruction o = (InvokeOutlineInstruction)other;
            return this.method == o.method && this.invokeType == o.invokeType && this.hasOutValue == o.hasOutValue && Objects.equals(this.proto, o.proto);
        }

        @Override
        public int compareTo(OutlineInstruction other) {
            if (!(other instanceof InvokeOutlineInstruction)) {
                return super.compareTo(other);
            }
            InvokeOutlineInstruction o = (InvokeOutlineInstruction)other;
            int result = this.method.compareTo(o.method);
            if (result != 0) {
                return result;
            }
            result = this.invokeType.compareTo(o.invokeType);
            if (result != 0) {
                return result;
            }
            result = Boolean.compare(this.hasOutValue, o.hasOutValue);
            if (result != 0) {
                return result;
            }
            if (this.proto != null && (result = this.proto.compareTo(o.proto)) != 0) {
                return result;
            }
            assert (this.equals(other));
            return 0;
        }

        @Override
        public String getDetailsString() {
            return "; method: " + this.method.toSourceString();
        }

        @Override
        public String getInstructionName() {
            return this.type.name() + "-" + this.invokeType.name();
        }

        @Override
        public boolean hasOutValue() {
            return this.hasOutValue;
        }

        @Override
        public int numberOfInputs() {
            return (this.hasReceiver ? 1 : 0) + this.method.proto.parameters.values.length;
        }

        @Override
        public int createInstruction(IRBuilder builder, Outline outline, int argumentMapIndex) {
            ArrayList<Value> inValues = new ArrayList<Value>(this.numberOfInputs());
            for (int i = 0; i < this.numberOfInputs(); ++i) {
                int register;
                if ((register = outline.argumentMap.get(argumentMapIndex++).intValue()) == -1) {
                    register = outline.argumentCount();
                }
                inValues.add(builder.readRegister(register, this.getArgumentConstraint(i)));
            }
            Value outValue = null;
            if (this.hasOutValue) {
                TypeElement latticeElement = TypeElement.fromDexType(this.method.proto.returnType, Nullability.maybeNull(), builder.appView);
                outValue = builder.writeRegister(outline.argumentCount(), latticeElement, BasicBlock.ThrowingInfo.CAN_THROW);
            }
            Invoke newInstruction = Invoke.create(this.invokeType, this.method, this.proto, outValue, inValues);
            builder.add(newInstruction);
            return argumentMapIndex;
        }

        @Override
        public boolean needsLensRewriting(GraphLens currentGraphLens) {
            return currentGraphLens.getRenamedMethodSignature(this.method) != this.method;
        }
    }

    private static class NewInstanceOutlineInstruction
    extends OutlineInstruction {
        private final DexType clazz;

        NewInstanceOutlineInstruction(DexType clazz) {
            super(OutlineInstruction.OutlineInstructionType.NEW);
            this.clazz = clazz;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof NewInstanceOutlineInstruction)) {
                return false;
            }
            NewInstanceOutlineInstruction o = (NewInstanceOutlineInstruction)other;
            boolean result = this.clazz == o.clazz;
            return result;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 7 + this.clazz.hashCode();
        }

        @Override
        public int compareTo(OutlineInstruction other) {
            if (!(other instanceof NewInstanceOutlineInstruction)) {
                return super.compareTo(other);
            }
            NewInstanceOutlineInstruction o = (NewInstanceOutlineInstruction)other;
            return this.clazz.compareTo(o.clazz);
        }

        @Override
        public String getDetailsString() {
            return this.clazz.toSourceString();
        }

        @Override
        public String getInstructionName() {
            return this.type.name();
        }

        @Override
        public boolean hasOutValue() {
            return true;
        }

        @Override
        public int numberOfInputs() {
            return 0;
        }

        @Override
        public int createInstruction(IRBuilder builder, Outline outline, int argumentMapIndex) {
            TypeElement latticeElement = TypeElement.fromDexType(this.clazz, Nullability.definitelyNotNull(), builder.appView);
            Value outValue = builder.writeRegister(outline.argumentCount(), latticeElement, BasicBlock.ThrowingInfo.CAN_THROW);
            NewInstance newInstruction = new NewInstance(this.clazz, outValue);
            builder.add(newInstruction);
            return argumentMapIndex;
        }

        @Override
        public boolean needsLensRewriting(GraphLens currentGraphLens) {
            return currentGraphLens.lookupType(this.clazz) != this.clazz;
        }
    }

    private static class BinOpOutlineInstruction
    extends OutlineInstruction {
        private final NumericType numericType;

        private BinOpOutlineInstruction(OutlineInstruction.OutlineInstructionType type, NumericType numericType) {
            super(type);
            this.numericType = numericType;
        }

        static BinOpOutlineInstruction fromInstruction(Binop instruction) {
            return new BinOpOutlineInstruction(OutlineInstruction.OutlineInstructionType.fromInstruction(instruction), instruction.getNumericType());
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 7 + this.numericType.ordinal();
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof BinOpOutlineInstruction)) {
                return false;
            }
            BinOpOutlineInstruction o = (BinOpOutlineInstruction)other;
            return o.type.equals((Object)this.type) && o.numericType.equals((Object)this.numericType);
        }

        @Override
        public int compareTo(OutlineInstruction other) {
            if (!(other instanceof BinOpOutlineInstruction)) {
                return super.compareTo(other);
            }
            BinOpOutlineInstruction o = (BinOpOutlineInstruction)other;
            int result = this.type.compareTo(o.type);
            if (result != 0) {
                return result;
            }
            return this.numericType.compareTo(o.numericType);
        }

        @Override
        public String getDetailsString() {
            return "";
        }

        @Override
        public String getInstructionName() {
            return this.type.name() + "-" + this.numericType.name();
        }

        @Override
        public boolean hasOutValue() {
            return true;
        }

        @Override
        public int numberOfInputs() {
            return 2;
        }

        @Override
        public int createInstruction(IRBuilder builder, Outline outline, int argumentMapIndex) {
            ArrayList<Value> inValues = new ArrayList<Value>(this.numberOfInputs());
            for (int i = 0; i < this.numberOfInputs(); ++i) {
                int register;
                if ((register = outline.argumentMap.get(argumentMapIndex++).intValue()) == -1) {
                    register = outline.argumentCount();
                }
                inValues.add(builder.readRegister(register, ValueTypeConstraint.fromNumericType(this.numericType)));
            }
            PrimitiveTypeElement latticeElement = PrimitiveTypeElement.fromNumericType(this.numericType);
            Value outValue = builder.writeRegister(outline.argumentCount(), latticeElement, BasicBlock.ThrowingInfo.CAN_THROW);
            ArithmeticBinop newInstruction = null;
            switch (this.type) {
                case ADD: {
                    newInstruction = new Add(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                case MUL: {
                    newInstruction = new Mul(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                case SUB: {
                    newInstruction = new Sub(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                case DIV: {
                    newInstruction = new Div(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                case REM: {
                    newInstruction = new Rem(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                default: {
                    throw new Unreachable("Invalid binary operation type: " + (Object)((Object)this.type));
                }
            }
            builder.add(newInstruction);
            return argumentMapIndex;
        }

        @Override
        public boolean needsLensRewriting(GraphLens currentGraphLens) {
            return false;
        }
    }

    private static abstract class OutlineInstruction {
        private static final int OUTLINE_TEMP = -1;
        protected final OutlineInstructionType type;

        protected OutlineInstruction(OutlineInstructionType type) {
            this.type = type;
        }

        static OutlineInstruction fromInstruction(Instruction instruction) {
            if (instruction.isBinop()) {
                return BinOpOutlineInstruction.fromInstruction(instruction.asBinop());
            }
            if (instruction.isNewInstance()) {
                return new NewInstanceOutlineInstruction(instruction.asNewInstance().clazz);
            }
            assert (instruction.isInvokeMethod());
            return InvokeOutlineInstruction.fromInstruction(instruction.asInvokeMethod());
        }

        public int hashCode() {
            return this.type.ordinal();
        }

        public int compareTo(OutlineInstruction other) {
            return this.type.compareTo(other.type);
        }

        public abstract boolean equals(Object var1);

        public abstract String getDetailsString();

        public abstract String getInstructionName();

        public abstract boolean hasOutValue();

        public abstract int numberOfInputs();

        public abstract int createInstruction(IRBuilder var1, Outline var2, int var3);

        public abstract boolean needsLensRewriting(GraphLens var1);

        public static enum OutlineInstructionType {
            ADD,
            SUB,
            MUL,
            DIV,
            REM,
            INVOKE,
            NEW;


            static OutlineInstructionType fromInstruction(Instruction instruction) {
                if (instruction.isAdd()) {
                    return ADD;
                }
                if (instruction.isSub()) {
                    return SUB;
                }
                if (instruction.isMul()) {
                    return MUL;
                }
                if (instruction.isDiv()) {
                    return DIV;
                }
                if (instruction.isRem()) {
                    return REM;
                }
                if (instruction.isInvokeMethod()) {
                    return INVOKE;
                }
                if (instruction.isNewInstance()) {
                    return NEW;
                }
                throw new Unreachable();
            }
        }
    }
}

