/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.BasicBlockInstructionsEquivalence;
import com.android.tools.r8.ir.optimize.InstructionEquivalence;
import com.android.tools.r8.ir.optimize.MoveEliminator;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class PeepholeOptimizer {
    public static void optimize(AppView<?> appView, IRCode code, LinearScanRegisterAllocator allocator) {
        PeepholeOptimizer.removeIdenticalPredecessorBlocks(code, allocator);
        PeepholeOptimizer.removeRedundantInstructions(code, allocator);
        PeepholeOptimizer.shareIdenticalBlockPrefix(code, allocator);
        PeepholeOptimizer.shareIdenticalBlockSuffix(code, allocator, 0);
        assert (code.isConsistentGraph(appView));
    }

    private static void shareIdenticalBlockPrefix(IRCode code, RegisterAllocator allocator) {
        InstructionEquivalence equivalence = new InstructionEquivalence(allocator, code);
        Set<BasicBlock> blocksToBeRemoved = Sets.newIdentityHashSet();
        for (BasicBlock block : code.blocks) {
            PeepholeOptimizer.shareIdenticalBlockPrefixFromNormalSuccessors(block, allocator, blocksToBeRemoved, equivalence);
        }
        code.blocks.removeAll(blocksToBeRemoved);
    }

    /*
     * Unable to fully structure code
     */
    private static void shareIdenticalBlockPrefixFromNormalSuccessors(BasicBlock block, RegisterAllocator allocator, Set<BasicBlock> blocksToBeRemoved, InstructionEquivalence equivalence) {
        if (blocksToBeRemoved.contains(block)) {
            return;
        }
        if (!PeepholeOptimizer.mayShareIdenticalBlockPrefix(block)) {
            return;
        }
        normalSuccessors = block.getNormalSuccessors();
        block0: while (true) {
            firstNormalSuccessor = normalSuccessors.get(0);
            for (BasicBlock normalSuccessor : normalSuccessors) {
                if (!normalSuccessor.isEmpty()) continue;
                if (!PeepholeOptimizer.$assertionsDisabled && !blocksToBeRemoved.containsAll(normalSuccessors)) {
                    throw new AssertionError();
                }
                return;
            }
            instruction = firstNormalSuccessor.entry();
            for (i = 1; i < normalSuccessors.size(); ++i) {
                otherNormalSuccessor = normalSuccessors.get(i);
                otherInstruction = otherNormalSuccessor.entry();
                if (equivalence.doEquivalent(instruction, otherInstruction)) continue;
                return;
            }
            if (instruction.instructionTypeCanThrow()) {
                if (block.hasCatchHandlers()) {
                    return;
                }
                for (BasicBlock normalSuccessor : normalSuccessors) {
                    if (!normalSuccessor.hasCatchHandlers()) continue;
                    return;
                }
            }
            if (instruction.outValue() != null && instruction.outValue().needsRegister()) {
                destinationRegister = allocator.getRegisterForValue(instruction.outValue(), instruction.getNumber());
                commutative = block.exit().inValues().stream().allMatch((Predicate<Value>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$shareIdenticalBlockPrefixFromNormalSuccessors$0(com.android.tools.r8.ir.regalloc.RegisterAllocator com.android.tools.r8.ir.code.BasicBlock com.android.tools.r8.ir.code.Instruction int com.android.tools.r8.ir.code.Value ), (Lcom/android/tools/r8/ir/code/Value;)Z)((RegisterAllocator)allocator, (BasicBlock)block, (Instruction)instruction, (int)destinationRegister));
                if (!commutative) {
                    return;
                }
            }
            if (!(instruction.getPosition().equals(block.exit().getPosition()) || block.exit().getPosition().isNone() && !block.exit().getDebugValues().isEmpty())) {
                return;
            }
            for (BasicBlock normalSuccessor : normalSuccessors) {
                normalSuccessor.getInstructions().removeFirst();
            }
            if (instruction.isJumpInstruction()) {
                instructions = block.getInstructions();
                instructions.removeLast();
                instructions.add(instruction);
                instruction.setBlock(block);
                oldNormalSuccessors = new ArrayList<BasicBlock>(normalSuccessors);
                block.detachAllSuccessors();
                for (BasicBlock newNormalSuccessor : firstNormalSuccessor.getNormalSuccessors()) {
                    block.link(newNormalSuccessor);
                }
                for (BasicBlock oldNormalSuccessor : oldNormalSuccessors) {
                    oldNormalSuccessor.detachAllSuccessors();
                }
                blocksToBeRemoved.addAll(oldNormalSuccessors);
                if (PeepholeOptimizer.mayShareIdenticalBlockPrefix(block)) continue;
                return;
            }
            block.getInstructions().listIterator(block.getInstructions().size() - 1).add(instruction);
            instruction.setBlock(block);
            if (!instruction.isDebugLocalsChange()) continue;
            localsChange = instruction.asDebugLocalsChange();
            var8_16 = normalSuccessors.iterator();
            while (true) {
                if (var8_16.hasNext()) ** break;
                continue block0;
                normalSuccessor = var8_16.next();
                localsChange.apply(normalSuccessor.getLocalsAtEntry());
            }
            break;
        }
    }

    private static boolean mayShareIdenticalBlockPrefix(BasicBlock block) {
        List<BasicBlock> normalSuccessors = block.getNormalSuccessors();
        if (normalSuccessors.size() <= 1) {
            return false;
        }
        for (BasicBlock normalSuccessor : normalSuccessors) {
            if (normalSuccessor.getPredecessors().size() == 1) continue;
            return false;
        }
        BasicBlock firstNormalSuccessor = normalSuccessors.get(0);
        for (int i = 1; i < normalSuccessors.size(); ++i) {
            BasicBlock otherNormalSuccessor = normalSuccessors.get(i);
            if (Objects.equals(firstNormalSuccessor.getLocalsAtEntry(), otherNormalSuccessor.getLocalsAtEntry())) continue;
            return false;
        }
        return true;
    }

    public static void shareIdenticalBlockSuffix(IRCode code, RegisterAllocator allocator, int overhead) {
        IdentityHashMap<BasicBlock, BasicBlock> newBlocks;
        Collection<BasicBlock> blocks = code.blocks;
        BasicBlock normalExit = null;
        List<BasicBlock> normalExits = code.computeNormalExitBlocks();
        if (normalExits.size() > 1) {
            normalExit = new BasicBlock();
            normalExit.getMutablePredecessors().addAll(normalExits);
            blocks = new ArrayList<BasicBlock>(code.blocks);
            blocks.add(normalExit);
        }
        do {
            newBlocks = new IdentityHashMap<BasicBlock, BasicBlock>();
            for (BasicBlock block : blocks) {
                InstructionEquivalence equivalence = new InstructionEquivalence(allocator, code);
                HashMap<Equivalence.Wrapper, List> lastInstructionToBlocks = new HashMap<Equivalence.Wrapper, List>();
                for (BasicBlock pred : block.getPredecessors()) {
                    if (pred.exit().isGoto() && pred.getSuccessors().size() == 1 && pred.getInstructions().size() > 1) {
                        LinkedList<Instruction> instructions = pred.getInstructions();
                        Instruction lastInstruction = (Instruction)instructions.get(instructions.size() - 2);
                        List value = lastInstructionToBlocks.computeIfAbsent(equivalence.wrap(lastInstruction), k -> new ArrayList());
                        value.add(pred);
                        continue;
                    }
                    if (!pred.exit().isReturn() || !pred.getSuccessors().isEmpty() || pred.getInstructions().size() <= 2) continue;
                    JumpInstruction lastInstruction = pred.exit();
                    List value = lastInstructionToBlocks.computeIfAbsent(equivalence.wrap(lastInstruction), k -> new ArrayList());
                    value.add(pred);
                }
                for (List predsWithSameLastInstruction : lastInstructionToBlocks.values()) {
                    if (predsWithSameLastInstruction.size() < 2) continue;
                    BasicBlock firstPred = (BasicBlock)predsWithSameLastInstruction.get(0);
                    int commonSuffixSize = firstPred.getInstructions().size();
                    for (int i = 1; i < predsWithSameLastInstruction.size(); ++i) {
                        BasicBlock pred = (BasicBlock)predsWithSameLastInstruction.get(i);
                        assert (pred.exit().isGoto() || pred.exit().isReturn());
                        commonSuffixSize = Math.min(commonSuffixSize, PeepholeOptimizer.sharedSuffixSize(firstPred, pred, allocator, code));
                    }
                    int sizeDelta = overhead - (predsWithSameLastInstruction.size() - 1) * commonSuffixSize;
                    if (commonSuffixSize <= 1 || sizeDelta >= 0) continue;
                    BasicBlock newBlock = PeepholeOptimizer.createAndInsertBlockForSuffix(code.getNextBlockNumber(), commonSuffixSize, predsWithSameLastInstruction, block == normalExit ? null : block, allocator);
                    newBlocks.put((BasicBlock)predsWithSameLastInstruction.get(0), newBlock);
                }
            }
            BasicBlockIterator blockIterator = code.listIterator();
            while (blockIterator.hasNext()) {
                BasicBlock block;
                block = (BasicBlock)blockIterator.next();
                if (!newBlocks.containsKey(block)) continue;
                blockIterator.add((BasicBlock)newBlocks.get(block));
            }
        } while (!(blocks = newBlocks.values()).isEmpty());
    }

    private static BasicBlock createAndInsertBlockForSuffix(int blockNumber, int suffixSize, List<BasicBlock> preds, BasicBlock successorBlock, RegisterAllocator allocator) {
        BasicBlock first = preds.get(0);
        assert (successorBlock != null && first.exit().isGoto() || successorBlock == null && first.exit().isReturn());
        BasicBlock newBlock = new BasicBlock();
        newBlock.setNumber(blockNumber);
        InstructionIterator from = first.iterator(first.getInstructions().size());
        Int2ReferenceOpenHashMap<DebugLocalInfo> newBlockEntryLocals = null;
        if (first.getLocalsAtEntry() != null) {
            newBlockEntryLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>(first.getLocalsAtEntry());
            int prefixSize = first.getInstructions().size() - suffixSize;
            InstructionIterator it = first.iterator();
            for (int i = 0; i < prefixSize; ++i) {
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isDebugLocalsChange()) continue;
                instruction.asDebugLocalsChange().apply(newBlockEntryLocals);
            }
        }
        allocator.addNewBlockToShareIdenticalSuffix(newBlock, suffixSize, preds);
        boolean movedThrowingInstruction = false;
        for (int i = 0; i < suffixSize; ++i) {
            Instruction instruction = from.previous();
            movedThrowingInstruction = movedThrowingInstruction || instruction.instructionTypeCanThrow();
            newBlock.getInstructions().addFirst(instruction);
            instruction.setBlock(newBlock);
        }
        if (movedThrowingInstruction && first.hasCatchHandlers()) {
            newBlock.transferCatchHandlers(first);
        }
        for (BasicBlock pred : preds) {
            Position lastPosition = pred.getPosition();
            LinkedList<Instruction> instructions = pred.getInstructions();
            for (int i = 0; i < suffixSize; ++i) {
                instructions.removeLast();
            }
            for (Instruction instruction : pred.getInstructions()) {
                if (!instruction.getPosition().isSome()) continue;
                lastPosition = instruction.getPosition();
            }
            Goto jump = new Goto();
            jump.setBlock(pred);
            jump.setPosition(lastPosition);
            instructions.add(jump);
            newBlock.getMutablePredecessors().add(pred);
            if (successorBlock != null) {
                pred.replaceSuccessor(successorBlock, newBlock);
                successorBlock.getMutablePredecessors().remove(pred);
            } else {
                pred.getMutableSuccessors().add(newBlock);
            }
            if (!movedThrowingInstruction) continue;
            pred.clearCatchHandlers();
        }
        newBlock.close(null);
        if (newBlockEntryLocals != null) {
            newBlock.setLocalsAtEntry(newBlockEntryLocals);
        }
        if (successorBlock != null) {
            newBlock.link(successorBlock);
        }
        return newBlock;
    }

    private static Int2ReferenceMap<DebugLocalInfo> localsAtBlockExit(BasicBlock block) {
        if (block.getLocalsAtEntry() == null) {
            return null;
        }
        Int2ReferenceOpenHashMap<DebugLocalInfo> locals = new Int2ReferenceOpenHashMap<DebugLocalInfo>(block.getLocalsAtEntry());
        for (Instruction instruction : block.getInstructions()) {
            if (!instruction.isDebugLocalsChange()) continue;
            instruction.asDebugLocalsChange().apply(locals);
        }
        return locals;
    }

    private static int sharedSuffixSize(BasicBlock block0, BasicBlock block1, RegisterAllocator allocator, IRCode code) {
        assert (block0.exit().isGoto() || block0.exit().isReturn());
        if (!Objects.equals(PeepholeOptimizer.localsAtBlockExit(block0), PeepholeOptimizer.localsAtBlockExit(block1))) {
            return 0;
        }
        InstructionIterator it0 = block0.iterator(block0.getInstructions().size());
        InstructionIterator it1 = block1.iterator(block1.getInstructions().size());
        int suffixSize = 0;
        while (it0.hasPrevious() && it1.hasPrevious()) {
            Instruction i1;
            Instruction i0 = it0.previous();
            if (!i0.identicalAfterRegisterAllocation(i1 = it1.previous(), allocator, code.getConversionOptions())) {
                return suffixSize;
            }
            ++suffixSize;
        }
        return suffixSize;
    }

    public static void removeIdenticalPredecessorBlocks(IRCode code, RegisterAllocator allocator) {
        boolean changed;
        BasicBlockInstructionsEquivalence equivalence = new BasicBlockInstructionsEquivalence(code, allocator);
        do {
            changed = false;
            for (BasicBlock block : code.blocks) {
                HashMap<Equivalence.Wrapper<BasicBlock>, Integer> blockToIndex = new HashMap<Equivalence.Wrapper<BasicBlock>, Integer>();
                for (int predIndex = 0; predIndex < block.getPredecessors().size(); ++predIndex) {
                    BasicBlock pred = block.getPredecessors().get(predIndex);
                    if (pred.getInstructions().size() == 1) continue;
                    Equivalence.Wrapper<BasicBlock> wrapper = equivalence.wrap(pred);
                    if (blockToIndex.containsKey(wrapper)) {
                        changed = true;
                        int otherPredIndex = (Integer)blockToIndex.get(wrapper);
                        BasicBlock otherPred = block.getPredecessors().get(otherPredIndex);
                        assert (!allocator.options().debug || Objects.equals(pred.getPosition(), otherPred.getPosition()));
                        allocator.mergeBlocks(otherPred, pred);
                        pred.clearCatchHandlers();
                        pred.getInstructions().clear();
                        equivalence.clearComputedHash(pred);
                        for (BasicBlock succ : pred.getSuccessors()) {
                            succ.removePredecessor(pred, null);
                        }
                        pred.getMutableSuccessors().clear();
                        pred.getMutableSuccessors().add(otherPred);
                        assert (!otherPred.getPredecessors().contains(pred));
                        otherPred.getMutablePredecessors().add(pred);
                        Goto exit = new Goto();
                        exit.setBlock(pred);
                        exit.setPosition(otherPred.getPosition());
                        pred.getInstructions().add(exit);
                        continue;
                    }
                    blockToIndex.put(wrapper, predIndex);
                }
            }
        } while (changed);
    }

    private static void removeRedundantInstructions(IRCode code, LinearScanRegisterAllocator allocator) {
        for (BasicBlock block : code.blocks) {
            HashMap<Integer, ConstNumber> registerToNumber = new HashMap<Integer, ConstNumber>();
            MoveEliminator moveEliminator = new MoveEliminator(allocator);
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                int outRegister;
                Instruction current = (Instruction)iterator2.next();
                if (moveEliminator.shouldBeEliminated(current)) {
                    iterator2.removeInstructionIgnoreOutValue();
                    continue;
                }
                if (current.outValue() == null || !current.outValue().needsRegister()) continue;
                Value outValue = current.outValue();
                int instructionNumber = current.getNumber();
                if (outValue.isConstant() && current.isConstNumber()) {
                    if (PeepholeOptimizer.constantSpilledAtDefinition(current.asConstNumber())) {
                        iterator2.removeInstructionIgnoreOutValue();
                        continue;
                    }
                    outRegister = allocator.getRegisterForValue(outValue, instructionNumber);
                    ConstNumber numberInRegister = (ConstNumber)registerToNumber.get(outRegister);
                    if (numberInRegister != null && numberInRegister.identicalNonValueNonPositionParts(current)) {
                        iterator2.removeInstructionIgnoreOutValue();
                        continue;
                    }
                    registerToNumber.put(outRegister, current.asConstNumber());
                    if (current.outType().isWide()) {
                        registerToNumber.remove(outRegister + 1);
                    }
                    PeepholeOptimizer.removeWideConstantCovering(registerToNumber, outRegister);
                    continue;
                }
                outRegister = allocator.getRegisterForValue(outValue, instructionNumber);
                for (int i = 0; i < outValue.requiredRegisters(); ++i) {
                    registerToNumber.remove(outRegister + i);
                }
                PeepholeOptimizer.removeWideConstantCovering(registerToNumber, outRegister);
            }
        }
    }

    private static void removeWideConstantCovering(Map<Integer, ConstNumber> registerToNumber, int register) {
        ConstNumber number = registerToNumber.get(register - 1);
        if (number != null && number.outType().isWide()) {
            registerToNumber.remove(register - 1);
        }
    }

    private static boolean constantSpilledAtDefinition(ConstNumber constNumber) {
        if (constNumber.outValue().isFixedRegisterValue()) {
            return false;
        }
        LiveIntervals definitionIntervals = constNumber.outValue().getLiveIntervals().getSplitCovering(constNumber.getNumber());
        return definitionIntervals.isSpilledAndRematerializable();
    }

    private static /* synthetic */ boolean lambda$shareIdenticalBlockPrefixFromNormalSuccessors$0(RegisterAllocator allocator, BasicBlock block, Instruction instruction, int destinationRegister, Value inValue) {
        int operandRegister = allocator.getRegisterForValue(inValue, block.exit().getNumber());
        for (int i = 0; i < instruction.outValue().requiredRegisters(); ++i) {
            for (int j = 0; j < inValue.requiredRegisters(); ++j) {
                if (destinationRegister + i != operandRegister + j) continue;
                return false;
            }
        }
        return true;
    }
}

