/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.FieldGet;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.AssumeRemover;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.PredicateUtils;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RedundantFieldLoadAndStoreElimination {
    private static final int MAX_CAPACITY = 10000;
    private static final int MIN_CAPACITY_PER_BLOCK = 50;
    private final AppView<?> appView;
    private final ProgramMethod method;
    private final IRCode code;
    private final int maxCapacityPerBlock;
    private final boolean release;
    private final Set<Value> affectedValues = Sets.newIdentityHashSet();
    private final BlockStates activeStates = new BlockStates();
    private BlockState activeState;
    private final Map<BasicBlock, Set<Instruction>> instructionsToRemove = new IdentityHashMap<BasicBlock, Set<Instruction>>();

    public RedundantFieldLoadAndStoreElimination(AppView<?> appView, IRCode code) {
        this.appView = appView;
        this.method = code.context();
        this.code = code;
        this.maxCapacityPerBlock = Math.max(50, 10000 / code.blocks.size());
        this.release = !appView.options().debug;
    }

    public static boolean shouldRun(AppView<?> appView, IRCode code) {
        return appView.options().enableRedundantFieldLoadElimination && (code.metadata().mayHaveArrayGet() || code.metadata().mayHaveFieldInstruction() || code.metadata().mayHaveInitClass());
    }

    private DexClassAndField resolveField(DexField field) {
        if (this.appView.enableWholeProgramOptimizations()) {
            FieldResolutionResult.SingleFieldResolutionResult<?> resolutionResult = ((AppInfo)this.appView.appInfo()).withLiveness().resolveField(field).asSingleFieldResolutionResult();
            return resolutionResult != null ? resolutionResult.getResolutionPair() : null;
        }
        if (field.getHolderType() == this.method.getHolderType()) {
            return this.method.getHolder().lookupProgramField(field);
        }
        return null;
    }

    private void processInstructionsToRemove() {
        this.instructionsToRemove.forEach((block, instructionsToRemoveInBlock) -> {
            assert (instructionsToRemoveInBlock.stream().allMatch(instruction -> instruction.getBlock() == block));
            InstructionListIterator instructionIterator = block.listIterator(this.code);
            while (instructionIterator.hasNext()) {
                Instruction instruction2 = (Instruction)instructionIterator.next();
                assert (!instruction2.isJumpInstruction());
                if (!instructionsToRemoveInBlock.contains(instruction2)) continue;
                instructionIterator.removeOrReplaceByDebugLocalRead();
                instructionsToRemoveInBlock.remove(instruction2);
                if (!instructionsToRemoveInBlock.isEmpty()) continue;
                return;
            }
        });
    }

    private boolean verifyWasInstanceInitializer() {
        VerticallyMergedClasses verticallyMergedClasses = this.appView.verticallyMergedClasses();
        assert (verticallyMergedClasses != null);
        assert (verticallyMergedClasses.isMergeTarget(this.method.getHolderType()) || this.appView.horizontallyMergedClasses().isMergeTarget(this.method.getHolderType()));
        assert (this.appView.dexItemFactory().isConstructor(this.appView.graphLens().getOriginalMethodSignature((DexMethod)this.method.getReference())));
        assert (((DexEncodedMethod)this.method.getDefinition()).getOptimizationInfo().forceInline());
        return true;
    }

    private void handleInvokeDirect(InvokeDirect invoke) {
        if (!this.appView.hasLiveness()) {
            this.killAllNonFinalActiveFields();
            return;
        }
        AppView<AppInfoWithLiveness> appViewWithLiveness = this.appView.withLiveness();
        DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, this.method);
        if (singleTarget == null || !((DexEncodedMethod)singleTarget.getDefinition()).isInstanceInitializer()) {
            this.killAllNonFinalActiveFields();
            return;
        }
        InstanceInitializerInfo instanceInitializerInfo = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getInstanceInitializerInfo(invoke);
        if (instanceInitializerInfo.mayHaveOtherSideEffectsThanInstanceFieldAssignments()) {
            this.killAllNonFinalActiveFields();
        }
        InstanceFieldInitializationInfoCollection fieldInitializationInfos = instanceInitializerInfo.fieldInitializationInfos();
        fieldInitializationInfos.forEachWithDeterministicOrder(this.appView, (field, info) -> {
            if (!((AppInfoWithLiveness)appViewWithLiveness.appInfo()).mayPropagateValueFor(appViewWithLiveness, (DexField)field.getReference())) {
                return;
            }
            if (info.isArgumentInitializationInfo()) {
                Value value = invoke.getArgument(info.asArgumentInitializationInfo().getArgumentIndex());
                Value object = invoke.getReceiver().getAliasedValue();
                FieldAndObject fieldAndObject = new FieldAndObject((DexField)field.getReference(), object);
                if (field.isFinal()) {
                    this.activeState.putFinalInstanceField(fieldAndObject, new ExistingValue(value));
                } else {
                    this.activeState.putNonFinalInstanceField(fieldAndObject, new ExistingValue(value));
                }
            } else if (info.isSingleValue()) {
                SingleValue value = info.asSingleValue();
                if (value.isMaterializableInContext(appViewWithLiveness, this.method)) {
                    Value object = invoke.getReceiver().getAliasedValue();
                    FieldAndObject fieldAndObject = new FieldAndObject((DexField)field.getReference(), object);
                    if (field.isFinal()) {
                        this.activeState.putFinalInstanceField(fieldAndObject, new MaterializableValue(value));
                    } else {
                        this.activeState.putNonFinalInstanceField(fieldAndObject, new MaterializableValue(value));
                    }
                }
            } else assert (info.isTypeInitializationInfo());
        });
    }

    private void handleInvokeStatic(InvokeStatic invoke) {
        ProgramMethod resolvedMethod;
        if (this.appView.hasClassHierarchy() && (resolvedMethod = ((AppInfo)this.appView.appInfo()).withClassHierarchy().unsafeResolveMethodDueToDexFormat(invoke.getInvokedMethod()).getResolvedProgramMethod()) != null) {
            this.markClassAsInitialized(resolvedMethod.getHolderType());
            this.markMostRecentInitClassForRemoval(resolvedMethod.getHolderType());
        }
        this.killAllNonFinalActiveFields();
    }

    private void handleInitClass(InstructionListIterator instructionIterator, InitClass initClass) {
        DexType clazz;
        assert (!initClass.outValue().hasAnyUsers());
        this.killNonFinalActiveFields(initClass);
        if (initClass.instructionInstanceCanThrow(this.appView, this.method)) {
            this.activeState.clearMostRecentFieldWrites();
        }
        if (this.markClassAsInitialized(clazz = initClass.getClassValue())) {
            if (this.release) {
                this.activeState.setMostRecentInitClass(initClass);
            }
        } else {
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    private boolean markClassAsInitialized(DexType type) {
        return this.activeState.markClassAsInitialized(type);
    }

    private void markMostRecentInitClassForRemoval(DexType initializedType) {
        InitClass mostRecentInitClass = this.activeState.getMostRecentInitClass();
        if (mostRecentInitClass != null && mostRecentInitClass.getClassValue() == initializedType) {
            this.instructionsToRemove.computeIfAbsent(mostRecentInitClass.getBlock(), MapUtils.ignoreKey(Sets::newIdentityHashSet)).add(mostRecentInitClass);
        }
    }

    private void handleArrayGet(InstructionListIterator it, ArrayGet arrayGet) {
        Value index;
        if (arrayGet.array().hasLocalInfo()) {
            return;
        }
        if (arrayGet.outValue().hasLocalInfo()) {
            return;
        }
        Value array = arrayGet.array().getAliasedValue();
        ArraySlot arraySlot = ArraySlot.create(array, index = arrayGet.index().getAliasedValue(), arrayGet.getMemberType());
        FieldValue replacement = this.activeState.getArraySlotValue(arraySlot);
        if (replacement != null) {
            replacement.eliminateRedundantRead(it, arrayGet);
            return;
        }
        this.activeState.putArraySlotValue(arraySlot, new ExistingValue(arrayGet.outValue()));
    }

    private void handleArrayPut(ArrayPut arrayPut) {
        int index = arrayPut.getIndexOrDefault(-1);
        MemberType memberType = arrayPut.getMemberType();
        if (index < 0) {
            this.activeState.removeArraySlotValues(memberType);
        } else {
            this.activeState.removeArraySlotValues(memberType, index);
        }
        Value array = arrayPut.array().getAliasedValue();
        Value indexValue = arrayPut.index().getAliasedValue();
        ArraySlot arraySlot = ArraySlot.create(array, indexValue, memberType);
        ExistingValue value = new ExistingValue(arrayPut.value());
        this.activeState.putArraySlotValue(arraySlot, value);
    }

    private void handleInstanceGet(InstructionListIterator it, InstanceGet instanceGet, DexClassAndField field, AssumeRemover assumeRemover) {
        if (instanceGet.outValue().hasLocalInfo()) {
            this.clearMostRecentInstanceFieldWrite(instanceGet, field);
            return;
        }
        Value object = instanceGet.object().getAliasedValue();
        FieldAndObject fieldAndObject = new FieldAndObject((DexField)field.getReference(), object);
        FieldValue replacement = this.activeState.getInstanceFieldValue(fieldAndObject);
        if (replacement != null) {
            this.markAssumeDynamicTypeUsersForRemoval(instanceGet, replacement, assumeRemover);
            replacement.eliminateRedundantRead(it, instanceGet);
            return;
        }
        this.activeState.putNonFinalInstanceField(fieldAndObject, new ExistingValue(instanceGet.value()));
        this.activeState.clearMostRecentInitClass();
        this.clearMostRecentInstanceFieldWrite(instanceGet, field);
    }

    private void handleNewInstance(NewInstance newInstance) {
        this.markClassAsInitialized(newInstance.getType());
        this.markMostRecentInitClassForRemoval(newInstance.getType());
        if (newInstance.getType().classInitializationMayHaveSideEffectsInContext(this.appView, this.method)) {
            this.killAllNonFinalActiveFields();
        }
    }

    private void clearMostRecentInstanceFieldWrite(InstanceGet instanceGet, DexClassAndField field) {
        if (instanceGet.instructionInstanceCanThrow(this.appView, this.method)) {
            this.activeState.clearMostRecentFieldWrites();
        } else {
            this.activeState.clearMostRecentInstanceFieldWrite((DexField)field.getReference());
        }
    }

    private void markAssumeDynamicTypeUsersForRemoval(FieldGet fieldGet, FieldValue replacement, AssumeRemover assumeRemover) {
        ExistingValue existingValue = replacement.asExistingValue();
        if (existingValue == null || !existingValue.getValue().isDefinedByInstructionSatisfying(definition -> definition.isFieldGet() && definition.asFieldGet().getField().getType() == fieldGet.getField().getType())) {
            assumeRemover.markAssumeDynamicTypeUsersForRemoval(fieldGet.outValue());
        }
    }

    private void handleInstancePut(InstancePut instancePut, DexClassAndField field) {
        this.activeState.removeNonFinalInstanceFields((DexField)field.getReference());
        if (instancePut.instructionInstanceCanThrow(this.appView, this.method)) {
            this.activeState.clearMostRecentFieldWrites();
        }
        Value object = instancePut.object().getAliasedValue();
        FieldAndObject fieldAndObject = new FieldAndObject((DexField)field.getReference(), object);
        ExistingValue value = new ExistingValue(instancePut.value());
        if (this.isFinal(field)) {
            assert (!((DexEncodedField)field.getDefinition()).isFinal() || ((DexEncodedMethod)this.method.getDefinition()).isInstanceInitializer() || this.verifyWasInstanceInitializer());
            this.activeState.putFinalInstanceField(fieldAndObject, value);
        } else {
            InstancePut mostRecentInstanceFieldWrite;
            this.activeState.putNonFinalInstanceField(fieldAndObject, value);
            if (this.release && (mostRecentInstanceFieldWrite = this.activeState.putMostRecentInstanceFieldWrite(fieldAndObject, instancePut)) != null) {
                this.instructionsToRemove.computeIfAbsent(mostRecentInstanceFieldWrite.getBlock(), MapUtils.ignoreKey(Sets::newIdentityHashSet)).add(mostRecentInstanceFieldWrite);
            }
        }
        this.activeState.clearMostRecentInitClass();
    }

    private void handleStaticGet(InstructionListIterator instructionIterator, StaticGet staticGet, DexClassAndField field, AssumeRemover assumeRemover) {
        SingleFieldValue singleFieldValue;
        this.markClassAsInitialized(field.getHolderType());
        if (staticGet.outValue().hasLocalInfo()) {
            this.killNonFinalActiveFields(staticGet);
            this.clearMostRecentStaticFieldWrite(staticGet, field);
            return;
        }
        FieldValue replacement = this.activeState.getStaticFieldValue((DexField)field.getReference());
        if (replacement != null) {
            this.markAssumeDynamicTypeUsersForRemoval(staticGet, replacement, assumeRemover);
            replacement.eliminateRedundantRead(instructionIterator, staticGet);
            return;
        }
        this.killNonFinalActiveFields(staticGet);
        this.clearMostRecentStaticFieldWrite(staticGet, field);
        ExistingValue value = new ExistingValue(staticGet.value());
        if (this.isFinal(field)) {
            this.activeState.putFinalStaticField((DexField)field.getReference(), value);
        } else {
            this.activeState.putNonFinalStaticField((DexField)field.getReference(), value);
        }
        if (this.appView.hasLiveness() && (singleFieldValue = ((DexEncodedField)field.getDefinition()).getOptimizationInfo().getAbstractValue().asSingleFieldValue()) != null) {
            this.applyObjectState(staticGet.outValue(), singleFieldValue.getObjectState());
        }
        this.markMostRecentInitClassForRemoval(field.getHolderType());
        this.activeState.clearMostRecentInitClass();
    }

    private void clearMostRecentStaticFieldWrite(StaticGet staticGet, DexClassAndField field) {
        if (staticGet.instructionInstanceCanThrow(this.appView, this.method)) {
            this.activeState.clearMostRecentFieldWrites();
        } else {
            this.activeState.clearMostRecentStaticFieldWrite((DexField)field.getReference());
        }
    }

    private void handleStaticPut(StaticPut staticPut, DexClassAndField field) {
        this.markClassAsInitialized(field.getHolderType());
        this.killNonFinalActiveFields(staticPut);
        if (staticPut.instructionInstanceCanThrow(this.appView, this.method)) {
            this.activeState.clearMostRecentFieldWrites();
        }
        ExistingValue value = new ExistingValue(staticPut.value());
        if (this.isFinal(field)) {
            assert (this.appView.checkForTesting(() -> !((DexEncodedField)field.getDefinition()).isFinal() || ((DexEncodedMethod)this.method.getDefinition()).isClassInitializer()));
            this.activeState.putFinalStaticField((DexField)field.getReference(), value);
        } else {
            StaticPut mostRecentStaticFieldWrite;
            this.activeState.putNonFinalStaticField((DexField)field.getReference(), value);
            if (this.release && (mostRecentStaticFieldWrite = this.activeState.putMostRecentStaticFieldWrite((DexField)field.getReference(), staticPut)) != null) {
                this.instructionsToRemove.computeIfAbsent(mostRecentStaticFieldWrite.getBlock(), MapUtils.ignoreKey(Sets::newIdentityHashSet)).add(mostRecentStaticFieldWrite);
            }
        }
        this.markMostRecentInitClassForRemoval(field.getHolderType());
        this.activeState.clearMostRecentInitClass();
    }

    private void applyObjectState(Value value, ObjectState objectState) {
        AppView<AppInfoWithLiveness> appViewWithLiveness = this.appView.withLiveness();
        objectState.forEachAbstractFieldValue((field, fieldValue) -> {
            SingleValue singleFieldValue;
            if (((AppInfoWithLiveness)appViewWithLiveness.appInfo()).mayPropagateValueFor(appViewWithLiveness, (DexField)field) && fieldValue.isSingleValue() && (singleFieldValue = fieldValue.asSingleValue()).isMaterializableInContext(appViewWithLiveness, this.method)) {
                this.activeState.putFinalInstanceField(new FieldAndObject((DexField)field, value), new MaterializableValue(singleFieldValue));
            }
        });
    }

    private void killAllNonFinalActiveFields() {
        this.activeState.clearArraySlotValues();
        this.activeState.clearNonFinalInstanceFields();
        this.activeState.clearNonFinalStaticFields();
        this.activeState.clearMostRecentFieldWrites();
        this.activeState.clearMostRecentInitClass();
    }

    private void killNonFinalActiveFields(Instruction instruction) {
        assert (instruction.isInitClass() || instruction.isStaticFieldInstruction());
        if (instruction.isStaticPut()) {
            if (instruction.instructionMayTriggerMethodInvocation(this.appView, this.method)) {
                this.activeState.clearNonFinalStaticFields();
                this.activeState.clearMostRecentFieldWrites();
            } else {
                this.activeState.removeNonFinalStaticField(instruction.asStaticPut().getField());
            }
        } else if (instruction.isInitClass() || instruction.isStaticGet()) {
            if (instruction.instructionMayTriggerMethodInvocation(this.appView, this.method)) {
                this.activeState.clearNonFinalStaticFields();
                this.activeState.clearMostRecentFieldWrites();
            }
        } else if (instruction.isInstanceGet()) {
            throw new Unreachable();
        }
    }

    public boolean isFinal(DexClassAndField field) {
        if (field.isProgramField()) {
            return ((DexEncodedField)field.getDefinition()).isFinal() || ((DexEncodedField)field.getDefinition()).getOptimizationInfo().getAbstractValue().isSingleValue();
        }
        return this.appView.libraryMethodOptimizer().isFinalLibraryField((DexEncodedField)field.getDefinition());
    }

    public void run() {
        Reference2IntOpenHashMap<BasicBlock> pendingNormalSuccessors = new Reference2IntOpenHashMap<BasicBlock>();
        for (BasicBlock block : this.code.blocks) {
            if (block.hasUniqueNormalSuccessor()) continue;
            pendingNormalSuccessors.put(block, block.numberOfNormalSuccessors());
        }
        AssumeRemover assumeRemover = new AssumeRemover(this.appView, this.code, this.affectedValues);
        for (BasicBlock head : this.code.topologicallySortedBlocks()) {
            if (head.hasUniquePredecessor() && head.getUniquePredecessor().hasUniqueNormalSuccessor()) continue;
            this.activeState = this.activeStates.computeActiveStateOnBlockEntry(head, this.maxCapacityPerBlock);
            this.activeStates.removeDeadBlockExitStates(head, pendingNormalSuccessors);
            BasicBlock block = head;
            BasicBlock end = null;
            do {
                InstructionListIterator it = block.listIterator(this.code);
                while (it.hasNext()) {
                    Instruction instruction = (Instruction)it.next();
                    if (instruction.isArrayAccess()) {
                        if (instruction.isArrayGet()) {
                            this.handleArrayGet(it, instruction.asArrayGet());
                            continue;
                        }
                        assert (instruction.isArrayPut());
                        this.handleArrayPut(instruction.asArrayPut());
                        continue;
                    }
                    if (instruction.isFieldInstruction()) {
                        DexField reference = instruction.asFieldInstruction().getField();
                        DexClassAndField field = this.resolveField(reference);
                        if (field == null || ((DexEncodedField)field.getDefinition()).isVolatile()) {
                            this.killAllNonFinalActiveFields();
                            continue;
                        }
                        if (instruction.isInstanceGet()) {
                            this.handleInstanceGet(it, instruction.asInstanceGet(), field, assumeRemover);
                            continue;
                        }
                        if (instruction.isInstancePut()) {
                            this.handleInstancePut(instruction.asInstancePut(), field);
                            continue;
                        }
                        if (instruction.isStaticGet()) {
                            this.handleStaticGet(it, instruction.asStaticGet(), field, assumeRemover);
                            continue;
                        }
                        if (!instruction.isStaticPut()) continue;
                        this.handleStaticPut(instruction.asStaticPut(), field);
                        continue;
                    }
                    if (instruction.isAssume()) {
                        assumeRemover.removeIfMarked(instruction.asAssume(), it);
                        continue;
                    }
                    if (instruction.isInitClass()) {
                        this.handleInitClass(it, instruction.asInitClass());
                        continue;
                    }
                    if (instruction.isMonitor()) {
                        if (!instruction.asMonitor().isEnter()) continue;
                        this.killAllNonFinalActiveFields();
                        continue;
                    }
                    if (instruction.isInvokeDirect()) {
                        this.handleInvokeDirect(instruction.asInvokeDirect());
                        continue;
                    }
                    if (instruction.isInvokeStatic()) {
                        this.handleInvokeStatic(instruction.asInvokeStatic());
                        continue;
                    }
                    if (instruction.isInvokeMethod() || instruction.isInvokeCustom()) {
                        this.killAllNonFinalActiveFields();
                        continue;
                    }
                    if (instruction.isNewInstance()) {
                        this.handleNewInstance(instruction.asNewInstance());
                        continue;
                    }
                    assert (!instruction.instructionMayTriggerMethodInvocation(this.appView, this.method));
                    if (instruction.instructionInstanceCanThrow(this.appView, this.method)) {
                        this.activeState.clearMostRecentFieldWrites();
                        this.activeState.clearMostRecentInitClass();
                    }
                    assert (instruction.isArgument() || instruction.isArrayGet() || instruction.isArrayLength() || instruction.isArrayPut() || instruction.isAssume() || instruction.isBinop() || instruction.isCheckCast() || instruction.isConstClass() || instruction.isConstMethodHandle() || instruction.isConstMethodType() || instruction.isConstNumber() || instruction.isConstString() || instruction.isDebugInstruction() || instruction.isDexItemBasedConstString() || instruction.isGoto() || instruction.isIf() || instruction.isInstanceOf() || instruction.isInvokeMultiNewArray() || instruction.isInvokeNewArray() || instruction.isMoveException() || instruction.isNewArrayEmpty() || instruction.isNewArrayFilledData() || instruction.isReturn() || instruction.isSwitch() || instruction.isThrow() || instruction.isUnop() || instruction.isRecordFieldValues()) : "Unexpected instruction of type " + instruction.getClass().getTypeName();
                }
                if (block.hasUniqueNormalSuccessorWithUniquePredecessor()) {
                    block = block.getUniqueNormalSuccessor();
                    continue;
                }
                end = block;
                block = null;
            } while (block != null);
            assert (end != null);
            this.activeStates.recordActiveStateOnBlockExit(end, this.activeState);
        }
        this.processInstructionsToRemove();
        assumeRemover.removeMarkedInstructions().finish();
        assert (this.code.isConsistentSSA(this.appView));
    }

    static class BlockState {
        private LinkedHashMap<ArraySlot, FieldValue> arraySlotValues;
        private LinkedHashMap<FieldAndObject, FieldValue> finalInstanceFieldValues;
        private LinkedHashMap<DexField, FieldValue> finalStaticFieldValues;
        private LinkedHashSet<DexType> initializedClasses;
        private LinkedHashMap<FieldAndObject, FieldValue> nonFinalInstanceFieldValues;
        private LinkedHashMap<DexField, FieldValue> nonFinalStaticFieldValues;
        private InitClass mostRecentInitClass;
        private LinkedHashMap<FieldAndObject, InstancePut> mostRecentInstanceFieldWrites;
        private LinkedHashMap<DexField, StaticPut> mostRecentStaticFieldWrites;
        private final int maxCapacity;

        public BlockState(int maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public BlockState(int maxCapacity, BlockState state) {
            this(maxCapacity);
            if (state != null) {
                if (state.arraySlotValues != null && !state.arraySlotValues.isEmpty()) {
                    this.arraySlotValues = new LinkedHashMap();
                    this.arraySlotValues.putAll(state.arraySlotValues);
                }
                if (state.finalInstanceFieldValues != null && !state.finalInstanceFieldValues.isEmpty()) {
                    this.finalInstanceFieldValues = new LinkedHashMap();
                    this.finalInstanceFieldValues.putAll(state.finalInstanceFieldValues);
                }
                if (state.finalStaticFieldValues != null && !state.finalStaticFieldValues.isEmpty()) {
                    this.finalStaticFieldValues = new LinkedHashMap();
                    this.finalStaticFieldValues.putAll(state.finalStaticFieldValues);
                }
                if (state.initializedClasses != null && !state.initializedClasses.isEmpty()) {
                    this.initializedClasses = new LinkedHashSet();
                    this.initializedClasses.addAll(state.initializedClasses);
                }
                if (state.nonFinalInstanceFieldValues != null && !state.nonFinalInstanceFieldValues.isEmpty()) {
                    this.nonFinalInstanceFieldValues = new LinkedHashMap();
                    this.nonFinalInstanceFieldValues.putAll(state.nonFinalInstanceFieldValues);
                }
                if (state.nonFinalStaticFieldValues != null && !state.nonFinalStaticFieldValues.isEmpty()) {
                    this.nonFinalStaticFieldValues = new LinkedHashMap();
                    this.nonFinalStaticFieldValues.putAll(state.nonFinalStaticFieldValues);
                }
                this.mostRecentInitClass = state.mostRecentInitClass;
                if (state.mostRecentInstanceFieldWrites != null && !state.mostRecentInstanceFieldWrites.isEmpty()) {
                    this.mostRecentInstanceFieldWrites = new LinkedHashMap();
                    this.mostRecentInstanceFieldWrites.putAll(state.mostRecentInstanceFieldWrites);
                }
                if (state.mostRecentStaticFieldWrites != null && !state.mostRecentStaticFieldWrites.isEmpty()) {
                    this.mostRecentStaticFieldWrites = new LinkedHashMap();
                    this.mostRecentStaticFieldWrites.putAll(state.mostRecentStaticFieldWrites);
                }
            }
        }

        private static <K> void intersectFieldValues(Map<K, FieldValue> fieldValues, Map<K, FieldValue> other) {
            fieldValues.entrySet().removeIf(entry -> other.get(entry.getKey()) != entry.getValue());
        }

        private static void intersectInitializedClasses(Set<DexType> initializedClasses, Set<DexType> other) {
            initializedClasses.removeIf(PredicateUtils.not(other::contains));
        }

        private static boolean isEmpty(Set<?> set) {
            return set == null || set.isEmpty();
        }

        private static boolean isEmpty(Map<?, ?> map) {
            return map == null || map.isEmpty();
        }

        private void killActiveInitializedClassesForExceptionalExit(InitClass instruction) {
            if (this.initializedClasses != null) {
                this.initializedClasses.remove(instruction.getClassValue());
            }
        }

        private static int reduceSize(int numberOfItemsToRemove, Set<?> set) {
            if (set == null || numberOfItemsToRemove == 0) {
                return numberOfItemsToRemove;
            }
            Iterator<?> iterator2 = set.iterator();
            while (iterator2.hasNext() && numberOfItemsToRemove > 0) {
                iterator2.next();
                iterator2.remove();
                --numberOfItemsToRemove;
            }
            return numberOfItemsToRemove;
        }

        private static int reduceSize(int numberOfItemsToRemove, Map<?, ?> map) {
            return BlockState.reduceSize(numberOfItemsToRemove, map != null ? map.keySet() : null);
        }

        private static int size(Set<?> set) {
            return set != null ? set.size() : 0;
        }

        private static int size(Map<?, ?> map) {
            return map != null ? map.size() : 0;
        }

        public void clearArraySlotValues() {
            this.arraySlotValues = null;
        }

        public void clearMostRecentFieldWrites() {
            this.clearMostRecentInstanceFieldWrites();
            this.clearMostRecentStaticFieldWrites();
        }

        public void clearMostRecentInstanceFieldWrite(DexField field) {
            if (this.mostRecentInstanceFieldWrites != null) {
                this.mostRecentInstanceFieldWrites.keySet().removeIf(key -> ((FieldAndObject)key).field == field);
            }
        }

        public void clearMostRecentInstanceFieldWrites() {
            this.mostRecentInstanceFieldWrites = null;
        }

        public void clearMostRecentStaticFieldWrite(DexField field) {
            if (this.mostRecentStaticFieldWrites != null) {
                this.mostRecentStaticFieldWrites.remove(field);
            }
        }

        public void clearMostRecentStaticFieldWrites() {
            this.mostRecentStaticFieldWrites = null;
        }

        public void clearNonFinalInstanceFields() {
            this.nonFinalInstanceFieldValues = null;
        }

        public void clearNonFinalStaticFields() {
            this.nonFinalStaticFieldValues = null;
        }

        public void ensureCapacityForNewElement() {
            int size = this.size();
            assert (size <= this.maxCapacity);
            if (size == this.maxCapacity) {
                this.reduceSize(1);
            }
        }

        public FieldValue getArraySlotValue(ArraySlot arraySlot) {
            return this.arraySlotValues != null ? this.arraySlotValues.get(arraySlot) : null;
        }

        public FieldValue getInstanceFieldValue(FieldAndObject field) {
            FieldValue value;
            FieldValue fieldValue = value = this.nonFinalInstanceFieldValues != null ? this.nonFinalInstanceFieldValues.get(field) : null;
            if (value != null) {
                return value;
            }
            return this.finalInstanceFieldValues != null ? this.finalInstanceFieldValues.get(field) : null;
        }

        public FieldValue getStaticFieldValue(DexField field) {
            FieldValue value;
            FieldValue fieldValue = value = this.nonFinalStaticFieldValues != null ? this.nonFinalStaticFieldValues.get(field) : null;
            if (value != null) {
                return value;
            }
            return this.finalStaticFieldValues != null ? this.finalStaticFieldValues.get(field) : null;
        }

        public void intersect(BlockState state) {
            if (this.arraySlotValues != null && state.arraySlotValues != null) {
                BlockState.intersectFieldValues(this.arraySlotValues, state.arraySlotValues);
            } else {
                this.arraySlotValues = null;
            }
            if (this.finalInstanceFieldValues != null && state.finalInstanceFieldValues != null) {
                BlockState.intersectFieldValues(this.finalInstanceFieldValues, state.finalInstanceFieldValues);
            } else {
                this.finalInstanceFieldValues = null;
            }
            if (this.finalStaticFieldValues != null && state.finalStaticFieldValues != null) {
                BlockState.intersectFieldValues(this.finalStaticFieldValues, state.finalStaticFieldValues);
            } else {
                this.finalStaticFieldValues = null;
            }
            if (this.initializedClasses != null && state.initializedClasses != null) {
                BlockState.intersectInitializedClasses(this.initializedClasses, state.initializedClasses);
            } else {
                this.initializedClasses = null;
            }
            if (this.nonFinalInstanceFieldValues != null && state.nonFinalInstanceFieldValues != null) {
                BlockState.intersectFieldValues(this.nonFinalInstanceFieldValues, state.nonFinalInstanceFieldValues);
            } else {
                this.nonFinalInstanceFieldValues = null;
            }
            if (this.nonFinalStaticFieldValues != null && state.nonFinalStaticFieldValues != null) {
                BlockState.intersectFieldValues(this.nonFinalStaticFieldValues, state.nonFinalStaticFieldValues);
            } else {
                this.nonFinalStaticFieldValues = null;
            }
            assert (this.mostRecentInitClass == null);
            assert (this.mostRecentInstanceFieldWrites == null);
            assert (this.mostRecentStaticFieldWrites == null);
        }

        public boolean isEmpty() {
            return BlockState.isEmpty(this.arraySlotValues) && BlockState.isEmpty(this.initializedClasses) && BlockState.isEmpty(this.finalInstanceFieldValues) && BlockState.isEmpty(this.finalStaticFieldValues) && BlockState.isEmpty(this.initializedClasses) && BlockState.isEmpty(this.nonFinalInstanceFieldValues) && BlockState.isEmpty(this.nonFinalStaticFieldValues);
        }

        public void killActiveFieldsForExceptionalExit(FieldInstruction instruction) {
            DexField field = instruction.getField();
            if (instruction.isInstanceGet()) {
                Value object = instruction.asInstanceGet().object().getAliasedValue();
                FieldAndObject fieldAndObject = new FieldAndObject(field, object);
                this.removeInstanceField(fieldAndObject);
            } else if (instruction.isStaticGet()) {
                this.removeStaticField(field);
            }
        }

        public boolean markClassAsInitialized(DexType clazz) {
            this.ensureCapacityForNewElement();
            if (this.initializedClasses == null) {
                this.initializedClasses = new LinkedHashSet();
            }
            return this.initializedClasses.add(clazz);
        }

        public void reduceSize(int numberOfItemsToRemove) {
            assert (numberOfItemsToRemove > 0);
            assert (numberOfItemsToRemove < this.size());
            numberOfItemsToRemove = BlockState.reduceSize(numberOfItemsToRemove, this.arraySlotValues);
            numberOfItemsToRemove = BlockState.reduceSize(numberOfItemsToRemove, this.initializedClasses);
            numberOfItemsToRemove = BlockState.reduceSize(numberOfItemsToRemove, this.nonFinalInstanceFieldValues);
            numberOfItemsToRemove = BlockState.reduceSize(numberOfItemsToRemove, this.nonFinalStaticFieldValues);
            numberOfItemsToRemove = BlockState.reduceSize(numberOfItemsToRemove, this.finalInstanceFieldValues);
            numberOfItemsToRemove = BlockState.reduceSize(numberOfItemsToRemove, this.finalStaticFieldValues);
            numberOfItemsToRemove = BlockState.reduceSize(numberOfItemsToRemove, this.mostRecentInstanceFieldWrites);
            numberOfItemsToRemove = BlockState.reduceSize(numberOfItemsToRemove, this.mostRecentStaticFieldWrites);
            assert (numberOfItemsToRemove == 0);
        }

        public void removeArraySlotValues(MemberType memberType) {
            if (this.arraySlotValues != null) {
                this.arraySlotValues.keySet().removeIf(arraySlot -> arraySlot.getMemberType() == memberType);
            }
        }

        public void removeArraySlotValues(MemberType memberType, int index) {
            if (this.arraySlotValues != null) {
                this.arraySlotValues.keySet().removeIf(arraySlot -> arraySlot.getMemberType() == memberType && arraySlot.maybeHasIndex(index));
            }
        }

        public void removeInstanceField(FieldAndObject field) {
            this.removeFinalInstanceField(field);
            this.removeNonFinalInstanceField(field);
            this.removeMostRecentInstanceFieldWrite(field);
        }

        public void removeFinalInstanceField(FieldAndObject field) {
            if (this.finalInstanceFieldValues != null) {
                this.finalInstanceFieldValues.remove(field);
            }
        }

        public void removeNonFinalInstanceField(FieldAndObject field) {
            if (this.nonFinalInstanceFieldValues != null) {
                this.nonFinalInstanceFieldValues.remove(field);
            }
        }

        public void removeNonFinalInstanceFields(DexField field) {
            if (this.nonFinalInstanceFieldValues != null) {
                this.nonFinalInstanceFieldValues.keySet().removeIf(key -> ((FieldAndObject)key).field == field);
            }
        }

        public void removeStaticField(DexField field) {
            this.removeFinalStaticField(field);
            this.removeNonFinalStaticField(field);
            this.removeMostRecentStaticFieldWrite(field);
        }

        public void removeFinalStaticField(DexField field) {
            if (this.finalStaticFieldValues != null) {
                this.finalStaticFieldValues.remove(field);
            }
        }

        public void removeNonFinalStaticField(DexField field) {
            if (this.nonFinalStaticFieldValues != null) {
                this.nonFinalStaticFieldValues.remove(field);
            }
        }

        public void removeMostRecentInstanceFieldWrite(FieldAndObject field) {
            if (this.mostRecentInstanceFieldWrites != null) {
                this.mostRecentInstanceFieldWrites.remove(field);
            }
        }

        public void removeMostRecentStaticFieldWrite(DexField field) {
            if (this.mostRecentStaticFieldWrites != null) {
                this.mostRecentStaticFieldWrites.remove(field);
            }
        }

        public void putArraySlotValue(ArraySlot arraySlot, FieldValue value) {
            this.ensureCapacityForNewElement();
            if (this.arraySlotValues == null) {
                this.arraySlotValues = new LinkedHashMap();
            }
            this.arraySlotValues.put(arraySlot, value);
        }

        public void putFinalInstanceField(FieldAndObject field, FieldValue value) {
            this.ensureCapacityForNewElement();
            if (this.finalInstanceFieldValues == null) {
                this.finalInstanceFieldValues = new LinkedHashMap();
            }
            this.finalInstanceFieldValues.put(field, value);
        }

        public void putFinalStaticField(DexField field, FieldValue value) {
            this.ensureCapacityForNewElement();
            if (this.finalStaticFieldValues == null) {
                this.finalStaticFieldValues = new LinkedHashMap();
            }
            this.finalStaticFieldValues.put(field, value);
        }

        public InstancePut putMostRecentInstanceFieldWrite(FieldAndObject field, InstancePut instancePut) {
            this.ensureCapacityForNewElement();
            if (this.mostRecentInstanceFieldWrites == null) {
                this.mostRecentInstanceFieldWrites = new LinkedHashMap();
            }
            return this.mostRecentInstanceFieldWrites.put(field, instancePut);
        }

        public StaticPut putMostRecentStaticFieldWrite(DexField field, StaticPut staticPut) {
            this.ensureCapacityForNewElement();
            if (this.mostRecentStaticFieldWrites == null) {
                this.mostRecentStaticFieldWrites = new LinkedHashMap();
            }
            return this.mostRecentStaticFieldWrites.put(field, staticPut);
        }

        public void putNonFinalInstanceField(FieldAndObject field, FieldValue value) {
            this.ensureCapacityForNewElement();
            assert (this.finalInstanceFieldValues == null || !this.finalInstanceFieldValues.containsKey(field));
            if (this.nonFinalInstanceFieldValues == null) {
                this.nonFinalInstanceFieldValues = new LinkedHashMap();
            }
            this.nonFinalInstanceFieldValues.put(field, value);
        }

        public void putNonFinalStaticField(DexField field, FieldValue value) {
            this.ensureCapacityForNewElement();
            assert (this.nonFinalStaticFieldValues == null || !this.nonFinalStaticFieldValues.containsKey(field));
            if (this.nonFinalStaticFieldValues == null) {
                this.nonFinalStaticFieldValues = new LinkedHashMap();
            }
            this.nonFinalStaticFieldValues.put(field, value);
        }

        public InitClass getMostRecentInitClass() {
            return this.mostRecentInitClass;
        }

        public void setMostRecentInitClass(InitClass initClass) {
            this.mostRecentInitClass = initClass;
        }

        public InitClass clearMostRecentInitClass() {
            InitClass result = this.mostRecentInitClass;
            this.mostRecentInitClass = null;
            return result;
        }

        public int size() {
            return BlockState.size(this.arraySlotValues) + BlockState.size(this.finalInstanceFieldValues) + BlockState.size(this.finalStaticFieldValues) + BlockState.size(this.initializedClasses) + BlockState.size(this.nonFinalInstanceFieldValues) + BlockState.size(this.nonFinalStaticFieldValues) + BlockState.size(this.mostRecentInstanceFieldWrites) + BlockState.size(this.mostRecentStaticFieldWrites);
        }
    }

    static class BlockStates {
        private final LinkedHashMap<BasicBlock, BlockState> activeStateAtExit = new LinkedHashMap();
        private int capacity = 10000;

        BlockStates() {
        }

        private void ensureCapacity(BlockState state) {
            int stateSize = state.size();
            assert (stateSize <= state.maxCapacity);
            int numberOfItemsToRemove = stateSize - this.capacity;
            if (numberOfItemsToRemove <= 0) {
                return;
            }
            Iterator<Map.Entry<BasicBlock, BlockState>> iterator2 = this.activeStateAtExit.entrySet().iterator();
            while (iterator2.hasNext() && numberOfItemsToRemove > 0) {
                Map.Entry<BasicBlock, BlockState> entry = iterator2.next();
                BlockState existingState = entry.getValue();
                int existingStateSize = existingState.size();
                assert (existingStateSize > 0);
                if (existingStateSize <= numberOfItemsToRemove) {
                    iterator2.remove();
                    this.capacity += existingStateSize;
                    numberOfItemsToRemove -= existingStateSize;
                    continue;
                }
                existingState.reduceSize(numberOfItemsToRemove);
                this.capacity += numberOfItemsToRemove;
                numberOfItemsToRemove = 0;
            }
            if (numberOfItemsToRemove > 0) {
                state.reduceSize(numberOfItemsToRemove);
            }
            assert (this.capacity == 10000 - this.size());
        }

        private void removeState(BasicBlock block) {
            BlockState state = (BlockState)this.activeStateAtExit.remove(block);
            if (state != null) {
                int stateSize = state.size();
                assert (stateSize > 0);
                this.capacity += stateSize;
            }
        }

        private int size() {
            int size = 0;
            for (BlockState state : this.activeStateAtExit.values()) {
                int stateSize = state.size();
                assert (stateSize > 0);
                size += stateSize;
            }
            return size;
        }

        BlockState computeActiveStateOnBlockEntry(BasicBlock block, int maxCapacityPerBlock) {
            if (block.isEntry()) {
                return new BlockState(maxCapacityPerBlock);
            }
            List<BasicBlock> predecessors = block.getPredecessors();
            Iterator<BasicBlock> predecessorIterator = predecessors.iterator();
            BlockState state = new BlockState(maxCapacityPerBlock, this.activeStateAtExit.get(predecessorIterator.next()));
            while (predecessorIterator.hasNext()) {
                BasicBlock predecessor = predecessorIterator.next();
                BlockState predecessorExitState = this.activeStateAtExit.get(predecessor);
                if (predecessorExitState == null) {
                    return new BlockState(maxCapacityPerBlock);
                }
                state.intersect(predecessorExitState);
            }
            for (BasicBlock predecessor : predecessors) {
                Instruction exceptionalExit;
                if (!predecessor.hasCatchSuccessor(block) || (exceptionalExit = predecessor.exceptionalExit()) == null) continue;
                if (exceptionalExit.isFieldInstruction()) {
                    state.killActiveFieldsForExceptionalExit(exceptionalExit.asFieldInstruction());
                    continue;
                }
                if (!exceptionalExit.isInitClass()) continue;
                state.killActiveInitializedClassesForExceptionalExit(exceptionalExit.asInitClass());
            }
            return state;
        }

        void removeDeadBlockExitStates(BasicBlock current, Reference2IntMap<BasicBlock> pendingNormalSuccessorsMap) {
            for (BasicBlock predecessor : current.getPredecessors()) {
                if (predecessor.hasUniqueSuccessor()) {
                    this.removeState(predecessor);
                    continue;
                }
                if (!predecessor.hasNormalSuccessor(current)) continue;
                int pendingNormalSuccessors = pendingNormalSuccessorsMap.getInt(predecessor) - 1;
                if (pendingNormalSuccessors == 0) {
                    pendingNormalSuccessorsMap.removeInt(predecessor);
                    this.removeState(predecessor);
                    continue;
                }
                pendingNormalSuccessorsMap.put(predecessor, pendingNormalSuccessors);
            }
        }

        void recordActiveStateOnBlockExit(BasicBlock block, BlockState state) {
            assert (!this.activeStateAtExit.containsKey(block));
            if (state.isEmpty()) {
                return;
            }
            if (!block.hasUniqueSuccessorWithUniquePredecessor()) {
                state.clearMostRecentFieldWrites();
                state.clearMostRecentInitClass();
            }
            this.ensureCapacity(state);
            this.activeStateAtExit.put(block, state);
            this.capacity -= state.size();
            assert (this.capacity >= 0);
        }
    }

    private static class FieldAndObject {
        private final DexField field;
        private final Value object;

        private FieldAndObject(DexField field, Value receiver) {
            assert (receiver == receiver.getAliasedValue());
            this.field = field;
            this.object = receiver;
        }

        public int hashCode() {
            return this.field.hashCode() * 7 + this.object.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof FieldAndObject)) {
                return false;
            }
            FieldAndObject o = (FieldAndObject)other;
            return o.object == this.object && o.field == this.field;
        }
    }

    private static class ArraySlotWithValueIndex
    extends ArraySlot {
        private final Value index;

        private ArraySlotWithValueIndex(Value array, Value index, MemberType memberType) {
            super(array, memberType);
            this.index = index;
        }

        @Override
        public boolean maybeHasIndex(int i) {
            return true;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.array, this.index, this.memberType});
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ArraySlotWithValueIndex arraySlot = (ArraySlotWithValueIndex)other;
            return this.index == arraySlot.index && this.baseEquals(arraySlot);
        }
    }

    private static class ArraySlotWithConstantIndex
    extends ArraySlot {
        private final int index;

        private ArraySlotWithConstantIndex(Value array, int index, MemberType memberType) {
            super(array, memberType);
            this.index = index;
        }

        @Override
        public boolean maybeHasIndex(int i) {
            return this.index == i;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.array, this.index, this.memberType});
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ArraySlotWithConstantIndex arraySlot = (ArraySlotWithConstantIndex)other;
            return this.index == arraySlot.index && this.baseEquals(arraySlot);
        }
    }

    private static abstract class ArraySlot {
        protected final Value array;
        protected final MemberType memberType;

        private ArraySlot(Value array, MemberType memberType) {
            this.array = array;
            this.memberType = memberType;
        }

        public static ArraySlot create(Value array, Value index, MemberType memberType) {
            if (index.isDefinedByInstructionSatisfying(Instruction::isConstNumber)) {
                return new ArraySlotWithConstantIndex(array, index.getDefinition().asConstNumber().getIntValue(), memberType);
            }
            return new ArraySlotWithValueIndex(array, index, memberType);
        }

        public MemberType getMemberType() {
            return this.memberType;
        }

        public abstract boolean maybeHasIndex(int var1);

        boolean baseEquals(ArraySlot arraySlot) {
            return this.array == arraySlot.array && this.memberType == arraySlot.memberType;
        }
    }

    private class MaterializableValue
    implements FieldValue {
        private final SingleValue value;

        private MaterializableValue(SingleValue value) {
            assert (value.isMaterializableInContext(RedundantFieldLoadAndStoreElimination.this.appView.withLiveness(), RedundantFieldLoadAndStoreElimination.this.method));
            this.value = value;
        }

        @Override
        public void eliminateRedundantRead(InstructionListIterator it, Instruction redundant) {
            RedundantFieldLoadAndStoreElimination.this.affectedValues.addAll(redundant.outValue().affectedValues());
            it.replaceCurrentInstruction(this.value.createMaterializingInstruction(RedundantFieldLoadAndStoreElimination.this.appView.withClassHierarchy(), RedundantFieldLoadAndStoreElimination.this.code, redundant));
        }
    }

    private class ExistingValue
    implements FieldValue {
        private final Value value;

        private ExistingValue(Value value) {
            this.value = value;
        }

        @Override
        public ExistingValue asExistingValue() {
            return this;
        }

        @Override
        public void eliminateRedundantRead(InstructionListIterator it, Instruction redundant) {
            RedundantFieldLoadAndStoreElimination.this.affectedValues.addAll(redundant.outValue().affectedValues());
            redundant.outValue().replaceUsers(this.value);
            it.removeOrReplaceByDebugLocalRead();
            this.value.uniquePhiUsers().forEach(Phi::removeTrivialPhi);
        }

        public Value getValue() {
            return this.value;
        }

        public String toString() {
            return "ExistingValue(v" + this.value.getNumber() + ")";
        }
    }

    private static interface FieldValue {
        default public ExistingValue asExistingValue() {
            return null;
        }

        public void eliminateRedundantRead(InstructionListIterator var1, Instruction var2);
    }
}

