/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.DepthFirstSearchWorkListBase;
import com.android.tools.r8.utils.IntBox;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class SimpleDominatingEffectAnalysis {
    private static final SimpleEffectAnalysisResult NO_RESULT = new SimpleEffectAnalysisResult(ResultState.NOT_SATISFIED, ImmutableList.of(), ImmutableList.of());

    public static SimpleEffectAnalysisResult run(IRCode code, final InstructionAnalysis analysis) {
        final SimpleEffectAnalysisResultBuilder builder = SimpleEffectAnalysisResult.builder();
        final IntBox visitedInstructions = new IntBox();
        new DepthFirstSearchWorkListBase.StatefulDepthFirstSearchWorkList<BasicBlock, ResultStateWithPartialBlocks>(){

            @Override
            protected TraversalContinuation<?> process(DepthFirstSearchWorkListBase.DFSNodeWithState<BasicBlock, ResultStateWithPartialBlocks> node, Function<BasicBlock, DepthFirstSearchWorkListBase.DFSNodeWithState<BasicBlock, ResultStateWithPartialBlocks>> childNodeConsumer) {
                InstructionEffect effect = InstructionEffect.NO_EFFECT;
                for (Instruction instruction : ((BasicBlock)node.getNode()).getInstructions()) {
                    if (visitedInstructions.getAndIncrement() > analysis.maxNumberOfInstructions()) {
                        builder.fail();
                        return TraversalContinuation.doBreak();
                    }
                    effect = analysis.analyze(instruction);
                    if (effect.isNoEffect()) continue;
                    if (!effect.isDesired()) break;
                    builder.addSatisfyingInstruction(instruction);
                    break;
                }
                if (effect.isNoEffect()) {
                    List<BasicBlock> successors = analysis.getSuccessors((BasicBlock)node.getNode());
                    for (BasicBlock successor : successors) {
                        DepthFirstSearchWorkListBase.DFSNodeWithState<BasicBlock, ResultStateWithPartialBlocks> childNode = childNodeConsumer.apply(successor);
                        if (!childNode.hasState()) continue;
                        builder.fail();
                        return TraversalContinuation.doBreak();
                    }
                }
                node.setState(new ResultStateWithPartialBlocks(effect.toResultState(), ImmutableList.of()));
                return TraversalContinuation.doContinue();
            }

            @Override
            protected TraversalContinuation<?> joiner(DepthFirstSearchWorkListBase.DFSNodeWithState<BasicBlock, ResultStateWithPartialBlocks> node, List<DepthFirstSearchWorkListBase.DFSNodeWithState<BasicBlock, ResultStateWithPartialBlocks>> childNodes) {
                ResultStateWithPartialBlocks resultState = node.getState();
                if (resultState.state.isNotComputed()) {
                    resultState = resultState.joinChildren(childNodes);
                } else {
                    assert (resultState.state.isSatisfied() || resultState.state.isNotSatisfied());
                    assert (childNodes.isEmpty());
                }
                node.setState(resultState);
                if (((BasicBlock)node.getNode()).isEntry()) {
                    builder.setResult(resultState.state);
                    builder.setFailingBlocksForPartialResults(resultState.failingBlocks);
                }
                return TraversalContinuation.doContinue();
            }
        }.run(code.entryBlock());
        return builder.build();
    }

    public static SimpleEffectAnalysisResult canInlineWithoutSynthesizingNullCheckForReceiver(AppView<?> appView, IRCode code) {
        assert (((DexEncodedMethod)code.context().getDefinition()).isVirtualMethod());
        Value receiver = code.getThis();
        if (!receiver.isUsed()) {
            return NO_RESULT;
        }
        ProgramMethod context = code.context();
        return SimpleDominatingEffectAnalysis.run(code, instruction -> {
            if (instruction.isInvokeMethodWithReceiver() && instruction.asInvokeMethodWithReceiver().getReceiver() == receiver || instruction.isInstanceFieldInstruction() && instruction.asInstanceFieldInstruction().object() == receiver || instruction.isMonitorEnter() && instruction.asMonitor().object() == receiver) {
                return InstructionEffect.fromBoolean(!instruction.getBlock().hasCatchHandlers());
            }
            return instruction.instructionMayHaveSideEffects(appView, context) ? InstructionEffect.OTHER_EFFECT : InstructionEffect.NO_EFFECT;
        });
    }

    public static SimpleEffectAnalysisResult triggersClassInitializationBeforeAnyStaticRead(AppView<AppInfoWithLiveness> appView, IRCode code, ProgramMethod context) {
        assert (((DexEncodedMethod)code.context().getDefinition()).isStatic());
        return SimpleDominatingEffectAnalysis.run(code, instruction -> {
            if (instruction.definitelyTriggersClassInitialization(code.context().getHolderType(), context, appView, ClassInitializationAnalysis.Query.DIRECTLY, ClassInitializationAnalysis.AnalysisAssumption.INSTRUCTION_DOES_NOT_THROW)) {
                return InstructionEffect.fromBoolean(!instruction.getBlock().hasCatchHandlers());
            }
            return instruction.isInvokeMethodWithReceiver() || instruction.instructionMayHaveSideEffects(appView, context) ? InstructionEffect.OTHER_EFFECT : InstructionEffect.NO_EFFECT;
        });
    }

    private static class SimpleEffectAnalysisResultBuilder {
        List<Instruction> satisfyingInstructions = new ArrayList<Instruction>();
        List<BasicBlock> failingBlocksForPartialResults = ImmutableList.of();
        private ResultState result;

        private SimpleEffectAnalysisResultBuilder() {
        }

        public void fail() {
            this.result = ResultState.NOT_SATISFIED;
        }

        public void addSatisfyingInstruction(Instruction instruction) {
            this.satisfyingInstructions.add(instruction);
        }

        public void setFailingBlocksForPartialResults(List<BasicBlock> basicBlocks) {
            this.failingBlocksForPartialResults = basicBlocks;
        }

        public void setResult(ResultState result) {
            this.result = result;
        }

        public SimpleEffectAnalysisResult build() {
            return this.result.isNotComputed() ? NO_RESULT : new SimpleEffectAnalysisResult(this.result, this.satisfyingInstructions, this.failingBlocksForPartialResults);
        }
    }

    public static class SimpleEffectAnalysisResult {
        private final ResultState result;
        private final List<Instruction> satisfyingInstructions;
        private final List<BasicBlock> topmostNotSatisfiedBlocks;

        private SimpleEffectAnalysisResult(ResultState result, List<Instruction> satisfyingInstructions, List<BasicBlock> topmostNotSatisfiedBlocks) {
            this.result = result;
            this.satisfyingInstructions = satisfyingInstructions;
            this.topmostNotSatisfiedBlocks = topmostNotSatisfiedBlocks;
            assert (!result.isPartial() || !satisfyingInstructions.isEmpty() && !topmostNotSatisfiedBlocks.isEmpty());
        }

        public static SimpleEffectAnalysisResultBuilder builder() {
            return new SimpleEffectAnalysisResultBuilder();
        }

        public void forEachSatisfyingInstruction(Consumer<Instruction> instructionConsumer) {
            this.satisfyingInstructions.forEach(instructionConsumer);
        }

        public List<BasicBlock> getTopmostNotSatisfiedBlocks() {
            return this.topmostNotSatisfiedBlocks;
        }

        public boolean isNotSatisfied() {
            return this.result.isNotSatisfied();
        }

        public boolean isSatisfied() {
            return this.result.isSatisfied();
        }

        public boolean isPartial() {
            return this.result.isPartial();
        }
    }

    public static interface InstructionAnalysis {
        public InstructionEffect analyze(Instruction var1);

        default public List<BasicBlock> getSuccessors(BasicBlock block) {
            return block.getNormalSuccessors();
        }

        default public int maxNumberOfInstructions() {
            return 100;
        }
    }

    private static class ResultStateWithPartialBlocks {
        private final ResultState state;
        private final List<BasicBlock> failingBlocks;

        private ResultStateWithPartialBlocks(ResultState state, List<BasicBlock> failingBlocks) {
            this.state = state;
            this.failingBlocks = failingBlocks;
        }

        public ResultStateWithPartialBlocks joinChildren(List<DepthFirstSearchWorkListBase.DFSNodeWithState<BasicBlock, ResultStateWithPartialBlocks>> childNodes) {
            assert (this.state.isNotComputed());
            ResultState newState = childNodes.isEmpty() ? ResultState.NOT_SATISFIED : ResultState.NOT_COMPUTED;
            for (DepthFirstSearchWorkListBase.DFSNodeWithState<BasicBlock, ResultStateWithPartialBlocks> childNode : childNodes) {
                ResultStateWithPartialBlocks childState = childNode.getState();
                assert (!childState.state.isNotComputed());
                newState = newState.join(childState.state);
            }
            assert (!newState.isNotComputed());
            ArrayList<BasicBlock> newFailingBlocks = new ArrayList<BasicBlock>();
            if (newState.isPartial()) {
                for (DepthFirstSearchWorkListBase.DFSNodeWithState<BasicBlock, ResultStateWithPartialBlocks> childNode : childNodes) {
                    if (childNode.getState().state.isNotSatisfied()) {
                        newFailingBlocks.add((BasicBlock)childNode.getNode());
                        continue;
                    }
                    if (!childNode.getState().state.isPartial()) continue;
                    newFailingBlocks.addAll(childNode.getState().failingBlocks);
                }
            }
            return new ResultStateWithPartialBlocks(newState, newFailingBlocks);
        }
    }

    private static enum ResultState {
        PARTIAL,
        SATISFIED,
        NOT_SATISFIED,
        NOT_COMPUTED;


        public boolean isPartial() {
            return this == PARTIAL;
        }

        public boolean isSatisfied() {
            return this == SATISFIED;
        }

        public boolean isNotSatisfied() {
            return this == NOT_SATISFIED;
        }

        public boolean isNotComputed() {
            return this == NOT_COMPUTED;
        }

        public ResultState join(ResultState other) {
            if (this.isPartial() || other.isNotComputed()) {
                return this;
            }
            if (this.isNotComputed() || other.isPartial()) {
                return other;
            }
            if (this == other) {
                return this;
            }
            return PARTIAL;
        }
    }

    public static final class InstructionEffect
    extends Enum<InstructionEffect> {
        public static final /* enum */ InstructionEffect NO_EFFECT = new InstructionEffect();
        public static final /* enum */ InstructionEffect DESIRED_EFFECT = new InstructionEffect();
        public static final /* enum */ InstructionEffect OTHER_EFFECT = new InstructionEffect();
        private static final /* synthetic */ InstructionEffect[] $VALUES;

        public static InstructionEffect[] values() {
            return (InstructionEffect[])$VALUES.clone();
        }

        public static InstructionEffect valueOf(String name) {
            return Enum.valueOf(InstructionEffect.class, name);
        }

        public static InstructionEffect fromBoolean(boolean value) {
            return value ? DESIRED_EFFECT : OTHER_EFFECT;
        }

        static {
            $VALUES = new InstructionEffect[]{NO_EFFECT, DESIRED_EFFECT, OTHER_EFFECT};
        }

        public boolean isDesired() {
            return this == DESIRED_EFFECT;
        }

        public boolean isOther() {
            return this == OTHER_EFFECT;
        }

        public boolean isNoEffect() {
            return this == NO_EFFECT;
        }

        public ResultState toResultState() {
            switch (this) {
                case NO_EFFECT: {
                    return ResultState.NOT_COMPUTED;
                }
                case DESIRED_EFFECT: {
                    return ResultState.SATISFIED;
                }
            }
            assert (this.isOther());
            return ResultState.NOT_SATISFIED;
        }
    }
}

