/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.IntSwitch;
import com.android.tools.r8.ir.code.StringSwitch;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.utils.BooleanUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntPredicate;

class SwitchCaseEliminator {
    private final BasicBlock block;
    private final BasicBlock defaultTarget;
    private final InstructionListIterator iterator;
    private final Switch theSwitch;
    private int alwaysHitCase = -1;
    private BasicBlock alwaysHitTarget;
    private boolean liveFallthrough = true;
    private boolean mayHaveIntroducedUnreachableBlocks = false;
    private IntSet switchCasesToBeRemoved;

    SwitchCaseEliminator(Switch theSwitch, InstructionListIterator iterator2) {
        this.block = theSwitch.getBlock();
        this.defaultTarget = theSwitch.fallthroughBlock();
        this.iterator = iterator2;
        this.theSwitch = theSwitch;
    }

    private boolean allSwitchCasesMarkedForRemoval() {
        return this.switchCasesToBeRemoved != null && this.switchCasesToBeRemoved.size() == this.theSwitch.numberOfKeys();
    }

    private boolean canBeOptimized() {
        assert (this.switchCasesToBeRemoved == null || !this.switchCasesToBeRemoved.isEmpty());
        return this.switchCasesToBeRemoved != null || this.hasAlwaysHitCase() || !this.isFallthroughLive();
    }

    private IntList unlinkDeadSuccessors() {
        IntPredicate successorHasBecomeDeadPredicate = this.computeSuccessorHasBecomeDeadPredicate();
        IntArrayList successorIndicesToBeRemoved = new IntArrayList();
        for (int i = 0; i < this.block.getSuccessors().size(); ++i) {
            if (!successorHasBecomeDeadPredicate.test(i)) continue;
            BasicBlock successor = this.block.getSuccessors().get(i);
            successor.removePredecessor(this.block, null);
            successorIndicesToBeRemoved.add(i);
            if (!successor.getPredecessors().isEmpty()) continue;
            this.mayHaveIntroducedUnreachableBlocks = true;
        }
        successorIndicesToBeRemoved.sort(Comparator.naturalOrder());
        this.block.removeSuccessorsByIndex(successorIndicesToBeRemoved);
        return successorIndicesToBeRemoved;
    }

    private IntPredicate computeSuccessorHasBecomeDeadPredicate() {
        int[] numberOfControlFlowEdgesToBlockWithIndex = new int[this.block.getSuccessors().size()];
        for (int i2 = 0; i2 < this.theSwitch.numberOfKeys(); ++i2) {
            int targetBlockIndex;
            if (!this.isSwitchCaseLive(i2)) continue;
            int n = targetBlockIndex = this.theSwitch.getTargetBlockIndex(i2);
            numberOfControlFlowEdgesToBlockWithIndex[n] = numberOfControlFlowEdgesToBlockWithIndex[n] + 1;
        }
        if (this.isFallthroughLive()) {
            int n = this.theSwitch.getFallthroughBlockIndex();
            numberOfControlFlowEdgesToBlockWithIndex[n] = numberOfControlFlowEdgesToBlockWithIndex[n] + 1;
        }
        Iterator<Integer> iterator2 = this.block.getCatchHandlersWithSuccessorIndexes().getUniqueTargets().iterator();
        while (iterator2.hasNext()) {
            int i3;
            int n = i3 = iterator2.next().intValue();
            numberOfControlFlowEdgesToBlockWithIndex[n] = numberOfControlFlowEdgesToBlockWithIndex[n] + 1;
        }
        return i -> numberOfControlFlowEdgesToBlockWithIndex[i] == 0;
    }

    private void replaceSwitchByGoto() {
        assert (!this.hasAlwaysHitCase() || this.alwaysHitTarget != null);
        BasicBlock target = this.hasAlwaysHitCase() ? this.alwaysHitTarget : this.defaultTarget;
        this.iterator.replaceCurrentInstruction(new Goto(target));
    }

    private void replaceSwitchByOptimizedSwitch(int originalNumberOfSuccessors, IntList removedSuccessorIndices) {
        Switch replacement;
        int[] targetBlockIndexOffset = new int[originalNumberOfSuccessors];
        IntListIterator intListIterator = removedSuccessorIndices.iterator();
        while (intListIterator.hasNext()) {
            int removedSuccessorIndex = (Integer)intListIterator.next();
            targetBlockIndexOffset[removedSuccessorIndex] = 1;
        }
        for (int i = 1; i < targetBlockIndexOffset.length; ++i) {
            int n = i;
            targetBlockIndexOffset[n] = targetBlockIndexOffset[n] + targetBlockIndexOffset[i - 1];
        }
        int newFallthrough = this.theSwitch.numberOfKeys();
        if (this.isFallthroughDead()) {
            for (int i = this.theSwitch.numberOfKeys() - 1; i >= 0; --i) {
                if (!this.isSwitchCaseLive(i)) continue;
                newFallthrough = i;
                break;
            }
        }
        int numberOfRemovedSwitchCases = this.switchCasesToBeRemoved != null ? this.switchCasesToBeRemoved.size() : 0;
        int newNumberOfKeys = this.theSwitch.numberOfKeys() - (numberOfRemovedSwitchCases += BooleanUtils.intValue(this.isFallthroughDead()));
        int[] newTargetBlockIndices = new int[newNumberOfKeys];
        int j = 0;
        for (int i = 0; i < newFallthrough; ++i) {
            if (!this.isSwitchCaseLive(i)) continue;
            newTargetBlockIndices[j] = this.theSwitch.getTargetBlockIndex(i) - targetBlockIndexOffset[this.theSwitch.getTargetBlockIndex(i)];
            assert (newTargetBlockIndices[j] < this.block.getSuccessors().size());
            ++j;
        }
        int fallthroughBlockIndex = this.isFallthroughLive() ? this.theSwitch.getFallthroughBlockIndex() - targetBlockIndexOffset[this.theSwitch.getFallthroughBlockIndex()] : this.theSwitch.getTargetBlockIndex(newFallthrough) - targetBlockIndexOffset[this.theSwitch.getTargetBlockIndex(newFallthrough)];
        if (this.theSwitch.isIntSwitch()) {
            IntSwitch intSwitch = this.theSwitch.asIntSwitch();
            int[] newKeys = new int[newNumberOfKeys];
            int j2 = 0;
            for (int i = 0; i < newFallthrough; ++i) {
                if (!this.isSwitchCaseLive(i)) continue;
                newKeys[j2] = intSwitch.getKey(i);
                ++j2;
            }
            replacement = new IntSwitch(this.theSwitch.value(), newKeys, newTargetBlockIndices, fallthroughBlockIndex);
        } else {
            assert (this.theSwitch.isStringSwitch());
            StringSwitch stringSwitch = this.theSwitch.asStringSwitch();
            DexString[] newKeys = new DexString[newNumberOfKeys];
            int j3 = 0;
            for (int i = 0; i < newFallthrough; ++i) {
                if (!this.isSwitchCaseLive(i)) continue;
                newKeys[j3] = stringSwitch.getKey(i);
                ++j3;
            }
            replacement = new StringSwitch(this.theSwitch.value(), newKeys, newTargetBlockIndices, fallthroughBlockIndex);
        }
        this.iterator.replaceCurrentInstruction(replacement);
    }

    boolean mayHaveIntroducedUnreachableBlocks() {
        return this.mayHaveIntroducedUnreachableBlocks;
    }

    public boolean isSwitchCaseLive(int index) {
        if (this.hasAlwaysHitCase()) {
            return index == this.alwaysHitCase;
        }
        if (this.switchCasesToBeRemoved != null) {
            return !this.switchCasesToBeRemoved.contains(index);
        }
        assert (!this.isFallthroughLive());
        return true;
    }

    public boolean isFallthroughDead() {
        return !this.isFallthroughLive();
    }

    public boolean isFallthroughLive() {
        return this.liveFallthrough;
    }

    public boolean hasAlwaysHitCase() {
        return this.alwaysHitCase >= 0;
    }

    void markSwitchCaseAsAlwaysHit(int i) {
        assert (this.alwaysHitCase < 0);
        this.alwaysHitCase = i;
        this.alwaysHitTarget = this.theSwitch.targetBlock(i);
        this.liveFallthrough = false;
    }

    void markSwitchCaseForRemoval(int i) {
        if (this.switchCasesToBeRemoved == null) {
            this.switchCasesToBeRemoved = new IntOpenHashSet();
        }
        this.switchCasesToBeRemoved.add(i);
    }

    void markSwitchFallthroughAsNeverHit() {
        assert (!this.hasAlwaysHitCase());
        this.liveFallthrough = false;
    }

    boolean optimize() {
        if (this.canBeOptimized()) {
            int originalNumberOfSuccessors = this.block.getSuccessors().size();
            IntList removedSuccessorIndices = this.unlinkDeadSuccessors();
            if (this.hasAlwaysHitCase() || this.allSwitchCasesMarkedForRemoval()) {
                this.replaceSwitchByGoto();
            } else {
                this.replaceSwitchByOptimizedSwitch(originalNumberOfSuccessors, removedSuccessorIndices);
            }
            return true;
        }
        return false;
    }
}

